# Lego Minifigure Presentation Slides

System prompt for generating Lego minifigure-themed presentation slides with photorealistic toy photography style.

## Theme Identity

- **Style:** Photorealistic Lego toy photography with shallow depth of field
- **Background:** Dark charcoal Lego baseplate (consistent across all slides)
- **Title treatment:** White sans-serif text at bottom of every slide
- **Tone:** Playful-but-professional
- **Essence:** "Complex ideas made approachable through the universal language of Lego"

## When to Use

Use this prompt when creating:
- Conference talks and workshops
- Training materials
- Technical presentations where engagement matters
- Any presentation where playful-but-professional imagery enhances understanding
- Internal team presentations
- Hackathon and innovation event decks

## Visual System

### Framing Prefix
Every prompt should begin with:
`"Lego minifigure scene, photorealistic toy photography with shallow depth of field."`

### Background
Dark charcoal Lego baseplate - consistent across ALL slides.

### Title Treatment
White sans-serif text at bottom of every slide. The title should be clearly readable against the dark baseplate.

### Layout Zones
- **TOP BANNER**: Status bars, labels, level indicators
- **LEFT PANEL**: Before state, input, problem
- **RIGHT PANEL**: After state, output, solution
- **CENTER PANEL**: Single focal point, hero subject
- **BOTTOM BANNER**: Title text, labels, CTA

## Slide Type Variants

### 1. Scene Slides (Welcome, Closing)
Narrative dioramas with minifigures in a setting. Full environmental storytelling.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. A diverse group of Lego minifigures gathered around a large conference table made of flat Lego plates, on a dark charcoal baseplate. One minifigure stands at a tiny Lego podium. Warm studio lighting with soft shadows. White title text at bottom: 'Welcome to AI-Native Engineering'. 16:9 aspect ratio."`

### 2. Data/Infographic Slides (Survey Results, Scale of Change)
Lego bar charts, scoreboards, labeled tiles built from actual bricks.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. On a dark charcoal baseplate, three bar charts made from stacked Lego bricks in red, blue, and green. Each bar is labeled with a tiny printed tile. A minifigure with clipboard stands beside the chart pointing. Numbers '86%' and '70%' displayed on white Lego tiles. White title text at bottom: 'Survey Results'. 16:9 aspect ratio."`

### 3. Comparison Slides (Paradox, Mindset Shifts)
Split scenes with LEFT/RIGHT contrast showing before vs after, old vs new.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. Split scene on dark charcoal baseplate. LEFT: A frustrated minifigure struggling to build a wobbly tower alone, dim lighting. RIGHT: A confident minifigure directing a small Lego robot assistant that efficiently stacks bricks, bright lighting. Clear visual divider down the center. White title text at bottom: 'The Paradox'. 16:9 aspect ratio."`

### 4. Framework Slides (Autonomy Framework, Levels)
Multi-panel grid with progression from left to right or bottom to top.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. Six-panel progression on dark charcoal baseplate, left to right. Panel 1: Minifigure typing manually on Lego computer. Panel 2: Same minifigure with small AI helper. Panel 3: Minifigure pair-programming with robot. Panel 4: Minifigure reviewing robot's work. Panel 5: Robot working autonomously with minifigure watching monitors. Panel 6: Fully automated Lego factory with conveyor belts. Labels L0 through L5 on white tiles below each panel. White title text at bottom: 'Levels of AI Autonomy'. 16:9 aspect ratio."`

### 5. Journey/Timeline Slides (Where We Are, 90-Day Commitment)
Path with milestone markers, road sections, progress indicators.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. A winding Lego road across dark charcoal baseplate, with four milestone signposts made from Lego flag pieces. Minifigures at different points along the path. First milestone: 'L2 Baseline', second: 'L3 Standard', third: 'L4 Pilots', fourth: 'L5 Vision'. A glowing arrow indicates current position at milestone 2. White title text at bottom: 'Where We Are Today'. 16:9 aspect ratio."`

### 6. Transformation Slides (Friction to Roadmap, Problems to Solutions)
Input to Process to Output flow showing transformation.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. On dark charcoal baseplate, a left-to-right transformation flow. LEFT: A pile of scattered mismatched Lego bricks labeled 'Friction'. CENTER: A Lego machine/factory with gears and conveyor belt, operated by minifigure engineers. RIGHT: Organized, colorful Lego structures labeled 'Solutions'. Arrows connect the three stages. White title text at bottom: 'From Problems to Solutions'. 16:9 aspect ratio."`

### 7. Workshop/Activity Slides (Group Assignments, What We Heard)
Collaborative scenes with multiple minifigures working together.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. Three separate workstation areas on dark charcoal baseplate, each with 3-4 diverse minifigures collaborating around Lego tables. Each group has a colored flag: red, blue, green. Tiny whiteboards with Lego brick diagrams. Energetic, busy scene. White title text at bottom: 'Group Assignments'. 16:9 aspect ratio."`

### 8. Inspirational/Closing Slides (Builders Not Coders, What Will You Build)
Hero shot with aspirational framing, dramatic lighting.

**Example prompt:** `"Lego minifigure scene, photorealistic toy photography with shallow depth of field. A single heroic minifigure standing on an elevated dark charcoal baseplate, looking out over an expansive Lego cityscape they've built. Dramatic backlighting creating a silhouette effect. Small Lego robot companion beside them. Epic scale, wide shot. White title text at bottom: 'What Will You Build?'. 16:9 aspect ratio."`

## Metaphor Dictionary

Map abstract engineering/AI concepts to Lego physical equivalents:

| Abstract Concept | Lego Physical Equivalent |
|---|---|
| Code | Lego bricks being stacked/assembled |
| AI Agent | Small Lego robot minifigure |
| Engineer | Lego minifigure (with hard hat, clipboard, or tool) |
| Documentation | Lego instruction manual / printed book piece |
| Code Review | Minifigure with magnifying glass inspecting a build |
| Guardrails | Literal Lego fence or railing pieces |
| Automation | Conveyor belt built from Lego Technic |
| Architecture | Minifigure on elevated platform with blueprint tile |
| Quality Issues | Wobbly, crooked, or incomplete Lego tower |
| Knowledge | Lego books, reference cards, library shelf |
| Compound Returns | Machine producing multiple copies/outputs |
| Milestone | Flag piece or signpost on Lego road plate |
| Technical Debt | Pile of mismatched, old, dusty Lego bricks |
| Testing | Minifigure with checklist next to completed build |
| Deployment | Lego truck carrying finished product |
| Collaboration | Multiple minifigures working on same build |
| Innovation | Minifigure with lightbulb piece above head |
| Risk | Minifigure near edge of baseplate or wobbly structure |
| Success | Completed, polished Lego build with flag on top |
| Failure | Collapsed Lego structure, scattered bricks |

## Diversity & Inclusion Guide

Ensure visual diversity in every group scene:

### Hair Styles
Mix: ponytails, buns, short cuts, long hair, no hair, hats/helmets

### Skin Tones
Use Lego's expanded palette: classic yellow, warm brown, dark brown, light peach

### Rule of Thirds
In any group of 6+ minifigures, aim for approximately:
- ~1/3 traditionally feminine presentation
- ~1/3 traditionally masculine presentation
- ~1/3 gender-neutral or diverse presentation
- Mix of skin tones across all groups

### Accessories for Variety
Hard hats, lab coats, glasses, headphones, different colored shirts

## Character Consistency

When a recurring "presenter" minifigure appears across slides:
- Give them a distinguishing accessory (e.g., blue hard hat + clipboard)
- Include a brief description in every prompt: "The lead engineer minifigure (blue hard hat, clipboard)"
- Keep their position consistent (often at the front or center of scenes)

## Iteration Playbook

Lego scenes benefit from iterative refinement:

### Generation 1 (Concept)
- Focus on layout and composition
- Get the basic scene structure right
- Don't worry about fine details

### Generation 2 (Refinement)
- Add specific details (labeled tiles, correct number of minifigures)
- Improve lighting and depth of field
- Ensure title text is readable

### Generation 3 (Polish)
- Fine-tune diversity of minifigures
- Ensure consistent baseplate color
- Verify all labels and text are correct
- Check that metaphor mappings are clear

### What Typically Improves Between Generations
- Text readability on tiles
- Minifigure diversity
- Depth of field consistency
- Background consistency (charcoal baseplate)
- Scene composition balance
- Label accuracy

## System Prompt

```
Role and objective
You generate photorealistic Lego minifigure presentation slides. Each slide depicts a miniature scene using real Lego pieces, minifigures, and baseplates photographed with shallow depth of field. The style should look like professional toy photography -- warm studio lighting, slight bokeh, and tactile detail on the plastic surfaces.

Visual rules (strict):
- Background: Dark charcoal Lego baseplate (every slide)
- Title text: White sans-serif at the bottom of every slide
- Photography style: Photorealistic toy photography, shallow depth of field
- Lighting: Warm studio lighting with soft shadows
- Scale: Everything should look miniature and built from real Lego
- Aspect ratio: 16:9

Layout zones:
- TOP BANNER: Status bars, level indicators, labels
- LEFT PANEL: Before state, input, problem side
- RIGHT PANEL: After state, output, solution side
- CENTER PANEL: Single focal point, hero subject
- BOTTOM BANNER: Title text (always present)

Minifigure diversity:
- Mix hair styles: ponytails, buns, short hair, long hair, bald, hats
- Mix skin tones: classic yellow, warm brown, dark brown, light peach
- Mix accessories: hard hats, glasses, lab coats, headphones
- In groups of 6+, aim for visual diversity across gender presentation and skin tone

Lego metaphor system:
- Code = Lego bricks being stacked
- AI Agent = Small Lego robot
- Engineer = Minifigure with hard hat or clipboard
- Documentation = Printed Lego book piece
- Guardrails = Lego fence/railing pieces
- Automation = Lego Technic conveyor belt
- Quality issues = Wobbly or crooked tower
- Success = Completed build with flag on top

Hard constraints:
- ALWAYS include white title text at the bottom
- ALWAYS use dark charcoal baseplate background
- ALWAYS use photorealistic toy photography style
- Maximum one main concept per slide
- Aspect ratio: 16:9
- All scenes must look like they could be built from real Lego pieces
```

## Usage Examples

### Title Slide
**User input:**
> "Create a title slide for 'AI-Native Engineering Workshop'"

**Prompt:** "Lego minifigure scene, photorealistic toy photography with shallow depth of field. On dark charcoal baseplate, a welcoming scene: diverse group of minifigures gathered around a circular table made of flat plates. Center of table has a glowing Lego brick. Small Lego robot at the edge. Warm studio lighting. White title text at bottom: 'AI-Native Engineering Workshop'. 16:9."

### Data Slide
**User input:**
> "Show that 86% of engineers use AI tools hourly"

**Prompt:** "Lego minifigure scene, photorealistic toy photography with shallow depth of field. On dark charcoal baseplate, a giant scoreboard made of Lego tiles showing '86%' in large white numbers. Below it, a row of 10 minifigures -- nine of them have small Lego laptops, while one stands idle. A label tile reads 'Using AI Tools Hourly'. White title text at bottom: 'Survey Results'. 16:9."

### Comparison Slide
**User input:**
> "Show before/after mindset shift from coding to building"

**Prompt:** "Lego minifigure scene, photorealistic toy photography with shallow depth of field. Split scene on dark charcoal baseplate. LEFT side labeled 'CODING': A lone minifigure hunched over a tiny Lego computer, dark/cramped workspace. RIGHT side labeled 'BUILDING': Same minifigure standing proudly before a large collaborative Lego build with multiple robot assistants and fellow builders. Dramatic contrast in lighting. White title text at bottom: 'Mindset Shift: From Coding to Building'. 16:9."

## Integration with Nano Banana Pro

### Step 1: Generate the slide

```
gemini_generate_image(
  prompt="[Lego system prompt above] + Scene: [description]",
  model="gemini-3-pro-image-preview",
  aspectRatio="16:9",
  imageSize="4K"
)
```

### Step 2: Iterate with continue_editing

```
continue_editing(
  instructions="Increase diversity of minifigures. Add more variety in hair styles and skin tones. Ensure the title text at bottom is clearly readable."
)
```

### Step 3: Optional branding

If Catalyst AI branding is needed, apply post-processing:
```bash
magick /path/to/lego-slide.png \
  \( /path/to/assets/catalyst-watermark-logo.png -resize 5% -alpha set -channel A -evaluate multiply 0.85 +channel \) \
  -gravity SouthEast -geometry +25+25 -composite \
  /path/to/output-branded.png
```

## Best Practices

1. **Consistency first**: Use the dark charcoal baseplate and white title text at the bottom on EVERY slide
2. **Real Lego pieces**: Everything in the scene should look like it could be built from actual Lego
3. **One concept per slide**: Don't overcrowd scenes -- each slide conveys one idea
4. **Iterate for diversity**: First generation often lacks minifigure variety -- refine in Gen 2
5. **Use the metaphor dictionary**: Convert abstract concepts to their Lego equivalents before prompting
6. **Shallow depth of field**: This creates the signature "toy photography" look
7. **Warm lighting**: Studio lighting with soft shadows creates approachability
