# AI Vocabulary and Cliché Patterns

This reference catalogs AI-overused words and phrases with frequency multipliers based on research.

## High-Frequency AI Words (Comparative Overuse)

### Extreme Overuse (50x+ more frequent in AI text)
- "aims to" (50x+)
- "crucial role" (182x)
- "objective study aimed" (269x)
- "research needed to understand" (235x)

### Heavy Overuse (15-50x more frequent)
- "showcasing" (20x)
- "underscores" (18x)
- "aligns" (16x)

### Moderate Overuse (5-15x more frequent)
- "pivotal"
- "intricate"
- "showcase"

### Notable Overuse (2-5x more frequent)
- "delve"
- "robust"
- "comprehensive"
- "multifaceted"
- "nuanced"
- "leverage"
- "cutting-edge"
- "revolutionize"

## Corporate-Academic Hybrid Terms
- synergy
- blockchain (when used inappropriately)
- thought leader
- value-add
- impactful
- game changer
- elevate
- unleash
- harness

## Qualifier Stacking Phrases
- "It's important to note that"
- "It's worth mentioning"
- "Indeed"
- "Certainly"
- "Notably"

## False Precision Phrases
- "This speaks to"
- "This underscores"
- "This highlights"

## Meta-Commentary Addiction
- Narrating what the text is doing rather than doing it
- "In this section, we will explore..."
- "Having discussed X, we now turn to Y..."

## Hedge Stacking
Excessive use of:
- "may"
- "might"
- "could potentially"
- "appears to"
- "seems to"

## Wikipedia-Identified Patterns

### Undue Emphasis on Symbolism
- "stands as a symbol"
- "enhanced significance"
- "plays a significant role"
- "rich cultural heritage"
- "enduring legacy"

### Transition Overuse
- "moreover" (AI favorite)
- "however" (3x more than humans)
- "furthermore"
- "in summary"
- "overall"

### Not X, But Y Construction
- "It's not just X, it's Y"
- "This isn't about X, it's about Y"

### Rule of Three
Grouping traits or ideas in threes formulaically:
- "creative, smart, and funny"
- "fast, reliable, and efficient"

## Connective Usage Patterns

### AI Prefers
- "however" (3x more)

### Humans Prefer
- "because" (15x more)
- "so" (10x more)
- "if" (5x more)

## Sentence Transition Templates
- "not only... but also..."
- "in addition to X, Y also..."
- "while X, Y..."

## Promotional Language
- "breathtaking"
- "majestic"
- "captivating"
- "fascinating" (when unearned)
- "remarkable"

## Academic Padding
- "In today's world"
- "In today's digital era"
- "In the modern landscape"
- "In recent years"
- "Increasingly"

## Usage Guidelines

**Density-Based Flagging:**
- Single use: Generally acceptable
- 2-3 instances per 500 words: Yellow flag
- 4+ instances per 500 words: Red alert

**Context Exceptions:**
- Technical writing may appropriately use "robust," "optimize," "architecture"
- Academic writing may use "moreover," "furthermore" more legitimately
- Business writing may need "leverage," "synergy" (though reconsider)

**Replace With:**
- Specific verbs instead of "delve into" → "examine," "analyze," "investigate"
- Concrete adjectives instead of "robust" → "durable," "resilient," "strong"
- Active constructions instead of "showcases" → "shows," "demonstrates," "reveals"
