# Veo 3.1 Prompt Examples

20+ categorized examples demonstrating effective prompting techniques.

---

## Action & Adventure

### Chase Scene
```
Tracking shot following a motorcycle weaving through traffic on rain-slicked
Tokyo streets at night. Neon signs reflect off wet pavement. Low angle,
wide-angle lens creating speed distortion.

SFX: Engine roaring, tires screeching, rain pattering on helmet.
Ambient: City traffic, distant sirens.

Cinematic, high-contrast lighting, cyberpunk aesthetic.
```

### Combat
```
Medium shot of two martial artists circling each other in a moonlit
courtyard. Slow-motion as one launches a spinning kick. Camera performs
180-degree arc shot during the attack.

SFX: Fabric whooshing, grunt of exertion, impact.
Ambient: Crickets, wind through bamboo.

Wuxia style, blue moonlight, shallow depth of field.
```

---

## Drama & Emotion

### Breakup Scene
```
Two shot in a coffee shop, a couple sitting across from each other.
She slides the ring across the table. Rack focus from the ring to
his devastated expression.

She says softly: "I'm sorry. I can't do this anymore."
Ambient: Muted café chatter, coffee machine.

Warm tungsten lighting, melancholy mood, slightly grainy film look.
```

### Reunion
```
Wide shot of airport arrivals gate. Slow dolly-in as a soldier in
uniform emerges from crowd. Cut to medium close-up of child's face
lighting up with recognition.

The child screams: "Daddy!"
SFX: Footsteps running, crowd noise, joyful sobbing.

Soft natural lighting, emotional, documentary style.
```

---

## Nature & Documentary

### Wildlife Close-Up
```
Extreme close-up of a hummingbird hovering at a red flower. Macro lens
with shallow focus isolating the bird. Slow motion capturing wing beats.
Early morning light with dew drops visible.

SFX: Gentle buzzing of wings, birdsong.
Ambient: Forest atmosphere, distant stream.

National Geographic style, photorealistic, 4K detail.
```

### Landscape Timelapse
```
Wide shot of mountain range as clouds roll through valleys. Golden hour
transitioning to blue hour. Deep focus showing layers of peaks.
Subtle time-lapse movement of shadows.

Ambient: Wind, distant eagle cry.

Epic scale, cinematic color grading, anamorphic lens flares.
```

### Ocean Documentary
```
Underwater tracking shot following a sea turtle gliding through
crystal-clear tropical water. Sunbeams pierce the surface above.
School of colorful fish pass in background.

Ambient: Underwater ambience, bubbles, distant whale song.

Blue Planet style, natural lighting, peaceful mood.
```

---

## Sci-Fi & Fantasy

### Spaceship Interior
```
Slow dolly through dimly lit spaceship corridor. Emergency red lights
pulse rhythmically. A lone astronaut floats past in zero gravity,
checking panels.

She speaks into comms: "Command, I've lost contact with the crew."
SFX: Mechanical hum, air circulation, distant alarm.

Alien aesthetic, claustrophobic, blue and red color contrast.
```

### Fantasy Reveal
```
POV shot walking through misty forest. Branches part to reveal an
ancient castle floating above a waterfall. Crane shot rises to
capture the full magnificent scale.

SFX: Footsteps on leaves, magical shimmer, waterfall roar.
Ambient: Mystical orchestra swells.

Epic fantasy, Lord of the Rings style, golden hour backlighting.
```

### Cyberpunk Street
```
Low angle tracking shot through crowded neon-lit street market.
Holographic advertisements flicker overhead. Rain falls through
colorful light beams. Diverse crowd of humans and androids.

SFX: Electronic chatter, sizzling food stalls, rain.
Ambient: Synthwave music from speakers.

Blade Runner aesthetic, high contrast, anamorphic lens.
```

---

## Horror & Suspense

### Creepy Hallway
```
Slow dolly down a long, dark hospital hallway. Flickering fluorescent
lights. At the far end, a figure in white stands motionless.
Subtle dutch angle increasing unease.

SFX: Buzzing lights, distant dripping, footsteps echo.
Ambient: Unsettling low-frequency hum.

Horror aesthetic, desaturated colors, deep shadows.
```

### Jump Scare Setup
```
Close-up of woman's face as she opens a closet door. Shallow focus.
She peers into darkness. Beat of silence. The camera pushes in slowly.

She whispers: "Hello? Is someone there?"
SFX: Creaking door, her nervous breathing.

Tension building, low-key lighting, handheld subtle shake.
```

---

## Comedy & Lifestyle

### Cooking Fail
```
Medium shot of enthusiastic home cook flipping a pancake. The pancake
arcs too high and sticks to the ceiling. Cut to their shocked expression
looking up.

SFX: Sizzling pan, whoosh of flip, splat on ceiling.
They sigh: "Not again..."

Bright kitchen lighting, comedic timing, warm colors.
```

### Pet Antics
```
Wide shot of living room as a golden retriever attempts to catch a
frisbee, crashes into couch cushions, and emerges triumphant with
toy in mouth. Slow motion during the crash.

SFX: Dog panting, crash, tail wagging.
Ambient: Cheerful acoustic guitar.

Home video style, natural daylight, warm and playful.
```

---

## Product & Commercial

### Luxury Watch
```
Extreme close-up of luxury watch on velvet surface. Slow 360-degree
rotation. Light catches the crystal face, reflections dance across
metal. Subtle rack focus from dial to brand logo.

SFX: Soft mechanical tick.
Ambient: Minimal, elegant piano note.

Product photography style, studio lighting, black background,
pristine reflections.
```

### Food Commercial
```
Slow-motion close-up of chocolate sauce pouring over ice cream.
Steam rises from the warm sauce. Macro lens captures every drip
and swirl. Rack focus to reveal full sundae.

SFX: Pouring liquid, subtle sizzle.
Ambient: Soft orchestral anticipation.

Food photography, dramatic lighting, appetite appeal.
```

---

## Timestamp Sequence Examples

### Coffee Shop Morning (8 seconds)
```
[00:00-00:02] Wide shot of empty coffee shop at dawn. Sun streams through
windows. Barista in apron walks into frame and flips "OPEN" sign.
SFX: Keys jingling, sign clicking.

[00:02-00:04] Close-up of hands grinding fresh coffee beans. Steam rises
from the grinder. Deep aroma implied by slow satisfied smile.
SFX: Grinder whirring, beans crackling.

[00:04-00:06] Medium shot of first customer entering, bell chiming.
Barista smiles: "The usual?"
Customer nods: "You know me too well."
Ambient: Gentle morning café music.

[00:06-00:08] Two shot as coffee cup slides across counter. Hands meet
briefly during exchange. Warm morning light, content expressions.
SFX: Cup sliding, soft thank you.
```

### Action Movie Opening (8 seconds)
```
[00:00-00:02] Aerial shot of desert highway at sunrise. Single black car
races across the frame leaving dust trail.
SFX: Roaring engine, wind.

[00:02-00:04] Interior shot of driver's hands gripping wheel. Quick cut
to rearview mirror showing pursuit vehicles approaching.
Driver mutters: "Not today."
SFX: Radio static, engine revving higher.

[00:04-00:06] Side tracking shot as car accelerates. Pursuit vehicles
gaining. Dust clouds intensify.
SFX: Multiple engines, gravel spray.

[00:06-00:08] Close-up of driver's eyes in mirror. Determined expression.
Hand reaches for gear shift. Music builds.
SFX: Dramatic synth bass drop.
```

---

## Negative Prompt Tips

Instead of saying "no walls," describe what you want:

| Avoid | Use Instead |
|-------|-------------|
| "No buildings" | "Open wilderness, natural landscape only" |
| "Don't show faces" | "Silhouettes, back of head, hands only" |
| "No people" | "Abandoned street, empty room, solitary" |
| "Not dark" | "Bright daylight, high-key lighting" |

---

## Pro Tips

1. **Layer audio elements** - Combine dialogue + SFX + ambient for richness
2. **Specify timing** - "3 seconds in" or "immediately after"
3. **Use film references** - "Shot like a Wes Anderson film"
4. **Add imperfections** - "Slightly grainy, film-like texture"
5. **Direct the emotion** - "Tense," "peaceful," "bittersweet"
