# Exhaustive Extraction

*Reference for **[spec-construction](spec-construction.md)***

---

**This step is critical. The specification is the golden document — if information doesn't make it here, it won't be built.**

For each topic or subtopic, perform exhaustive extraction:

1. **Re-scan ALL source material** — Don't rely on memory. Go back to the source material and systematically review it for the current topic.

2. **Search for keywords** — Topics are rarely contained in one section. Search for:
   - The topic name and synonyms
   - Related concepts and terms
   - Names of systems, fields, or behaviors mentioned in context

3. **Collect scattered information** — Source material is often non-linear. Information about a single topic may be scattered across:
   - Multiple sections of the same document
   - Different documents entirely
   - Tangential discussions that revealed important details

4. **Filter for what we're building** — Include only validated decisions:
   - Exclude discarded alternatives
   - Exclude ideas that were explored but rejected
   - Exclude "maybes" that weren't confirmed
   - Include only what the user has decided to build

**Why this matters:** The specification is the single source of truth for planning. Planning will not reference prior source material — only this document. Missing a detail here means that detail doesn't get implemented.
