﻿# Reference Documentation

**Version:** {{VERSION}}
**Last Updated:** {{DATE}}

<!-- SCOPE: Reference documentation hub (ADRs, Guides, Manuals) with links to subdirectories -->
<!-- DO NOT add here: ADR/Guide/Manual content → specific files, Project details → project/README.md -->

---

## Overview

This directory contains reusable knowledge base and architecture decisions:

- **Architecture Decision Records (ADRs)** - Key technical decisions
- **Project Guides** - Reusable patterns and best practices
- **Package Manuals** - API reference for external libraries

---

## Architecture Decision Records (ADRs)

<!-- Example: [ADR-001: Use React+Next.js](adrs/adr-001-frontend-framework.md) | Accepted | 2024-10-15 -->

{{ADR_LIST}}

---

## Project Guides

<!-- Example: [01-Repository Pattern](guides/01-repository-pattern.md) | 2024-11-10 -->

{{GUIDE_LIST}}

---

## Package Manuals

<!-- Example: [Axios 1.6](manuals/axios-1.6.md) | 2024-10-20 -->

{{MANUAL_LIST}}

---

## Maintenance

**Last Updated:** {{DATE}}

**Update Triggers:**
- New ADRs added to adrs/ directory
- New guides added to guides/ directory
- New manuals added to manuals/ directory

**Verification:**
- [ ] All ADR links in registry are valid
- [ ] All guide links in registry are valid
- [ ] All manual links in registry are valid
- [ ] Placeholders {{ADR_LIST}}, {{GUIDE_LIST}}, {{MANUAL_LIST}} synced with files

---

**Template Version:** 2.0.0
**Template Last Updated:** {{DATE}}
