# Task Navigation

<!-- SCOPE: Quick navigation to active tasks in Linear ONLY. Contains links and titles per Context Budget Rule. -->
<!-- DO NOT add here: task descriptions, implementation notes, workflow rules → tasks/README.md -->

> **Last Updated**: [YYYY-MM-DD] (Hierarchical format: Status → Epic → Story → Tasks)

---

## Linear Configuration (use MCP Linear)

**What is Linear:** Issue tracking and project management tool with workspace → initiative → project → issue hierarchy.

**Our Configuration:**
- **Workspace**: [TEAM_NAME] ([WORKSPACE_URL])
- **Team**: [TEAM_NAME] (Team Key: [TEAM_KEY])
- **Initiative**: [Your Initiative Name]
- **Projects**: Each Epic = separate Linear Project
- **Issues**: User Stories (label:user-story, parentId=null) + Tasks (parentId=StoryId)

**Key Features:**
- Custom views replicate kanban workflow (Backlog → Active → Review → Done)
- Labels for technical categorization (db, api, service, testing)
- Issue titles preserve Epic context (EP{N}_{XX}: Task Name)
- Single source of truth for all task tracking

**Detailed Guide:** See [docs/guides/25-linear-task-management.md](../guides/25-linear-task-management.md) for:
- Hierarchical structure and best practices
- Custom views, labels, and workflow patterns
- Team keyboard shortcuts and bulk actions

**Single Source of Truth for all Linear variables**

| Variable | Value | Description |
|----------|-------|-------------|
| **Team ID** | [TEAM_NAME] | Linear team name |
| **Team UUID** | [TEAM_UUID] | Team UUID for API calls |
| **Team Key** | [TEAM_KEY] | Short key for issues ([TEAM_KEY]-XX) |
| **Workspace URL** | [WORKSPACE_URL] | Linear workspace |
| **Next Epic Number** | 1 | Next available Epic number |

## Quick Access

**Views:**
- [Backlog]([WORKSPACE_URL]/team/[TEAM_KEY]/backlog)
- [Todo]([WORKSPACE_URL]/team/[TEAM_KEY])
- [Active Sprint]([WORKSPACE_URL]/team/[TEAM_KEY]/active)
- [All Issues]([WORKSPACE_URL]/team/[TEAM_KEY]/all)

---

### Epic Story Counters

| Epic | Last Story | Next Story | Last Task | Next Task |
|------|------------|------------|-----------|-----------|
| Epic 0 | - | US001 | - | EP0_01 |
| Epic 1+ | - | US001 | - | EP1_01 |

> [!NOTE]

> User Story numbering starts at US001 for each new Epic. Task numbering starts at EP{N}_01 where N is the Epic number. [TEAM_KEY]-XX numbers are auto-generated by Linear.

---

## Work in Progress

**Format:** Each status section groups tasks by Epic → Story → Tasks hierarchy. Epic headers (`**Epic N: Title**`) have no indent. Stories have 2-space indent. Tasks have 4-space indent (2 base + 2 for dash).

**Important:** Stories without tasks are ONLY allowed in Backlog/Postponed statuses with note: `_(tasks not created yet)_`

**Critical:** Done and Postponed sections contain ONLY Stories (no Tasks). Tasks are removed from kanban when their Story moves to Done/Postponed.

### Backlog

**Epic 0: Common Tasks**

  📖 [[TEAM_KEY]-XX: US001 Example Story Title](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)
    _( tasks not created yet)_

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US001 Another Example Story](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)
    - [[TEAM_KEY]-XX: EP1_01 Example Task](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)

### Todo

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US002 Approved Story Title](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ APPROVED
    - [[TEAM_KEY]-XX: EP1_02 Ready Task](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)
    - [[TEAM_KEY]-XX: EP1_03 Another Ready Task](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)

### In Progress

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US002 Approved Story Title](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ APPROVED
    - [[TEAM_KEY]-XX: EP1_02 Active Task](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)

### To Review

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US002 Approved Story Title](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ APPROVED
    - [[TEAM_KEY]-XX: EP1_02 Task Under Review](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)

### To Rework

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US002 Approved Story Title](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ APPROVED
    - [[TEAM_KEY]-XX: EP1_02 Task Needing Fixes](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)

### Done (Last 5 stories)

**Epic 0: Common Tasks**

  📖 [[TEAM_KEY]-XX: US001 Completed Story](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ DONE (YYYY-MM-DD)

**Epic 1: Example Feature Area**

  📖 [[TEAM_KEY]-XX: US002 Another Completed Story](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX) ✅ DONE (YYYY-MM-DD)

### Postponed

**Epic 0: Common Tasks**

  📖 [[TEAM_KEY]-XX: US003 Deferred Story](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)
    _(future iteration)_

**Epic 2: Future Feature**

  📖 [[TEAM_KEY]-XX: US001 Postponed Work](https://linear.app/[workspace]/issue/[TEAM_KEY]-XX)
    _(lower priority)_

---

## Epics Overview

**Active:**
_No active epics yet_

**Completed:**
_No completed epics yet_

---

## Workflow Reference

| Status | Purpose |
|--------|---------|
| **Backlog** | New tasks requiring estimation and approval |
| **Postponed** | Deferred tasks for future iterations |
| **Todo** | Approved tasks ready for development |
| **In Progress** | Active development |
| **To Review** | Awaiting code review |
| **To Rework** | Needs fixes, returns to In Progress |
| **Done** | Completed and approved |

**Manual Statuses:** Canceled, Duplicate

---

## Related Documentation
- [tasks/README.md](./README.md) - Task system workflow and rules

---

**Template Version:** 4.0.0 (Done/Postponed sections contain ONLY Stories, no Tasks)
**Last Updated:** 2026-01-09
