# {{PROJECT_NAME}} - Presentation

> **SCOPE:** Navigation hub for project presentation (HTML presentation access, customization guide, build instructions ONLY). DO NOT add here: Project documentation → docs/project/, Architecture details → docs/project/architecture.md, Technical specs → docs/project/tech_stack.md

---

## Purpose

This directory contains the interactive HTML presentation for **{{PROJECT_NAME}}**, generated from project documentation (requirements, architecture, technical specifications).

**Use this when:**
- Presenting project overview to stakeholders
- Onboarding new team members
- Sharing project architecture visually
- Creating project demos

---

## Quick Navigation

**Main Presentation:**
- [presentation_final.html](presentation_final.html) - Open this in your browser

**Modular Structure:**
- [assets/presentation_template.html](assets/presentation_template.html) - Base template
- [assets/styles.css](assets/styles.css) - Styling
- [assets/scripts.js](assets/scripts.js) - Tab switching logic
- [assets/tabs/](assets/tabs/) - Individual tab content (tab_overview.html, tab_requirements.html, tab_architecture.html, tab_technical_spec.html, tab_roadmap.html, tab_guides.html)
- [assets/build-presentation.js](assets/build-presentation.js) - Build script

**⚠️ IMPORTANT: presentation_final.html is a GENERATED file**
- DO NOT edit presentation_final.html directly - changes will be overwritten on next build
- ALL changes must be made in source files (tabs/*.html, styles.css, scripts.js, presentation_template.html)
- Rebuild after source changes: `node docs/presentation/assets/build-presentation.js`

---

## Customization Guide

### Editing Content

1. **Edit individual tabs** in `assets/tabs/`:
   - `tab_overview.html` - Project overview and key information
   - `tab_requirements.html` - Functional requirements and acceptance criteria
   - `tab_architecture.html` - System architecture and C4 diagrams
   - `tab_technical_spec.html` - Technology stack, API, database (or specialized tabs)
   - `tab_roadmap.html` - Project roadmap and milestones
   - `tab_guides.html` - Quick guides and best practices

2. **Update styles** in `assets/css/custom.css`:
   - Modify colors, fonts, spacing
   - Customize section backgrounds
   - Adjust diagram styles

3. **Modify behavior** in `assets/js/custom.js`:
   - Add custom interactions
   - Implement navigation helpers
   - Integrate analytics

### Presentation Update Workflow

**⚠️ CRITICAL RULE: NEVER edit presentation_final.html directly (it's a generated file)**

Follow this workflow for ALL presentation updates:

1. **Identify what to change:**
   - Content update → Edit `assets/tabs/tab_*.html` (6 files)
   - Styling update → Edit `assets/styles.css`
   - Behavior update → Edit `assets/scripts.js`
   - Layout update → Edit `assets/presentation_template.html`

2. **Make changes ONLY in source files:**
   - Tab content: `assets/tabs/tab_overview.html`, `tab_requirements.html`, `tab_architecture.html`, `tab_technical_spec.html`, `tab_roadmap.html`, `tab_guides.html`
   - Styling: `assets/styles.css`
   - JavaScript: `assets/scripts.js`
   - Template: `assets/presentation_template.html`

3. **Rebuild presentation:**
   ```bash
   cd docs/presentation
   node assets/build-presentation.js
   ```

4. **Verify changes:**
   - Open `presentation_final.html` in browser
   - Check all tabs load correctly
   - Verify diagrams render properly
   - Test navigation between tabs

5. **Commit BOTH:**
   - Source files (assets/tabs/, assets/*.{css,js,html})
   - Regenerated `presentation_final.html`

**Why this matters:** presentation_final.html is auto-generated by combining all source files. Direct edits will be lost on next rebuild.

---

## Build Instructions

**Prerequisites:**
- Project documentation in `docs/project/` (requirements.md, architecture.md, tech_stack.md, etc.)

**Build Process:**
1. Run skill: `ln-115-presentation-creator`
2. Skill reads documentation from `docs/project/`
3. Generates HTML tabs in `assets/tabs/`
4. Combines tabs into `presentation_final.html`
5. Creates this README for navigation

**Rebuild Triggers:**
- Updated project documentation
- New architecture diagrams
- Changed requirements or roadmap
- Added new guides

---

## Maintenance

**Last Updated:** {{LAST_UPDATED}}

**Update Triggers:**
- Documentation updates in docs/project/
- New C4 diagrams or Mermaid charts
- Roadmap or milestone changes
- Design system updates

**Verification:**
- [ ] presentation_final.html opens without errors
- [ ] All tabs load correctly (Overview, Requirements, Architecture, etc.)
- [ ] Mermaid diagrams render properly
- [ ] Navigation between tabs works
- [ ] All links to documentation are valid

---

## Related Documentation

- [Project Documentation](../project/README.md) - Source for presentation content
- [Architecture Diagrams](../project/architecture.md) - C4 Model diagrams
- [Requirements](../project/requirements.md) - Functional requirements

---

**Template Version:** 1.0.0
**Last Updated:** {{LAST_UPDATED}}
