// commitlint Configuration Template
// Generated by ln-742-precommit-setup
// Location: commitlint.config.mjs

export default {
  extends: ['@commitlint/config-conventional'],
  rules: {
    // Allowed commit types
    'type-enum': [
      2, // Error level
      'always',
      [
        'feat',     // New feature
        'fix',      // Bug fix
        'docs',     // Documentation only
        'style',    // Formatting, no code change
        'refactor', // Code change, no feature/fix
        'test',     // Adding/updating tests
        'chore',    // Maintenance tasks
        'ci',       // CI/CD changes
        'perf',     // Performance improvement
        'revert',   // Revert previous commit
      ],
    ],

    // Subject must be lowercase
    'subject-case': [2, 'always', 'lower-case'],

    // Max header length
    'header-max-length': [2, 'always', 100],

    // Body must have blank line before
    'body-leading-blank': [2, 'always'],

    // Footer must have blank line before
    'footer-leading-blank': [2, 'always'],
  },
};
