// React Component Test Template
// Generated by ln-743-test-infrastructure
// Location: src/components/Button.test.tsx

import { render, screen, fireEvent } from '@testing-library/react';
import { describe, it, expect, vi } from 'vitest';
// import { Button } from './Button';

// Sample component for testing (replace with actual import)
const Button = ({
  children,
  onClick,
  disabled = false,
}: {
  children: React.ReactNode;
  onClick?: () => void;
  disabled?: boolean;
}) => (
  <button onClick={onClick} disabled={disabled}>
    {children}
  </button>
);

describe('Button', () => {
  // Test: Component renders correctly
  it('renders with text content', () => {
    // Arrange
    const buttonText = 'Click me';

    // Act
    render(<Button>{buttonText}</Button>);

    // Assert
    expect(screen.getByRole('button')).toHaveTextContent(buttonText);
  });

  // Test: Click handler is called
  it('calls onClick when clicked', () => {
    // Arrange
    const handleClick = vi.fn();

    // Act
    render(<Button onClick={handleClick}>Click me</Button>);
    fireEvent.click(screen.getByRole('button'));

    // Assert
    expect(handleClick).toHaveBeenCalledTimes(1);
  });

  // Test: Disabled state
  it('does not call onClick when disabled', () => {
    // Arrange
    const handleClick = vi.fn();

    // Act
    render(
      <Button onClick={handleClick} disabled>
        Click me
      </Button>
    );
    fireEvent.click(screen.getByRole('button'));

    // Assert
    expect(handleClick).not.toHaveBeenCalled();
    expect(screen.getByRole('button')).toBeDisabled();
  });
});
