// Vitest Configuration Template
// Generated by ln-743-test-infrastructure
// Location: vitest.config.ts

import { defineConfig } from 'vitest/config';
import react from '@vitejs/plugin-react';

export default defineConfig({
  plugins: [react()],
  test: {
    // Use global test functions (describe, it, expect)
    globals: true,

    // Browser-like environment for React
    environment: 'jsdom',

    // Setup file for testing-library matchers
    setupFiles: './src/test/setup.ts',

    // Include patterns
    include: ['src/**/*.{test,spec}.{ts,tsx}'],

    // Exclude patterns
    exclude: ['node_modules', 'dist', 'e2e'],

    // Coverage configuration
    coverage: {
      // Use v8 for faster coverage (alternative: 'istanbul')
      provider: 'v8',

      // Output formats
      reporter: ['text', 'json', 'html', 'lcov'],

      // Source files to cover
      include: ['src/**/*.{ts,tsx}'],

      // Exclude from coverage
      exclude: [
        'src/**/*.test.{ts,tsx}',
        'src/**/*.spec.{ts,tsx}',
        'src/test/**',
        'src/**/*.d.ts',
      ],

      // Coverage thresholds - REQUIRED
      thresholds: {
        lines: 80,
        branches: 80,
        functions: 80,
        statements: 80,
      },
    },
  },
});
