---
name: retention-analysis
description: Analyze user retention and churn using survival analysis, cohort analysis, and machine learning. Calculate retention rates, build survival curves, predict churn risk, and generate retention optimization strategies. Use when working with user subscription data, membership information, or when user mentions retention, churn, survival analysis, or customer lifetime value.
allowed-tools: Read, Write, Edit, Bash, Grep, Glob
---

# Retention Analysis Skill

Analyze user retention patterns, predict customer churn, and optimize retention strategies using advanced statistical methods and machine learning techniques.

## Quick Start

This skill helps you:
1. **Calculate retention rates** and churn metrics
2. **Build survival curves** using Kaplan-Meier analysis
3. **Perform cohort analysis** to understand behavior patterns
4. **Predict churn risk** with machine learning models
5. **Identify retention drivers** using Cox regression
6. **Generate actionable insights** for retention improvement

## When to Use

- **SaaS Product Analysis**: User subscription renewal and cancellation patterns
- **Membership Programs**: Member engagement and loyalty analysis
- **E-commerce**: Customer repeat purchase behavior and subscription boxes
- **Gaming Apps**: Player retention and engagement metrics
- **Service Industries**: Customer satisfaction and long-term relationships
- **Subscription Businesses**: Monthly/yearly subscription analysis

## Key Requirements

Install required packages:
```bash
pip install pandas numpy matplotlib seaborn scikit-learn lifelines
```

## Core Workflow

### 1. Data Preparation
Your data should include:
- **User identifiers**: Unique user/customer IDs
- **Time variables**: Registration date, activity dates, subscription period
- **Event indicators**: Churn status (1=churned, 0=active)
- **User attributes**: Demographics, behavior, subscription details
- **Optional**: Usage metrics, payment history, engagement data

### 2. Analysis Process
1. **Data preprocessing**: Clean and prepare retention data
2. **Survival analysis**: Build Kaplan-Meier curves
3. **Cohort analysis**: Group users by acquisition time
4. **Risk modeling**: Identify churn drivers with Cox regression
5. **Churn prediction**: Build machine learning prediction models
6. **Insight generation**: Create actionable recommendations

### 3. Output Deliverables
- Retention rate tables and charts
- Survival curves with confidence intervals
- Cohort heatmaps and behavior patterns
- Churn risk scores and feature importance
- Retention optimization strategies

## Example Usage Scenarios

### SaaS Subscription Analysis
```python
# Analyze monthly subscription renewal patterns
# Predict which users are likely to churn
# Identify features that drive long-term retention
```

### Membership Program Analysis
```python
# Track member engagement over time
# Compare retention across membership tiers
# Analyze payment method impact on retention
```

### E-commerce Customer Retention
```python
# Analyze repeat purchase patterns
# Calculate customer lifetime value
# Identify high-value customer segments
```

## Key Analysis Methods

### Survival Analysis
- **Kaplan-Meier Estimator**: Non-parametric survival curve
- **Log-rank Test**: Compare survival between groups
- **Cox Proportional Hazards**: Multi-variable risk modeling
- **Median Survival Time**: Time when 50% of users have churned

### Cohort Analysis
- **Time-based Cohorts**: Group by acquisition month/quarter
- **Behavior-based Cohorts**: Group by usage patterns
- **Retention Matrix**: Visualize retention over time periods
- **Cohort Comparison**: Compare different cohort behaviors

### Machine Learning Prediction
- **Logistic Regression**: Binary churn classification
- **Random Forest**: Non-linear pattern detection
- **Gradient Boosting**: High accuracy prediction
- **Feature Importance**: Identify key churn drivers

## Common Business Questions Answered

1. **What is our overall retention rate?**
2. **How does retention vary by user segment?**
3. **What factors most influence customer churn?**
4. **Which users are at highest risk of leaving?**
5. **How can we improve long-term retention?**
6. **What is the typical customer lifetime?**

## Integration Examples

See [examples/](examples/) directory for:
- `basic_retention.py` - Survival analysis basics
- `cohort_analysis.py` - Cohort-based retention analysis
- `churn_prediction.py` - ML-based churn prediction
- Sample datasets for testing

## Best Practices

1. **Data Quality**: Ensure accurate churn definitions and time measurements
2. **Event Definition**: Clearly define what constitutes "churn"
3. **Time Windows**: Choose appropriate analysis periods
4. **Segmentation**: Analyze different user groups separately
5. **Validation**: Always validate models with test data
6. **Business Context**: Consider operational constraints and costs

## Advanced Features

- **Competing Risks Analysis**: Different types of churn
- **Time-varying Covariates**: Dynamic feature analysis
- **Customer Lifetime Value**: Integrate retention with revenue
- **Retention Forecasting**: Predict future retention trends
- **A/B Testing**: Measure retention improvement impact