# Shipany - Getting Started

**Pages:** 20

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改网站地图

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#获取-shipany-代码

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#定制化修改

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## ShipAny Docs

**URL:** https://docs.shipany.ai/zh/deploy/deploy-with-dokploy

**Contents:**
- 使用 Dokploy 部署
- 部署流程
- 参考资料

ShipAny 支持使用 Dokploy 部署。

在此之前，你需要按照 Dokploy 官方文档的说明，在你的服务器安装 Dokploy 服务。

你需要先按照 快速开始 的步骤，在本地拉取 shipany-template-one 模板代码，修改好后上传到你自己的 Github 仓库。

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#安装项目

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改落地页内容

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#提交代码

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#部署上线

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#开发调试

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改网站协议

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#项目检查

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改网站配色

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## ShipAny Docs

**URL:** https://docs.shipany.ai/zh/deploy/deploy-with-dokploy#参考资料

**Contents:**
- 使用 Dokploy 部署
- 部署流程
- 参考资料

ShipAny 支持使用 Dokploy 部署。

在此之前，你需要按照 Dokploy 官方文档的说明，在你的服务器安装 Dokploy 服务。

你需要先按照 快速开始 的步骤，在本地拉取 shipany-template-one 模板代码，修改好后上传到你自己的 Github 仓库。

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改网站多语言文案

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改网站-logo-和-icon

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#拉取项目代码

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## ShipAny Docs

**URL:** https://docs.shipany.ai/zh/deploy/deploy-with-dokploy#部署流程

**Contents:**
- 使用 Dokploy 部署
- 部署流程
- 参考资料

ShipAny 支持使用 Dokploy 部署。

在此之前，你需要按照 Dokploy 官方文档的说明，在你的服务器安装 Dokploy 服务。

你需要先按照 快速开始 的步骤，在本地拉取 shipany-template-one 模板代码，修改好后上传到你自己的 Github 仓库。

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#本地开发

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---

## 快速开始 | ShipAny Docs

**URL:** https://docs.shipany.ai/zh/#修改配置内容

**Contents:**
- 获取 ShipAny 代码
- 本地开发
  - 拉取项目代码
  - 安装项目
  - 开发调试
- 定制化修改
  - 修改网站配色
  - 修改落地页内容
  - 修改网站多语言文案
  - 修改网站协议

感谢选择 ShipAny，这是一个 NextJS 开发框架，用于快速开发 AI SaaS 项目。

https://shipany.ai/pricing

https://shipany.ai/my-orders

https://github.com/shipanyai/shipany-template-one

在浏览器打开 http://localhost:3000 ，即可预览你的项目

ShipAny 使用 tailwindcss4，请使用 oklch 颜色格式，复制主题样式

打开落地页内容文件：src/i18n/pages/landing/en.json

根据你的需求，把 src/i18n/pages/landing 下的所有文件都更新

打开网站多语言文件：src/i18n/messages/en.json

根据你的网站信息，把 src/i18n/messages 目录下的所有文件都更新

在网站正式上线之前，请根据你网站提供的服务，更新网站协议。

网站协议内容位于： src/app/(legal) 目录下

用新的内容替换 src/app/(legal)/privacy-policy/page.mdx 文件中的内容，更新隐私政策。

用新的内容替换 src/app/(legal)/terms-of-service/page.mdx 文件中的内容，更新服务条款。

请为你的网站生成 Logo 和 Icon 图片，分别替换 public/logo.png，public/favicon.ico 两个文件。

网站地图文件地址：public/sitemap.xml，默认内容如下：

请根据你的网站在线上运行的域名和需要暴露给搜索引擎的页面路径，更新此文件。

开发环境的配置文件是：.env.development，线上环境的配置文件是：.env.production

请根据项目实际情况，配置这两个文件的内容。配置参考：

在提交项目代码前，请检查以下内容是否都已按照实际情况修改。

请务必选择私有仓库，不要公开发布 ShipAny 的代码，拒绝盗版。

可参考以下步骤，使用 Vercel 把项目快速部署上线。

**Examples:**

Example 1 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 2 (unknown):
```unknown
git clone [email protected]:shipanyai/shipany-template-one.git my-shipany-project
```

Example 3 (unknown):
```unknown
cd my-shipany-project
```

Example 4 (unknown):
```unknown
cd my-shipany-project
```

---
