---
name: tech-manga-explainer
description: 生成技术科普漫画，用对话形式解释复杂的技术概念。当用户请求「用漫画解释技术」「生成技术科普漫画」「把这个技术概念画成漫画」「漫画教程」「用漫画讲解 XXX」或类似需求时使用。适合 n8n、Kubernetes、AI、编程、架构等技术话题。通过 nanobanana + Gemini API 生成图片。
---

# Tech Manga Explainer

用漫画对话形式将复杂技术概念变得通俗易懂。

## 核心特点

- **目标读者**：成年技术学习者、编程新手、想了解技术的非技术人员
- **表达形式**：漫画对话，老手带新手，边问边答
- **画风选择**：日式漫画、简约线条、赛博朋克、手绘涂鸦
- **角色组合**：支持多套角色，默认火影师徒（卡卡西 & 鸣人）
- **适用主题**：编程、架构、AI、自动化、云原生、数据库等技术概念

## ⚠️ 角色一致性规则（重要）

全套漫画必须保持角色外观完全一致。每一页 prompt 都会自动包含完整角色卡。

### 可选角色组

| 角色组 | 参数 | 导师 | 学员 | 风格特点 |
|-------|------|------|------|---------|
| 火影师徒 | `--preset naruto` | 😷 卡卡西 | 🍥 鸣人 | 热血修行、师徒传承、循序渐进（默认） |
| 程序员搭档 | `--preset coder` | 👨‍💻 码叔 | 🧑 小新 | 职场日常、轻松幽默 |

### 默认角色卡：火影师徒

**卡卡西（Kakashi）- 技术导师**
```
FACE & HEAD:
- Japanese male ninja, around 30 years old, tall and lean
- HAIR: Spiky SILVER/WHITE hair, gravity-defying, pointing up and left
- LEFT EYE: Covered by TILTED forehead protector (hitai-ate)
- RIGHT EYE: Relaxed, half-lidded, slightly bored
- MASK: ALWAYS wearing dark navy blue FACE MASK covering nose and mouth

CLOTHING (NEVER CHANGES):
- HEAD: Konoha forehead protector worn TILTED to cover left eye
- TOP: Green/olive JONIN VEST (flak jacket) with scroll pouches
- UNDER: Dark navy blue long-sleeve shirt with built-in mask
- PANTS: Dark navy blue ninja pants
- SHOES: Standard blue ninja sandals

⚠️ 必须出现的特征：银白刺猬头、遮左眼的护额、深蓝色面罩、绿色马甲、慵懒眼神
```

**鸣人（Naruto）- 热血学习者**
```
FACE & HEAD:
- Japanese male ninja, around 16 years old (Shippuden era)
- HAIR: Bright SPIKY BLONDE/YELLOW hair, messy, sticking out everywhere
- EYES: Big bright BLUE eyes, very expressive
- FACE: THREE WHISKER MARKS on each cheek (6 total)

CLOTHING (NEVER CHANGES - Shippuden outfit):
- HEAD: Konoha forehead protector worn on FOREHEAD (black cloth)
- TOP: Orange and BLACK TRACKSUIT jacket with zipper
- INSIDE: Black t-shirt visible at collar
- PANTS: Orange tracksuit pants
- SHOES: Black ninja sandals
- ACCESSORIES: Small green crystal necklace

⚠️ 必须出现的特征：金色刺猬头、蓝色眼睛、每边脸3道胡须印记、橙黑运动服、正戴护额
```

### 备选角色卡：程序员搭档

**码叔（Ma Shu）- 技术导师**
```
⚠️ 必须出现的特征：秃顶+两侧有发、银框眼镜、红黑格子衬衫、灰色帽衫堆在脖子后、络腮胡
```

**小新（Xiao Xin）- 技术新手**
```
⚠️ 必须出现的特征：蘑菇头黑发、黑色拉链卫衣敞开、白T恤、灰背包+像素机器人挂件
```

## 工作流程

### 第一步：技术概念分析与页数判断

1. 理解用户想要解释的技术概念
2. **🚨 必须：分析内容复杂度，根据下方标准确定合适的页数（禁止默认6页）**
3. 拆解知识点，为每个知识点设计「问-答」对话
4. 确定合适的比喻和类比（可用忍术类比技术概念）

#### ⚠️ 页数判断标准（强制执行）

**核心原则**：
- ❌ 禁止：不分析内容就默认生成 6 页
- ✅ 必须：先数核心概念数量，再用公式计算页数
- ✅ 必须：在规划中写明「复杂度判断理由」

**计算公式**：
```
总页数 = 开头引入(1页) + 核心概念数 × 1.5页 + 结尾总结(1页)

示例：3个核心概念 → 1 + 3×1.5 + 1 = 6.5 → 取整为 6-7 页
示例：7个核心概念 → 1 + 7×1.5 + 1 = 12.5 → 取整为 12-13 页
```

| 复杂度 | 页数范围 | 核心概念数 | 判断标准 | 示例 |
|-------|---------|-----------|---------|------|
| 简单 | 3-4页 | 1-2个 | 单一概念，无需深入原理 | "什么是API"、"环境变量" |
| 中等 | 5-8页 | 3-5个 | 需要解释原理+应用 | "Docker入门"、"什么是RAG" |
| 复杂 | 9-15页 | 6-10个 | 多个子概念相互关联 | "K8s架构全解"、"Transformer原理" |
| 系统性 | 15-25页 | 10+个 | 完整教程或论文解读 | "从零理解LLM"、"论文完整解读" |

**判断流程（必须执行）**：
1. 列出需要解释的核心概念/知识点
2. 数一数有几个核心概念
3. 根据上表确定复杂度和页数范围
4. 在规划中明确写出判断理由

**判断示例**：

示例1：用户要求「用漫画解释什么是 Pod」
- 核心概念：Pod的定义(1个)
- 判断：简单概念 → 3-4页
- 结构：引入 → Pod概念 → 与Container关系 → 总结

示例2：用户要求「用漫画讲解 Kubernetes 的 Pod、Node、Cluster」
- 核心概念：Pod + Node + Cluster + 三者关系 = 4个概念
- 判断：中等复杂度 → 6-7页
- 结构：引入 → Pod → Node → Cluster → 三者关系 → 实际应用 → 总结

示例3：用户要求「把这篇 Transformer 论文变成漫画」
- 核心概念：注意力机制 + Self-Attention + Multi-Head + Encoder + Decoder + 位置编码 + 训练过程 = 7+个概念
- 判断：复杂内容 → 12-15页
- 结构：引入 → 逐个概念讲解(每个1-2页) → 整体架构 → 应用场景 → 总结

### 第二步：漫画结构规划

**必须先输出规划，等用户确认后再生成图片。**

#### ⚠️ 规划硬性要求

1. **禁止合并页数**：不能写"第2-3页"，必须每页单独规划
2. **必须包含试错环节**：至少有1页是「鸣人犯错→卡卡西纠正」
3. **技术图示必须漫画化**：不能写抽象描述，要转化为具体画面

输出规划格式：

```
## 漫画规划

主题：[技术概念名称]
复杂度判断：[简单/中等/复杂/系统性] - [判断理由]
总页数：[X页]
画风：[manga/minimal/cyberpunk/sketch]
角色组：[naruto/coder] - 默认火影师徒

### 核心比喻
[主比喻] = [忍术/火影世界事物]
理由：[为什么这个比喻合适]
例：Docker = 封印卷轴，把整个环境封印进去，随时随地都能召唤

### 知识点拆解（每个概念单独一行）
1. [知识点1] - 第X页
2. [知识点2] - 第X页
3. 【试错环节】鸣人的理解错误 - 第X页 ← 必须有这一行
4. ...

### 第1页 - 引入问题
- 场景：[具体场景，如：木叶村情报分析室，鸣人对着一堆卷轴抓狂]
- 鸣人：「[用口癖开头，如：可恶！/卡卡西老师！]...」
- 卡卡西：「[用口癖开头，如：嘛嘛...]...」
- 画面要点：[具体视觉元素]

### 第2页 - [知识点1标题]
- 场景：[具体场景]
- 鸣人：「...」
- 卡卡西：「...」
- 技术图示：[漫画化描述，如：卡卡西手持三个卷轴，分别写着Q/K/V，箭头汇聚成发光球]
- 画面要点：[具体视觉元素]

### 第X页 - 鸣人的理解错误【必须有】
- 场景：[鸣人自信尝试的场景]
- 鸣人：「哦！我懂了！就是XXX对吧！（开始乱搞）」
- 卡卡西：「等等...你还没...」
- 画面要点：[失败/爆炸/报错特效]

### 第X+1页 - 卡卡西纠正
- 场景：[卡卡西认真讲解的场景]
- 卡卡西：「不对不对。关键点是...」
- 鸣人：「原来是这样...」
- 技术图示：[正确理解的可视化]
- 画面要点：[对比错误和正确的做法]

### 第N页 - 总结应用
- 场景：[成功场景，如：夕阳下的训练场]
- 鸣人：「哦哦！我懂了！[用自己的话总结，带上忍术类比]」
- 卡卡西：「嘛，差不多是这个意思（翻开小橙书）」
- 画面要点：[成就感、成长氛围]
```

**规划完成后询问用户**：
> 以上是漫画结构规划，共X页（包含1个试错学习环节）。确认无误后我将开始生成图片，或者你可以告诉我需要调整的地方。

### 第三步：生成漫画图片

使用脚本逐页生成：

```bash
# 默认使用卡卡西 & 鸣人
python3 /mnt/skills/user/tech-manga-explainer/scripts/generate_tech_manga.py \
  --style manga \
  --prompt "木叶村训练场，卡卡西在白板前讲解" \
  --dialogue "鸣人:这个 Docker 到底是什么啊！|卡卡西:嘛嘛，你想想忍者出任务时为什么要带卷轴？" \
  --tech-diagram "Docker 容器结构示意图" \
  --output page_01.png

# 使用程序员角色组
python3 /mnt/skills/user/tech-manga-explainer/scripts/generate_tech_manga.py \
  --preset coder \
  --style manga \
  --prompt "办公室场景，码叔在白板前" \
  --dialogue "小新:Pod是什么？|码叔:就像一个集装箱..." \
  --output page_01.png
```

## 画风参数

| 风格代码 | 风格名称 | 特点 | 适合主题 |
|---------|---------|------|---------|
| manga | 日式漫画 | 清晰线条、网点背景、动态表情 | 通用，最推荐 |
| minimal | 简约线条 | 黑白为主、极简、专业感 | 架构、流程讲解 |
| cyberpunk | 赛博朋克 | 霓虹色、科技感、暗色调 | AI、云原生、未来技术 |
| sketch | 手绘涂鸦 | 轻松随意、像白板画 | 快速原型、头脑风暴 |

## 角色组参数

| 角色组 | 参数 | 特点 | 对话风格 |
|-------|------|------|---------|
| naruto | `--preset naruto` | 热血修行、师徒传承 | 鸣人冲动提问，卡卡西慵懒解答 |
| coder | `--preset coder` | 职场日常、轻松幽默 | 小新虚心请教，码叔耐心讲解 |

## 脚本参数

```bash
python3 generate_tech_manga.py [选项]

必需参数：
  --prompt       场景描述

核心参数：
  --dialogue     对话内容，格式：角色:内容|角色:内容
  --preset       角色组 [naruto|coder]，默认 naruto（卡卡西&鸣人）
  --style        画风 [manga|minimal|cyberpunk|sketch]，默认 manga
  
可选参数：
  --tech-diagram 需要在画面中展示的技术图示描述
  --output       输出文件名，默认 tech_manga_page.png
  --size         图片尺寸，默认 1024x1024（推荐竖版 768x1024）
  --show-prompt  仅显示提示词，不生成图片
  --list-styles  列出所有可用画风
  --list-presets 列出所有可用角色组
```

## 使用示例

### 示例1：卡卡西 & 鸣人讲解 Docker（默认角色）

```bash
# 第1页 - 引入
python3 generate_tech_manga.py \
  --style manga \
  --prompt "木叶村训练场，鸣人在电脑前抓狂，卡卡西慵懒地走过来" \
  --dialogue "鸣人:卡卡西老师！这个 Docker 到底是什么啊！跑了一天都报错！|卡卡西:嘛嘛，别着急。你想想，忍者出任务时为什么要带卷轴？" \
  --output docker_01.png

# 第2页 - 核心比喻
python3 generate_tech_manga.py \
  --style manga \
  --prompt "卡卡西拿出一个卷轴展示，上面画着封印术式" \
  --dialogue "鸣人:因为...可以随时召唤需要的武器？|卡卡西:没错。Docker 就是你的封印卷轴，把整个运行环境封印进去，到哪里都能完美还原" \
  --tech-diagram "卷轴里封印着：代码 + 依赖 + 配置 = 容器" \
  --output docker_02.png

# 第3页 - 理解确认
python3 generate_tech_manga.py \
  --style manga \
  --prompt "鸣人眼睛发光，双手握拳，卡卡西眼神带笑" \
  --dialogue "鸣人:哦！我懂了！这就像我把影分身术封印在卷轴里，走到哪都能用！|卡卡西:差不多是这个意思（翻开小橙书）" \
  --output docker_03.png
```

### 示例2：程序员搭档讲解 Kubernetes Pod

```bash
python3 generate_tech_manga.py \
  --preset coder \
  --style manga \
  --prompt "办公室场景，小新对着电脑挠头，码叔端着咖啡杯走过来" \
  --dialogue "小新:码叔，这个 Pod 到底是啥？文档看得我头大|码叔:来，我给你打个比方" \
  --output k8s_pod_01.png
```

### 示例3：赛博朋克风格讲 AI Agent

```bash
python3 generate_tech_manga.py \
  --style cyberpunk \
  --prompt "霓虹灯闪烁的未来城市背景，卡卡西和鸣人站在一个全息投影前" \
  --dialogue "鸣人:AI Agent 和普通聊天机器人有什么区别？|卡卡西:Agent 能自己思考、规划、还能动手干活，就像上忍和下忍的区别" \
  --tech-diagram "Agent 循环图：感知→思考→规划→执行" \
  --output agent_01.png
```

## 对话设计技巧

好的技术漫画对话应该：

### 火影师徒风格（默认）

#### 🎭 角色语言特点（必须遵守）

**卡卡西的说话习惯：**
- 口癖：「嘛嘛...」「嘛，差不多是这个意思」
- 语气：慵懒、不紧不慢，但关键时刻一针见血
- 特点：喜欢用反问引导思考，偶尔翻小橙书
- 常用句式：
  - 「嘛嘛，别着急。你想想...」
  - 「这就是为什么...（叹气）」
  - 「不对不对，你理解错了。关键是...」
  - 「差不多是这个意思（眼神带笑）」

**鸣人的说话习惯：**
- 口癖：「我说啊！」「可恶！」「哦哦！我懂了！」
- 语气：热血、冲动、容易激动
- 特点：经常先犯错再理解，喜欢用自己的话总结
- 常用句式：
  - 「卡卡西老师！这个XXX到底是什么啊！」
  - 「可恶！又报错了！」
  - 「等等...我好像有点懂了...就是说...」
  - 「哦！我懂了！这就像XXX！」

#### 📝 对话示例对比

| 场景 | ❌ 错误写法（太正式） | ✅ 正确写法（火影风格） |
|------|---------------------|----------------------|
| 提问 | "请问 Docker 的定义是什么？" | "卡卡西老师！这个 Docker 到底是什么啊！我搞了一天都跑不起来！" |
| 回答 | "Docker 是一种容器化技术" | "嘛嘛，别着急。你想想，忍者出任务时为什么要带卷轴？" |
| 犯错 | "我理解错了" | "可恶！我以为直接复制就行了！" |
| 纠正 | "不对，应该是这样的" | "不对不对。你用的是下忍的方法。看好了...（单手结印）" |
| 理解 | "我明白了" | "哦哦！我懂了！这就像把影分身术封印在卷轴里！" |
| 确认 | "是的，你理解正确" | "嘛，差不多是这个意思（翻开小橙书）" |

#### 🥷 忍术类比技术概念（推荐映射表）

**基础设施类：**
| 技术概念 | 忍术类比 | 类比理由 |
|---------|---------|---------|
| Docker | 封印卷轴 | 把整个环境封印进去，随时召唤 |
| Kubernetes | 火影 | 调度管理所有忍者（容器），分配任务 |
| Container | 影分身 | 可以复制多个，每个都能独立工作 |
| 虚拟机 | 变身术 | 整个人变成另一个样子，开销大 |
| 镜像 | 卷轴原本 | 可以复制，但原本不变 |

**架构类：**
| 技术概念 | 忍术类比 | 类比理由 |
|---------|---------|---------|
| API | 通灵术 | 召唤其他服务来帮忙 |
| 微服务 | 木叶十二小强 | 各有专长，协同作战 |
| 负载均衡 | 分身协调 | 把任务分给多个分身 |
| 缓存 | 写轮眼记忆 | 看过一次就记住，下次直接用 |
| 消息队列 | 飞雷神标记 | 先做标记，之后再传送 |

**AI/ML类：**
| 技术概念 | 忍术类比 | 类比理由 |
|---------|---------|---------|
| 注意力机制 | 白眼 | 360度同时观察所有信息的关系 |
| Self-Attention | 白眼观察队友 | 每个人同时观察所有队友的状态 |
| Multi-Head | 影分身分析 | 多个分身从不同角度同时分析 |
| Encoder | 山中一族读心 | 理解输入信息的含义 |
| Decoder | 写轮眼复制 | 基于理解生成输出 |
| 神经网络 | 经络系统 | 信息像查克拉一样在网络中流动 |
| 训练 | 修行 | 反复练习直到掌握 |
| 过拟合 | 只会对付一个敌人 | 训练太单一，换个对手就不行了 |

#### ⚠️ 必须包含「试错学习」环节

**火影的核心是成长，每个教程都应该有鸣人犯错→被纠正的桥段：**

```
【试错学习模板】

第X页 - 鸣人的理解错误（必须有这一页）
- 场景：鸣人自信地尝试，结果失败
- 鸣人："我懂了！就是XXX对吧！（开始乱搞）"
- 卡卡西："等等...你还没学会基础就..."
- 画面要点：鸣人自信满满 → 爆炸/报错特效

第X+1页 - 卡卡西纠正
- 场景：卡卡西解释正确做法
- 卡卡西："不对不对。你理解错了关键点。XXX不是YYY，而是ZZZ。"
- 鸣人："原来是这样...那应该怎么做？"
- 画面要点：卡卡西认真讲解，鸣人虚心听讲
```

**常见的「犯错点」设计：**
1. 把相似概念搞混（Container vs Image）
2. 跳过基础直接上手（不看文档就开干）
3. 字面理解而非本质理解（"注意力"就是"看一遍"）
4. 过度简化（"就是XXX嘛，很简单"）

### 程序员搭档风格

**码叔的说话习惯：**
- 语气：耐心、幽默、偶尔自嘲
- 特点：喜欢用生活化比喻，喝咖啡
- 常用句式：「来，我给你打个比方...」「我当年也是这么踩坑的...」

**小新的说话习惯：**
- 语气：好奇、虚心、偶尔冒傻气
- 特点：认真记笔记，喜欢确认理解
- 常用句式：「所以说...」「等等，让我理一下...」

### 通用原则

- **每页对话不超过3轮**：漫画是视觉媒介，文字太多会挤压画面
- **禁止合并页数**：必须每页单独规划，不能写"第2-3页"
- **每个概念至少1页**：宁可多拆不要压缩

## 技术图示设计（漫画化）

技术图示不能太抽象，必须转化为漫画场景：

### ❌ 错误写法（太抽象）
```
技术图示：注意力权重计算图（Query, Key, Value）
```

### ✅ 正确写法（漫画化）
```
技术图示：三个鸣人分身分别拿着写有"Q/K/V"的卷轴，
箭头汇聚到中间一个发光的结果球，
旁边标注"注意力分数"
```

### 图示漫画化转换表

| 抽象图示 | 漫画化描述 |
|---------|-----------|
| 架构图（方块+箭头） | 忍者村落地图，建筑=组件，道路=数据流 |
| 流程图 | 任务卷轴，步骤用忍术手印表示 |
| 神经网络图 | 经络系统图，节点=穴位，连线=查克拉流动 |
| 数据流图 | 情报传递路线，情报=数据，忍者=处理节点 |
| 对比图 | 左边下忍做法（错误），右边上忍做法（正确） |

## 📦 第四步：生成交互式 HTML 漫画（必须执行）

**所有图片生成完成后，必须生成一个交互式 HTML 文件**，将所有页面整合成可浏览的漫画教程。

### HTML 模板文件

模板文件位于 `assets/` 目录：

```
assets/
├── manga_template.html      # 主模板（完整页面结构，深色技术风格）
├── page_template.html       # 单页模板（循环生成每页）
└── dialogue_template.html   # 对话模板（角色对话块）
```

### 模板占位符说明

**主模板 `manga_template.html`：**

| 占位符 | 说明 | 示例 |
|-------|------|------|
| `{{TITLE}}` | 教程标题 | Docker 入门：封印卷轴的秘密 |
| `{{COMPLEXITY}}` | 复杂度 | 简单/中等/复杂 |
| `{{PAGE_COUNT}}` | 总页数 | 6 |
| `{{STYLE}}` | 画风名称 | 日式漫画 |
| `{{ANALOGY_TITLE}}` | 核心比喻标题 | 本教程的核心比喻 |
| `{{ANALOGY_DESC}}` | 核心比喻描述 | Docker = 封印卷轴 |
| `{{PAGES}}` | 页面内容（循环生成） | - |

**单页模板 `page_template.html`：**

| 占位符 | 说明 |
|-------|------|
| `{{PAGE_NUM}}` | 页码 |
| `{{PAGE_TITLE}}` | 页面标题 |
| `{{IMAGE_FILE}}` | 图片文件名 |
| `{{DIALOGUES}}` | 对话内容（循环生成） |
| `{{TECH_POINT}}` | 技术要点 |

**对话模板 `dialogue_template.html`：**

| 占位符 | 说明 |
|-------|------|
| `{{CLASS}}` | CSS类名：mashu / xiaoxin |
| `{{EMOJI}}` | 角色 emoji：👨‍🏫 / 🧑 |
| `{{NAME}}` | 角色名称：码叔 / 小新 |
| `{{CONTENT}}` | 对话内容 |

### 生成流程

1. 读取 `assets/manga_template.html` 主模板
2. 对每一页，读取 `assets/page_template.html` 并填充内容
3. 对每段对话，读取 `assets/dialogue_template.html` 并填充
4. 将所有页面内容插入主模板的 `{{PAGES}}` 位置
5. 保存为 `[主题]_manga.html`

### 生成要求

1. **文件命名**：`[主题]_manga.html`
2. **图片引用**：使用相对路径引用生成的图片
3. **代码高亮**：技术术语用 `<code>` 标签包裹
4. **技术要点**：每页的核心知识点单独展示
5. **响应式**：确保手机端也能正常浏览

### 完成提示

生成 HTML 后，告知用户：
> ✅ 技术漫画已完成！共生成 [N] 张图片和 1 个交互式 HTML 文件。
> 
> 📁 文件列表：
> - page_01.png ~ page_0N.png（漫画图片）
> - [主题]_manga.html（交互式漫画，可在浏览器中打开）
>
> 💡 提示：将 HTML 文件和所有图片放在同一文件夹，用浏览器打开 HTML 即可阅读完整漫画教程。

## 依赖

- nanobanana skill（提供 Gemini 图像生成能力）
- Python 3
- 环境变量：通过 nanobanana 配置 GEMINI_API_KEY
