---
name: career-document-architect
description: Use when writing or reviewing career documents including research statements, teaching statements, diversity statements, CVs, or biosketches. Invoke when user mentions research statement, teaching philosophy, diversity statement, biosketch, academic CV, faculty application, or needs help with career narrative, positioning, or professional documents for academic advancement.
---

# Career Document Architect

## Table of Contents
- [Purpose](#purpose)
- [When to Use](#when-to-use)
- [Core Principles](#core-principles)
- [Workflow](#workflow)
- [Document Frameworks](#document-frameworks)
- [Writing Strategies](#writing-strategies)
- [Guardrails](#guardrails)
- [Quick Reference](#quick-reference)

## Purpose

This skill guides the creation of career documents for academic advancement including research statements, teaching statements, diversity statements, CVs, and biosketches. These documents require strategic positioning, narrative coherence, and alignment with institutional expectations while authentically representing the candidate's contributions and vision.

## When to Use

Use this skill when:

- **Faculty applications**: Research, teaching, and diversity statements
- **Fellowship applications**: Research statements for postdoc fellowships
- **Promotion packages**: Career narratives for tenure or advancement
- **Award applications**: Statements for career awards
- **CV/Biosketch preparation**: Formatting and content optimization
- **Career pivots**: Repositioning narrative for new directions

Trigger phrases: "research statement", "teaching statement", "teaching philosophy", "diversity statement", "biosketch", "academic CV", "faculty application", "career narrative"

**Do NOT use for:**
- Grant proposals (use `grant-proposal-assistant`)
- Recommendation letters (use `academic-letter-architect`)
- Manuscript writing (use `scientific-manuscript-review`)

## Core Principles

**1. Vision + Track Record**: Show where you're going AND what you've accomplished

**2. Coherent Narrative**: All pieces should tell a unified story

**3. Audience Awareness**: Tailor depth and framing to readers

**4. Evidence-Based Claims**: Support assertions with specifics

**5. Future-Oriented**: Emphasize trajectory and potential

**6. Authentic Voice**: Represent yourself genuinely

## Workflow

Copy this checklist and track your progress:

```
Career Document Progress:
- [ ] Step 1: Identify document type and audience
- [ ] Step 2: Gather raw materials (CV, accomplishments)
- [ ] Step 3: Develop core narrative thread
- [ ] Step 4: Draft document using appropriate framework
- [ ] Step 5: Add evidence and specifics
- [ ] Step 6: Align with institutional expectations
- [ ] Step 7: Polish and format
```

**Step 1: Identify Type and Audience**

Determine document type (research/teaching/diversity statement, CV, biosketch). Identify audience (search committee, review panel). Note any specific requirements (page limits, format specifications). See [resources/methodology.md](resources/methodology.md#audience-analysis) for audience considerations.

**Step 2: Gather Raw Materials**

Compile: Current CV, publications, grants, teaching evaluations, mentorship record, outreach activities, preliminary data, future plans. See [resources/methodology.md](resources/methodology.md#materials-checklist) for comprehensive list.

**Step 3: Develop Core Narrative**

Identify the through-line connecting your work. What question drives you? What impact do you seek? How does past work connect to future plans? See [resources/methodology.md](resources/methodology.md#narrative-development) for narrative construction.

**Step 4: Draft Using Framework**

Select appropriate framework for document type. Follow structure that matches institutional norms. See [Document Frameworks](#document-frameworks) for each type.

**Step 5: Add Evidence and Specifics**

Replace generic claims with specific accomplishments. Quantify where possible (papers, citations, students mentored). Add concrete examples for abstract claims.

**Step 6: Align with Institution**

Research institution's priorities. Emphasize fit without fabricating. Address how you contribute to their mission. See [resources/methodology.md](resources/methodology.md#institutional-fit) for alignment strategies.

**Step 7: Polish and Format**

Check length constraints. Ensure consistent formatting. Proofread carefully. Validate using [resources/evaluators/rubric_career_document.json](resources/evaluators/rubric_career_document.json). **Minimum standard**: Average score ≥ 3.5.

## Document Frameworks

### Research Statement

**Purpose:** Articulate research vision, demonstrate independence, show future potential

**Length:** Typically 2-5 pages (check requirements)

**Structure:**
```
OPENING (1 paragraph)
- Hook: Compelling statement of your research focus
- Big picture: Why this matters to the field/society
- Your role: How you contribute to addressing this

PAST RESEARCH (1-2 pages)
- Organize by themes, not chronology
- Highlight key contributions with impact
- Show how past work builds foundation for future
- Include quantifiable outcomes (papers, citations, methods)

CURRENT RESEARCH (0.5-1 page)
- Ongoing projects and preliminary results
- Bridge between past and future
- Show productivity and momentum

FUTURE DIRECTIONS (1-2 pages)
- 2-3 specific research directions
- For each: Why important? What's the approach? What's expected impact?
- Show independence and creativity
- Connect to fundable questions (NIH/NSF relevance)

CLOSING (1 paragraph)
- Synthesis: How pieces fit together
- Why this institution/department
- Broader impact statement
```

### Teaching Statement

**Purpose:** Articulate teaching philosophy and demonstrate effectiveness

**Length:** Typically 1-2 pages

**Structure:**
```
PHILOSOPHY (1-2 paragraphs)
- Core beliefs about teaching/learning
- What makes your approach distinctive
- Grounded in evidence or experience

EVIDENCE OF EFFECTIVENESS (1-2 paragraphs)
- Courses taught with enrollments
- Teaching evaluations (quote specific feedback)
- Student outcomes (publications, placements)
- Innovations introduced

METHODS AND APPROACHES (1-2 paragraphs)
- Specific techniques you use
- Active learning strategies
- Assessment approaches
- Technology integration

MENTORSHIP (1 paragraph)
- Undergraduate/graduate mentoring
- Student achievements
- Mentoring philosophy

FUTURE TEACHING (1 paragraph)
- Courses you could teach
- New courses you'd develop
- Curricular contributions
```

### Diversity Statement

**Purpose:** Demonstrate commitment to diversity, equity, and inclusion

**Length:** Typically 1-2 pages

**Structure:**
```
INTRODUCTION (1 paragraph)
- Your understanding of DEI in academia
- Why it matters to you
- Preview of your contributions

PAST ACTIONS (1-2 paragraphs)
- Specific activities promoting DEI
- Mentoring underrepresented students
- Curriculum development
- Outreach activities
- Quantify impact where possible

PERSONAL CONTEXT (optional, 1 paragraph)
- Your own background if relevant
- Experiences informing your commitment
- Only include if comfortable and genuine

FUTURE PLANS (1 paragraph)
- How you'll contribute at this institution
- Specific programs or initiatives
- Connection to institutional DEI priorities

CLOSING
- Synthesis of commitment
- Why this matters for your field
```

### CV Format (Academic)

**Standard Sections:**
```
CONTACT INFORMATION
EDUCATION
- Degrees in reverse chronological order
- Institution, degree, year, advisor (for PhD)

POSITIONS
- Academic appointments
- Industry positions (if relevant)

PUBLICATIONS
- Peer-reviewed (mark * for corresponding author)
- Preprints
- Reviews/Book chapters

GRANTS AND FUNDING
- Current and past funding
- Role (PI, Co-PI, etc.)
- Amount and duration

HONORS AND AWARDS

PRESENTATIONS
- Invited talks
- Conference presentations

TEACHING
- Courses taught
- Mentoring record

SERVICE
- Editorial boards
- Review panels
- Committee work

PROFESSIONAL MEMBERSHIPS
```

### NIH Biosketch

**Length:** 5 pages maximum

**Sections:**
```
A. PERSONAL STATEMENT (0.5 page)
- Why you're well-suited for this project
- Relevant experience and expertise
- Key accomplishments that qualify you
- Up to 4 publications supporting this statement

B. POSITIONS, SCIENTIFIC APPOINTMENTS, AND HONORS

C. CONTRIBUTIONS TO SCIENCE (up to 5 contributions, 0.5 page each)
- Contribution 1:
  - Description of contribution (1 paragraph)
  - Your specific role
  - Impact on field
  - Up to 4 publications supporting this contribution
- [Repeat for each contribution]

D. RESEARCH SUPPORT
- Current (with role, title, dates, description)
- Completed (last 3 years)
```

## Writing Strategies

### The "So What?" Test

For every claim, ask "so what?" If you can't answer, the claim needs more:

| Claim | So What? | Improved |
|-------|----------|----------|
| "I published 10 papers" | Impact? | "My 10 papers have been cited 500 times, including 3 that established new methods in the field" |
| "I'm passionate about teaching" | Evidence? | "My passion for teaching is reflected in consistent evaluation scores above 4.5/5 and 5 undergraduates who went to PhD programs" |
| "I'm committed to diversity" | What have you done? | "I co-founded a mentoring program that has supported 20 students from underrepresented groups" |

### Showing vs. Telling

| Telling (Weak) | Showing (Strong) |
|----------------|------------------|
| "I am a productive researcher" | "I have published 15 peer-reviewed articles including 3 in high-impact journals" |
| "I am an effective teacher" | "Student evaluations average 4.7/5.0 with comments highlighting my use of active learning" |
| "I am committed to mentoring" | "I have mentored 8 undergraduates, 5 of whom are now in PhD programs" |

### Future Vision Formula

For each future direction:
1. **The Question**: What will you investigate?
2. **The Importance**: Why does this matter?
3. **The Approach**: How will you do it?
4. **The Expected Impact**: What changes if successful?

## Guardrails

**Critical requirements:**

1. **Truthful**: Never fabricate or exaggerate
2. **Evidence-based**: Claims supported by specifics
3. **Audience-appropriate**: Match depth to readers
4. **Forward-looking**: Emphasize trajectory and vision
5. **Coherent narrative**: All pieces connect
6. **Compliant**: Follow format and length requirements

**Common pitfalls:**
- ❌ **Laundry lists**: Lists without narrative
- ❌ **Vague claims**: "I am passionate about..." without evidence
- ❌ **Missing future**: All past, no vision
- ❌ **Generic fit**: Same statement for every application
- ❌ **Too long**: Ignoring page limits
- ❌ **Missing impact**: What you did without why it matters

## Quick Reference

**Key resources:**
- **[resources/methodology.md](resources/methodology.md)**: Audience analysis, narrative development, institutional fit
- **[resources/template.md](resources/template.md)**: Section templates, examples
- **[resources/evaluators/rubric_career_document.json](resources/evaluators/rubric_career_document.json)**: Quality scoring

**Typical lengths:**
| Document | Typical Length |
|----------|----------------|
| Research Statement | 2-5 pages |
| Teaching Statement | 1-2 pages |
| Diversity Statement | 1-2 pages |
| NIH Biosketch | 5 pages max |

**Time estimates:**
- Research statement (from scratch): 2-4 weeks
- Research statement (revision): 1-2 days
- Teaching statement: 1-2 days
- Diversity statement: 1-2 days
- CV update: 1-2 hours
- Biosketch: 2-4 hours

**Inputs required:**
- Current CV
- Job/fellowship description
- Institutional priorities (if known)
- Specific accomplishments to highlight

**Outputs produced:**
- Polished career document
- Commentary on structure and positioning
