# Career Document Methodology

This resource supports the Career Document Architect skill with detailed methods.

---

## Audience Analysis

### Know Your Readers

**Faculty Search Committees:**
- Mix of specialists and non-specialists
- Looking for: Independence, vision, fit, potential
- Time-pressured: May skim initially
- Priorities: Can this person get tenure here?

**Fellowship Review Panels:**
- Often broader expertise range
- Looking for: Training plan, mentor quality, candidate promise
- Priorities: Is this a good investment?

**Promotion Committees:**
- Senior faculty across departments
- Looking for: Track record, impact, trajectory
- Priorities: Has this person met expectations?

### Tailoring Content

| Audience | Depth | Jargon | Length | Emphasis |
|----------|-------|--------|--------|----------|
| Specialists | High | OK | Longer OK | Methods, technical contribution |
| Broad committee | Moderate | Define | Shorter | Impact, big picture |
| Non-academic | Low | Avoid | Short | Applications, outcomes |

---

## Materials Checklist

### Before Writing, Gather:

**Research:**
- [ ] Complete publication list with citations
- [ ] Grants (current and pending)
- [ ] Conference presentations
- [ ] Invited talks
- [ ] Collaborations
- [ ] Methods developed
- [ ] Data resources created
- [ ] Patents (if any)

**Teaching:**
- [ ] Courses taught with enrollments
- [ ] Teaching evaluations (numbers and quotes)
- [ ] Course materials developed
- [ ] Pedagogical innovations
- [ ] Student feedback highlights

**Mentorship:**
- [ ] Students mentored (undergrad, grad, postdoc)
- [ ] Their current positions
- [ ] Co-authored papers with mentees
- [ ] Thesis committees served on

**Service:**
- [ ] Review activities (journals, grants)
- [ ] Committee work
- [ ] Professional society roles
- [ ] Editorial positions
- [ ] Outreach activities

**DEI:**
- [ ] Mentoring of underrepresented students
- [ ] Outreach programs
- [ ] Curriculum development for inclusion
- [ ] Committee service on DEI
- [ ] Workshops or training attended

---

## Narrative Development

### Finding Your Through-Line

Your through-line is the unifying theme connecting all your work.

**Questions to identify it:**
1. What question keeps you up at night?
2. What would you work on even without funding?
3. What problem are you uniquely positioned to solve?
4. How do your different projects connect?
5. What impact do you ultimately seek?

### Through-Line Formula

"I am working to [solve problem/answer question] by [approach], because [why it matters], which will [impact]."

**Example:**
"I am working to understand how cells make fate decisions by developing new imaging technologies that capture cellular dynamics in real time, because understanding this process is key to regenerative medicine and cancer biology, which will enable new therapeutic strategies."

### Testing Your Narrative

- Does every section connect to the through-line?
- Can you explain your work to a non-specialist using it?
- Does it distinguish you from others in your field?
- Does past work lead logically to future plans?

---

## Institutional Fit

### Research Before Writing

**Find out:**
- Department's strategic priorities
- Recent hires and their areas
- Gaps they might want to fill
- Core facilities and resources
- Potential collaborators
- Teaching needs and expectations
- DEI initiatives

**Sources:**
- Department website
- Recent job ad language
- Faculty profiles
- Recent news/announcements
- Talk with current faculty/students

### Showing Fit (Without Fabricating)

**Good fit statements:**
- "My expertise in X would complement existing strengths in Y"
- "I look forward to collaborating with [specific faculty] on [specific topic]"
- "The [specific resource] at [institution] would enable my planned work on..."
- "I could contribute to teaching [courses that align with your skills]"

**Avoid:**
- ❌ Generic fit: "I would be a good fit because I like your department"
- ❌ Name-dropping without substance: Listing names without real connection
- ❌ Fabricating interest: Claiming interest in things you don't actually care about

### Customization Strategy

**What to customize:**
- Opening/closing paragraphs mentioning institution
- Future plans that leverage their resources
- Teaching section matching their needs
- Collaborator mentions

**What stays the same:**
- Core narrative and through-line
- Past accomplishments
- Main future directions
- Fundamental teaching philosophy

---

## Common Mistakes

### Research Statement Mistakes

| Mistake | Problem | Fix |
|---------|---------|-----|
| All past, no future | No vision | Add 40% future content |
| Technical laundry list | No narrative | Organize around themes |
| Too much jargon | Alienates committee | Define terms, write for broader audience |
| No independence shown | Concern about PI shadow | Emphasize YOUR contributions |
| Missing impact | Why should they care? | Add significance statements |

### Teaching Statement Mistakes

| Mistake | Problem | Fix |
|---------|---------|-----|
| Generic philosophy | Not distinctive | Add specific methods and examples |
| No evidence | Just claims | Add evaluations, outcomes |
| Missing mentorship | Incomplete picture | Add student success stories |
| No future courses | Limited contribution | Propose courses you could teach |

### Diversity Statement Mistakes

| Mistake | Problem | Fix |
|---------|---------|-----|
| Virtue signaling | No substance | Focus on actions and impact |
| Only future plans | What have you done? | Add past activities |
| Performative | Seems insincere | Be genuine about your commitment |
| Too personal | Oversharing | Keep focus on professional activities |
| Generic | Same as everyone | Add specific examples |

---

## Revision Checklist

### Before Submitting

**Content:**
- [ ] Through-line clear and consistent
- [ ] Claims supported with evidence
- [ ] Future vision compelling and feasible
- [ ] Institutional fit demonstrated
- [ ] Impact statements present

**Structure:**
- [ ] Logical organization
- [ ] Appropriate headings
- [ ] Transitions between sections
- [ ] Opening hooks attention
- [ ] Closing memorable

**Format:**
- [ ] Within page limit
- [ ] Consistent formatting
- [ ] Professional appearance
- [ ] Proofread for errors
- [ ] Name on every page
