---
name: chain-roleplay-debate-synthesis
description: Use when facing decisions with multiple legitimate perspectives and inherent tensions. Invoke when stakeholders have competing priorities (growth vs. sustainability, speed vs. quality, innovation vs. risk), need to pressure-test ideas from different angles before committing, exploring tradeoffs between incompatible values, synthesizing conflicting expert opinions into coherent strategy, or surfacing assumptions that single-viewpoint analysis would miss.
---

# Chain Roleplay → Debate → Synthesis

## Workflow

Copy this checklist and track your progress:

```
Roleplay → Debate → Synthesis Progress:
- [ ] Step 1: Frame the decision and identify roles
- [ ] Step 2: Roleplay each perspective authentically
- [ ] Step 3: Structured debate between viewpoints
- [ ] Step 4: Synthesize into coherent recommendation
- [ ] Step 5: Validate synthesis quality
```

**Step 1: Frame the decision and identify roles**

State the decision clearly as a question, identify 2-5 stakeholder perspectives or roles that have legitimate but competing interests, and clarify what a successful synthesis looks like. See [Decision Framing](#decision-framing) for guidance on choosing productive roles.

**Step 2: Roleplay each perspective authentically**

For each role, articulate their position, priorities, concerns, and evidence. Genuinely advocate for each viewpoint without strawmanning. See [Roleplay Guidelines](#roleplay-guidelines) for authentic advocacy techniques and use [resources/template.md](resources/template.md) for complete structure.

**Step 3: Structured debate between viewpoints**

Facilitate direct clash between perspectives on key points of disagreement. Surface tensions, challenge assumptions, test edge cases, and identify cruxes (what evidence would change each perspective's mind). See [Debate Structure](#debate-structure) for debate formats and facilitation techniques.

**Step 4: Synthesize into coherent recommendation**

Integrate insights from all perspectives into a unified decision that acknowledges tradeoffs, incorporates valid concerns from each viewpoint, and explains what's being prioritized and why. See [Synthesis Patterns](#synthesis-patterns) for integration approaches and [resources/template.md](resources/template.md) for synthesis framework. For complex multi-stakeholder decisions, see [resources/methodology.md](resources/methodology.md).

**Step 5: Validate synthesis quality**

Check synthesis against [resources/evaluators/rubric_chain_roleplay_debate_synthesis.json](resources/evaluators/rubric_chain_roleplay_debate_synthesis.json) to ensure all perspectives were represented authentically, debate surfaced real tensions, synthesis is coherent and actionable, and no perspective was dismissed without engagement. See [When NOT to Use This Skill](#when-not-to-use-this-skill) to confirm this approach was appropriate.

---

## Decision Framing

### Choosing Productive Roles

**Good role selection:**
- **Competing interests**: Roles have legitimate but different priorities (e.g., Speed Advocate vs. Quality Guardian)
- **Different expertise**: Roles bring distinct knowledge domains (e.g., Engineer, Designer, Customer)
- **Value tensions**: Roles represent incompatible values (e.g., Privacy Advocate vs. Personalization)
- **Stakeholder representation**: Roles map to real decision-makers or affected parties

**Typical role patterns:**
- **Functional roles**: Engineer, Designer, PM, Marketer, Finance, Legal, Customer
- **Archetype roles**: Optimist, Pessimist, Risk Manager, Visionary, Pragmatist
- **Stakeholder roles**: Customer, Employee, Investor, Community, Regulator
- **Value roles**: Ethics Officer, Growth Hacker, Brand Guardian, Innovation Lead
- **Temporal roles**: Short-term Thinker, Long-term Strategist

**How many roles:**
- **2 roles**: Clean binary debate (build vs. buy, growth vs. profitability)
- **3 roles**: Triadic tension (speed vs. quality vs. cost)
- **4-5 roles**: Multi-stakeholder complexity (product strategy with eng, design, marketing, finance, customer)
- **Avoid >5**: Becomes unwieldy, synthesis too complex

### Framing the Question

**Strong framing:**
- "Should we prioritize X over Y?" (clear tradeoff)
- "What's the right balance between A and B?" (explicit tension)
- "Should we pursue strategy X?" (specific, actionable)

**Weak framing:**
- "What should we do?" (too vague)
- "How can we have our cake and eat it too?" (assumes false resolution)
- "Who's right?" (assumes winner rather than synthesis)

---

## Roleplay Guidelines

### Authentic Advocacy

**Each role should:**
1. **State position clearly**: What do they believe should be done?
2. **Articulate priorities**: What values or goals drive this position?
3. **Surface concerns**: What risks or downsides do they see in other approaches?
4. **Provide evidence**: What data, experience, or reasoning supports this view?
5. **Show vulnerability**: What uncertainties or limitations does this role acknowledge?

**Avoiding strawmen:**
- ❌ "The engineer just wants to use shiny new tech" (caricature)
- ✅ "The engineer values maintainability and believes new framework reduces technical debt"

- ❌ "Sales only cares about closing deals" (dismissive)
- ✅ "Sales is accountable for revenue and sees this feature as critical for competitive positioning"

**Empathy without capitulation:**
You can deeply understand a perspective without agreeing with it. Each role should be the "hero of their own story."

### Perspective-Taking Checklist

For each role, answer:
- [ ] What success looks like from this perspective
- [ ] What failure looks like from this perspective
- [ ] What metrics or evidence this role finds most compelling
- [ ] What this role fears about alternative approaches
- [ ] What this role knows that others might not
- [ ] What constraints or pressures this role faces

---

## Debate Structure

### Facilitating Productive Clash

**Debate formats:**

**1. Point-Counterpoint**
- Role A makes case for their position
- Role B responds with objections and counterarguments
- Role A addresses objections
- Repeat with Role B's case

**2. Devil's Advocate**
- One role presents the "default" or "obvious" choice
- Other roles systematically challenge assumptions and surface risks
- Goal: Pressure-test before committing

**3. Constructive Confrontation**
- Identify 3-5 key decision dimensions (cost, speed, risk, quality, etc.)
- Each role articulates position on each dimension
- Surface where perspectives conflict most

**4. Crux-Finding**
- Ask each role: "What would need to be true for you to change your mind?"
- Identify testable assumptions or evidence that would shift debate
- Focus discussion on cruxes rather than rehashing positions

### Questions to Surface Tensions

- "What's the strongest argument against your position?"
- "What does [other role] see that you might be missing?"
- "Where is the irreducible tradeoff between your perspectives?"
- "If you had to steelman the opposing view, what would you say?"
- "What happens in edge cases for your approach?"
- "What are you optimizing for that others aren't?"

### Red Flags in Debate

- **Premature consensus**: Roles agree too quickly without surfacing real tensions
- **Talking past each other**: Roles argue different points rather than engaging
- **Appeal to authority**: "Because the CEO said so" rather than reasoning
- **False dichotomies**: "Either we do X or we fail" without exploring middle ground
- **Unsupported claims**: "Everyone knows Y" without evidence or reasoning

---

## Synthesis Patterns

### Integration Approaches

**1. Weighted Synthesis**
- "We'll prioritize X, while incorporating safeguards for Y's concerns"
- Example: "Ship fast (PM's priority), but with feature flags and monitoring (Engineer's concern)"

**2. Sequencing**
- "First we do X, then we address Y"
- Example: "Launch MVP to test market (Growth), then invest in quality (Engineering) once product-market fit is proven"

**3. Conditional Strategy**
- "If condition A, do X; if condition B, do Y"
- Example: "If adoption > 10K users in Q1, invest in scale; otherwise, pivot based on feedback"

**4. Hybrid Approach**
- "Combine elements of multiple perspectives"
- Example: "Build core in-house (control) but buy peripheral components (speed)"

**5. Reframing**
- "Debate reveals the real question is Z, not X vs Y"
- Example: "Debate about pricing reveals we need to segment customers first"

**6. Elevating Constraint**
- "Identify the binding constraint both perspectives agree on"
- Example: "Both speed and quality advocates agree engineering capacity is the bottleneck; synthesis is to hire first"

### Synthesis Quality Markers

**Strong synthesis:**
- ✅ Acknowledges validity of multiple perspectives
- ✅ Explains what's being prioritized and why
- ✅ Addresses major concerns from each viewpoint
- ✅ Clear on tradeoffs being accepted
- ✅ Actionable recommendation
- ✅ Monitoring plan for key assumptions

**Weak synthesis:**
- ❌ "Let's do everything" (no prioritization)
- ❌ "X wins, Y loses" (dismisses valid concerns)
- ❌ "We need more information" (avoids decision)
- ❌ "It depends" without specifying conditions
- ❌ Vague platitudes without concrete next steps

---

## Examples

### Example 1: Short-form Synthesis

**Decision**: Should we rewrite our monolith as microservices?

**Roles**:
- **Scalability Engineer**: We need microservices to scale independently and deploy faster
- **Pragmatic Engineer**: Rewrite is 12-18 months with high risk; monolith works fine
- **Finance**: What's the ROI? Rewrite costs $2M in eng time

**Synthesis**:
Don't rewrite everything, but extract the 2-3 services with clear scaling needs (authentication, payment processing) as independent microservices. Keep core business logic in monolith for now. This addresses scalability concerns for bottleneck components (Scalability Engineer), limits risk and timeline (Pragmatic Engineer), and reduces cost to $400K vs. $2M (Finance). Revisit full migration if extracted services succeed and prove the pattern.

### Example 2: Full Analysis

For a complete worked example with detailed roleplay, debate, and synthesis, see:
- [resources/examples/build-vs-buy-crm.md](resources/examples/build-vs-buy-crm.md) - Sales, Engineering, Finance debate CRM platform decision

---

## When NOT to Use This Skill

**Skip roleplay-debate-synthesis when:**

❌ **Single clear expert**: If one person has definitive expertise and others defer, just ask the expert
❌ **No genuine tension**: If stakeholders actually agree, debate is artificial
❌ **Values cannot be negotiated**: If ethical red line, don't roleplay the unethical side
❌ **Time-critical decision**: If decision must be made in minutes, skip full debate
❌ **Implementation details**: If decision is "how" not "whether" or "what", use technical collaboration not debate

**Use simpler approaches when:**
- ✅ Decision is straightforward with clear data → Use decision matrix or expected value
- ✅ Need creative options not evaluation → Use brainstorming not debate
- ✅ Need detailed analysis not perspective clash → Use analytical frameworks
- ✅ Implementation planning not decision-making → Use project planning not roleplay

---

## Advanced Techniques

For complex multi-stakeholder decisions, see [resources/methodology.md](resources/methodology.md) for:
- **Multi-round debates** (iterative refinement of positions)
- **Audience-perspective shifts** (how synthesis changes for different stakeholders)
- **Facilitation anti-patterns** (how debates go wrong)
- **Synthesis under uncertainty** (when evidence is incomplete)
- **Stakeholder mapping** (identifying who needs to be represented)

---

## Resources

- **[resources/template.md](resources/template.md)** - Structured template for roleplay → debate → synthesis analysis
- **[resources/methodology.md](resources/methodology.md)** - Advanced facilitation techniques and debate formats
- **[resources/examples/](resources/examples/)** - Complete worked examples across domains
- **[resources/evaluators/rubric_chain_roleplay_debate_synthesis.json](resources/evaluators/rubric_chain_roleplay_debate_synthesis.json)** - Quality assessment rubric (10 criteria)
