# Roleplay → Debate → Synthesis Template

## Workflow

Copy this checklist and track your progress:

```
Roleplay → Debate → Synthesis Progress:
- [ ] Step 1: Frame decision and select 2-5 roles
- [ ] Step 2: Roleplay each perspective authentically
- [ ] Step 3: Facilitate structured debate
- [ ] Step 4: Synthesize unified recommendation
- [ ] Step 5: Self-assess with rubric
```

**Step 1: Frame decision and select roles**
Define the decision question clearly, identify 2-5 stakeholder perspectives with competing interests, and determine what successful synthesis looks like. Use [Quick Template](#quick-template) structure below.

**Step 2: Roleplay each perspective**
For each role, articulate their position, priorities, concerns, evidence, and vulnerabilities without strawmanning. See [Section 2](#2-roles--perspectives) of template structure.

**Step 3: Facilitate structured debate**
Use debate format (point-counterpoint, devil's advocate, crux-finding) to surface tensions and challenge assumptions. See [Section 3](#3-debate) of template structure.

**Step 4: Synthesize unified recommendation**
Integrate insights using synthesis patterns (weighted, sequencing, conditional, hybrid, reframing, or constraint elevation). See [Section 4](#4-synthesis) of template structure and [Synthesis Patterns](#synthesis-patterns).

**Step 5: Self-assess with rubric**
Validate using rubric: perspective authenticity, debate quality, synthesis coherence, and actionability. Use [Quality Checklist](#quality-checklist) before finalizing.

---

## Quick Template

Copy this structure to create your analysis:

```markdown
# Decision: [Question]

**Date**: [Today's date]
**Decision-maker**: [Who decides]
**Stakes**: [High/Medium/Low - impact and reversibility]

---

## 1. Decision Context

**What we're deciding:**
[Clear statement of the choice - "Should we X?" or "What's the right balance between X and Y?"]

**Why this matters:**
[Business impact, urgency, strategic importance]

**Success criteria for synthesis:**
[What makes this synthesis successful]

**Constraints:**
- [Budget, timeline, requirements, non-negotiables]

**Audience:** [Who needs to approve or act on this decision]

---

## 2. Roles & Perspectives

### Role 1: [Name - e.g., "Engineering Lead" or "Growth Advocate"]

**Position**: [What they believe should be done]

**Priorities**: [What values or goals drive this position]
- [Priority 1]
- [Priority 2]
- [Priority 3]

**Concerns about alternatives**: [What risks or downsides they see]
- [Concern 1]
- [Concern 2]

**Evidence**: [What data, experience, or reasoning supports this view]
- [Evidence 1]
- [Evidence 2]

**Vulnerabilities**: [What uncertainties or limitations they acknowledge]
- [What they're unsure about]
- [What could prove them wrong]

**Success metrics**: [How this role measures success]

---

### Role 2: [Name]

[Same structure as Role 1]

---

### Role 3: [Name] (if applicable)

[Same structure as Role 1]

---

## 3. Debate

### Key Points of Disagreement

**Dimension 1: [e.g., "Timeline - Fast vs. Thorough"]**
- **[Role A]**: [Their position on this dimension]
- **[Role B]**: [Their position on this dimension]
- **Tension**: [Where the conflict lies]

**Dimension 2: [e.g., "Risk Tolerance"]**
- **[Role A]**: [Position]
- **[Role B]**: [Position]
- **Tension**: [Conflict]

### Debate Transcript (Point-Counterpoint)

**[Role A] Opening Case:**
[Their argument for their position - 2-3 paragraphs]

**[Role B] Response:**
[Objections and counterarguments - 2-3 paragraphs]

**[Role A] Rebuttal:**
[Addresses objections - 1-2 paragraphs]

**Cross-examination:**
- **[Role A] to [Role B]**: [Probing question]
- **[Role B]**: [Response]

### Cruxes (What Would Change Minds)

**[Role A] would shift if:**
- [Condition or evidence that would change their position]

**[Role B] would shift if:**
- [Condition or evidence]

### Areas of Agreement

Despite disagreements, roles agree on:
- [Common ground 1]
- [Common ground 2]

---

## 4. Synthesis

### Integration Approach

**Pattern used**: [Weighted Synthesis / Sequencing / Conditional / Hybrid / Reframing / Constraint Elevation]

**Synthesis statement:**
[1-2 paragraphs explaining the unified recommendation that integrates insights from all perspectives]

### What We're Prioritizing

**Primary focus**: [What's being prioritized and why]
- From [Role X]: [What we're adopting from this perspective]
- From [Role Y]: [What we're adopting]

**Secondary considerations**: [How we're addressing other concerns]
- [Role X]'s concern about [issue]: Mitigated by [approach]

### Tradeoffs Accepted

**We're accepting:**
- [Tradeoff 1]
  - **Rationale**: [Why this makes sense]

**We're NOT accepting:**
- [What we explicitly decided against]
  - **Reason**: [Why rejected]

---

## 5. Recommendation

**Recommended Action:**
[Clear, specific recommendation in 1-2 sentences]

**Rationale:**
[2-3 paragraphs explaining why this synthesis is the best path forward]

**Key factors driving this decision:**
1. [Factor 1 - from which role's perspective]
2. [Factor 2]
3. [Factor 3]

---

## 6. Implementation

**Immediate next steps:**
1. [Action 1] - [Owner] by [Date]
2. [Action 2] - [Owner] by [Date]
3. [Action 3] - [Owner] by [Date]

**Phased approach:** (if using sequencing)
- **Phase 1** ([Timeline]): [What happens first]
- **Phase 2** ([Timeline]): [What happens next]

**Conditional triggers:** (if using conditional strategy)
- **If [condition A]**: [Then do X]
- **If [condition B]**: [Then do Y]

**Success metrics:**
- [Metric 1 - from Role X's perspective]: Target [value] by [date]
- [Metric 2 - from Role Y's perspective]: Target [value] by [date]

**Monitoring plan:**
- **Weekly**: [What we track frequently]
- **Monthly**: [What we review periodically]

---

## 7. Stakeholder Communication

**For [Stakeholder Group A - e.g., Executive Team]:**
- Key message: [1-sentence summary]
- Focus on: [What matters most to them]

**For [Stakeholder Group B - e.g., Engineering Team]:**
- Key message: [1-sentence summary]
- Focus on: [What matters most to them]

---

## 8. Appendix: Assumptions & Uncertainties

**Key assumptions:**
1. [Assumption 1]
   - **Confidence**: High / Medium / Low
   - **Impact if wrong**: [What happens]

**Unresolved uncertainties:**
- [Uncertainty 1]: [How we'll handle this]

**What would change our mind:**
- [Condition or evidence that would trigger reconsideration]
```

---

## Synthesis Patterns

### 1. Weighted Synthesis
"Prioritize X, while incorporating safeguards for Y"
- Example: "Ship fast (PM), with feature flags and monitoring (Engineer)"

### 2. Sequencing
"First X, then Y"
- Example: "Launch MVP (Growth), then invest in quality (Engineering) if PMF proven"

### 3. Conditional Strategy
"If A, do X; if B, do Y"
- Example: "If >10K users in Q1, scale; otherwise pivot"

### 4. Hybrid Approach
"Combine elements of multiple perspectives"
- Example: "Build core in-house (control) but buy peripherals (speed)"

### 5. Reframing
"Debate reveals real question is Z, not X vs Y"
- Example: "Pricing debate reveals we need to segment customers first"

### 6. Constraint Elevation
"Identify binding constraint all perspectives agree on"
- Example: "Both agree eng capacity is bottleneck; hire first"

---

## Quality Checklist

Before finalizing, verify:

**Roleplay quality:**
- [ ] Each role has clear position, priorities, concerns, evidence
- [ ] Perspectives feel authentic (not strawmen)
- [ ] Vulnerabilities acknowledged
- [ ] Success metrics defined for each role

**Debate quality:**
- [ ] Key disagreements surfaced on 3-5 dimensions
- [ ] Perspectives directly engage (not talking past each other)
- [ ] Cruxes identified (what would change minds)
- [ ] Areas of agreement noted

**Synthesis quality:**
- [ ] Clear integration approach (weighted/sequencing/conditional/hybrid/reframe/constraint)
- [ ] All roles' concerns addressed (not dismissed)
- [ ] Tradeoffs explicit (what we're accepting and why)
- [ ] Recommendation is unified and coherent
- [ ] Actionable next steps with owners and dates

**Communication quality:**
- [ ] Tailored for different stakeholders
- [ ] Key messages clear (1-sentence summaries)
- [ ] Emphasis appropriate for audience

**Integrity:**
- [ ] Assumptions stated explicitly
- [ ] Uncertainties acknowledged
- [ ] "What would change our mind" conditions specified
- [ ] No perspective dismissed without engagement
