---
name: cognitive-design
description: Use when designing visual interfaces, data visualizations, educational content, or presentations and need to ensure they align with how humans naturally perceive, process, and remember information. Invoke when user mentions cognitive load, visual hierarchy, dashboard design, form design, e-learning, infographics, or wants to improve clarity and reduce user confusion. Also applies when evaluating existing designs for cognitive alignment or choosing between design alternatives.
---

# Cognitive Design Principles

## Table of Contents

- [Read This First](#read-this-first)
- [How to Use This Skill](#how-to-use-this-skill)
- [Workflows](#workflows)
  - [New Design Workflow](#new-design-workflow)
  - [Design Review Workflow](#design-review-workflow)
  - [Quick Validation Workflow](#quick-validation-workflow)
- [Path Selection Menu](#path-selection-menu)
  - [Path 1: Understand Cognitive Foundations](#path-1-understand-cognitive-foundations)
  - [Path 2: Apply Design Frameworks](#path-2-apply-design-frameworks)
  - [Path 3: Evaluate Existing Designs](#path-3-evaluate-existing-designs)
  - [Path 4: Get Domain-Specific Guidance](#path-4-get-domain-specific-guidance)
  - [Path 5: Avoid Common Mistakes](#path-5-avoid-common-mistakes)
  - [Path 6: Access Quick Reference](#path-6-access-quick-reference)
  - [Path 7: Exit](#path-7-exit)

---

## Read This First

### What This Skill Does

This skill helps you create **cognitively aligned designs** - visual interfaces, data visualizations, educational content, and presentations that work with (not against) human perception, attention, memory, and decision-making.

**Core principle:** Effective design aligns with how people think, not just how things look.

### Why Cognitive Design Matters

**Common problems this addresses:**
- Users miss critical information in dashboards
- Complex interfaces cause cognitive overload and abandonment
- Data visualizations are misinterpreted or misleading
- Educational materials aren't retained
- Form completion rates are low
- Error messages are confusing

**How this helps:**
- Ground design decisions in cognitive psychology research
- Apply systematic frameworks (Cognitive Design Pyramid, Design Feedback Loop, Three-Layer Model)
- Evaluate designs against objective cognitive criteria
- Choose appropriate visual encodings based on perceptual hierarchy
- Manage attention, memory limits, and cognitive load

### When to Use This Skill

**Use this skill when:**
- ✓ Designing new interfaces, dashboards, visualizations, or educational content
- ✓ Users report confusion, overwhelm, or missing information
- ✓ Improving designs with poor metrics (low completion rates, high bounce rates)
- ✓ Conducting design reviews and need systematic evaluation
- ✓ Choosing between design alternatives with cognitive rationale
- ✓ Advocating for design decisions to stakeholders
- ✓ Designing high-stakes interfaces where cognitive failure has consequences

**Do NOT use for:**
- ✗ Pure aesthetic/brand identity decisions unrelated to cognition
- ✗ Technical implementation (coding, databases)
- ✗ Business strategy (feature prioritization, pricing)
- ✗ Tool-specific training (how to use Figma, Tableau, etc.)

### How This Skill Works

This is an **interactive hub** - you choose your path based on current need:

1. **Learning mode:** Start with Path 1 (Cognitive Foundations) to understand principles
2. **Application mode:** Jump to Path 2 (Frameworks) or Path 4 (Domain Guidance) to apply to specific design
3. **Evaluation mode:** Use Path 3 (Evaluation Tools) to assess existing designs
4. **Quick mode:** Use Path 6 (Quick Reference) for rapid decision-making

**After completing any path, return to the menu to select another or exit.**

### Collaborative Nature

I'll guide you through cognitive design principles by:
- Explaining WHY certain designs work (cognitive foundations)
- Providing HOW to apply principles (frameworks and workflows)
- Offering domain-specific guidance (data viz, UX, education, storytelling)
- Evaluating designs systematically (checklists and audits)

You bring domain expertise and context; I provide cognitive science grounding.

---

## How to Use This Skill

### Prerequisites

- Basic design literacy (familiarity with UI terminology, common chart types)
- Understanding of user tasks and context (from user research, stories, or brief)
- Access to design being created or evaluated

### Expected Outcomes

**Immediate:**
- Designs with clear visual hierarchy
- Reduced cognitive load (fewer overwhelm complaints)
- Systematic evaluation process

**Short-term (weeks):**
- Improved usability metrics (completion rates, time-on-task)
- Fewer user support requests
- More defensible design decisions

**Long-term (months):**
- Internalized cognitive principles
- Team shared vocabulary
- Measurable business impact

---

## Workflows

Choose a workflow based on your current situation:

### New Design Workflow

**Use when:** Creating a new interface, dashboard, visualization, or educational content from scratch

**Time:** 2-4 hours

**Copy this checklist and track your progress:**

```
New Design Progress:
- [ ] Step 1: Orient to cognitive principles
- [ ] Step 2: Structure design thinking with frameworks
- [ ] Step 3: Apply domain-specific guidance
- [ ] Step 4: Evaluate design for cognitive alignment
- [ ] Step 5: Check for common mistakes
- [ ] Step 6: Iterate based on findings
```

**Step 1: Orient to cognitive principles**

Start with [Cognitive Foundations](resources/cognitive-foundations.md) for deep understanding of WHY designs work (perception, memory, Gestalt principles) OR use [Quick Reference](resources/quick-reference.md) for rapid orientation (20 core principles, decision rules). Foundations give you theoretical grounding; Quick Reference gets you started faster.

**Step 2: Structure design thinking with frameworks**

Use [Design Frameworks](resources/frameworks.md) to apply systematic approaches: Cognitive Design Pyramid (4-tier quality assessment), Design Feedback Loop (interaction cycles), and Three-Layer Visualization Model (data communication fidelity). These provide repeatable structure for design decisions.

**Step 3: Apply domain-specific guidance**

Choose your domain: [Data Visualization](resources/data-visualization.md) for charts/dashboards, [UX Product Design](resources/ux-product-design.md) for interfaces/apps, [Educational Design](resources/educational-design.md) for e-learning/training, or [Storytelling & Journalism](resources/storytelling-journalism.md) for data journalism/presentations. Apply tailored cognitive principles for your specific context.

**Step 4: Evaluate design for cognitive alignment**

Use [Evaluation Tools](resources/evaluation-tools.md) to assess systematically: Cognitive Design Checklist (8 dimensions including visibility, hierarchy, chunking) and Visualization Audit Framework (4 criteria: Clarity, Efficiency, Integrity, Aesthetics). Identify weaknesses and prioritize fixes.

**Step 5: Check for common mistakes**

Review [Cognitive Fallacies](resources/cognitive-fallacies.md) to prevent failures: chartjunk, truncated axes, 3D distortion, cognitive biases, data integrity violations. Ensure your design avoids misleading patterns.

**Step 6: Iterate based on findings**

Return to domain guidance or frameworks as needed. Fix issues identified in evaluation. Re-evaluate until design passes cognitive alignment criteria (avg score ≥3.5 on rubric).

---

### Design Review Workflow

**Use when:** Evaluating existing designs for cognitive alignment, conducting design critiques, or diagnosing usability issues

**Time:** 30-60 minutes

**Copy this checklist and track your progress:**

```
Design Review Progress:
- [ ] Step 1: Systematic assessment with evaluation tools
- [ ] Step 2: Quick checks for common mistakes
- [ ] Step 3: Rapid validation against core principles
- [ ] Step 4: Note issues and prioritize fixes
```

**Step 1: Systematic assessment with evaluation tools**

Start with [Evaluation Tools](resources/evaluation-tools.md) for comprehensive review: Apply Cognitive Design Checklist (visibility, hierarchy, chunking, simplicity, memory support, feedback, consistency, scanning) and Visualization Audit Framework (score Clarity, Efficiency, Integrity, Aesthetics 1-5). Identify failing dimensions.

**Step 2: Quick checks for common mistakes**

Reference [Cognitive Fallacies](resources/cognitive-fallacies.md) for rapid diagnosis: Look for chartjunk, truncated axes, 3D effects, misleading colors, data integrity violations. These are common culprits in cognitive failures.

**Step 3: Rapid validation against core principles**

Use [Quick Reference](resources/quick-reference.md) for fast validation: Apply 3-question check (Attention? Memory? Clarity?), verify chart selection matches task, check color usage, confirm chunking fits working memory. Catches major issues quickly.

**Step 4: Note issues and prioritize fixes**

Document findings with severity: CRITICAL (integrity violations, accessibility failures), HIGH (clarity/efficiency issues preventing use), MEDIUM (suboptimal patterns, aesthetic issues), LOW (minor optimizations). Prioritize fixes foundation-first (perception → coherence → engagement → behavior).

---

### Quick Validation Workflow

**Use when:** Need rapid go/no-go decision, spot-checking changes, or validating against cognitive basics during active design work

**Time:** 5-10 minutes

**Copy this checklist and track your progress:**

```
Quick Validation Progress:
- [ ] Step 1: Three-question rapid check
- [ ] Step 2: Spot checks if issues found
```

**Step 1: Three-question rapid check**

Use [Quick Reference](resources/quick-reference.md) and apply: (1) Attention - "Is it obvious what to look at first?" (visual hierarchy clear, primary elements salient, predictable scanning), (2) Memory - "Is user required to remember anything that could be shown?" (state visible, options presented, fits 4±1 chunks), (3) Clarity - "Can someone unfamiliar understand in 5 seconds?" (purpose graspable, no unnecessary decoration, familiar terminology). If all YES → likely cognitively sound.

**Step 2: Spot checks if issues found**

If any question fails, use [Evaluation Tools](resources/evaluation-tools.md) for targeted diagnosis: Failed attention? Check hierarchy and visual salience sections. Failed memory? Check chunking and memory support sections. Failed clarity? Check simplicity and labeling sections. Apply specific fixes from relevant section.

---

## Path Selection Menu

**Choose your path based on current need:**

### Path 1: Understand Cognitive Foundations

**Choose this when:** You want to learn the core cognitive psychology principles underlying effective design (attention, memory, perception, Gestalt grouping, visual encoding hierarchy).

**What you'll get:** Deep understanding of WHY certain designs work, grounded in research from Tufte, Norman, Ware, Cleveland & McGill, Mayer, and others.

**Time:** 20-40 minutes

**→ [Go to Cognitive Foundations resource](resources/cognitive-foundations.md)**

---

### Path 2: Apply Design Frameworks

**Choose this when:** You want systematic frameworks to structure your design thinking and decision-making.

**What you'll get:** Three complementary frameworks:
- **Cognitive Design Pyramid** (4 tiers: Perceptual Efficiency → Cognitive Coherence → Emotional Engagement → Behavioral Alignment)
- **Design Feedback Loop** (Perceive → Interpret → Decide → Act → Learn)
- **Three-Layer Visualization Model** (Data → Visual Encoding → Cognitive Interpretation)

**Time:** 30-45 minutes

**→ [Go to Frameworks resource](resources/frameworks.md)**

---

### Path 3: Evaluate Existing Designs

**Choose this when:** You need to assess a design systematically for cognitive alignment, or conducting a design review/critique.

**What you'll get:**
- **Cognitive Design Checklist** (visibility, hierarchy, chunking, consistency, feedback, memory support)
- **Visualization Audit Framework** (4 criteria: Clarity, Efficiency, Integrity, Aesthetics)
- Examples of evaluation in practice

**Time:** 30-60 minutes (depending on design complexity)

**→ [Go to Evaluation Tools resource](resources/evaluation-tools.md)**

---

### Path 4: Get Domain-Specific Guidance

**Choose this when:** You're working on a specific type of design and want tailored cognitive principles for that context.

**Choose your domain:**

#### 4a. Data Visualization (Charts, Dashboards, Analytics)

**→ [Go to Data Visualization resource](resources/data-visualization.md)**

**Covers:** Chart selection via task-encoding alignment, dashboard hierarchy and grouping, progressive disclosure for exploration, narrative data visualization

---

#### 4b. Product/UX Design (Interfaces, Mobile Apps, Web Applications)

**→ [Go to UX Product Design resource](resources/ux-product-design.md)**

**Covers:** Learnability via familiar patterns, task flow efficiency, cognitive load management, onboarding design, error handling

---

#### 4c. Educational Design (E-Learning, Training, Instructional Materials)

**→ [Go to Educational Design resource](resources/educational-design.md)**

**Covers:** Multimedia learning principles, dual coding, worked examples, retrieval practice, segmenting, coherence principle

---

#### 4d. Storytelling/Journalism (Data Journalism, Presentations, Infographics)

**→ [Go to Storytelling & Journalism resource](resources/storytelling-journalism.md)**

**Covers:** Visual narrative structure, annotation strategies, scrollytelling, framing and context, visual metaphors

---

### Path 5: Avoid Common Mistakes

**Choose this when:** You want to prevent or diagnose cognitive design failures - chartjunk, misleading visualizations, cognitive biases, data integrity violations.

**What you'll get:**
- Common cognitive fallacies explained (WHY they fail)
- Visual misleads and how to avoid them
- Integrity principles for trustworthy design

**Time:** 15-25 minutes

**→ [Go to Cognitive Fallacies resource](resources/cognitive-fallacies.md)**

---

### Path 6: Access Quick Reference

**Choose this when:** You need rapid design guidance, core principles summary, or quick validation checks.

**What you'll get:**
- 20 core actionable principles (one-sentence summaries)
- 3-question quick check (Attention, Memory, Clarity)
- Common decision rules (when to use bar vs pie charts, how to chunk information, etc.)
- Design heuristics at a glance

**Time:** 5-15 minutes

**→ [Go to Quick Reference resource](resources/quick-reference.md)**

---

### Path 7: Exit

**Choose this when:** You've completed your design work or gathered the information you need.

**Before you exit:**
- Have you achieved your goal for this session?
- Do you need to return to any path for deeper exploration?
- Have you documented key design decisions and cognitive rationale?

**Thank you for using the Cognitive Design skill. Your designs are now more cognitively aligned!**

