# Educational Design

This resource provides cognitive design principles for instructional materials, e-learning courses, and educational software.

**Covered topics:**
1. Multimedia learning principles (Mayer's principles)
2. Dual coding theory
3. Worked examples for skill acquisition
4. Retrieval practice for retention
5. Segmenting and coherence

---

## Why Educational Design Needs Cognitive Principles

### WHY This Matters

**Core insight:** Human learning is constrained by working memory limits and processing channels - instructional design must align with these cognitive realities.

**Common problems:**
- Dense slides with text paragraphs + complex diagrams (split attention)
- Passive reading/watching (weak memory traces)
- Decorative graphics competing with instructional content
- Information overload (exceeds working memory)
- No active recall opportunities (retrieval practice missing)

**How cognitive principles help:**
- **Dual coding:** Combine relevant visuals + words (two memory traces)
- **Modalities principle:** Audio narration + visuals (splits load across channels)
- **Coherence:** Remove extraneous content (frees working memory)
- **Segmenting:** Break into chunks (fits working memory)
- **Retrieval practice:** Active recall strengthens retention

**Research foundation:** Richard Mayer's multimedia learning principles, John Sweller's cognitive load theory, Paivio's dual coding theory

---

## What You'll Learn

**Five key areas:**

1. **Multimedia Principles:** How to combine words, pictures, and audio effectively
2. **Dual Coding:** Leveraging visual and verbal processing channels
3. **Worked Examples:** Teaching complex procedures efficiently
4. **Retrieval Practice:** Active recall for long-term retention
5. **Segmenting & Coherence:** Chunking content and removing noise

---

## Why Multimedia Principles Matter

### WHY This Matters

**Core insight:** People have separate processing channels for visual and verbal information (Baddeley's working memory model) - proper multimedia design leverages both without overloading either.

**Baddeley's Model:**
- **Phonological loop:** Processes spoken/written words
- **Visuospatial sketchpad:** Processes images/spatial information
- **Central executive:** Coordinates both channels

**Implication:** You can split cognitive load across channels, but wrong combinations cause interference.

---

### WHAT to Apply

#### Multimedia Principle

**Principle:** People learn better from words + pictures than words alone

**Evidence:** Dual coding creates two memory traces instead of one (Paivio 1971, Mayer 2001)

**Application:**
```
❌ Text-only explanation of process
✓ Diagram showing process + text labels
✓ Video demonstrating concept + verbal explanation

Example: Teaching how heart pumps blood
❌ Text description only
✓ Animated diagram of heart + narration
Result: 50-100% better retention with multimedia
```

**Caution:** Pictures must be RELEVANT to content
```
❌ Decorative stock photo of "learning" (generic student at desk)
✓ Annotated diagram directly supporting concept
```

---

#### Modality Principle

**Principle:** Audio narration + visuals better than on-screen text + visuals

**Why:** On-screen text + complex visual both compete for visual channel (overload)

**Application:**
```
For animations or complex diagrams:
❌ Dense on-screen text + diagram (visual channel overloaded)
✓ Audio narration + diagram (splits load across channels)

Example: Explaining software interface
❌ Screenshot with text callouts explaining every feature
✓ Screenshot + voiceover explaining each feature
Result: Reduces cognitive load, improves comprehension
```

**Exception:** For static text-heavy content (articles, code), on-screen text is fine
- Reader controls pace
- Can re-read as needed
- Narration unnecessary

---

#### Spatial Contiguity Principle

**Principle:** Place text near corresponding graphics, not separated

**Why:** Prevents holding one in memory while searching for the other (split attention)

**Application:**
```
Diagram with labels:
❌ Diagram on left, labels in legend/list on right (requires visual search + memory)
✓ Labels directly ON or immediately adjacent to diagram parts

Example: Anatomy diagram
❌ Numbered diagram + separate key (1. Heart, 2. Lungs...)
✓ Direct labels on organs + leader lines
Result: Instant association, no memory burden
```

---

#### Temporal Contiguity Principle

**Principle:** Present corresponding narration and animation simultaneously, not sequentially

**Why:** Holding one in memory while waiting for the other adds cognitive load

**Application:**
```
Video lesson:
❌ Show full animation, then explain what happened (requires remembering animation)
✓ Narrate while animation plays (synchronized)

Example: Chemistry reaction
❌ Play full reaction animation → then explain
✓ Narrate each step as it's happening
Result: Immediate connection between visual and explanation
```

---

#### Coherence Principle

**Principle:** Exclude extraneous material - every element should support learning goal

**What to remove:**
```
❌ Decorative graphics unrelated to content
❌ Background music during instruction
❌ Tangential interesting stories (if they don't support main point)
❌ Excessive detail beyond learning objective

✓ Keep: Relevant diagrams, supporting examples, meaningful practice
```

**Application:**
```
Slide design:
Before (violates coherence):
- Stock photo of "teamwork" (decorative)
- Background music playing
- Tangent about company history
- Dense paragraph with extra details
→ Cognitive overload from extraneous content

After (coherent):
- Diagram directly illustrating concept
- No background music
- Focus only on learning objective
- Concise explanation
→ All working memory devoted to learning
```

**Evidence:** Extraneous content can reduce learning by 30-50% (Mayer)

---

#### Signaling Principle

**Principle:** Highlight essential material to guide attention

**Application:**
```
✓ Bold key terms first time introduced
✓ Headings/subheadings show structure
✓ Arrows/circles on diagrams highlighting key elements
✓ Verbal cues: "The most important point is..."
✓ Color highlighting for critical information (use sparingly)

Example: Complex diagram
Without signaling: User must determine what's important
With signaling: Arrows point to key mechanism, key part highlighted
Result: Attention directed to essentials
```

---

#### Segmenting Principle

**Principle:** Break lessons into user-paced segments rather than continuous presentation

**Why:** Fits working memory limits, allows consolidation before next chunk

**Application:**
```
❌ 30-minute continuous lecture video (cognitive overload)
✓ 6 segments × 5 minutes each, user clicks "Next" to continue

Benefits:
- Fits attention span
- User controls pace (can pause/replay)
- Breaks between segments allow consolidation
- Can skip ahead if already know topic
```

**Optimal segment length:** 3-7 minutes per concept

---

## Why Dual Coding Matters

### WHY This Matters

**Dual Coding Theory (Paivio):** Humans process visual and verbal information through separate channels that can reinforce each other.

**Benefits:**
- Two memory traces instead of one (redundancy aids recall)
- Visual channel good for spatial/concrete concepts
- Verbal channel good for abstract/sequential concepts
- Combined = stronger encoding

---

### WHAT to Apply

**Application patterns:**

**Text + Diagram:**
```
Example: Explaining data structure
✓ Code snippet (verbal) + visual diagram of structure
Result: Can recall via either channel
```

**Narration + Illustration:**
```
Example: Historical event
✓ Illustrated timeline + audio story
Result: Visual spatial memory + verbal narrative memory
```

**Caution - Avoid Redundant Text:**
```
❌ On-screen text identical to audio narration (doesn't add channel, just duplicates)
✓ On-screen keywords/outline + audio detailed explanation
```

---

## Why Worked Examples Matter

### WHY This Matters

**Core insight:** For novices learning procedures, worked examples reduce extraneous cognitive load and allow focus on solution patterns.

**Problem-solving (novice):**
- High cognitive load (exploring solution space)
- Many wrong paths taken
- Limited capacity for noticing patterns

**Worked example (novice):**
- Low extraneous load (no exploring)
- All capacity devoted to understanding steps
- Can study solution pattern

**Application:** Transition from worked examples → partially completed examples → full problems

---

### WHAT to Apply

**Worked Example Structure:**

```
Step 1: Problem statement
Step 2: Solution shown with explanation of each step
Step 3: Principle highlighted: "Notice how we..."

Example: Math problem
Instead of: "Solve this equation: 3x + 7 = 19"
Better:
  Problem: 3x + 7 = 19
  Solution:
    3x + 7 = 19
    3x = 12       (subtract 7 from both sides - inverse operation)
    x = 4         (divide both sides by 3 - inverse operation)
  Principle: Use inverse operations to isolate variable
```

**Fading:**
```
Start: Full worked example
Next: Partially worked (complete last step)
Then: Start provided, learner completes middle + end
Finally: Full problem-solving
```

---

## Why Retrieval Practice Matters

### WHY This Matters

**Testing effect:** Practicing retrieval (active recall) creates stronger memory traces than passive re-reading.

**Evidence:** Retrieval practice improves long-term retention by 30-50% vs passive study (Roediger & Karpicke)

**Why it works:**
- Active recall strengthens memory pathways
- Identifies gaps in knowledge (metacognitive benefit)
- Desirable difficulty (requires effort = better encoding)

---

### WHAT to Apply

**Application patterns:**

**Embedded quizzes:**
```
After each segment: 2-3 questions testing key concepts
✓ Multiple choice (forces retrieval)
✓ Short answer (even better - must generate answer)
✓ Immediate explanatory feedback (not just "correct/incorrect")

Example:
After video on Gestalt principles:
Q: "Which principle explains why we see related items as grouped when they're placed close together?"
A: Proximity principle
Feedback: "Correct! Proximity is the tendency to group nearby elements. This is why we use whitespace to separate unrelated content."
```

**Spaced repetition:**
```
Immediate: Quiz at end of lesson
1 day later: Review quiz
1 week later: Cumulative quiz
1 month later: Final assessment

Spacing effect: Distributed practice beats massed practice
```

**Low-stakes practice:**
```
✓ Formative quizzes don't count toward grade (reduces anxiety)
✓ Unlimited attempts (learning goal, not evaluation)
✓ Explanatory feedback (teaching moment)
```

---

## Why Segmenting & Coherence Matter

### WHY This Matters

**Segmenting:** Prevents cognitive overload by chunking within working memory limits

**Coherence:** Eliminates extraneous load so all capacity devoted to learning

**Together:** Essential for managing cognitive load in complex material

---

### WHAT to Apply

**Segmenting strategies:**

```
30-minute topic divided into:
- Segment 1 (5 min): Concept introduction + first example
- Pause (user clicks next)
- Segment 2 (5 min): Second example + principle
- Pause
- Segment 3 (5 min): Practice problem
- Pause
- Segment 4 (5 min): Application to real scenario
- Pause
- Segment 5 (5 min): Summary + quiz

Benefits: Working memory not overloaded, consolidation between segments
```

**Coherence strategies:**

```
Remove:
❌ Decorative stock photos
❌ Background music
❌ Tangential fun facts (if they don't support learning objective)
❌ Overly detailed explanations beyond scope

Keep:
✓ Relevant diagrams supporting concept
✓ Concrete examples illustrating principle
✓ Practice problems applying knowledge
✓ Summaries reinforcing key points
```

