---
name: cognitive-design
description: Use when designing visual interfaces, data visualizations, educational content, or presentations and need to ground decisions in cognitive psychology principles — perception, attention, memory, Gestalt grouping, and visual encoding hierarchy. Invoke when user mentions cognitive load, visual hierarchy, working memory, preattentive processing, Gestalt principles, encoding hierarchy, cognitive design pyramid, or needs to understand WHY certain designs work. For design evaluation, use `design-evaluation-audit`. For fallacy prevention, use `cognitive-fallacies-guard`. For data storytelling, use `visual-storytelling-design`.
---

# Cognitive Design Principles

## Table of Contents

- [Read This First](#read-this-first)
- [How to Use This Skill](#how-to-use-this-skill)
- [Workflows](#workflows)
  - [Apply Cognitive Principles Workflow](#apply-cognitive-principles-workflow)
  - [Quick Validation Workflow](#quick-validation-workflow)
- [Path Selection Menu](#path-selection-menu)
  - [Path 1: Understand Cognitive Foundations](#path-1-understand-cognitive-foundations)
  - [Path 2: Apply Design Frameworks](#path-2-apply-design-frameworks)
  - [Path 3: Get Domain-Specific Guidance](#path-3-get-domain-specific-guidance)
  - [Path 4: Access Quick Reference](#path-4-access-quick-reference)
  - [Path 5: Explore Source Landscape](#path-5-explore-source-landscape)
  - [Path 6: Exit](#path-6-exit)
- [Related Skills](#related-skills)

---

## Read This First

### What This Skill Does

This skill provides the **cognitive science foundations** for effective design — the perception, attention, memory, and decision-making principles that explain WHY certain designs work.

**Core principle:** Effective design aligns with how people think, not just how things look.

### Why Cognitive Design Matters

**Common problems this addresses:**
- Users miss critical information in dashboards
- Complex interfaces cause cognitive overload and abandonment
- Data visualizations are misinterpreted
- Educational materials aren't retained
- Form completion rates are low

**How this helps:**
- Ground design decisions in cognitive psychology research (Tufte, Norman, Ware, Cleveland & McGill, Mayer)
- Apply systematic frameworks (Cognitive Design Pyramid, Design Feedback Loop, Three-Layer Model)
- Choose appropriate visual encodings based on perceptual hierarchy
- Manage attention, memory limits, and cognitive load
- Apply domain-specific cognitive principles (data viz, UX, education)

### When to Use This Skill

**Use this skill when:**
- ✓ Learning cognitive foundations for design
- ✓ Applying cognitive frameworks to new designs
- ✓ Choosing visual encodings based on perception research
- ✓ Getting domain-specific cognitive guidance (data viz, UX, education)
- ✓ Advocating for design decisions with research backing
- ✓ Understanding WHY designs succeed or fail cognitively

**Use other skills for:**
- → `design-evaluation-audit` for systematic design reviews and audits
- → `cognitive-fallacies-guard` for detecting misleading visualizations
- → `visual-storytelling-design` for data journalism and narrative visualization
- → `information-architecture` for content organization and navigation
- → `d3-visualization` for implementing visualizations with D3.js

---

## How to Use This Skill

### Prerequisites

- Basic design literacy (familiarity with UI terminology, common chart types)
- Understanding of user tasks and context
- Access to design being created

### Expected Outcomes

**Immediate:** Designs grounded in cognitive science with clear rationale
**Short-term:** Improved usability metrics (completion rates, time-on-task)
**Long-term:** Internalized cognitive principles, team shared vocabulary

---

## Workflows

### Apply Cognitive Principles Workflow

**Use when:** Creating a new interface, dashboard, visualization, or educational content from scratch

**Time:** 1-2 hours

**Copy this checklist and track your progress:**

```
Cognitive Design Progress:
- [ ] Step 1: Orient to cognitive principles
- [ ] Step 2: Structure design thinking with frameworks
- [ ] Step 3: Apply domain-specific guidance
- [ ] Step 4: Validate against quick reference
```

**Step 1: Orient to cognitive principles**

Start with [Cognitive Foundations](resources/cognitive-foundations.md) for deep understanding of WHY designs work (perception, memory, Gestalt principles) OR use [Quick Reference](resources/quick-reference.md) for rapid orientation (20 core principles, decision rules). Foundations give you theoretical grounding; Quick Reference gets you started faster.

**Step 2: Structure design thinking with frameworks**

Use [Design Frameworks](resources/frameworks.md) to apply systematic approaches: Cognitive Design Pyramid (4-tier quality assessment), Design Feedback Loop (interaction cycles), and Three-Layer Visualization Model (data communication fidelity). These provide repeatable structure for design decisions.

**Step 3: Apply domain-specific guidance**

Choose your domain: [Data Visualization](resources/data-visualization.md) for charts/dashboards, [UX Product Design](resources/ux-product-design.md) for interfaces/apps, or [Educational Design](resources/educational-design.md) for e-learning/training. Apply tailored cognitive principles for your specific context.

**Step 4: Validate against quick reference**

Use [Quick Reference](resources/quick-reference.md) to verify your design against the 3-question check (Attention? Memory? Clarity?) and 20 core principles. Confirm your design passes basic cognitive alignment.

**Next steps:** Use `design-evaluation-audit` skill for systematic evaluation, `cognitive-fallacies-guard` to check for misleads.

---

### Quick Validation Workflow

**Use when:** Need rapid go/no-go decision, spot-checking changes, or validating against cognitive basics during active design work

**Time:** 5-10 minutes

**Copy this checklist and track your progress:**

```
Quick Validation Progress:
- [ ] Step 1: Three-question rapid check
- [ ] Step 2: Spot checks if issues found
```

**Step 1: Three-question rapid check**

Use [Quick Reference](resources/quick-reference.md) and apply: (1) Attention - "Is it obvious what to look at first?" (visual hierarchy clear, primary elements salient, predictable scanning), (2) Memory - "Is user required to remember anything that could be shown?" (state visible, options presented, fits 4±1 chunks), (3) Clarity - "Can someone unfamiliar understand in 5 seconds?" (purpose graspable, no unnecessary decoration, familiar terminology). If all YES → likely cognitively sound.

**Step 2: Spot checks if issues found**

If any question fails, consult the relevant cognitive foundation: Failed attention? Check hierarchy and visual salience in [Cognitive Foundations](resources/cognitive-foundations.md). Failed memory? Check chunking and memory constraints. Failed clarity? Check simplicity principles and labeling guidance.

---

## Path Selection Menu

**Choose your path based on current need:**

### Path 1: Understand Cognitive Foundations

**Choose this when:** You want to learn the core cognitive psychology principles underlying effective design (attention, memory, perception, Gestalt grouping, visual encoding hierarchy).

**What you'll get:** Deep understanding of WHY certain designs work, grounded in research.

**Time:** 20-40 minutes

**→ [Go to Cognitive Foundations resource](resources/cognitive-foundations.md)**

---

### Path 2: Apply Design Frameworks

**Choose this when:** You want systematic frameworks to structure your design thinking.

**What you'll get:** Three complementary frameworks:
- **Cognitive Design Pyramid** (4 tiers: Perceptual Efficiency → Cognitive Coherence → Emotional Engagement → Behavioral Alignment)
- **Design Feedback Loop** (Perceive → Interpret → Decide → Act → Learn)
- **Three-Layer Visualization Model** (Data → Visual Encoding → Cognitive Interpretation)

**Time:** 30-45 minutes

**→ [Go to Frameworks resource](resources/frameworks.md)**

---

### Path 3: Get Domain-Specific Guidance

**Choose this when:** You're working on a specific type of design and want tailored cognitive principles.

**Choose your domain:**

#### 3a. Data Visualization (Charts, Dashboards, Analytics)

**→ [Go to Data Visualization resource](resources/data-visualization.md)**

**Covers:** Chart selection via task-encoding alignment, dashboard hierarchy and grouping, progressive disclosure for exploration, narrative data visualization

---

#### 3b. Product/UX Design (Interfaces, Mobile Apps, Web Applications)

**→ [Go to UX Product Design resource](resources/ux-product-design.md)**

**Covers:** Learnability via familiar patterns, task flow efficiency, cognitive load management, onboarding design, error handling

---

#### 3c. Educational Design (E-Learning, Training, Instructional Materials)

**→ [Go to Educational Design resource](resources/educational-design.md)**

**Covers:** Multimedia learning principles, dual coding, worked examples, retrieval practice, segmenting, coherence principle

---

### Path 4: Access Quick Reference

**Choose this when:** You need rapid design guidance, core principles summary, or quick validation checks.

**What you'll get:** 20 core principles, 3-question check, common decision rules, design heuristics

**Time:** 5-15 minutes

**→ [Go to Quick Reference resource](resources/quick-reference.md)**

---

### Path 5: Explore Source Landscape

**Choose this when:** You want to understand the research traditions and key authors behind cognitive design principles.

**What you'll get:** Key researchers (Tufte, Norman, Ware, Cleveland & McGill, Mayer, Nielsen), their contributions, and when to cite them.

**Time:** 10-20 minutes

**→ [Go to Source Landscape resource](resources/source-landscape.md)**

---

### Path 6: Exit

**Choose this when:** You've completed your design work or gathered the information you need.

**Before you exit:**
- Have you achieved your goal for this session?
- Need to evaluate your design? → Use `design-evaluation-audit` skill
- Need to check for misleads? → Use `cognitive-fallacies-guard` skill
- Need to tell a data story? → Use `visual-storytelling-design` skill

---

## Related Skills

| Skill | Use For |
|---|---|
| `design-evaluation-audit` | Systematic design reviews using cognitive checklists and visualization audits |
| `cognitive-fallacies-guard` | Detecting chartjunk, misleading axes, cognitive biases, data integrity violations |
| `visual-storytelling-design` | Data journalism, presentations, infographics, narrative visualization |
| `information-architecture` | Content organization, navigation design, taxonomy, findability |
| `d3-visualization` | Implementing interactive data visualizations with D3.js |
