# Example: Product Launch Announcement

## Scenario

**Context:** Launching "Analytics Insights" - automated report generation tool that saves customer success teams 10-15 hours per week. Announcing to existing customers via email + blog post.

**Audience:** Customer success managers and directors at mid-size B2B SaaS companies
- Expertise: Moderate technical literacy, very familiar with pain points
- Concerns: Time savings, ease of adoption, cost, disruption to current workflow
- Time available: 2-3 minutes to read email, 5-10 minutes for blog

**Purpose:** Drive adoption of new feature (target: 40% adoption in 30 days)

**Tone:** Empathetic (acknowledge pain), excited (benefits), supportive (easy transition)

---

## Story Structure Used

**Before-After-Bridge (BAB):**
1. Before: Painful current state (audience's lived experience)
2. After: Improved future state (what becomes possible)
3. Bridge: The solution (how to get there)
4. Call to Action: Next step to access the "after" state

---

## Draft: Communication

### Before (Weak - Feature Announcement)

> Subject: New Feature: Analytics Insights
>
> Hi there,
>
> We're excited to announce Analytics Insights, a new feature that automatically generates customer health reports. This feature uses machine learning to analyze usage patterns and create personalized insights for each customer.
>
> Key features:
> - Automated report generation
> - Customizable templates
> - Email scheduling
> - Data visualization
> - 10+ pre-built metrics
>
> Analytics Insights is available now in the dashboard under "Reports." Check out our documentation for setup instructions.
>
> Let us know if you have any questions!

**Problems:**
- ❌ Leads with feature ("Analytics Insights") not benefit
- ❌ Doesn't acknowledge current pain (assumes audience knows why they need this)
- ❌ Feature list without context (why do I care about "customizable templates"?)
- ❌ No proof (claims time savings but doesn't quantify or show evidence)
- ❌ Weak CTA ("check it out") without urgency or clear next step
- ❌ No storytelling - just a list of features

### After (Strong - Storytelling)

> Subject: Spend 15 hours/week on customers, not spreadsheets
>
> # Before: Your Weekends Belong to Excel. After: They Belong to You.
>
> If you're a customer success manager, I don't have to tell you how your Fridays go.
>
> **Your current Friday afternoon:**
> - 2:00pm: Start pulling usage data for your top 20 accounts
> - 2:45pm: Export to CSV, clean up formatting issues (why does every export break?)
> - 3:30pm: Build pivot tables and charts in Google Sheets
> - 4:15pm: Copy-paste into your customer email template
> - 4:45pm: Personalize each email (change "Hey Sarah" to "Hey Michael", update account-specific context)
> - 6:30pm: Send last email, realize you spent 4.5 hours on reporting that should have taken 30 minutes
> - Saturday morning: Customer replies asking for clarification on a metric - back to your laptop
>
> You became a CS manager to build relationships and drive retention. Instead, you're a data janitor.
>
> We built Analytics Insights to fix this.
>
> ## After: What Your Friday Looks Like Now
>
> **Your new Friday afternoon:**
> - 2:00pm: Open Analytics Insights, click "Generate Reports"
> - 2:03pm: Review automatically generated insights for your 20 accounts (already personalized, already visualized, already in email format)
> - 2:15pm: Click "Send" or make minor tweaks if needed
> - 2:20pm: Done. You just freed up 4 hours.
>
> **What you do with those 4 hours:**
> - Proactively reach out to at-risk accounts (the system flagged 3 with declining usage)
> - Prepare for Monday's executive retention review (with confidence, not scrambling)
> - Actually leave at 5pm on Friday
>
> This isn't about automation for automation's sake. It's about spending time on what matters: your customers.
>
> ## How It Works (The Bridge)
>
> **Setup (5 minutes):**
> 1. Go to Reports → Analytics Insights
> 2. Choose your template (we have 5 pre-built, including "Executive Summary" and "Feature Adoption")
> 3. Select accounts and schedule (weekly Fridays at 2pm, or on-demand)
> 4. Done.
>
> **What Happens Next:**
> Every Friday at 2pm, Analytics Insights:
> - Pulls usage data for each account (sessions, feature adoption, health score trends)
> - Generates insights using the same patterns you'd manually identify ("Sarah's team adoption is up 40% this month, driven by the new workflow builder")
> - Creates beautiful visualizations (no more manual charting)
> - Drafts personalized emails (including customer name, account-specific context, relevant metrics)
> - Sends to you for review (or auto-sends if you enable it)
>
> **Customization:**
> - Add your own metrics (we start with 12 standard ones)
> - Edit templates (match your voice and brand)
> - Override insights (AI gets it 90% right, you perfect the last 10%)
>
> ## Why We Built This (Proof You Can Trust It)
>
> We didn't build this in a vacuum. Over the past 6 months:
> - We interviewed 40 CS managers like you
> - 38 of them mentioned "manual reporting" as their #1 time sink
> - Average time reported: 12 hours per week
>
> We piloted Analytics Insights with 12 beta customers for 8 weeks. Results:
> - **Time saved:** Average 10.6 hours per week (range: 8-15 hours depending on account size)
> - **Accuracy:** 94% of AI-generated insights matched what CS managers would have written manually
> - **Adoption:** 11 of 12 beta users now use it weekly (one still tweaking template preferences)
>
> **What beta users said:**
>
> > "This is the feature I didn't know I needed until I had it. Now I can't imagine going back. I left at 4pm last Friday for the first time in a year." — Sarah Chen, CS Director, TechCorp (120 accounts)
>
> > "I was skeptical about AI writing my customer emails. But it nails the tone—I only change 1-2 sentences per email now. Total game changer." — Michael Rodriguez, CS Manager, GrowthCo (45 accounts)
>
> > "The ROI calculation is simple: I save 12 hours per week. That's 48 hours per month. If my time is worth $100/hr (conservative), this saves my company $4,800/month. It's already included in my plan. This is a no-brainer." — Jamie Lee, VP Customer Success, DataCo (8-person CS team)
>
> ## This Is Included (No Extra Cost)
>
> Analytics Insights is included in your current plan. No upgrade, no add-on, no surprise invoice.
>
> Why? Because your success is our success. If you spend less time on manual work and more time with customers, retention improves. When retention improves, we both win.
>
> ## Get Started Today (Your Friday Is Waiting)
>
> **Here's what to do next:**
>
> 1. **[Try it now - 5 minute setup](link)** → Set up your first automated report
> 2. **[Watch 3-minute demo video](link)** → See it in action before you commit
> 3. **[Join office hours this Thursday 2pm PT](link)** → Ask questions, see advanced tips
>
> **What to expect:**
> - **This week:** Set up and generate your first report (test with 5 accounts before full rollout)
> - **Next week:** Roll out to all accounts, customize templates to match your voice
> - **Week 3:** Sit back and enjoy your Fridays (seriously, that's the goal)
>
> **Need help?**
> Reply to this email and I'll personally help you set up. Or book time with our CS team [here](link).
>
> ## A Note from Our CEO
>
> "We started this company because we believe customer success teams are undervalued and overworked. You're expected to be data analysts, relationship managers, product experts, and therapists—all at once. This feature is our attempt to give you back time to focus on what you do best: building relationships that drive retention. I hope it makes your life a little easier."
>
> —CEO Name
>
> **P.S.** Set a reminder to try this before next Friday. Future you will thank present you when you leave work at 5pm instead of 7pm. [Set up Analytics Insights now →](link)

**Why This Works:**

✅ **Headline:** "Spend 15 hours/week on customers, not spreadsheets" - benefit-focused, quantified, relatable
✅ **Empathy:** Opens with painfully specific current state that audience lives ("Friday 2pm, start pulling usage data...")
✅ **Show don't tell:** Detailed timeline of current Friday (4.5 hours of manual work) vs new Friday (20 minutes)
✅ **Specificity:** 10.6 hours saved (not "saves time"), 94% accuracy (not "highly accurate"), 11/12 adoption (not "popular")
✅ **Social proof:** 3 customer testimonials with names, companies, account sizes (credibility through specificity)
✅ **Proof:** Beta results (12 customers, 8 weeks, quantified outcomes) not just claims
✅ **Stakes:** Humanized ($4,800/month = 48 hours × $100/hr) and emotional (leave at 5pm on Friday)
✅ **No-risk:** Included in current plan (removes cost objection)
✅ **Actionability:** 3 clear next steps (try now, watch demo, join office hours) with timelines
✅ **Multiple CTAs:** Try now (for action-oriented), watch demo (for cautious), office hours (for question-askers)
✅ **Tone:** Empathetic ("I don't have to tell you..."), supportive ("I'll personally help"), excited but not over-the-top
✅ **Structure:** BAB (Before → After → Bridge) creates clear transformation narrative

---

## Self-Assessment Using Rubric

**Headline Clarity (5/5):** "Spend 15 hours/week on customers, not spreadsheets" - crystal clear benefit
**Structure (5/5):** BAB (Before painful, After aspirational, Bridge actionable) - perfect fit for product launch
**Evidence Quality (5/5):** 12 beta customers, 8 weeks, 10.6 hours saved, 94% accuracy, 11/12 adoption, 3 named testimonials
**Audience Fit (5/5):** Deep empathy with CS manager pain points, appropriate detail level, addresses concerns (cost, accuracy, adoption)
**Storytelling (5/5):** Hyper-specific current state (Friday timeline), vivid future state (leave at 5pm), concrete bridge (5-minute setup)
**Accountability (4/5):** Acknowledges AI isn't perfect (90% right, you perfect last 10%), CEO note shows commitment
**Actionability (5/5):** 3 tiered CTAs (try/watch/ask), weekly timeline, support offers (personal help, office hours)
**Tone (5/5):** Empathetic + excited + supportive - matches product launch for existing customers
**Transparency (5/5):** Shows beta results (not just cherry-picked wins), admits AI needs 10% human refinement
**Credibility (5/5):** Customer testimonials with full names/companies, quantified beta results, CEO commitment

**Average: 4.9/5** ✓ Production-ready (very strong)

---

## Key Techniques Demonstrated

1. **Empathy Opening:** Start with painful specificity audience recognizes ("Your Friday afternoon: 2:00pm...")
2. **Transformation Narrative:** Contrast current painful state (6:30pm still working) with aspirational future (2:20pm done)
3. **Humanization:** Time saved → emotional benefit (leave at 5pm Friday for first time in a year)
4. **Social Proof:** 3 testimonials from different seniority levels (director, manager, VP) with specific results
5. **Risk Removal:** Included in current plan (no cost), 5-minute setup (low effort), personal help offered (low barrier)
6. **Multiple CTAs:** Try/Watch/Ask - accommodates different audience personas (action-takers, cautious evaluators, question-askers)
7. **Proof Stack:** Interviews (40 CS managers) + beta (12 customers, 8 weeks) + testimonials (3 named) = comprehensive evidence
8. **Specificity:** Not "saves time" but "10.6 hours/week", not "accurate" but "94%", not "popular" but "11/12 beta users"
9. **CEO Voice:** Adds weight and shows company commitment (not just product team shipping feature)
10. **PS Technique:** Reinforces CTA with emotional hook (future you will thank present you)

---

## Alternative Version: Internal Announcement (to CS Team)

If announcing internally to your own CS team (not customers), adjust:

**Headline:** "Reclaim Your Fridays: New Auto-Reporting Tool Launching"

**Changes:**
- More emphasis on how to get support (training sessions, dedicated Slack channel)
- Call out change management (optional first month, required after pilot)
- Acknowledge concerns ("I know change is hard when you have a system that works")
- Add metrics we're tracking (adoption rate, time saved, quality scores)
- Make CEO note about supporting the team through transition

**Tone shift:** Still empathetic, but more collaborative (we're in this together) vs selling (you should use this)

---

## Alternative Version: Blog Post (Public)

If publishing as public blog (not just customers), adjust:

**Headline:** "Why We Built Analytics Insights: Giving CS Teams Their Time Back"

**Changes:**
- Add "Why this matters for the industry" section (CS burnout crisis, data janitor problem universal)
- Include more behind-the-scenes (how we built it, technical challenges overcome)
- Broaden appeal (useful for any CS tool provider, not just our customers)
- End with industry call-to-action (other CS tools should solve this too)

**Tone shift:** Thought leadership (here's what we learned) vs product marketing (here's what you get)
