---
name: constraint-based-creativity
description: Use when brainstorming feels stuck or generates obvious ideas, need to break creative patterns, working with limited resources (budget/time/tools/materials), want unconventional solutions, designing with specific limitations, user mentions "think outside the box", "we're stuck", "same old ideas", "tight constraints", "limited budget/time", or seeking innovation through limitation rather than abundance.
---

# Constraint-Based Creativity

## Table of Contents
- [Purpose](#purpose)
- [When to Use](#when-to-use)
- [What Is It](#what-is-it)
- [Workflow](#workflow)
- [Constraint Types](#constraint-types)
- [Common Patterns](#common-patterns)
- [Guardrails](#guardrails)
- [Quick Reference](#quick-reference)

## Purpose

Turn limitations into creative fuel by strategically imposing constraints that force novel thinking, break habitual patterns, and reveal unexpected solutions.

## When to Use

**Invoke this skill when you observe:**
- Unconstrained brainstorming produces predictable, generic ideas
- Team defaulting to "same old approaches"
- Creative block despite ample resources
- Need to work within tight limitations (budget, time, materials, technical)
- Want to differentiate from competitors using similar unlimited resources
- Seeking simplicity and focus over feature bloat
- Innovation feels incremental rather than breakthrough

**Common trigger phrases:**
- "We keep coming up with the same ideas"
- "How do we innovate on a tight budget?"
- "Think outside the box"
- "We're stuck"
- "What if we could only use X?"
- "Design this with severe limitations"
- "Create something radically different"

## What Is It

**Constraint-based creativity** deliberately limits freedom (resources, rules, materials, format) to force creative problem-solving. Paradoxically, constraints often boost creativity by:

1. **Reducing decision paralysis** - Fewer options = clearer focus
2. **Breaking habitual patterns** - Can't use usual solutions
3. **Forcing novel combinations** - Must work with what's allowed
4. **Increasing psychological safety** - "We had to because of X"
5. **Creating memorable differentiation** - Constraints make solutions distinctive

**Quick example:** Twitter's original 140-character limit forced concise, punchy writing. Haiku's 5-7-5 syllable structure produces poetry. $10K budget forces guerrilla marketing over Super Bowl ads. Building with only CSS (no images) creates distinctive visual style.

## Workflow

Copy this checklist and track your progress:

```
Constraint-Based Creativity Progress:
- [ ] Step 1: Understand the problem and context
- [ ] Step 2: Choose or design strategic constraints
- [ ] Step 3: Generate ideas within constraints
- [ ] Step 4: Evaluate and refine solutions
- [ ] Step 5: Validate quality and deliver
```

**Step 1: Understand the problem and context**

Ask user for the creative challenge (what needs solving), current state (what's been tried, why it's not working), ideal outcome (success criteria), and any existing constraints (real limitations already in place). Understanding why ideas feel stale or stuck helps identify which constraints will unlock creativity. See [Constraint Types](#constraint-types) for strategic options.

**Step 2: Choose or design strategic constraints**

If user has existing constraints (tight budget, short timeline, limited materials) → Use [resources/template.md](resources/template.md) to work within them creatively. If no constraints exist and ideation is stuck → Study [resources/methodology.md](resources/methodology.md) to design strategic constraints that force new thinking patterns. Choose 1-3 constraints maximum to avoid over-constraining.

**Step 3: Generate ideas within constraints**

Apply chosen constraints rigorously during ideation. Create `constraint-based-creativity.md` file documenting: problem statement, active constraints (what's forbidden/required/limited), idea generation process, and all ideas produced (including "failed" attempts that revealed insights). Quantity matters - aim for 20+ ideas before evaluating. See [resources/template.md](resources/template.md) for structured generation process.

**Step 4: Evaluate and refine solutions**

Assess ideas using dual criteria: (1) Does it satisfy all constraints? (2) Does it solve the original problem? Select strongest 2-3 ideas. Refine by combining elements, removing unnecessary complexity, and strengthening the constraint-driven insight. Document why certain ideas stand out - often the constraint reveals an unexpected angle. See [resources/methodology.md](resources/methodology.md) for evaluation frameworks.

**Step 5: Validate quality and deliver**

Self-assess using [resources/evaluators/rubric_constraint_based_creativity.json](resources/evaluators/rubric_constraint_based_creativity.json). Verify: constraints were genuinely respected (not bent/broken), solutions are novel (not slight variations of existing), the constraint created the creativity (solution wouldn't exist without it), ideas are actionable (not just conceptual), and creative insight is explained (why this constraint unlocked this idea). Minimum standard: Average score ≥ 3.5. Present completed `constraint-based-creativity.md` file highlighting the constraint-driven breakthroughs.

## Constraint Types

Strategic constraints fall into categories. Choose based on what pattern you want to break:

**Resource Constraints** (force efficiency):
- Budget: "Design this campaign for $500" (vs typical $50K)
- Time: "Ship in 48 hours" (vs typical 2-week sprint)
- Team: "Solo project only" or "No engineers"
- Materials: "Found objects only" or "Recyclables only"

**Format/Medium Constraints** (force adaptation):
- Length: "Explain in 10 words" or "Story in 6 words"
- Medium: "Text only, no images" or "Visual only, no words"
- Platform: "Twitter thread only" (vs blog post)
- Dimensions: "Square format only" or "Vertical video"

**Rule-Based Constraints** (force creative workarounds):
- Forbidden elements: "No letter 'e'" or "No adjectives"
- Required elements: "Must include these 3 objects"
- Style rules: "Hemingway style only" or "As if Shakespeare"
- Process rules: "No editing, one-take only"

**Technical Constraints** (force optimization):
- Code: "100 lines maximum" or "No external libraries"
- Performance: "Load in <1 second" or "Run on 1990s hardware"
- Data: "No PII collection" or "Works offline"
- Compatibility: "Text-based only (ASCII art)"

**Audience/Perspective Constraints** (force reframing):
- Audience: "Explain to 5-year-olds" or "For experts only"
- Perspective: "First person only" or "Second person only"
- Tone: "No corporate speak" or "Casual only"
- Voice: "Write as [specific person/character]"

## Common Patterns

**Pattern: The Limitation Sprint**
When team is stuck, run 30-minute sprints with different constraints. Example: "10 ideas using only free tools" → "10 ideas in black/white only" → "10 ideas for $100 budget." Constraint rotation prevents pattern fixation.

**Pattern: The Subtraction Game**
Remove assumed "essentials" one at a time. Example: "App without login" → "App without UI" (voice only) → "App without internet" (offline-first). Forces questioning assumptions.

**Pattern: The Format Flip**
Change medium to force different thinking. Example: "Explain strategy as a recipe" or "Present roadmap as a movie trailer" or "Write documentation as a children's book."

**Pattern: The Resource Inversion**
Make the assumed limitation the focus. Example: "We have no budget" → "Build guerrilla marketing campaign showcasing zero-budget creativity" or "Only 2-person team" → "Sell the 'small team, big care' advantage."

**Pattern: The Historical Constraint**
Impose constraints from different eras. Example: "Design this as if it's 1995" (pre-smartphone) or "Build this with Victorian-era materials" or "Market this like 1960s Mad Men."

## Guardrails

**✓ Do:**
- Choose constraints that directly counter the creative block (stuck on complexity → simplicity constraint)
- Enforce constraints rigorously during ideation (no "bending" rules mid-process)
- Generate high volume before judging (quantity first, then quality)
- Document failed ideas - they often contain seeds of insight
- Explain how the constraint created the solution (causality matters)
- Use multiple different constraints in sequence (sprint pattern)

**✗ Don't:**
- Over-constrain (3+ simultaneous constraints usually paralyzes)
- Choose arbitrary constraints unrelated to the problem
- Abandon constraints when ideas get hard (that's when breakthroughs happen)
- Confuse constraint-based creativity with regular brainstorming
- Accept slight variations of existing ideas (constraint should force novelty)
- Skip the evaluation step (need to validate constraint drove the creativity)

## Quick Reference

**Resources:**
- `resources/template.md` - Structured process for generating ideas within constraints
- `resources/methodology.md` - Advanced techniques for designing strategic constraints, combining constraint types, and systematic exploration
- `resources/examples/` - Worked examples showing constraint-driven breakthroughs
- `resources/evaluators/rubric_constraint_based_creativity.json` - Quality assessment before delivery

**When to choose which resource:**
- Working with existing constraints (budget, time, technical) → Start with template
- No constraints but ideation is stuck → Study methodology to design constraints
- Need to see examples of breakthroughs → Review examples folder
- Before delivering to user → Always validate with rubric

**Expected deliverable:**
`constraint-based-creativity.md` file containing: problem statement, chosen constraints with rationale, idea generation process (including volume metrics), top 2-3 solutions with refinement notes, explanation of how constraints drove creativity, and next steps.
