# Discovery Interviews & Surveys - Template

## Workflow

```
Research Template Progress:
- [ ] Define objectives and hypotheses
- [ ] Design screening and recruitment
- [ ] Create interview guide or survey
- [ ] Plan analysis approach
- [ ] Document research plan
```

---

## Interview Guide Template

### Research Objective
**What we're trying to learn**: [Specific learning goal]

**Key hypotheses**:
1. [Hypothesis 1]
2. [Hypothesis 2]

### Participant Criteria
**Must have**:
- [Criterion 1—e.g., used competitor product in last 6 months]
- [Criterion 2—e.g., decision-maker for this purchase]

**Nice to have**:
- [Optional criterion]

**Sample size**: [5-15 for qualitative themes]

### Interview Script

**Introduction** (2 min):
"Thanks for joining. I'm researching [topic]. There are no right/wrong answers—I want to understand your experience. I'll record this for note-taking (with your permission). Any questions before we start?"

**Warm-up** (3 min):
- Tell me about your role and what you're responsible for.
- [Context-setting question relevant to topic]

**Problem Discovery** (20-30 min):

Core questions (open-ended, behavior-focused):

1. **Recent experience**: "Tell me about the last time you [specific behavior related to problem]. Walk me through what happened."
   - Follow-up: "What prompted that?" "What happened next?" "How did that feel?"

2. **Current solution**: "How do you handle [problem] today? Show me if possible."
   - Follow-up: "How long have you done it this way?" "What works well?" "What's frustrating?"

3. **Workarounds**: "What have you tried to solve [problem]?"
   - Follow-up: "How did that go?" "What made you stop/continue?"

4. **Pain points**: "What's the most frustrating part of [workflow]?"
   - Follow-up: "How often does this happen?" "What's the impact when it does?"

5. **Desired outcome**: "If you could wave a magic wand and fix [problem], what would be different?"
   - Follow-up: "Why would that matter?" "What would that enable?"

6. **Willingness to change**: "What would need to be true for you to change how you [workflow]?"
   - Follow-up: "What's the cost of changing?" "What's the cost of not changing?"

**Concept Test** (10 min, if applicable):

Show concept (mockup, landing page, description):

1. **Comprehension**: "In your own words, what is this?"
2. **Audience**: "Who do you think this is for?"
3. **Use case**: "When would you use this?" "What would you use it for?"
4. **Value perception**: "How much would you expect to pay for this?" "Why?"
5. **Comparison**: "How is this different from [competitor/current solution]?"
6. **Concerns**: "What concerns you about this?" "What would hold you back?"

**Wrap-up** (5 min):
- "Is there anything I should have asked but didn't?"
- "Who else should I talk to?" (snowball sampling)
- "Can I follow up if I have more questions?"

**Thank and compensate**: [Gift card, donation, etc.]

---

## Survey Template

### Survey Structure

**Screener** (qualify participants):
1. [Demographic filter—e.g., age, location]
2. [Behavioral filter—e.g., used product X]
3. [Decision-making filter—e.g., influence on purchase]

**Main Survey**:

**Section 1: Current Behavior** (establish baseline)
1. Which of the following [products/services] do you currently use? (Select all that apply)
   - [Option 1]
   - [Option 2]
   - None of the above

2. How often do you [key behavior]?
   - Daily / Weekly / Monthly / Rarely / Never

3. What do you use [product/service] for? (Open-end)

**Section 2: Satisfaction & Problems** (identify pain points)
4. How satisfied are you with your current [solution]? (1-5 scale)
   - Very dissatisfied / Dissatisfied / Neutral / Satisfied / Very satisfied

5. What are the biggest challenges you face with [current solution]? (Open-end)

6. How important is [feature/capability] to you? (1-5 scale)
   - Not at all important / Slightly important / Moderately important / Very important / Extremely important

**Section 3: Feature Prioritization** (for product roadmap)
7. Please rate the importance of each feature: (Matrix—rows = features, columns = 1-5 importance)
   - [Feature 1]
   - [Feature 2]
   - [Feature 3]

8. If you could only have 3 of these features, which would you choose? (Rank order, top 3)

**Section 4: Concept Test** (if applicable)

Show concept (image, description):

9. In your own words, what is this product/service? (Open-end)

10. How likely are you to use this if it were available? (1-5 scale)
    - Very unlikely / Unlikely / Neutral / Likely / Very likely

11. What would you be willing to pay per month? (Price sensitivity)
    - Less than $X / $X-$Y / $Y-$Z / More than $Z / I wouldn't pay

12. What concerns do you have about this concept? (Open-end)

**Section 5: Demographics** (for segmentation)
13. Company size (if B2B): [ranges]
14. Industry: [options]
15. Role: [options]

**Thank you**: "Thank you! [Incentive details if applicable]"

---

## Jobs-to-be-Done Interview Template

Focus on recent switchers (adopted your product or competitor in last 3-6 months).

**Timeline reconstruction**:

1. **First thought** (passive looking): "When did you first realize you had a problem with [old solution]? What happened?"

2. **Trigger event** (active looking): "What made you start actively looking for alternatives? What changed?"

3. **Consideration** (evaluation): "What options did you consider? How did you evaluate them?"
   - Follow-up: "What criteria mattered most?" "What sources did you trust?"

4. **Anxiety** (concerns): "What almost stopped you from switching?" "What made you hesitate?"

5. **Decision** (commitment): "What made you ultimately choose [product]? What was the deciding factor?"

6. **First use** (onboarding): "Walk me through your first experience using [product]. What stood out?"

7. **Habit formation** (ongoing): "How has your use evolved? What's different now vs. early days?"

8. **Outcome** (job fulfillment): "What's better now compared to before? What job is [product] doing for you?"

9. **Tradeoffs**: "What did you give up by switching? What's worse now?"

---

## Question Design Principles

**DO:**
- ✅ Ask about past behavior: "Tell me about the last time..."
- ✅ Request demonstrations: "Can you show me how you..."
- ✅ Dig deeper: "Why did that matter?" "Tell me more" "What else?"
- ✅ Embrace silence: Pause after questions. Let participant think.
- ✅ Use open-ended questions: "What..." "How..." "Tell me about..."
- ✅ Focus on specifics: "Walk me through..." "What happened next?"

**DON'T:**
- ❌ Ask leading questions: "Don't you think...?" "Isn't it true that...?"
- ❌ Ask hypotheticals: "Would you...?" "If we built..."
- ❌ Ask multiple questions at once: Confuses participants
- ❌ Interrupt or finish sentences: Let them talk
- ❌ Explain or defend: You're learning, not selling
- ❌ Ask "why" repeatedly: Sounds accusatory. Use "What prompted..." "What mattered..."

---

## Screening Questions

**For B2B SaaS**:
1. What is your role? [Job title dropdown]
2. What is your company size? [Employee count ranges]
3. Do you influence or make purchase decisions for [product category]? Yes/No
4. Are you currently using [competitor product]? Yes/No/Used in the past
5. How long have you been using [product]? [Duration ranges]

**For Consumer**:
1. Which age range are you in? [Ranges]
2. Do you currently [key behavior]? Daily/Weekly/Monthly/Rarely/Never
3. When did you last [specific action]? [Time ranges]
4. Which of the following have you used? [Product list, select all]

**Disqualifiers** (screen out):
- Competitors (unless research is competitive analysis)
- Never used category (for product-specific research)
- Outside target demographic

---

## Analysis Templates

**For Interviews: Thematic Coding**

1. **Transcribe**: Convert recordings to text (automated tool or manual)
2. **Initial coding**: Read transcripts, highlight key quotes, note themes
3. **Affinity mapping**: Group similar quotes/observations
4. **Theme identification**: Name each cluster (e.g., "Onboarding confusion", "Pricing concerns")
5. **Frequency counting**: How many participants mentioned each theme?
6. **Quote extraction**: Pull representative quotes for each theme

**Output format**:
```
Theme: [Name]
Frequency: X/Y participants
Representative quotes:
- "Quote 1" (P3)
- "Quote 2" (P7)
Insight: [What this means]
Recommendation: [What to do]
```

**For Surveys: Statistical Analysis**

1. **Data cleaning**: Remove incomplete responses, check for quality
2. **Descriptive stats**: Mean, median, mode, distribution for scaled questions
3. **Cross-tabulation**: Compare segments (e.g., users vs non-users)
4. **Statistical significance**: Chi-square (categorical) or t-test (continuous)
5. **Open-end coding**: Categorize open-ended responses, count frequencies
6. **Visualization**: Charts for key findings (bar charts, distribution plots)

**Key metrics**:
- CSAT (Customer Satisfaction): Average rating (1-5 scale)
- NPS (Net Promoter Score): % Promoters (9-10) minus % Detractors (0-6)
- Feature importance vs satisfaction: 2x2 matrix (importance on Y, satisfaction on X)
- Sample size check: n ≥ 30 per segment for statistical power

---

## Insights Document Template

```markdown
# Research Insights: [Study Name]

## Executive Summary
[2-3 sentences: key findings, decision recommendation]

## Research Objective
**What we wanted to learn**: [Objective]
**Key questions**: [Questions]

## Methodology
- **Method**: [Interviews/Survey/Mixed]
- **Participants**: [N, demographics]
- **Dates**: [When conducted]

## Key Findings

### Finding 1: [Theme Name]
**Evidence**: X/Y participants mentioned [pattern]
**Quotes**:
- "Quote 1" (P3)
- "Quote 2" (P7)
**Insight**: [What this means]

### Finding 2: [Theme Name]
[Same structure]

## Surprises & Contradictions
[What didn't match expectations? Outliers?]

## Recommendations
1. [Action 1—specific, based on findings]
2. [Action 2]
3. [Action 3]

## Confidence & Limitations
- Confidence level: [High/Medium/Low] based on [sample size, consistency, etc.]
- Limitations: [Sampling bias? Small sample? Anything that limits generalization?]

## Next Steps
- [Follow-up research needed?]
- [Decision to be made?]
```
