# Environmental Scanning & Foresight Templates

Quick-start templates for PESTLE scanning, weak signal detection, scenario development, and signpost setting.

## Workflow

```
Environmental Scanning Progress:
- [ ] Step 1: Define scope and focus areas
- [ ] Step 2: Scan PESTLE forces and trends
- [ ] Step 3: Detect and validate weak signals
- [ ] Step 4: Assess cross-impacts and interactions
- [ ] Step 5: Develop scenarios for plausible futures
- [ ] Step 6: Set signposts and adaptive triggers
```

**Step 1: Define scope and focus areas**

Use [Scanning Scope Definition](#scanning-scope-definition) to clarify scanning theme, geographic scope, time horizon, and key uncertainties.

**Step 2: Scan PESTLE forces and trends**

Systematically collect trends using [PESTLE Scanning Framework](#pestle-scanning-framework) across Political, Economic, Social, Technological, Legal, Environmental dimensions.

**Step 3: Detect and validate weak signals**

Identify early indicators using [Weak Signal Template](#weak-signal-template) with validation criteria for credibility, evidence, and impact potential.

**Step 4: Assess cross-impacts and interactions**

Map trend interactions using [Cross-Impact Analysis](#cross-impact-analysis) to identify reinforcing, offsetting, and cascading effects.

**Step 5: Develop scenarios for plausible futures**

Create 3-4 scenarios using [Scenario Development Template](#scenario-development-template) built around critical uncertainties.

**Step 6: Set signposts and adaptive triggers**

Define leading indicators using [Signpost Definition Template](#signpost-definition-template) with specific thresholds and monitoring cadence.

---

## Scanning Scope Definition

**Scanning Theme**:
- What aspect of environment? (Technology disruption, market evolution, regulatory shift, competitive dynamics, etc.)
- What strategic questions? (Should we enter this market? Will our business model remain viable? What capabilities will we need?)

**Geographic Scope**:
- [ ] Global (worldwide trends)
- [ ] Regional (continent, trade bloc)
- [ ] National (country-specific)
- [ ] Local (city, state, industry cluster)

**Time Horizon**:
- [ ] Short-term (1-2 years): Operational planning, current trend extrapolation
- [ ] Medium-term (3-5 years): Strategic planning, inflection points
- [ ] Long-term (5-10+ years): Visioning, transformational change, paradigm shifts

**Key Uncertainties** (what we don't know that matters most):
1.
2.
3.

**Scanning Objectives** (what decisions will this inform?):
-

---

## PESTLE Scanning Framework

### Political

**Government & Policy**:
- Election outcomes and implications:
- Policy priorities and shifts:
- Political stability/instability:
- Geopolitical tensions/alignments:

**Regulation & Governance**:
- Regulatory proposals in pipeline:
- Deregulation or liberalization trends:
- Government intervention patterns:
- International agreements/treaties:

**Sources**: Government announcements, policy think tanks, political risk indices, diplomatic cables

### Economic

**Macroeconomic Conditions**:
- GDP growth/contraction forecasts:
- Inflation and interest rate trends:
- Employment and labor market:
- Currency and exchange rates:

**Market & Trade**:
- Trade policy and tariff changes:
- Foreign direct investment flows:
- Supply chain and logistics costs:
- Capital availability and credit:

**Income & Spending**:
- Income distribution and inequality:
- Consumer spending patterns:
- Savings and debt levels:

**Sources**: Central bank reports, economic forecasts (IMF, World Bank), market data, trade statistics

### Social

**Demographics**:
- Population growth/decline:
- Age structure shifts (aging, youth bulge):
- Migration patterns:
- Urbanization trends:

**Values & Culture**:
- Shifting social values (sustainability, equity, individualism):
- Trust in institutions:
- Cultural movements and identity politics:
- Generational attitudes (Gen Z, Millennials):

**Lifestyle & Behavior**:
- Work-life balance preferences:
- Health and wellness trends:
- Education and skill development:
- Consumption patterns (sharing economy, minimalism):

**Sources**: Census data, survey research (Pew, Gallup), social media trends, cultural commentary

### Technological

**Innovation & R&D**:
- Breakthrough technologies emerging:
- R&D investment levels and focus:
- Patent filings in relevant domains:
- Technology adoption curves:

**Digital & Automation**:
- Digitalization of industry:
- AI and machine learning applications:
- Robotics and automation:
- Cybersecurity and data privacy tech:

**Infrastructure**:
- Broadband and connectivity expansion:
- Cloud and edge computing:
- Energy infrastructure and grids:
- Transportation and logistics tech:

**Sources**: Technology journals, patent databases, VC investment reports, tech conferences, research labs

### Legal

**Regulatory Frameworks**:
- New laws and regulations:
- Regulatory enforcement trends:
- Compliance requirements expanding/contracting:
- Cross-border regulatory harmonization:

**Standards & Liability**:
- Industry standards evolving:
- Liability and litigation trends:
- Intellectual property regime changes:
- Data protection and privacy laws:

**Sources**: Legislative trackers, regulatory agency announcements, legal journals, compliance advisories

### Environmental

**Climate & Weather**:
- Climate change impacts (temperature, precipitation, extremes):
- Physical risk to assets and operations:
- Climate policy and carbon pricing:
- Renewable energy adoption:

**Resources & Pollution**:
- Natural resource availability (water, minerals, land):
- Pollution and waste management:
- Circular economy and recycling:
- Biodiversity and ecosystem health:

**Sustainability**:
- Corporate sustainability commitments:
- Investor ESG pressure:
- Consumer demand for sustainable products:
- Supply chain sustainability requirements:

**Sources**: IPCC reports, climate models, environmental agencies, sustainability indices, ESG ratings

---

## Weak Signal Template

**Signal Identified**: [Brief description of anomaly or early indicator]

**Source & Date**:
- Where detected:
- When observed:
- Source credibility (high/medium/low):

**Why This Is a Weak Signal** (not mainstream yet):
- Diverges from current expectations:
- Early/emergent (not widely recognized):
- Edge of system (niche, subculture, fringe):

**Validation Criteria**:
- [ ] Source credibility: Is source reliable and knowledgeable?
- [ ] Supporting evidence: Are there multiple independent confirmations?
- [ ] Plausibility: Is amplification mechanism realistic?
- [ ] Impact if scaled: Would this matter significantly?

**Potential Amplification Path** (how could this scale?):
-

**Impact Assessment** (if signal amplifies):
- Opportunities:
- Threats:
- Affected stakeholders:

**Monitoring Plan**:
- Track indicator:
- Frequency:
- Trigger for escalation:

---

## Cross-Impact Analysis

Map how trends interact. Use matrix to identify reinforcing (accelerate), offsetting (tension), and cascading (trigger) relationships.

**Key Trends Identified** (from PESTLE scan):
1.
2.
3.
4.
5.

**Interaction Matrix**:

| Trend | 1 | 2 | 3 | 4 | 5 |
|-------|---|---|---|---|---|
| **1** | - |   |   |   |   |
| **2** |   | - |   |   |   |
| **3** |   |   | - |   |   |
| **4** |   |   |   | - |   |
| **5** |   |   |   |   | - |

Legend: **+** = Reinforcing (accelerates), **-** = Offsetting (inhibits), **→** = Cascading (triggers), **0** = Independent

**Critical Uncertainties** (high impact + high uncertainty):
-
-

**Predetermined Elements** (high impact + low uncertainty):
-
-

**Feedback Loops** (self-reinforcing or self-limiting):
-

---

## Scenario Development Template

### Scenario Structure (2x2 Matrix)

**Critical Uncertainty 1** (Axis 1): [e.g., "Speed of Technology Adoption"]
- High:
- Low:

**Critical Uncertainty 2** (Axis 2): [e.g., "Regulatory Stringency"]
- High:
- Low:

**Four Scenarios**:

#### Scenario A: [Name] (High Axis 1 + High Axis 2)
- **Probability/Plausibility**:
- **Key Drivers**:
- **Narrative** (2-3 paragraphs describing this future):


- **Strategic Implications**:


#### Scenario B: [Name] (High Axis 1 + Low Axis 2)
- **Probability/Plausibility**:
- **Key Drivers**:
- **Narrative**:


- **Strategic Implications**:


#### Scenario C: [Name] (Low Axis 1 + High Axis 2)
- **Probability/Plausibility**:
- **Key Drivers**:
- **Narrative**:


- **Strategic Implications**:


#### Scenario D: [Name] (Low Axis 1 + Low Axis 2)
- **Probability/Plausibility**:
- **Key Drivers**:
- **Narrative**:


- **Strategic Implications**:


**Wild Cards** (low probability, high impact events not captured in scenarios):
-

**No-Regrets Moves** (strategies that work across all scenarios):
-

**Hedges** (actions that protect in some scenarios):
-

---

## Signpost Definition Template

Signposts are leading indicators that trigger adaptive responses before trends fully materialize.

**Signpost 1**:
- **What to monitor**: [Specific observable indicator]
- **Current baseline**:
- **Threshold for action**: [Specific value or condition]
- **Action triggered**: [What we do when threshold crossed]
- **Data source**:
- **Update frequency**:
- **Lead time** (how far ahead of outcome?):

**Signpost 2**:
- **What to monitor**:
- **Current baseline**:
- **Threshold for action**:
- **Action triggered**:
- **Data source**:
- **Update frequency**:
- **Lead time**:

**Signpost 3**:
- **What to monitor**:
- **Current baseline**:
- **Threshold for action**:
- **Action triggered**:
- **Data source**:
- **Update frequency**:
- **Lead time**:

**Monitoring Cadence**:
- [ ] Weekly (fast-moving indicators)
- [ ] Monthly (medium-term trends)
- [ ] Quarterly (strategic review)
- [ ] Annually (comprehensive environmental scan update)

**Dashboard Location**: [Where are signposts tracked?]

**Review Process**: [Who reviews? What triggers escalation?]
