# Facilitation Patterns Templates

Quick-start templates for session design, agenda building, logistics, and follow-up.

## Workflow

```
Facilitation Planning Progress:
- [ ] Step 1: Define session objectives
- [ ] Step 2: Select facilitation pattern
- [ ] Step 3: Design agenda
- [ ] Step 4: Prepare materials and logistics
- [ ] Step 5: Facilitate the session
- [ ] Step 6: Close and follow up
```

**Step 1**: Define objectives → Use [Session Design Template](#session-design-template)

**Step 2**: Select pattern → See SKILL.md [Common Patterns](../SKILL.md#common-patterns)

**Step 3**: Design agenda → Use [Agenda Design Template](#agenda-design-template)

**Step 4**: Prepare logistics → Use [Logistics Checklist](#logistics-checklist)

**Step 5**: Facilitate → Use [Facilitation Script Template](#facilitation-script-template)

**Step 6**: Close and follow up → Use [Closing and Follow-up Template](#closing-and-followup-template)

---

## Session Design Template

**Session name**: [Give it a clear, descriptive name]

**Date/Time**: [When, how long]

**Facilitator**: [Who runs it] **Scribe**: [Who takes notes]

### Objective

**Primary goal** (complete this sentence): 
"By the end of this session, we will have [specific outcome]."

Examples:
- Decided on Q2 roadmap priorities (top 5 features)
- Generated 30+ ideas for customer onboarding improvements
- Aligned on product vision and 6-month milestones
- Identified 3 improvements from sprint retrospective

**Success criteria**: How will you know if session succeeded?
- [ ] [Measurable outcome 1]
- [ ] [Measurable outcome 2]
- [ ] [Participants report session was valuable (feedback score ≥4/5)]

### Participants

| Name | Role | Why invited | Required? |
|------|------|-------------|-----------|
| [Person 1] | [Title] | [Decision-maker, subject matter expert, implementer, stakeholder] | Yes/No |
| [Person 2] | [Title] | [Reason] | Yes/No |
| [Person 3] | [Title] | [Reason] | Yes/No |

**Total**: [N people] (ideal: 5-8 for discussion, up to 20 for presentation+Q&A, 3-5 for decision)

**Power dynamics to manage**: [Boss in room? New person? Introverts + extroverts? Conflict between attendees?]

### Pre-work (if needed)

Send 3-5 days before session:
- [ ] [Read document X]
- [ ] [Prepare data/examples for discussion]
- [ ] [Complete survey to gather input]

**Don't overload**: 15-30 min max. If no one does pre-work, session still succeeds.

---

## Agenda Design Template

**Session**: [Name] **Duration**: [Total time]

**Decision method**: [How will decisions be made? Consensus, consent, vote, advisory, delegation]

### Agenda

| Time | Activity | Format | Owner | Output |
|------|----------|--------|-------|--------|
| 0:00-0:05 (5 min) | **Welcome & ground rules** | Facilitator presents | [Name] | Shared norms |
| 0:05-0:15 (10 min) | **Context setting** | Present slides, Q&A | [Name] | Aligned on why we're here |
| 0:15-0:30 (15 min) | **[Activity 1 name]** | [Silent brainstorm, round robin, etc.] | [Name] | [Output: sticky notes, list] |
| 0:30-0:50 (20 min) | **[Activity 2 name]** | [Small groups, report back] | [Name] | [Output: clustered themes] |
| 0:50-1:00 (10 min) | **Break** | | | Recharged |
| 1:00-1:25 (25 min) | **[Activity 3 name]** | [Dot voting, discussion] | [Name] | [Output: prioritized list] |
| 1:25-1:35 (10 min) | **Decision** | [Vote, facilitator decides with input] | [Name] | Final decision documented |
| 1:35-1:45 (10 min) | **Next steps & close** | Facilitator summarizes | [Name] | Action items, owners, dates |

**Total**: 1:45 (105 min) **Buffer**: 15 min for overruns → Schedule 2 hours

### Activity Details

**Activity 1: [Name]**
- **Goal**: [What you're trying to achieve]
- **Format**: [How it works - e.g., "Each person writes 5 ideas on sticky notes (5 min), then shares with group (1 min each)"]
- **Materials**: [Sticky notes, Mural board, shared doc, etc.]
- **Facilitation tips**: [Start with example, remind time limit, collect notes on board]

**Activity 2: [Name]**
- **Goal**: [What you're trying to achieve]
- **Format**: [How it works]
- **Materials**: [What's needed]
- **Facilitation tips**: [How to run it well]

**[Repeat for each activity]**

### Flow Check

- [ ] **Diverge before converge**: Generate ideas before evaluating (don't critique during brainstorm)
- [ ] **Energy variation**: Mix individual work, pairs, whole group. Sit/stand. Talk/silent.
- [ ] **Breaks**: Every 60-90 min (5-10 min break)
- [ ] **Buffer time**: 10-15% slack for overruns, questions
- [ ] **Outputs visible**: Shared board, doc, or projection (everyone sees same thing)

---

## Logistics Checklist

### Before Session (1 week out)

- [ ] **Calendar invite** sent with clear title, objective, agenda, pre-work (if any)
- [ ] **Room booked** (physical) or **virtual link** created (Zoom, Meet, Teams)
- [ ] **Materials prepared**: Slides, Mural/Miro board, shared doc, templates
- [ ] **Tech tested**: Can you share screen? Camera/mic work? Board accessible to all?
- [ ] **Pre-work sent** (if needed): Clear, time-boxed (15-30 min max), due 1 day before

### Day Before

- [ ] **Reminder sent**: "Looking forward to [session] tomorrow. Please complete [pre-work] if you haven't."
- [ ] **Agenda finalized**: Timing confirmed, activities clear, decision method chosen
- [ ] **Roles assigned**: Facilitator, scribe, time-keeper (if different people)

### Day of Session (15 min before)

- [ ] **Room setup**: Chairs arranged (circle for discussion, theater for presentation), whiteboard/flip charts ready
- [ ] **Tech ready**: Laptop connected, screen sharing works, Mural/doc opened, recording (if applicable)
- [ ] **Materials accessible**: Links shared in chat, sticky notes available, pens/markers ready
- [ ] **Facilitator mindset**: Calm, neutral, focused on process (not pushing own opinion)

### During Session

- [ ] **Start on time**: Don't wait for latecomers (trains people to be on time)
- [ ] **Scribe tracks**: Decisions, action items, questions/parking lot
- [ ] **Time-keeper alerts**: 5 min warnings, cut discussions if over time
- [ ] **Facilitator manages**: Participation (quiet voices speak, verbose people time-limited), energy (breaks, pace), focus (parking lot for tangents)

### After Session (within 24 hours)

- [ ] **Notes shared**: What was discussed, decisions made, action items (who, what, when)
- [ ] **Feedback gathered** (optional): Quick survey (3 questions: What worked? What to improve? Overall rating 1-5)
- [ ] **Follow-ups sent**: Action item owners reminded, next session scheduled (if needed)

---

## Facilitation Script Template

Use this to run the session smoothly, especially for new facilitators.

### Opening (5 min)

**Welcome**:
"Thanks for joining [session name]. We have [duration], goal is [objective]."

**Agenda overview**:
"Here's how we'll spend our time: [list 3-5 key activities]. We'll break at [time]."

**Ground rules** (choose 3-5):
- One conversation at a time (no sidebar discussions)
- Vegas rule (what's said here stays here, if sensitive)
- Challenge ideas, not people
- Step up, step back (if you talk a lot, make space; if you're quiet, push yourself to contribute)
- Phones/laptops closed unless needed for the work

**Decision method**:
"Just so you know upfront, here's how we'll make decisions: [consensus, vote, advisory]. I'll [make final call with your input / we'll vote / we'll discuss until agreement]."

### Transitions Between Activities

**Moving to next activity**:
"Okay, we've got [summarize output from last activity]. Now we're going to [next activity]. Here's how it works: [explain format]. You'll have [time]. Ready? Go."

**Time warnings**:
- "5 minutes left"
- "2 minutes - start wrapping up"
- "Time's up. Let's hear what you've got."

**Cutting off discussion**:
"This is a great discussion, but we need to move on to stay on schedule. I'm going to [add to parking lot / table for later / make a call now]."

### Managing Participation

**Inviting quiet voices**:
- "We haven't heard from [name] yet. [Name], what do you think?"
- "Let's do a round robin so everyone shares. [Name], want to start?"

**Limiting verbose participants**:
- "Thanks, [name]. Let's hear from others. Who else has a perspective?"
- "I'm going to ask you to wrap up in 30 seconds so we can hear from the group."
- Set time limits: "Everyone gets 2 minutes to present their idea."

**Handling sidebar conversations**:
- "Hey, can we have one conversation? What were you discussing?"
- If recurring: "I'm noticing sidebars. Let's stay together or take a break if folks need to connect offline."

### Handling Difficult Situations

**Conflict / disagreement**:
- "I hear two different views. Let's understand each. [Person A], can you explain your reasoning? Then [Person B], yours."
- Don't rush to resolve. Air the disagreement, clarify trade-offs, then decide per decision method.

**Tangent / off-topic**:
- "That's important, but off the agenda for today. I'll add to parking lot. Let's come back to [topic]."

**Someone dominating**:
- "Thanks for the input. Before we continue, let's hear from others. Quick round robin - 1 min each."

**Energy drop**:
- "Feeling the energy lag. Let's take a 5 min break."
- "Quick energizer: Stand up, stretch, shake it out. 30 seconds."

**Confusion about task**:
- "I see some confusion. Let me re-explain: [clarify activity]. Questions before we start?"

### Closing (10 min)

**Summarize outcomes**:
"Here's what we accomplished today: [list key decisions, outputs, insights]."

**Action items**:
"Next steps - I'll read each and confirm owner and due date."
- [ ] [Action 1] - [Owner] by [Date]
- [ ] [Action 2] - [Owner] by [Date]

**Parking lot**:
"We captured these topics for later: [list]. I'll [send to owner, schedule follow-up, add to backlog]."

**Feedback** (optional):
"Quick feedback: Thumbs up if session was valuable, thumbs sideways if just okay, thumbs down if waste of time." [Tally and note patterns]

**Thanks and close**:
"Thanks for your time and engagement. Notes will be sent within 24 hours. [Next session scheduled for X date, or I'll follow up with next steps]."

---

## Closing and Follow-up Template

### Session Summary

**Session**: [Name] **Date**: [Date] **Participants**: [Names]

**Decisions Made**:
1. [Decision 1]: [Rationale - why we chose this]
2. [Decision 2]: [Rationale]
3. [Decision 3]: [Rationale]

**Key Insights / Themes**:
- [Insight 1 from discussion]
- [Insight 2]
- [Insight 3]

**Parking Lot** (topics for later):
- [Topic 1] → [Owner to address / schedule follow-up]
- [Topic 2] → [Action]

### Action Items

| Action | Owner | Due Date | Status |
|--------|-------|----------|--------|
| [Do X] | [Name] | [Date] | Not started |
| [Do Y] | [Name] | [Date] | Not started |
| [Do Z] | [Name] | [Date] | Not started |

**Next session**: [Scheduled for X date, or TBD]

### Feedback Summary (if collected)

**Overall rating**: [Average score out of 5]

**What worked**:
- [Feedback 1]
- [Feedback 2]

**What to improve**:
- [Feedback 1]
- [Feedback 2]

**Facilitator notes** (for yourself):
- [What I'd do differently next time]
- [What worked well to repeat]

---

## Quick Templates by Pattern

### Divergent Brainstorm (30-60 min)

```
Agenda:
1. Frame the challenge (5 min)
2. Silent brainstorm on sticky notes (10 min)
3. Share ideas, one per person (10 min)
4. Cluster similar ideas (10 min)
5. Dot voting on most promising (5 min)
6. Discuss top 5-10 ideas (15 min)
7. Next steps (5 min)

Materials: Sticky notes, pens, Mural board, dot stickers (or virtual equivalent)
Output: 30-100 ideas, clustered, top 5-10 prioritized
```

### Convergent Decision (90 min)

```
Agenda:
1. Present context and options (15 min)
2. Clarifying questions (10 min)
3. Small groups assess options on criteria (20 min)
4. Report back, discussion (20 min)
5. Break (10 min)
6. Vote or rank options (10 min)
7. Decision + rationale (10 min)
8. Next steps (5 min)

Materials: Criteria matrix, voting mechanism (dots, Fist to Five, ranked choice)
Output: Decision documented with rationale, action items
```

### Retrospective (60-90 min)

```
Agenda:
1. Set the stage: Check-in, ground rules (5 min)
2. Gather data: Timeline or Start-Stop-Continue (15 min)
3. Generate insights: Themes, patterns, root causes (20 min)
4. Decide what to do: Pick 2-3 improvements (15 min)
5. Close: Appreciation, feedback (5 min)

Materials: Retro board (physical or Retrium/Mural), sticky notes
Output: 2-3 actionable improvements with owners and dates
```

### Alignment Session (2-4 hours)

```
Agenda:
1. Welcome, agenda, ground rules (10 min)
2. Context: Why we're here, current state (20 min)
3. Vision: Where we're going (30 min presentation + Q&A)
4. Small group discussion: Questions, concerns, gaps (30 min)
5. Break (15 min)
6. Report back: Each group shares themes (20 min)
7. Facilitated Q&A: Address concerns (30 min)
8. Consensus check: Fist to Five on alignment (10 min)
9. Next steps, commitments (15 min)

Materials: Presentation slides, breakout spaces, shared doc for questions
Output: Documented alignment (or misalignment to address), commitments
```
