---
name: facilitation-patterns
description: Use when running meetings, workshops, brainstorms, design sprints, retrospectives, or team decision-making sessions. Apply when need structured group discussion, managing diverse stakeholder input, ensuring equal participation, handling conflict or groupthink, or when user mentions facilitation, workshop design, meeting patterns, session planning, or running effective collaborative sessions.
---
# Facilitation Patterns

## Table of Contents
- [Purpose](#purpose)
- [When to Use](#when-to-use)
- [What Is It?](#what-is-it)
- [Workflow](#workflow)
- [Common Patterns](#common-patterns)
- [Guardrails](#guardrails)
- [Quick Reference](#quick-reference)

## Purpose

Facilitation Patterns provide structured approaches for running productive group sessions—from quick standups to multi-day workshops. This skill guides you through selecting the right format, designing agendas, managing participation dynamics, making group decisions, and handling difficult situations to achieve session objectives.

## When to Use

Use this skill when:

- **Planning sessions**: Design meeting agenda, choose workshop format, estimate timing
- **Running meetings**: Daily standup, 1:1s, team sync, all-hands, board meeting
- **Facilitating workshops**: Brainstorm, design sprint, strategy offsite, training session
- **Team decisions**: Need structured decision-making (voting, consensus, delegation)
- **Retrospectives**: Sprint retro, project postmortem, quarterly review
- **Stakeholder engagement**: Kickoff, requirements gathering, alignment session
- **Conflict resolution**: Tensions between team members, opposing viewpoints, stuck decisions
- **Participation issues**: Some dominate conversation, others silent, sidebar discussions, low energy
- **Remote facilitation**: Virtual meetings, hybrid sessions, asynchronous collaboration

Trigger phrases: "facilitation", "workshop design", "meeting patterns", "how to run", "session planning", "effective meetings", "group discussion", "team collaboration"

## What Is It?

**Facilitation Patterns** are proven formats and techniques for structuring group interactions to achieve specific outcomes (decisions, ideas, alignment, learning, etc.).

**Core components**:
- **Format selection**: Which pattern fits your goal? (divergent brainstorm, convergent decision, alignment, learning)
- **Agenda design**: Time-boxed activities in logical flow (diverge → converge, build → test)
- **Participation techniques**: Ensure everyone contributes (round robin, silent writing, breakouts)
- **Decision methods**: How to choose (consensus, consent, vote, delegation, advisory)
- **Energy management**: Pacing, breaks, energizers, transitions
- **Difficult dynamics**: Handle dominators, silent participants, conflict, tangents, groupthink

**Quick example:**

**Scenario**: Product team needs to prioritize features for Q2 (8 people, 90 minutes).

**Pattern selected**: Effort-Impact Workshop (diverge → assess → converge)

**Agenda**:
1. **Frame** (10 min): Present context, Q2 goals, constraints
2. **Diverge** (20 min): Silent brainstorm on sticky notes (what features could we build?)
3. **Cluster** (15 min): Group similar ideas, clarify duplicates
4. **Assess** (25 min): Plot features on effort-impact 2×2 matrix (in pairs, then discuss)
5. **Converge** (15 min): Dot voting on "quick wins" (high impact, low effort)
6. **Decide** (10 min): Top 5 features by votes → facilitator makes final call with input
7. **Close** (5 min): Summarize decisions, next steps, feedback on session

**Outcome**: Prioritized list of 5 features, buy-in from team (they contributed), completed in 90 min.

**Core benefits**:
- **Structured productivity**: Clear process prevents aimless discussion
- **Inclusive participation**: Techniques ensure quiet voices heard, dominators managed
- **Better decisions**: Multiple perspectives, bias mitigation (group vs individual), explicit criteria
- **Time efficiency**: Time-boxing prevents overruns, focused activities
- **Psychological safety**: Ground rules, equal participation, separated idea generation from evaluation

## Workflow

Copy this checklist and track your progress:

```
Facilitation Planning Progress:
- [ ] Step 1: Define session objectives
- [ ] Step 2: Select facilitation pattern
- [ ] Step 3: Design agenda
- [ ] Step 4: Prepare materials and logistics
- [ ] Step 5: Facilitate the session
- [ ] Step 6: Close and follow up
```

**Step 1: Define session objectives**

What outcome do you need? (Decision, ideas, alignment, learning, relationship-building). Who attends? How much time? See [resources/template.md](resources/template.md#session-design-template).

**Step 2: Select facilitation pattern**

Based on objective and group size, choose pattern (Brainstorm, Decision Workshop, Alignment Session, Retro, Design Sprint). See [Common Patterns](#common-patterns) and [resources/methodology.md](resources/methodology.md#1-pattern-selection-guide).

**Step 3: Design agenda**

Create time-boxed agenda with activities, transitions, breaks. Follow diverge-converge flow. See [resources/template.md](resources/template.md#agenda-design-template) and [resources/methodology.md](resources/methodology.md#2-agenda-design-principles).

**Step 4: Prepare materials and logistics**

Set up space (physical or virtual), prepare slides/boards, send pre-work if needed, test tech. See [resources/template.md](resources/template.md#logistics-checklist).

**Step 5: Facilitate the session**

Run agenda, manage time, ensure participation, handle dynamics, track outputs. See [resources/methodology.md](resources/methodology.md#3-facilitation-techniques) and [resources/methodology.md](resources/methodology.md#4-handling-difficult-dynamics).

**Step 6: Close and follow up**

Summarize outcomes, clarify next steps and owners, gather feedback, share notes. See [resources/template.md](resources/template.md#closing-and-followup-template).

Validate using [resources/evaluators/rubric_facilitation_patterns.json](resources/evaluators/rubric_facilitation_patterns.json). **Minimum standard**: Average score ≥ 3.5.

## Common Patterns

**Pattern 1: Divergent Brainstorm (Generate Ideas)**
- **Goal**: Maximum idea generation, creative exploration
- **Format**: Silent individual brainstorm → share → cluster → refine
- **Techniques**: Crazy 8s, SCAMPER, "Yes, and...", defer judgment
- **Time**: 30-60 min for 5-10 people
- **Output**: 30-100 ideas, clustered by theme
- **When**: Need creative options, early in project, no single right answer

**Pattern 2: Convergent Decision Workshop (Choose Direction)**
- **Goal**: Narrow options, make decision with group input
- **Format**: Present options → assess criteria → vote/rank → decide
- **Techniques**: 2×2 matrix (effort-impact), dot voting, affinity grouping, forced ranking
- **Time**: 60-90 min for decision, 2-3 hours for complex
- **Output**: Prioritized list or single decision with rationale
- **When**: Multiple options exist, need buy-in, criteria clear

**Pattern 3: Alignment Session (Build Shared Understanding)**
- **Goal**: Get everyone on same page (vision, strategy, plan)
- **Format**: Present → Q&A → small group discussion → report back → synthesize
- **Techniques**: Fishbowl, gallery walk, 1-2-4-All, consensus check
- **Time**: 90-120 min for alignment, half-day for strategy
- **Output**: Shared mental model, documented assumptions, commitments
- **When**: Starting project, misalignment detected, new team formation

**Pattern 4: Retrospective (Reflect and Improve)**
- **Goal**: Learn from experience, identify improvements
- **Format**: Set context → gather data → generate insights → decide actions → close
- **Techniques**: Start-Stop-Continue, Mad-Sad-Glad, Timeline, Sailboat, 4Ls (Liked, Learned, Lacked, Longed for)
- **Time**: 45-90 min for sprint retro, 2-3 hours for project postmortem
- **Output**: 2-5 actionable improvements with owners
- **When**: End of sprint/project, recurring team practice, after incident

**Pattern 5: Design Sprint (Prototype and Test)**
- **Goal**: Rapidly prototype and validate concept
- **Format**: 5 days: Understand → Diverge → Decide → Prototype → Test
- **Techniques**: Sketching, storyboarding, Crazy 8s, Heat Map voting, user testing
- **Time**: 5 full days (can compress to 2-3 days)
- **Output**: Validated prototype, user feedback, go/no-go decision
- **When**: Big design decision, high uncertainty, time to test before committing

**Pattern 6: Asynchronous Collaboration (Remote/Distributed)**
- **Goal**: Collaborate across time zones, allow reflection time
- **Format**: Post prompt → async responses (24-48h) → sync synthesis session → document
- **Techniques**: Shared docs, threaded discussions, Loom videos, async voting (Polly, Simple Poll)
- **Time**: 2-5 days total (30-60 min sync session)
- **Output**: Documented decisions, rationale, action items
- **When**: Global team, deep thinking needed, no urgency for immediate decision

## Guardrails

**Critical requirements:**

1. **Objectives before format**: Start with "what outcome do we need?" not "let's do a brainstorm". Format serves objective. If objective unclear, session will drift.

2. **Time-box ruthlessly**: Parkinson's Law (work expands to fill time). Set strict timers, end activities even if incomplete. 25 min generates better focus than open-ended "until we're done."

3. **Separate divergence from convergence**: Don't critique ideas during brainstorm (kills creativity). Defer judgment. Generate first, evaluate second. Premature convergence yields safe, obvious ideas.

4. **Ensure psychological safety**: Ground rules (no interrupting, critique ideas not people, Vegas rule if needed). Address power dynamics (boss speaks last, use anonymous input). Without safety, you get groupthink or silence.

5. **Manage participation actively**: Silent people have ideas (use individual writing, round robin, small groups). Verbose people dominate (time limits, "let's hear from others", parking lot for tangents). Don't let dysfunction fester.

6. **Decide how decisions are made**: Consensus (everyone agrees), consent (no objections), majority vote, delegation (input → decision-maker). Announce method upfront. Lack of clarity → "I thought we decided, but nothing happened."

7. **Track outputs visibly**: Shared board, live doc, sticky notes. Everyone sees same thing (reduces misunderstanding). Assign scribe if needed. Invisible outputs are easily lost.

8. **Close with clarity**: What was decided? Who does what by when? What's still open? How will we communicate? 5 min close prevents week of confusion.

**Common pitfalls:**

- ❌ **No agenda**: Meetings drift, go long, participants unclear on purpose. Always have agenda (even 3 bullets).
- ❌ **Wrong people**: Decision-makers absent, too many observers, missing key stakeholders. Right people > right process.
- ❌ **Too much content**: 10 topics in 60 min = shallow on all. Better: 2-3 topics, go deep, make progress.
- ❌ **Facilitator dominates**: Facilitator should guide process, not content. Reduce own talking, ask questions, stay neutral.
- ❌ **No breaks**: 2+ hours without break → diminishing returns. Break every 60-90 min (5-10 min).
- ❌ **Ignoring energy**: Pushing through low energy → poor output. Use energizers, adjust pace, or stop early.

## Quick Reference

**Key resources:**
- **[resources/template.md](resources/template.md)**: Session design template, agenda builder, logistics checklist, closing template
- **[resources/methodology.md](resources/methodology.md)**: Pattern selection guide, agenda design principles, facilitation techniques, handling difficult dynamics, decision-making methods
- **[resources/evaluators/rubric_facilitation_patterns.json](resources/evaluators/rubric_facilitation_patterns.json)**: Session quality criteria (objectives clarity, participation balance, decision clarity, time management)

**Decision-making methods**:
- **Consensus**: Everyone must agree (slow, high buy-in, use for high-stakes or high-impact decisions)
- **Consent**: No one objects / "safe to try" (faster than consensus, Sociocracy)
- **Majority vote**: >50% wins (quick, can leave minority feeling unheard)
- **Advisory**: Input from group, decision by one person (fast, accountable, use when decision-maker clear)
- **Delegation**: Empower subset to decide with constraints (scales well, trust required)

**Participation techniques**:
- **Round robin**: Each person speaks in turn (ensures equal airtime)
- **1-2-4-All**: Think alone → pairs → fours → whole group (builds ideas, safe for introverts)
- **Silent writing**: Sticky notes or shared doc, no talking (prevents groupthink, good for brainstorms)
- **Breakout rooms**: Small groups (3-5 people) discuss, report back (scalable, increases participation)
- **Dot voting**: Each person gets N dots to vote on ideas (quick prioritization, visual)
- **Fist to Five**: Show fingers 0-5 to gauge agreement (quick temperature check)

**Energizers** (5-10 min):
- **Standup stretch**: Literally stand and stretch (blood flow)
- **Quick icebreaker**: "One word to describe how you're feeling", "What's on your desk right now?"
- **Music break**: Play upbeat song, encouraged to dance/move
- **Pair share**: 2 min with partner on non-work topic
- **Voting game**: Thumbs up/down rapid-fire questions ("Coffee or tea?")

**Timing guidelines**:
- **Daily standup**: 15 min (5-10 people, 1 min each)
- **1:1**: 30-60 min (half listening, half topics)
- **Team sync**: 60 min (updates, 1-2 discussion topics)
- **Brainstorm**: 30-60 min (diverge, cluster, dot vote)
- **Decision workshop**: 90-120 min (options, criteria, discussion, vote)
- **Retrospective**: 60-90 min (sprint), 2-3 hours (project)
- **Alignment session**: 2-4 hours (include breaks)
- **Design sprint**: 5 full days (or compressed to 2-3 days)

**Red flags** (adjust or stop session):
- >50% on laptops/phones (not engaged) → take break, energizer, or change format
- Same 2-3 people talking entire time → round robin, small groups
- Sidebar conversations → address directly ("Let's have one conversation"), or acknowledge and parking lot
- Confusion about purpose → stop, re-clarify objective, adjust agenda
- Running 30+ min over → apologize, reschedule rest, or ruthlessly cut content

**Inputs required:**
- **Objective**: What outcome do you need? (Decision, ideas, alignment, learning)
- **Participants**: Who? How many? Roles? Power dynamics?
- **Time**: How long? (Realistic estimate, not wishful thinking)
- **Constraints**: Location (remote/in-person), budget, cultural norms

**Outputs produced:**
- `facilitation-plan.md`: Session design (objective, agenda, materials, decision method, outputs)
- `session-notes.md`: What was discussed, decisions made, action items with owners
