# Facilitation Patterns Methodology

Advanced techniques for pattern selection, agenda design, facilitation, handling dynamics, decision-making, and remote collaboration.

## Workflow

```
Facilitation Planning Progress:
- [ ] Step 1: Define session objectives
- [ ] Step 2: Select facilitation pattern
- [ ] Step 3: Design agenda
- [ ] Step 4: Prepare materials and logistics
- [ ] Step 5: Facilitate the session
- [ ] Step 6: Close and follow up
```

**Step 1-3**: Define objectives, select pattern, design agenda → See [1. Pattern Selection Guide](#1-pattern-selection-guide) and [2. Agenda Design Principles](#2-agenda-design-principles)

**Step 4**: Prepare logistics → See [resources/template.md](template.md#logistics-checklist)

**Step 5**: Facilitate → See [3. Facilitation Techniques](#3-facilitation-techniques) and [4. Handling Difficult Dynamics](#4-handling-difficult-dynamics)

**Step 6**: Close and follow up → See [5. Decision-Making Methods](#5-decision-making-methods) for ensuring clarity

---

## 1. Pattern Selection Guide

### Decision Tree

**Question 1: What's the primary objective?**

**A. Generate ideas / explore options (Divergent)**
- Group size: <15 people → **Brainstorm pattern**
- Group size: >15 people → Breakouts first, then report back

**B. Make a decision / choose direction (Convergent)**
- Clear criteria exist → **Decision Workshop pattern**
- Criteria need to be defined → Alignment session first, then decision

**C. Build shared understanding / align (Convergence on mental model)**
- Strategy or vision alignment → **Alignment Session pattern**
- Tactical alignment (who does what) → **Working Session pattern**

**D. Reflect and improve (Retrospective)**
- After sprint/project → **Retrospective pattern**
- After incident → **Postmortem pattern** (blameless, focus on systems)

**E. Prototype and validate (Design)**
- High uncertainty, big decision → **Design Sprint pattern** (5 days)
- Medium uncertainty, smaller scope → **Rapid prototyping workshop** (1 day)

**Question 2: What's the group size?**

- **3-5 people**: Simple discussion format, less structure needed
- **6-10 people**: Ideal for most patterns, can have whole-group discussion
- **11-20 people**: Need breakouts for discussion, report back to whole group
- **20+**: Presentation + Q&A + breakouts, or multiple sessions

**Question 3: How much time?**

- **<30 min**: Standup, quick sync, tactical decision
- **30-60 min**: Focused brainstorm or simple decision
- **60-120 min**: Decision workshop, retrospective, working session
- **Half day (3-4 hours)**: Alignment, planning, deep dive
- **Full day+**: Design sprint, strategy offsite, training

### Pattern Matching Table

| Goal | Pattern | Time | Group Size | Output |
|------|---------|------|-----------|--------|
| Generate ideas | Brainstorm | 30-60 min | 5-10 | 30-100 ideas |
| Prioritize options | Decision Workshop | 90-120 min | 5-10 | Ranked list or decision |
| Align on vision | Alignment Session | 2-4 hours | 10-30 | Shared understanding |
| Reflect on sprint | Retrospective | 60-90 min | 5-8 | 2-3 improvements |
| Design solution | Design Sprint | 5 days | 5-7 | Tested prototype |
| Tactical planning | Working Session | 90-120 min | 4-8 | Plan with owners |
| Incident review | Postmortem | 2-3 hours | 5-12 | Root cause, actions |

---

## 2. Agenda Design Principles

### The Diverge-Converge Diamond

Most effective sessions follow this flow:

```
Start (Narrow) → Diverge (Expand) → Converge (Narrow) → Decide (Narrow)

Example:
1. Frame the problem (narrow focus)
2. Individual brainstorm (diverge - many ideas)
3. Cluster ideas, discuss themes (converge - patterns emerge)
4. Dot vote on top ideas (decide - commit to 3-5)
```

**Why it works**: Diverge prevents premature convergence (jumping to first idea). Converge prevents paralysis (too many options). Structure creates productive tension.

### Time-Boxing Principles

**Parkinson's Law**: Work expands to fill available time. Tight time-boxes → focus.

**Guidelines**:
- **5-10 min**: Quick individual task (write ideas, read doc)
- **15-20 min**: Small group discussion or activity
- **25-30 min**: Deep discussion or complex activity (max before energy drops)
- **45-60 min**: Absolute max without break (diminishing returns after)
- **10-15% buffer**: Add slack for overruns (60 min session → schedule 70 min)

**Time warnings**: Give "5 minutes left" and "2 minutes, wrap up" warnings. Keeps people aware.

**Cutting activities**: If running over, don't extend (trains bad behavior). Either ruthlessly cut remaining topics or schedule follow-up.

### Energy Arc

**Energy curve**: High at start (fresh), dips mid-session (fatigue), can lift at end (urgency).

**Design for energy**:
- **Start with easy win**: Quick activity to build momentum (not heavy content immediately)
- **Hard thinking mid-session**: Complex discussion or decision when energy still good (not at end)
- **Vary modalities**: Alternate sitting/standing, individual/group, talking/silent, consuming/creating
- **Breaks**: Every 60-90 min (5-10 min). Non-negotiable for 2+ hour sessions.
- **Energizers**: Quick activities to lift energy (stretch, music, movement, game)
- **End strong**: Clear summary, appreciation, next steps (not "we're out of time, bye")

### Activity Sequencing

**Good sequences**:
1. **Individual → Pairs → Small Group → Whole Group** (1-2-4-All)
   - Ensures everyone thinks first (not dominated by fast talkers)
2. **Silent → Verbal** (write first, then discuss)
   - Prevents groupthink, gives introverts processing time
3. **Generate → Cluster → Prioritize** (brainstorm workflow)
   - Diverge (ideas), converge (themes), decide (priority)
4. **Presentation → Q&A → Discussion → Decision**
   - Context first, clarify, explore, then commit

**Bad sequences**:
- Starting with whole-group discussion (dominators take over, no equal participation)
- Critique during idea generation (kills creativity)
- Decision before discussion (premature, low buy-in)

---

## 3. Facilitation Techniques

### Ensuring Participation

**Problem**: Some people dominate, others silent. Leads to groupthink or missing perspectives.

**Techniques**:

**Round Robin**: Each person speaks in turn (30 sec - 2 min each). Can't interrupt or pass.
- **Use when**: Want to hear from everyone, equal airtime important
- **Variation**: Popcorn (people nominate next speaker, ensures network spreads)

**1-2-4-All**: Individual (1 min think alone) → Pairs (2 min discuss) → Fours (4 min synthesize) → All (report themes)
- **Use when**: Complex question, want deep thinking before sharing
- **Benefit**: Introverts process privately first, extroverts get multiple discussion rounds

**Silent Writing / Brain-writing**: Everyone writes ideas on sticky notes or shared doc (5-10 min), no talking
- **Use when**: Brainstorming, want to avoid groupthink
- **Benefit**: Parallel idea generation (10 people generate 50 ideas in 5 min vs 30 min talking)

**Breakout Rooms** (physical or virtual): Small groups (3-5 people) discuss, then report back
- **Use when**: >10 people, need deeper discussion than whole-group allows
- **Tip**: Give clear prompt and time limit (15-20 min). Visit rooms to check progress.

**Anonymous Input**: Use tools (Slido, Mentimeter, shared doc) for questions or ideas without names
- **Use when**: Sensitive topics, power dynamics (boss in room), psychological safety low

**Equalize speaking time**: Set explicit time limits (2 min per person), use timer, enforce gently
- **Tip**: "I'm going to ask everyone to keep responses to 2 minutes so we hear from all."

### Managing Time

**Visible timer**: Shared screen timer or physical clock. Everyone sees time remaining.

**Time-keeper role**: Delegate to someone (not facilitator) to give warnings ("5 min left", "time")

**Ruthless cutting**: If activity runs over, don't extend (trains people to respect time-box). Either cut remaining topics or defer to follow-up.

**Buffer in agenda**: Add 10-15% slack. If 5 activities × 10 min each = 50 min, schedule 60 min.

### Capturing Outputs

**Visible board**: Everyone sees same thing (whiteboard, Mural, shared doc projected). Reduces misunderstanding.

**Scribe role**: Delegate note-taking to someone (not facilitator). Facilitator focuses on process.

**Structured capture**:
- Decisions: What was decided, rationale, who, when
- Action items: Specific, owner, due date
- Parking lot: Topics for later (important but off-agenda)
- Key insights: Themes, patterns, surprising learnings

**Post-session**: Share notes within 24 hours. Faster = better (while fresh).

---

## 4. Handling Difficult Dynamics

### Dominating Participants

**Symptoms**: Same 2-3 people talking entire time, others silent, depth of contribution varies.

**Interventions**:
- **Round robin**: Force equal airtime
- **Direct invite**: "We haven't heard from [name] yet. What's your take?"
- **Interrupt gently**: "Thanks [name], let me pause you there and hear from others first."
- **Set ground rules upfront**: "Step up, step back" (if you talk a lot, make space; if quiet, push to contribute)
- **Private chat** (if recurring): "I appreciate your input. Can you help me by holding space for quieter folks?"

### Silent Participants

**Causes**: Introverted, processing time needed, intimidated, disagree but don't want conflict, multitasking.

**Interventions**:
- **Silent writing first**: Gives time to think before talking
- **Pairs before whole group**: Safer to talk to one person first
- **Direct invite (gently)**: "We haven't heard from you, [name]. What do you think?" (Don't force if they decline)
- **Chat box / anonymous**: Can type thoughts if uncomfortable speaking
- **Offline**: "I noticed you were quiet. Any thoughts you didn't get to share?"

**Don't assume**: Silence doesn't always mean disengagement. Some process internally.

### Conflict or Disagreement

**Normal and healthy** (if managed well). Different perspectives → better decisions.

**Interventions**:
- **Surface it**: "I hear two different views. Let's understand each fully before deciding."
- **Steelman each position**: Ask each person to restate other's view ("What's the strongest argument for their position?")
- **Clarify trade-offs**: "What are we optimizing for? What do we gain/lose with each option?"
- **Separate people from ideas**: "We're debating the idea, not attacking each other."
- **Decision method clarity**: "Here's how we'll decide after hearing all views: [vote, consensus, advisory]."
- **Escalate if needed**: "We're stuck. Let's take to [decision-maker] with both views and recommendation."

**Avoid**: Rushing to resolution, dismissing minority view, facilitator taking side.

### Tangents or Off-Topic

**Symptoms**: Discussion drifts from agenda, pursuing interesting but irrelevant thread.

**Interventions**:
- **Parking lot**: "That's important, but off today's agenda. I'll capture it here and we'll address later."
- **Refocus**: "Let's come back to the question: [restate agenda item]."
- **Check with group**: "This is interesting but not on agenda. Do we want to spend time on this or stay focused?" (Usually folks choose focus)

**Prevention**: Clear agenda upfront, ground rules about staying on-topic, strong facilitator.

### Low Energy or Disengagement

**Symptoms**: Laptops open, sidebar conversations, people leaving room, glazed looks.

**Interventions**:
- **Break**: "Let's take 5 min. I see energy dropping."
- **Energizer**: Quick physical activity (stand, stretch, music, game)
- **Change format**: Switch from presentation to discussion, or whole-group to breakouts
- **Check in**: "I'm sensing low energy. What's going on? Do we need to adjust?"
- **Stop early**: If session isn't working, better to cut short than push through. "This isn't landing. Let's regroup."

**Prevention**: Vary activities (don't lecture for 90 min), breaks every 60-90 min, start strong.

### Power Dynamics

**Symptoms**: Boss in room → people defer, don't speak candidly. New person → intimidated. Hierarchy suppresses dissent.

**Interventions**:
- **Boss speaks last**: Explicitly ask senior person to hold input until others share
- **Anonymous input**: Use tools so contributions not attributed
- **Small groups**: Mix hierarchy levels, or group by level (peers discuss first)
- **Ground rules**: "Challenge ideas, not people" + "No rank in this room for next 90 min"
- **Private channels**: 1:1s for sensitive topics hierarchy prevents

**Facilitator neutrality**: Don't align with boss or senior person. Protect space for dissent.

---

## 5. Decision-Making Methods

### Consensus

**Definition**: Everyone must agree (or at least accept) the decision.

**Process**: Discuss until all objections resolved. Ask "Can you live with this?" (not "Do you love it?")

**Pros**: High buy-in, all voices heard, surfaces concerns early

**Cons**: Slow (can take hours or multiple sessions), one person can block, pressure to conform

**Use when**: High-stakes, irreversible decisions. Team needs to deeply own outcome. Time available.

**Red flags**: Fake consensus (people agree publicly but disagree privately). Dominators steamroll minority.

### Consent (Sociocracy)

**Definition**: No one has a "principled objection" (i.e., decision is "safe to try").

**Process**: Propose decision. Ask "Any objections?" If objection, explore: Is it principled (violates values, causes harm) or preference (I'd rather do X)? Principled → revise proposal. Preference → document but proceed.

**Pros**: Faster than consensus, surfaces critical objections, empowers minority voice

**Cons**: Requires discipline (distinguishing principled vs preference), unfamiliar to many

**Use when**: Need speed but also safety. Experimental decisions (can reverse if fails). Sociocratic orgs.

### Majority Vote

**Definition**: >50% wins (or 2/3, or other threshold).

**Process**: Present options, clarify, vote (show of hands, poll, secret ballot). Majority wins.

**Pros**: Fast, clear outcome, democratic

**Cons**: Minority may feel unheard, low buy-in from losers, binary (can't combine ideas)

**Use when**: Simple choices, time pressure, democratic process expected, low controversy

**Variations**:
- **Ranked choice**: Vote for 1st, 2nd, 3rd choice. Eliminates least popular iteratively.
- **Dot voting**: Each person gets N dots to allocate across options. Visual, quick prioritization.

### Advisory (Input-Driven)

**Definition**: One person makes decision after gathering input from group.

**Process**: Present options, gather feedback/concerns, decision-maker weighs input and decides. Announces decision with rationale.

**Pros**: Fast, accountable (one person owns), scalable (doesn't require everyone to agree)

**Cons**: Can feel top-down if not communicated well, decision-maker may ignore input

**Use when**: Decision-maker clear, they have context others lack, time pressure, precedent for this authority

**Keys**: Announce upfront ("I'll make call with your input"), genuinely consider input, explain rationale.

### Delegation

**Definition**: Empower a subset (person or small group) to decide within constraints.

**Process**: Define decision space ("You can decide X, Y, Z within budget $N and timeframe T"). Delegate. Group decides autonomously. Reports back.

**Pros**: Scales well, develops autonomy, fast (no coordination overhead)

**Cons**: Requires trust, may make suboptimal choice (lack full context), others may feel excluded

**Use when**: Decision is specialized (subset has expertise), trust high, decision reversible, empowerment valued

### Comparison Table

| Method | Speed | Buy-in | Use When |
|--------|-------|--------|----------|
| **Consensus** | Slow | Very High | High-stakes, irreversible, time available |
| **Consent** | Medium | High | Experimental, need safety + speed |
| **Majority Vote** | Fast | Medium | Simple choice, democratic process |
| **Advisory** | Fast | Medium | Clear decision-maker, time pressure |
| **Delegation** | Very Fast | Varies | Specialized, trust high, empowerment |

---

## 6. Remote Facilitation Best Practices

### Synchronous (Live Video)

**Challenges**: Harder to read body language, tech issues, "Zoom fatigue", harder to manage participation.

**Best practices**:
- **Cameras on** (if possible, respect privacy): Increases engagement, body language visible
- **Mute when not speaking**: Reduces background noise
- **Use chat**: Parallel channel for questions, links, emoji reactions, jokes (humanizes)
- **Breakout rooms**: Small groups for discussion (easier than 15 people on main call)
- **Visual board**: Mural, Miro, Google Jamboard. Everyone contributes simultaneously.
- **Shorter sessions**: 90 min max without break (Zoom fatigue real). Prefer 60 min.
- **More breaks**: Every 45-60 min (5 min break). People need screen rest.
- **Explicit turn-taking**: Harder to read cues. Use hand-raise feature, or round robin.
- **Share agenda in chat**: Pin message or share screen. Easy reference.
- **Tech check**: "Can everyone see screen? Hear me okay?" at start.

**Tools**:
- **Video**: Zoom, Google Meet, Microsoft Teams
- **Collaboration**: Mural, Miro, Figma, Google Jamboard, Lucidspark
- **Voting**: Slido, Mentimeter, Poll Everywhere, built-in Zoom polls
- **Anonymous Q&A**: Slido, Mentimeter (reduces hierarchy)

### Asynchronous

**When to use**: Global teams (time zones), deep thinking needed, no urgency, writing > talking.

**Process**:
1. **Post prompt**: Clear question, context, examples, deadline (24-48h)
2. **Async responses**: People respond in shared doc, thread, video (Loom)
3. **Synthesize**: Facilitator (or AI) summarizes themes, patterns, questions
4. **Sync session** (optional): Short call (30-60 min) to discuss, clarify, decide based on async input
5. **Document decision**: Write up, share with all

**Best practices**:
- **Clear prompts**: Specific questions, not vague ("What do you think about X?"). Example: "What are the top 3 risks for this feature launch? For each, suggest a mitigation."
- **Deadline**: Give 24-48h for responses. Longer → people forget.
- **Acknowledge contributions**: React to comments, thank people for input
- **Thread discussions**: Use threaded replies (Slack, Notion, Google Docs comments) so conversations organized
- **Synthesis required**: Don't expect participants to read 50 comments. Facilitator summarizes.

**Tools**:
- **Docs**: Google Docs (comments), Notion, Confluence
- **Threads**: Slack, Microsoft Teams, Discord
- **Video**: Loom (async video responses)
- **Forms**: Google Forms, Typeform (structured input)

### Hybrid (Some In-Person, Some Remote)

**Hardest to facilitate well**: Remote folks feel like second-class participants.

**Best practices**:
- **Equalize participation**: Use digital tools even for in-person folks (everyone on laptop + Mural, not whiteboard that remote can't access)
- **Camera for room**: If in-person group, aim camera at room so remote see body language and who's speaking
- **Explicit turn-taking**: "Let's hear from remote folks first, then in-person."
- **Assign in-room advocate**: Someone in-person watches chat, relays remote comments aloud
- **Minimize hybrid if possible**: Strongly prefer all-remote or all-in-person. Hybrid is hardest.

---

## Summary

**Pattern selection**: Match pattern to objective (divergent brainstorm, convergent decision, alignment, retro, design sprint). Consider group size, time available.

**Agenda design**: Follow diverge-converge flow, time-box ruthlessly, design for energy arc (breaks every 60-90 min, vary modalities).

**Facilitation techniques**: Ensure participation (round robin, 1-2-4-All, silent writing, breakouts), manage time (visible timer, buffer), capture outputs (visible board, scribe, structured notes).

**Difficult dynamics**: Handle dominators (round robin, interrupt gently), silent participants (writing first, pairs, direct invite), conflict (surface it, clarify trade-offs, decision method), tangents (parking lot), low energy (breaks, energizers, stop early), power dynamics (boss speaks last, anonymous).

**Decision methods**: Consensus (slow, high buy-in), consent (safe to try, faster), vote (fast, democratic), advisory (input-driven, one person decides), delegation (empower subset). Choose based on stakes, time, trust.

**Remote facilitation**: Synchronous (cameras on, chat, visual boards, shorter sessions, more breaks, explicit turn-taking). Asynchronous (clear prompts, deadlines, synthesis required). Hybrid (hardest - equalize participation, minimize if possible).

**Final principle**: Facilitation is about process, not content. Facilitator guides how group works together, stays neutral on what group decides. Strong process → better outcomes.
