# Focus, Timeboxing, and 80/20 Templates

Quick-start templates for identifying high-impact work, designing focus blocks, and timeboxing your schedule.

## 80/20 Analysis Template

**Goal**: Identify the vital 20% of tasks that drive 80% of your results.

### Step 1: Brain Dump All Tasks

List everything competing for your attention (work tasks, projects, meetings, admin):

1. [Task/Project 1]
2. [Task/Project 2]
3. [Task/Project 3]
...

### Step 2: Force Rank by Impact

For each task, ask: "If I could only do ONE task this week, which would create the most value?"

| Rank | Task | Impact Score (1-10) | Effort (1-10) | Impact/Effort Ratio |
|------|------|---------------------|---------------|---------------------|
| 1 | [Highest impact task] | 10 | 6 | 1.67 |
| 2 | [Second highest] | 8 | 4 | 2.0 |
| 3 | [Third] | 7 | 5 | 1.4 |
| ... | ... | ... | ... | ... |

### Step 3: Identify Your Vital Few (Top 20%)

**If you have 10 tasks → Top 2 are vital few**
**If you have 20 tasks → Top 4 are vital few**

**My Vital Few** (20% that drive 80% of results):
1. [Task 1] - Why: [Impact/outcome if done well]
2. [Task 2] - Why: [Impact/outcome if done well]
3. [Task 3] - Why: [Impact/outcome if done well]

### Step 4: Allocate 80% of Focus Time to Vital Few

**This week's deep work allocation**:
- Task 1: [X hours / Y focus blocks]
- Task 2: [X hours / Y focus blocks]
- Task 3: [X hours / Y focus blocks]

**Remaining 80% (trivial many)**: Batch, delegate, defer, or eliminate.

---

## Focus Block Design Template

**Goal**: Design distraction-free time blocks for high-value work.

### Block Configuration

**Task**: [What you'll work on]

**Duration**: [25 min / 50 min / 90 min / 120 min] (see guidance below)

**When**: [Day + time, e.g., Monday 9-10:30am]

**Energy required**: [Low / Medium / High]

**Pre-work** (prep before block starts):
- [ ] [Gather all materials/resources needed]
- [ ] [Clear goal/outcome for this session]
- [ ] [Close email, Slack, unnecessary tabs]
- [ ] [Phone away, notifications off]
- [ ] [Set timer]

**During block**:
- Focus: [Single clear objective, e.g., "Draft product spec sections 1-3"]
- No: [List specific distractions to avoid, e.g., "No Slack, no email, no meetings"]

**After block**:
- [ ] [Take break - walk, stretch, water]
- [ ] [Quick note on progress/what's next]
- [ ] [Update task status]

### Duration Selection Guide

| Duration | Use When | Max Per Day |
|----------|----------|-------------|
| **25 min** | High resistance, procrastination, building habit | 8-10 |
| **50 min** | Moderate complexity, mixed tasks | 6-8 |
| **90 min** | Deep work, complex thinking, creative work | 3-4 |
| **120 min** | Maximum deep work, flow state (experienced only) | 2-3 |

---

## Weekly Timeboxing Template

**Week of**: [Date]

**Top 3 Priorities** (from 80/20 analysis):
1. [Priority 1] - Target: [Outcome/milestone]
2. [Priority 2] - Target: [Outcome/milestone]
3. [Priority 3] - Target: [Outcome/milestone]

### Weekly Calendar Allocation

| Day | Morning (9am-12pm) | Afternoon (2-5pm) | Notes |
|-----|-------------------|-------------------|-------|
| **Monday** | Deep Work: Priority 1 (2× 90min) | Meetings + Code Reviews | Peak energy on Priority 1 |
| **Tuesday** | Deep Work: Priority 1 (2× 90min) | Team Collab + Planning | Continue momentum |
| **Wednesday** | Deep Work: Priority 2 (2× 90min) | Meetings + Admin Batch | Shift to Priority 2 |
| **Thursday** | Deep Work: Priority 3 (1× 90min) | Meetings (batch afternoon) | Mix priorities |
| **Friday** | Deep Work: Priority 1 wrap-up (1× 90min) | Admin Batch + Weekly Review | Close loops, plan next week |

**Deep Work Total**: [X hours across Y blocks]

**Meeting Blocks**: [Tue/Thu afternoons]

**Admin Batches**: [Fri afternoon, daily 3:30-4pm]

**Buffer Time**: [20% of week = ~8 hours unscheduled]

### Protection Rules

- [ ] No meetings before 12pm Mon-Wed (deep work sacred)
- [ ] Email checked 2× per day only (11am, 4pm)
- [ ] Slack DND during focus blocks
- [ ] Hard stop at 5pm daily (no evening work)
- [ ] Friday afternoons for planning/admin/cleanup

---

## Daily Timeboxing Template

**Date**: [Today's date]

**Top Goal**: [Most important outcome for today]

**Energy level**: [High / Medium / Low] (adjust plan if low)

### Time-Blocked Schedule

| Time | Block Type | Activity | Done? |
|------|------------|----------|-------|
| 8:00-8:30 | Morning Routine | Exercise, breakfast, prepare for day | [ ] |
| 8:30-9:00 | Planning | Review daily plan, gather resources | [ ] |
| 9:00-10:30 | **Deep Work 1** | [Task: X - clear outcome] | [ ] |
| 10:30-10:45 | Break | Walk outside, stretch, water | [ ] |
| 10:45-12:15 | **Deep Work 2** | [Task: Y - clear outcome] | [ ] |
| 12:15-1:00 | Lunch | Eat away from desk, NO email | [ ] |
| 1:00-2:00 | Meetings | [Standup, 1:1, team sync] | [ ] |
| 2:00-2:15 | Break | Quick walk, coffee | [ ] |
| 2:15-3:15 | Moderate Work | [Code reviews, moderate tasks] | [ ] |
| 3:15-4:00 | Admin Batch | Email, Slack, expense reports, planning | [ ] |
| 4:00-4:30 | Buffer / Overflow | Catch up on anything that ran over | [ ] |
| 4:30-5:00 | Daily Review | What got done? What's tomorrow's top priority? | [ ] |
| 5:00pm | **HARD STOP** | Close laptop, NO evening work | [ ] |

**Total Deep Work**: 3 hours (2× 90min blocks)

**Distraction Log** (track interruptions):
- [Time] - [What interrupted] - [How handled]

**Energy Notes**:
- Peak energy: [When did you feel most focused?]
- Low energy: [When did focus drop?]

---

## Pomodoro Session Template

**For high-resistance tasks or building focus habit.**

**Task**: [What you'll work on]

**Total Pomodoros needed**: [Estimate: 1-8 Pomodoros]

### Session Tracker

| Pomodoro # | Start Time | Task/Subtask | Completed? | Distractions |
|------------|------------|--------------|------------|--------------|
| 1 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 2 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 3 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 4 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| **Long Break** | **15-30 min** | Walk, snack, completely disconnect | [ ] | |
| 5 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 6 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 7 | [Time] | [Specific subtask] | [ ] | [Count: X] |
| 8 | [Time] | [Specific subtask] | [ ] | [Count: X] |

**Rules**:
- 25 min work, 5 min break (non-negotiable)
- After 4 Pomodoros, take 15-30 min break
- If interrupted mid-Pomodoro, mark as void and restart
- Track distractions (awareness helps reduce them)

---

## Task Batching Template

**Goal**: Group similar low-cognitive-load tasks to minimize context-switching.

### Email Batch (30 min, 2× per day)

**Times**: 11:00am and 4:00pm

**Process**:
1. [ ] Sort by priority (VIP, team, automated)
2. [ ] Respond to urgent only (2-min rule: if <2 min, do now)
3. [ ] Archive/delete automated/low-value
4. [ ] Flag for follow-up (action items)
5. [ ] Close email app after 30 min (set timer)

**Not allowed**: Checking email outside these times

### Meeting Batch (Afternoons: Tue/Thu 2-5pm)

**Tue 2-5pm**:
- 2:00-2:30: 1:1 with [Person A]
- 2:30-3:00: 1:1 with [Person B]
- 3:00-3:30: Team sync
- 3:30-4:00: Product review
- 4:00-4:30: Planning meeting

**Thu 2-5pm**: [Similar structure]

**Protection**: No meetings Mon/Wed/Fri mornings (deep work)

### Admin Batch (Fri 3-5pm)

**Checklist**:
- [ ] Expense reports
- [ ] Timesheets
- [ ] Planning for next week (review priorities)
- [ ] Clear inbox to zero
- [ ] Update project status
- [ ] File/organize docs
- [ ] Clean up desk/digital workspace

---

## Weekly Review Template

**Week of**: [Date]

**Purpose**: Assess what worked, what didn't, and adjust next week's plan.

### 1. Deep Work Quality

**Focus blocks completed this week**: [X out of Y planned]

**Quality rating** (1-5, where 5 = completely undistracted):
- Monday: [Rating] - [Notes]
- Tuesday: [Rating] - [Notes]
- Wednesday: [Rating] - [Notes]
- Thursday: [Rating] - [Notes]
- Friday: [Rating] - [Notes]

**Average**: [X.X / 5]

**What protected focus?**
- [e.g., Morning schedule-free zone, Slack DND]

**What interrupted focus?**
- [e.g., Emergency meeting Tuesday, email compulsion]

### 2. 80/20 Alignment

**Did I spend 80% of focus time on vital few (top 20%)?** [Yes / No]

**Time allocation**:
- Priority 1: [X hours] - Target: [Y hours]
- Priority 2: [X hours] - Target: [Y hours]
- Priority 3: [X hours] - Target: [Y hours]
- Low-value tasks: [X hours] (should be <20%)

**Misallocations** (time spent on 80% low-impact):
- [Task that consumed time but low impact]
- [Why: urgent but not important, hard to say no, etc.]

### 3. Energy Management

**Peak energy hours**: [When did I feel most energized?]

**Did I schedule deep work during peak energy?** [Yes / No]

**Energy drains**:
- [e.g., Back-to-back meetings, late-night email checking]

**Energy boosters**:
- [e.g., Morning walk, breaks between blocks, hard stop at 5pm]

### 4. Wins & Challenges

**Wins** (what went well):
1. [Win 1]
2. [Win 2]
3. [Win 3]

**Challenges** (what didn't work):
1. [Challenge 1] - **Fix**: [What to try next week]
2. [Challenge 2] - **Fix**: [What to try next week]
3. [Challenge 3] - **Fix**: [What to try next week]

### 5. Next Week Adjustments

**Changes to make**:
- [ ] [e.g., Block Monday mornings for deep work]
- [ ] [e.g., Batch meetings on Thu afternoon only]
- [ ] [e.g., Set phone timer for breaks]

**Commitments**:
- [ ] [Specific commitment, e.g., "No email before 11am"]
- [ ] [Specific commitment, e.g., "Take full lunch break away from desk"]

---

## Focus Time Tracker (Weekly Log)

Track focus blocks to identify patterns and improve over time.

| Date | Start Time | Duration | Task | Quality (1-5) | Distractions | Outcome |
|------|------------|----------|------|---------------|--------------|---------|
| Mon | 9:00am | 90 min | Payment API design | 5 | 0 | Completed spec |
| Mon | 11:00am | 90 min | Payment implementation | 4 | 1 (Slack ping) | 60% done |
| Tue | 9:00am | 90 min | Payment implementation | 5 | 0 | Completed |
| Tue | 11:00am | 90 min | Testing + bug fixes | 3 | 2 (meeting interrupt) | Partial |
| Wed | 9:00am | 90 min | Documentation | 4 | 1 (email) | 80% done |

**Weekly Totals**:
- Focus blocks completed: [X]
- Average quality: [X.X / 5]
- Total deep work hours: [X hours]
- Most productive day: [Day]
- Biggest distraction source: [e.g., Slack, meetings, email]

**Insights**:
- [What patterns emerge? e.g., "Quality drops after lunch," "Mornings consistently 5/5"]
- [Action for next week: e.g., "Schedule deep work only in mornings"]

---

## Quick Examples by Role

### Example 1: Software Engineer

**Vital Few (80/20)**:
1. Ship payment feature (customer-requested, revenue impact)
2. Fix critical performance bug (customer escalation)
3. Code review backlog (team velocity blocker)

**Weekly Plan**:
- Mon-Wed 9am-12pm: Payment feature (3× 3hr deep work blocks = 9 hours)
- Thu-Fri 9am-11am: Performance bug (2× 2hr deep work blocks = 4 hours)
- Afternoons: Code reviews (1hr/day batched), meetings, admin

**Outcome**: Payment shipped Wed, bug fixed Fri. Code reviews cleared. vs. scattered attention = weeks of delays.

### Example 2: Product Manager

**Vital Few (80/20)**:
1. Q3 roadmap (exec review next week)
2. User research synthesis (inform roadmap)
3. Pricing experiment design (potential 20% revenue lift)

**Weekly Plan**:
- Mon-Tue mornings: Roadmap deep work (4× 90min = 6 hours)
- Wed-Thu mornings: Research synthesis (4× 90min = 6 hours)
- Fri morning: Pricing experiment design (2× 90min = 3 hours)
- Afternoons: Stakeholder meetings (batched Tue/Thu 2-5pm), 1:1s, admin

### Example 3: Writer/Researcher

**Vital Few (80/20)**:
1. Draft chapter 3 (book deadline approaching)
2. Revise chapter 2 based on feedback
3. Outline chapters 4-5

**Weekly Plan**:
- Mon-Thu 6-9am: Writing deep work (4 days × 3hrs = 12 hours)
- Afternoons: Research, reading, notes, admin
- Fri: Buffer for overflow, planning next week

**Protection**: Morning = writing only. No email, no calls, no meetings before noon.
