# Premortem Principles

## The Psychology of Overconfidence

### Why We're Systematically Overconfident

**The Planning Fallacy:**
- We focus on best-case scenarios
- We ignore historical delays and failures
- We assume "our case is different"
- We underestimate Murphy's Law

**Research:**
- 90% of projects run over budget
- 70% of projects run late
- Yet 80% of project managers predict on-time completion

**The fix:** Premortem forces you to imagine failure has already happened.

---

## Hindsight Bias

### The "I Knew It All Along" Effect

**What it is:**
After an outcome occurs, we believe we "always knew" it would happen.

**Example:**
- Before 2008 crash: "Housing is safe"
- After 2008 crash: "The signs were obvious"

**Problem for forecasting:**
If we think outcomes were predictable in hindsight, we'll be overconfident going forward.

**The premortem fix:**
By forcing yourself into "hindsight mode" BEFORE the outcome, you:
1. Generate the warning signs you would have seen
2. Realize how many ways things could go wrong
3. Reduce overconfidence

---

## The Power of Inversion

### Solving Problems Backward

**Charlie Munger:**
> "Invert, always invert. Many hard problems are best solved backward."

**In forecasting:**
- Hard: "Will this succeed?" (requires imagining all paths to success)
- Easier: "It failed - why?" (failure modes are more concrete)

**Why this works:**
- Failure modes are finite and enumerable
- Success paths are infinite and vague
- Humans are better at imagining concrete negatives than abstract positives

---

## Research on Premortem Effectiveness

### Gary Klein's Studies

**Original research:**
- Teams that did premortems identified 30% more risks
- Risks identified were more specific and actionable
- Teams adjusted plans proactively

**Key finding:**
> "Prospective hindsight" (imagining an event has happened) improves recall by 30%

---

### Kahneman's Endorsement

**Daniel Kahneman:**
> "The premortem is the single best debiasing technique I know."

**Why it works:**
1. **Legitimizes doubt** - In group settings, dissent is hard. Premortem makes it safe.
2. **Concrete > Abstract** - "Identify risks" is vague. "Explain the failure" is concrete.
3. **Defeats groupthink** - Forces even optimists to imagine failure.

---

## Outcome Bias

### Judging Decisions by Results, Not Process

**What it is:**
We judge the quality of a decision based on its outcome, not the process.

**Example:**
- Drunk driver gets home safely → "It was fine"
- Sober driver has accident → "Bad decision to drive"

**Reality:**
Quality of decision ≠ Quality of outcome (because of randomness)

**For forecasting:**
A 90% prediction that fails doesn't mean the forecast was bad (10% events happen 10% of the time).

**The premortem fix:**
By imagining failure BEFORE it happens, you evaluate the decision process independent of outcome.

---

## When Premortems Work Best

### High-Confidence Predictions

**Use when:**
- Your probability is >80% or <20%
- You feel very certain
- Confidence intervals are narrow

**Why:**
These are the predictions most likely to be overconfident.

---

### Team Forecasting

**Use when:**
- Multiple people are making predictions
- Groupthink is a risk
- Dissent is being suppressed

**Why:**
Premortems legitimize expressing doubts without seeming disloyal.

---

### Important Decisions

**Use when:**
- Stakes are high
- Irreversible commitments
- Significant resource allocation

**Why:**
Worth the time investment to reduce overconfidence.

---

## When Premortems Don't Help

### Already Uncertain

**Skip if:**
- Your probability is ~50%
- Confidence intervals are already wide
- You're confused, not confident

**Why:**
You don't need a premortem to tell you you're uncertain.

---

### Trivial Predictions

**Skip if:**
- Low stakes
- Easily reversible
- Not worth the time

**Why:**
Premortems take effort; save them for important forecasts.

---

## The Premortem vs Other Techniques

### Premortem vs Red Teaming

**Red Teaming:**
- Adversarial: Find flaws in the plan
- Focus: Attack the strategy
- Mindset: "How do we defeat this?"

**Premortem:**
- Temporal: Failure has occurred
- Focus: Understand what happened
- Mindset: "What led to this outcome?"

**Use both:** Red team attacks the plan, premortem explains the failure.

---

### Premortem vs Scenario Planning

**Scenario Planning:**
- Multiple futures: Good, bad, likely
- Branching paths
- Strategies for each scenario

**Premortem:**
- Single future: Failure has occurred
- Backward path
- Identify risks to avoid

**Use both:** Scenario planning explores, premortem stress-tests.

---

### Premortem vs Risk Register

**Risk Register:**
- List of identified risks
- Probability and impact scores
- Mitigation strategies

**Premortem:**
- Narrative of failure
- Causal chains
- Discover unknown unknowns

**Use both:** Premortem feeds into risk register.

---

## Cognitive Mechanisms

### Why Premortems Defeat Overconfidence

**1. Prospective Hindsight**
Imagining an event has occurred improves memory access by 30%.

**2. Permission to Doubt**
Social license to express skepticism without seeming negative.

**3. Concrete Failure Modes**
Abstract "risks" become specific "this happened, then this, then this."

**4. Temporal Distancing**
Viewing from the future reduces emotional attachment to current plan.

**5. Narrative Construction**
Building a story forces causal reasoning, revealing gaps.

---

## Common Objections

### "This is too negative!"

**Response:**
Pessimism during planning prevents failure during execution.

**Reframe:**
Not negative - realistic. You're not hoping for failure, you're preparing for it.

---

### "We don't have time for this."

**Response:**
- Premortem: 30 minutes
- Recovering from preventable failure: Months/years

**Math:**
If premortem prevents 10% of failures, ROI is massive.

---

### "Our case really is different!"

**Response:**
Maybe. But the premortem will reveal HOW it's different, not just assert it.

**Test:**
If the premortem reveals nothing new, you were right. If it reveals risks, you weren't.

---

## Practical Takeaways

1. **Use for high-confidence predictions** - When you feel certain
2. **Legitimate skepticism** - Makes doubt socially acceptable
3. **Concrete failure modes** - Forces specific risks, not vague worries
4. **Widen confidence intervals** - Adjust based on plausibility of failure narrative
5. **Set kill criteria** - Know what would change your mind
6. **Monitor signposts** - Track early warning signals

**The Rule:**
> If you can easily write a plausible failure narrative, your confidence is too high.

---

**Return to:** [Main Skill](../SKILL.md#interactive-menu)
