# Grant Methodology

This resource supports the Grant Proposal Assistant skill with detailed evaluation methods.

---

## Grant Mechanisms

### NIH Research Grants

**R01 (Research Project Grant)**
- Standard research grant, most common
- Research Strategy: 12 pages
- Budget: Typically $250K-$500K direct/year
- Duration: Up to 5 years
- Best for: Established investigators, substantial projects

**R21 (Exploratory/Developmental)**
- High-risk, high-reward exploratory studies
- Research Strategy: 6 pages
- Budget: $275K total direct (2 years)
- Duration: 2 years, no renewal
- Best for: New directions, preliminary studies for R01

**R03 (Small Research Grant)**
- Limited scope projects
- Research Strategy: 6 pages
- Budget: $50K direct/year
- Duration: 2 years
- Best for: Pilot studies, secondary analyses

**K-Series (Career Development)**
- Training and career development
- Research + Career Development sections
- 75% protected time required
- Best for: Early-stage investigators

### NSF Research Grants

- Project Description: 15 pages
- Broader Impacts required (separate section)
- Intellectual Merit + Broader Impacts scored equally
- Duration: Typically 3 years

---

## Core Question Audit

### Audit Checklist

Read the proposal and mark where each element appears:

**Question 1: Central Hypothesis**
- [ ] Clearly stated (exact sentence identifiable)
- [ ] Testable (can be proven false)
- [ ] Specific (not vague or overly broad)
- [ ] Location: Page ___, Section ___

**Question 2: Importance/Significance**
- [ ] Problem clearly defined
- [ ] Gap explicitly stated ("However, X remains unknown")
- [ ] Impact quantified where possible
- [ ] Timely (why now?)
- [ ] Location: Page ___, Section ___

**Question 3: Innovation**
- [ ] Specific innovation claims (not generic)
- [ ] Type clear: conceptual/methodological/application
- [ ] Advances beyond incremental
- [ ] Location: Page ___, Section ___

**Question 4: Feasibility**
- [ ] Preliminary data supports approach
- [ ] Team has relevant expertise
- [ ] Resources available
- [ ] Timeline realistic
- [ ] Pitfalls acknowledged
- [ ] Alternatives proposed
- [ ] Location: Page ___, Section ___

### Common Audit Findings

| Issue | Frequency | Fix |
|-------|-----------|-----|
| Vague hypothesis | 40% | Rewrite with specific, testable prediction |
| Implicit gap | 35% | Add explicit "However, X remains..." statement |
| Generic innovation | 50% | Replace with specific "first to..." claims |
| Missing pitfalls | 30% | Add pitfall paragraph for each aim |

---

## Significance Checklist

### Required Elements

- [ ] **The Problem**: What clinical/scientific problem exists? (1-2 paragraphs)
- [ ] **Current State**: What's been done? What do we know? (1-2 paragraphs)
- [ ] **The Gap**: What critical question remains? (explicit statement)
- [ ] **Impact of Gap**: What's the cost of not knowing? (quantify if possible)
- [ ] **If Successful**: What changes? How does field advance?

### Scoring Guide

**Score 1-3 (Strong):**
- Gap is critical and timely
- Impact is clear and significant
- Success would change practice/understanding

**Score 4-5 (Moderate):**
- Gap exists but importance less clear
- Impact is incremental
- Some significance but not compelling

**Score 6-9 (Weak):**
- Gap not well defined
- Problem seems solved or unimportant
- Impact vague or minimal

---

## Innovation Checklist

### Required Elements

- [ ] **Specific Claims**: Each innovation is concrete, not generic
- [ ] **Type Identified**: Conceptual, methodological, or application
- [ ] **"First" Statements**: Where applicable, claim novelty explicitly
- [ ] **Beyond Incremental**: Explains why this isn't just "more of the same"

### Innovation Types

**Conceptual Innovation:**
- New framework or model
- Paradigm-shifting hypothesis
- Novel interpretation of existing data

**Methodological Innovation:**
- New technique or assay
- Novel application of existing method
- Technical advance enabling new questions

**Application Innovation:**
- Known method applied to new problem
- Translation across fields
- New model system

### Weak vs. Strong Innovation Claims

| Weak | Strong |
|------|--------|
| "Innovative approach" | "First application of X to Y disease" |
| "Novel methods" | "New assay with 10x sensitivity" |
| "Cutting-edge techniques" | "Adapts CRISPR screening for primary cells" |
| "State-of-the-art" | "Combines single-cell RNA-seq with spatial transcriptomics" |

---

## Reviewer Perspective

### Simulating Reviewer Reading

**First pass (2 minutes):**
- Read Specific Aims page
- Decision: Interested or not?
- What's the hypothesis? What's innovative? Feasible?

**Second pass (15-30 minutes):**
- Skim each section
- Look for: hypothesis, gaps, innovation, controls, statistics
- Mark weaknesses

**Scoring pass:**
- Assign criterion scores (Significance, Innovation, Approach, etc.)
- Determine Overall Impact

### Common Reviewer Criticisms

**Significance:**
- "The gap is not well established"
- "It's unclear how this advances the field"
- "The problem seems solved"

**Innovation:**
- "This is an incremental advance"
- "Methods are standard"
- "Innovation claims are overstated"

**Approach:**
- "Insufficient detail for replication"
- "Missing controls"
- "Statistical plan inadequate"
- "No alternatives if approach fails"
- "Aims are interdependent"

**Investigator/Environment:**
- "Team lacks expertise in X"
- "No evidence of collaboration"
- "Resources not described"

### Writing for Reviewers

**DO:**
- Use headers and bullets for scannability
- State key points explicitly (don't make them infer)
- Front-load important information
- Define terms for non-specialists
- Include visual summary (timeline, flowchart)

**DON'T:**
- Bury hypothesis in paragraph
- Assume deep domain knowledge
- Use walls of text
- Leave innovation implicit
- Forget non-expert secondary reviewers
