# Grant Templates

This resource provides structural templates for grant proposal sections.

---

## Specific Aims Template

### Structure (1 Page Maximum)

```markdown
[OPENING PARAGRAPH - 5-7 sentences]

[Sentence 1: Hook - Significance statement]
[Disease/problem] affects [number] people annually, causing [impact].

[Sentence 2-3: Current state and limitation]
Current approaches [what exists], but [limitation]. This is because [why it fails].

[Sentence 4: Long-term goal]
The long-term goal of our research is to [broad objective].

[Sentence 5: Central hypothesis]
Our central hypothesis is that [specific, testable prediction].

[Sentence 6: Rationale]
This hypothesis is based on [preliminary data/published literature] showing [evidence].

[Sentence 7: Overview]
To test this hypothesis, we will pursue the following specific aims:

---

**Aim 1: [Verb phrase - what you will do]**

[2-3 sentences explaining: what, why, expected outcome]
We will [method] to [objective]. We expect to find [prediction]. This aim will
establish [what it contributes to overall hypothesis].

---

**Aim 2: [Verb phrase - what you will do]**

[2-3 sentences explaining: what, why, expected outcome]
Building on [connection to Aim 1 or independent rationale], we will [method] to
[objective]. The expected outcome is [prediction]. This aim will [contribution].

---

**Aim 3 (optional): [Verb phrase - what you will do]**

[2-3 sentences]

---

[CLOSING PARAGRAPH - 2-4 sentences]

[Expected Outcomes]
Completion of these aims will [what knowledge is gained].

[Impact]
These studies will have a significant positive impact by [how field/patients benefit].

[Future Directions]
This work will lay the foundation for [future studies/applications].
```

### Specific Aims Checklist

- [ ] Fits on exactly 1 page (no spillover)
- [ ] Hypothesis stated explicitly in opening paragraph
- [ ] Each aim starts with action verb (Determine, Establish, Test, Evaluate)
- [ ] Aims are independent (project survives if one fails)
- [ ] Expected outcomes stated for each aim
- [ ] Impact statement in closing is specific
- [ ] Readable by non-specialist

---

## Approach Per Aim

### Template for Each Aim Section

```markdown
## Aim [X]: [Title]

### Rationale
[1 paragraph]
Why is this aim necessary? How does it test the hypothesis? What gap does it fill?
Connect to overall project logic.

### Preliminary Data (if applicable)
[1-2 paragraphs + figures if available]
What have you already done that shows feasibility? Include key data supporting
the approach.

### Experimental Strategy

**Subaim X.1: [Specific objective]**
[Detailed description of experiments]
- Model system: [What you're using]
- Methods: [How you'll do it]
- Controls: [Positive and negative]
- Sample size: [N and power calculation]
- Analysis: [How data will be analyzed]
- Timeline: [When completed]

**Subaim X.2: [Specific objective]**
[Detailed description...]

### Expected Outcomes
What results do you expect? How will you interpret different outcomes?
- If [result A]: supports hypothesis because [interpretation]
- If [result B]: refutes hypothesis, suggesting [alternative interpretation]

### Potential Pitfalls and Alternative Approaches
[1-2 paragraphs]
What could go wrong? Be specific.
- Pitfall 1: [What might fail]. Alternative: [Backup plan]
- Pitfall 2: [What might fail]. Alternative: [Backup plan]

### Milestones and Timeline
- Month 1-6: [Milestone]
- Month 7-12: [Milestone]
- Go/no-go decision point: [What determines if you proceed]
```

---

## Significance Section Template

```markdown
## Significance

### The Problem
[1-2 paragraphs]
[Disease/challenge] represents a major [clinical/scientific] problem, affecting
[statistics]. Current mortality/morbidity is [data]. Economic burden is [if applicable].

### Current State of Knowledge
[2-3 paragraphs]
Our understanding of [topic] has advanced through [key findings]. [Author] showed
that [finding]. [Another author] demonstrated [finding]. These studies established
that [current knowledge].

### Critical Gap
[1 paragraph]
**However, a critical gap remains:** [explicit gap statement]. Despite progress in
[what's known], [what remains unknown]. This gap is significant because [consequence
of not knowing].

### Impact if Successful
[1 paragraph]
Successful completion of this project will [specific outcomes]. These findings will
[how field advances]. Ultimately, this work will enable [clinical/scientific impact].

### Rigor of Prior Research
[1 paragraph - NIH requirement]
The premise for the proposed research is based on [published literature]. Key studies
supporting this proposal include [citations] which showed [findings]. These studies
used [methods] with [sample sizes/rigor indicators].
```

---

## Innovation Section Template

```markdown
## Innovation

The proposed research is innovative in the following ways:

**Conceptual Innovation:**
• [Specific claim]: This project will be the first to [novel concept/framework].
  Unlike previous approaches that [old paradigm], we propose [new paradigm].

**Methodological Innovation:**
• [Specific claim]: We will develop/apply [new method] which offers [advantage]
  over existing approaches. This method enables [what's now possible].

**Application Innovation:**
• [Specific claim]: This represents the first application of [approach] to
  [problem/disease]. While [approach] has been used for [other purpose], its
  application to [this problem] is novel because [reason].

**Expected Innovation in Outcomes:**
• This project will generate [novel data type/resource] that will enable
  [future studies]. No such [resource/dataset] currently exists for [field].
```

---

## Compliance Checklist

### NIH R01 Requirements

**Format:**
- [ ] Arial 11pt or Georgia 11pt (or equivalent)
- [ ] Margins: 0.5 inch minimum
- [ ] Page numbers included

**Page Limits:**
- [ ] Specific Aims: 1 page
- [ ] Research Strategy: 12 pages (Significance + Innovation + Approach)
- [ ] Bibliography: No page limit
- [ ] Biosketch: 5 pages per person

**Required Sections:**
- [ ] Specific Aims
- [ ] Significance
- [ ] Innovation
- [ ] Approach
- [ ] Bibliography
- [ ] Resource Sharing Plan (if applicable)
- [ ] Authentication of Key Resources

**Biosketch Format:**
- [ ] Uses current NIH format
- [ ] Personal statement tailored to project
- [ ] Contributions to science (up to 5)
- [ ] Publications listed (up to 4 per contribution)

### NSF Requirements

- [ ] Project Summary: 1 page (separate Intellectual Merit and Broader Impacts)
- [ ] Project Description: 15 pages
- [ ] References Cited: No page limit
- [ ] Biographical Sketch: 3 pages per senior personnel
- [ ] Data Management Plan: 2 pages
