# Portfolio Roadmapping Bets Template

## Table of Contents
1. [Workflow](#workflow)
2. [Portfolio Roadmap Template](#portfolio-roadmap-template)
3. [Bet Template](#bet-template)
4. [Guidance for Each Section](#guidance-for-each-section)
5. [Quick Patterns](#quick-patterns)
6. [Quality Checklist](#quality-checklist)

## Workflow

Copy this checklist and track your progress:

```
Portfolio Roadmapping Bets Progress:
- [ ] Step 1: Define theme and constraints
- [ ] Step 2: Inventory and size bets
- [ ] Step 3: Sequence across horizons
- [ ] Step 4: Set exit and scale criteria
- [ ] Step 5: Balance and validate portfolio
```

**Step 1: Define theme and constraints**

Fill out [Portfolio Context](#1-portfolio-context) section with strategic theme, time horizon definitions, resource constraints, and portfolio balance targets.

**Step 2: Inventory and size bets**

List all candidate initiatives using [Bet Template](#bet-template). Size each by effort (S/M/L/XL) and impact (1x/3x/10x). See [Guidance: Sizing Bets](#sizing-bets) for examples.

**Step 3: Sequence across horizons**

Assign bets to H1/H2/H3 based on dependencies, capacity, and strategic timing. Fill out [Horizon 1](#3-horizon-1-h1-now-0-6-months), [Horizon 2](#4-horizon-2-h2-next-6-12-months), [Horizon 3](#5-horizon-3-h3-later-12-24-months) sections.

**Step 4: Set exit and scale criteria**

For each bet, define success (scale) and failure (exit) criteria with metrics and timelines. See [Guidance: Exit & Scale Criteria](#exit--scale-criteria).

**Step 5: Balance and validate portfolio**

Complete [Portfolio Balance Summary](#6-portfolio-balance-summary). Check risk distribution, horizon mix, capacity feasibility. Use [Quality Checklist](#quality-checklist) to validate.

---

## Portfolio Roadmap Template

### 1. Portfolio Context

**Strategic Theme:**
[What overarching goal drives this portfolio? Example: "Grow marketplace GMV 3x to $300M in 18 months"]

**Time Horizons:**
- **H1 (Now)**: [Date range, e.g., Jan-Jun 2024] - [Description: shipping, high confidence]
- **H2 (Next)**: [Date range, e.g., Jul-Dec 2024] - [Description: planning/development, medium confidence]
- **H3 (Later)**: [Date range, e.g., Jan-Jun 2025+] - [Description: exploration/research, lower confidence]

**Resource Constraints:**
- **Budget**: $[X] total available
- **People**: [Y engineers, Z designers, etc. - specify capacity by function]
- **Time**: [Key deadlines: board meeting, fiscal year end, competitive launch, etc.]

**Portfolio Balance Targets:**
- **By Risk**: [Example: 70% core / 20% adjacent / 10% transformational]
- **By Horizon**: [Example: 50% H1 / 30% H2 / 20% H3]
- **By Type**: [Example: 60% product features / 30% platform / 10% R&D]

**Success Metrics:**
[How will we measure portfolio success? Example: "GMV growth rate, seller retention, buyer NPS"]

---

### 2. Bet Inventory

**Total Bets**: [Count across all horizons]

**Effort Distribution**:
- Small (1-2 weeks): [Count]
- Medium (1-3 months): [Count]
- Large (3-6 months): [Count]
- X-Large (6-12+ months): [Count]

**Impact Distribution**:
- 1x (Incremental): [Count]
- 3x (Substantial): [Count]
- 10x (Breakthrough): [Count]

**Type Distribution**:
- Core (optimize existing): [Count, %]
- Adjacent (extend to new): [Count, %]
- Transformational (new paradigm): [Count, %]

---

### 3-5. Horizons (H1/H2/H3)

For each horizon, fill out:

**Theme for H[X]**: [Focus for this horizon]
**Capacity Available**: [Person-months by function]

**Bets**: Use [Bet Template](#bet-template) below for each bet

**Summary**:
- Total Bets: [Count]
- Total Effort: [Sum] vs Capacity: [X] ✓ or ⚠
- Expected Impact: [All succeed vs risk-adjusted]
- Dependencies: [Critical path or blockers]

---

### 6. Portfolio Balance Summary

**Risk Distribution:**
| Type | Count | % of Bets | % of Effort |
|------|-------|-----------|-------------|
| Core | [X] | [Y%] | [Z%] |
| Adjacent | [X] | [Y%] | [Z%] |
| Transformational | [X] | [Y%] | [Z%] |
| **Total** | [Sum] | 100% | 100% |

**Target**: [e.g., 70% core / 20% adjacent / 10% transformational]
**Assessment**: ✓ Balanced / ⚠ Too conservative / ⚠ Too aggressive

**Horizon Distribution:**
| Horizon | Count | % of Bets | % of Effort |
|---------|-------|-----------|-------------|
| H1 (Now) | [X] | [Y%] | [Z%] |
| H2 (Next) | [X] | [Y%] | [Z%] |
| H3 (Later) | [X] | [Y%] | [Z%] |
| **Total** | [Sum] | 100% | 100% |

**Target**: [e.g., 50% H1 / 30% H2 / 20% H3]
**Assessment**: ✓ Balanced / ⚠ Too short-term / ⚠ Too long-term

**Capacity Feasibility:**
- **H1**: [Total effort] / [Capacity] = [X%] utilization (target: ≤80% for 20% slack)
- **H2**: [Total effort] / [Capacity] = [X%] utilization
- **H3**: [Total effort] / [Capacity] = [X%] utilization (rough estimate)

**Assessment**: ✓ Feasible / ⚠ Overcommitted / ⚠ Underutilized

**Impact Ambition:**
- **Strategic Theme Goal**: [e.g., "3x revenue = $300M"]
- **Portfolio Total Impact (all succeed)**: [Sum of all bet impacts, e.g., "4.5x revenue"]
- **Portfolio Expected Impact (risk-adjusted)**: [Assume 50% success rate, e.g., "2.25x revenue"]

**Assessment**: ✓ Ambitious enough / ⚠ Below goal / ⚠ Unrealistic

---

### 7. Dependencies & Review Plan

**Critical Path**: [Must-have sequence, e.g., "Bet A → Bet B → Bet C"]
**Dependency Map**: [Visual or list of dependencies]
**Risk**: [What if key dependencies fail?]

**Review Cadence**: [Monthly H1, quarterly H2, semi-annual H3]
**Review Criteria**: Exit/scale met? Dependencies on track? Re-scope needed?
**Iteration**: Kill / Pivot / Persevere / Scale framework
**Next Review**: [Date]

---

## Bet Template

Copy this for each bet:

```markdown
### Bet [Horizon]-[Number]: [Bet Name]

**Owner**: [Name/team]
**Type**: [Core / Adjacent / Transformational]
**Effort**: [S/M/L/XL] - [Estimate]
**Impact**: [1x/3x/10x] - [Metric]
**Dependencies**: [Prerequisites]
**Rationale**: [Why this? Why now?]
**Exit Criteria**: [Kill if...]
**Scale Criteria**: [Double-down if...]
**Status**: [Not Started / In Progress / Shipped / Exited]
```

---

## Guidance for Each Section

### Portfolio Context
- **Theme**: Specific, measurable, time-bound (e.g., "Grow revenue 3x in 18mo")
- **Horizons**: H1 >80% confidence, H2 ~60%, H3 ~40%
- **Constraints**: Realistic capacity, account for unknowns

### Sizing Bets
**Effort**: S (1-2wk), M (1-3mo), L (3-6mo), XL (6-12+mo)
**Impact**: 1x (10-50% lift), 3x (2-5x lift), 10x (breakthrough)

### Exit & Scale Criteria
**Exit**: Time ("90 days"), Metric ("<5%"), Cost (">$100K"), Strategic ("market shifts")
**Scale**: Adoption (">20%"), Engagement (">3x"), Revenue (">$100K"), Efficiency ("LTV/CAC >5")

**Example**: Bet: Premium tier | Exit: <1000 signups in 90d OR churn >20% | Scale: >5000 signups AND churn <5%

### Dependencies
Types: Technical, Learning, Strategic, Resource
Document clearly: "Depends on Bet H1-2 (payment API) by March"

### Portfolio Balance
**Risk**: 70% Core / 20% Adjacent / 10% Transformational (adjust: Startup 50/30/20, Enterprise 80/15/5)
**Horizon**: ~50-60% H1, ~25-30% H2, ~15-20% H3

---

## Quick Patterns

### Product Portfolio (Features)
```
H1: 5 quick wins (S/M bets) + 2 strategic features (L bets)
H2: 3 major features (L bets) + 1 platform upgrade (XL)
H3: 1-2 exploratory bets (L/XL)
Balance: 60% incremental, 30% substantial, 10% breakthrough
```

### Technology Portfolio (Platform)
```
H1: Stability & performance (4 M bets) + 1 migration start (L)
H2: Complete migration (L) + 2 platform improvements (M)
H3: Next-gen architecture research (XL)
Balance: 50% maintain, 30% improve, 20% transform
```

### Innovation Portfolio (R&D)
```
H1: Scale 2 validated experiments (M) + Run 3 new tests (S)
H2: 2 strategic bets (L) + 4 experiments (S)
H3: 2 moonshots (XL)
Balance: 70% core business, 20% adjacent, 10% transformational
```

### Marketing Portfolio (Campaigns)
```
H1: Optimize 3 proven channels (M) + Test 2 new channels (S)
H2: Scale winners (M/L) + Brand campaign (L)
H3: New positioning & market entry (L)
Balance: 70% performance, 20% growth tests, 10% brand
```

---

## Quality Checklist

Before finalizing your portfolio roadmap, verify:

**Portfolio Context**:
- [ ] Strategic theme is specific and measurable (includes target number + timeline)
- [ ] Time horizons clearly defined with date ranges
- [ ] Resource constraints realistic (budget, people, time)
- [ ] Portfolio balance targets explicit (risk mix, horizon mix)

**Bets**:
- [ ] Each bet has owner, type, effort, impact, dependencies
- [ ] Effort sized as S/M/L/XL with rough estimates
- [ ] Impact quantified (1x/3x/10x) with metric examples
- [ ] Exit criteria defined (metric + timeline to kill)
- [ ] Scale criteria defined (metric + timeline to double-down)
- [ ] Rationale explains why this bet, why now, why this horizon

**Sequencing**:
- [ ] Dependencies mapped (technical, learning, strategic, resource)
- [ ] Critical path identified
- [ ] Bets assigned to H1/H2/H3 with rationale
- [ ] No circular dependencies

**Balance**:
- [ ] Risk distribution checked (core/adjacent/transformational)
- [ ] Horizon distribution checked (H1/H2/H3)
- [ ] Capacity feasibility validated (effort ≤ capacity × 0.8)
- [ ] Impact ambition validated (portfolio total ≥ strategic goal with risk adjustment)

**Review Plan**:
- [ ] Review cadence defined (monthly, quarterly)
- [ ] Review criteria specified (what to check)
- [ ] Iteration process clear (kill/scale/pivot/add)
- [ ] Next review date set

**Overall**:
- [ ] Portfolio ladders up to strategic theme
- [ ] No overcommitment (realistic about capacity)
- [ ] No under-ambition (portfolio impact < strategic goal)
- [ ] Stakeholders aligned on priorities and trade-offs
