# Reviews, Retros & Reflection Template

## Workflow

Copy this checklist and track your progress:

```
Retrospective Progress:
- [ ] Step 1: Set the stage
- [ ] Step 2: Gather data
- [ ] Step 3: Generate insights
- [ ] Step 4: Decide actions
- [ ] Step 5: Close retrospective
```

**Step 1: Set the stage**

Define period, review previous actions, state Prime Directive. See [Setting the Stage](#setting-the-stage).

**Step 2: Gather data**

Collect metrics, events, feedback using chosen format. See [Format Templates](#format-templates).

**Step 3: Generate insights**

Identify patterns, root causes, surprises. See [Insight Generation](#generating-insights).

**Step 4: Decide actions**

Vote and prioritize, create SMART actions. See [Action Planning](#action-planning).

**Step 5: Close**

Commit, schedule follow-up, appreciate. See [Closing](#closing-the-retrospective).

---

## Retrospective Template

### Setting the Stage

**Period**: [Sprint 47 / Q3 2024 / Project Alpha / Week of Nov 11-15]

**Duration**: [Start time - End time, e.g., 2:00-3:30 PM]

**Participants**: [Names and roles]

**Facilitator**: [Name]

**Prime Directive**:
"Regardless of what we discover, we understand and truly believe that everyone did the best job they could, given what they knew at the time, their skills and abilities, the resources available, and the situation at hand."

**Previous Action Items** (from last retro):

| Action | Owner | Status | Notes |
|--------|-------|--------|-------|
| [Previous action 1] | [Name] | ✓ Done / ⚠ In Progress / ✗ Not Done | [Update] |
| [Previous action 2] | [Name] | [Status] | [Update] |

**Completion rate**: [X/Y completed = Z%]

---

### Format Templates

**Choose one format below based on context:**

#### Option 1: Start/Stop/Continue

**What should we START doing?**
- [Item 1]: [Why this would help]
- [Item 2]: [Why this would help]

**What should we STOP doing?**
- [Item 1]: [Why this isn't working]
- [Item 2]: [Why this isn't working]

**What should we CONTINUE doing?**
- [Item 1]: [Why this is working well]
- [Item 2]: [Why this is working well]

#### Option 2: Mad/Sad/Glad

**What made you MAD?** (frustrated, angry)
- [Item 1]: [What happened, impact]
- [Item 2]: [What happened, impact]

**What made you SAD?** (disappointed)
- [Item 1]: [What happened, impact]
- [Item 2]: [What happened, impact]

**What made you GLAD?** (happy, satisfied)
- [Item 1]: [What happened, impact]
- [Item 2]: [What happened, impact]

#### Option 3: 4Ls

**What did we LOVE?**
- [Item 1]: [What worked exceptionally well]
- [Item 2]

**What did we LEARN?**
- [Item 1]: [New insight or skill gained]
- [Item 2]

**What did we LACK?**
- [Item 1]: [Missing resource, skill, or support]
- [Item 2]

**What did we LONG FOR?**
- [Item 1]: [What we wish we had]
- [Item 2]

#### Option 4: Sailboat/Speedboat

**🌬️ WIND** (What's helping us move forward?)
- [Item 1]: [Accelerator, enabler]
- [Item 2]

**⚓ ANCHOR** (What's slowing us down?)
- [Item 1]: [Blocker, drag]
- [Item 2]

**🪨 ROCKS** (What risks lie ahead?)
- [Item 1]: [Upcoming risk or danger]
- [Item 2]

**🏝️ ISLAND** (Where are we heading?)
- [Goal/vision we're working toward]

#### Option 5: Timeline

**Timeline of events**:

```
Week 1          Week 2          Week 3          Week 4
  |               |               |               |
  📈 High         📉 Low          📈 High         📊 Medium

Key events:
- [Date]: [Event 1 - why it was a high/low]
- [Date]: [Event 2]
- [Date]: [Event 3]
```

**Patterns observed**:
- [Pattern 1]: [What we noticed across the timeline]
- [Pattern 2]

---

### Generating Insights

**Themes and patterns** (group similar items):

**Theme 1: [Name, e.g., "Communication gaps"]**
- Related items: [Item A, Item B, Item C]
- Root cause: [Why is this happening? Use 5 Whys if needed]
- Impact: [How is this affecting team/product/customers?]

**Theme 2: [Name]**
- Related items: [...]
- Root cause: [...]
- Impact: [...]

**Surprises** (unexpected discoveries):
- [Surprise 1]: [What we didn't expect to learn]
- [Surprise 2]

**Wins to celebrate** (recognize successes):
- [Win 1]: [What went well, who contributed]
- [Win 2]

---

### Action Planning

**Potential actions** (brainstorm):

| Action | Impact (H/M/L) | Effort (H/M/L) | Votes |
|--------|----------------|----------------|-------|
| [Action 1] | H | L | 🟢🟢🟢🟢🟢 (5) |
| [Action 2] | H | M | 🟢🟢🟢 (3) |
| [Action 3] | M | L | 🟢🟢 (2) |
| [Action 4] | L | H | 🟢 (1) |

**Selected Actions** (Top 1-3, SMART format):

**Action 1**: [Specific action using active verb]
- **Measurable**: [How we'll know it's done / success metric]
- **Assigned**: [Owner name]
- **Realistic**: [Why this is achievable]
- **Time-bound**: [Deadline or milestone]

**Action 2**: [Action]
- **Measurable**: [...]
- **Assigned**: [...]
- **Realistic**: [...]
- **Time-bound**: [...]

**Action 3**: [Action]
- **Measurable**: [...]
- **Assigned**: [...]
- **Realistic**: [...]
- **Time-bound**: [...]

---

### Closing the Retrospective

**Commitment**:
- [ ] Team commits to actions above
- [ ] Owners accept responsibility
- [ ] Follow-up scheduled: [Date/time]

**Retrospective feedback** (improve the retro itself):
- **What worked**: [What to keep in next retro]
- **What to improve**: [How to make next retro better]

**Appreciation** (recognize contributions):
- **Shoutouts**: [Thank specific people for specific contributions]

**Next retrospective**: [Date/time]

---

## Format Selection Guidance

### When to Use Each Format

**Start/Stop/Continue** → General purpose, balanced feedback, action-oriented
- ✓ Regular sprint retros
- ✓ New teams establishing practices
- ✓ Time-constrained (30 min)
- ❌ Avoid if need emotional processing or deep reflection

**Mad/Sad/Glad** → Emotion processing, team health, morale
- ✓ After difficult period (crunch, conflict, failure)
- ✓ Team experiencing low morale
- ✓ Surface hidden frustrations
- ❌ Avoid if already good team dynamics (can create negativity)

**4Ls** → Comprehensive, learning-focused, depth
- ✓ End of major project/phase
- ✓ Quarterly/annual reviews
- ✓ Want thorough reflection
- ❌ Avoid for regular sprints (too heavy)

**Sailboat** → Visual, strategic, cross-functional
- ✓ Product/strategy planning
- ✓ Teams unfamiliar with retros
- ✓ Distributed teams (visual aids async participation)
- ❌ Avoid for tactical process issues

**Timeline** → Complex period, shared understanding
- ✓ Long period (quarter, multi-month project)
- ✓ Many events, unclear chronology
- ✓ New team members joining (catch them up)
- ❌ Avoid for short sprints (overkill)

---

## Action Quality Checklist

**SMART Criteria** (all actions must meet):
- [ ] **Specific**: Clear verb, what exactly will be done
- [ ] **Measurable**: Can verify completion objectively
- [ ] **Assigned**: Named owner (not "team" or "we")
- [ ] **Realistic**: Achievable with current resources/skills
- [ ] **Time-bound**: Explicit deadline or milestone

**Good vs Bad Actions**:

❌ **Bad**: "Improve communication"
- Not specific (what communication?)
- Not measurable (how measure improvement?)
- No owner or deadline

✓ **Good**: "Sarah creates #eng-updates Slack channel and posts daily standup summary by 10 AM starting Monday Nov 18"
- Specific: Create channel, post summary
- Measurable: Channel exists, daily post by 10 AM
- Assigned: Sarah
- Realistic: <15 min/day, uses existing tools
- Time-bound: Starting Nov 18

**Additional Quality Checks**:
- [ ] Addresses root cause (not just symptom)
- [ ] Team has authority to implement (not dependent on external approval)
- [ ] Concrete first step defined (not just goal)
- [ ] Success criteria clear (binary done/not done or numeric threshold)
- [ ] Owner committed and present (not absent team member)

---

## Facilitation Tips

**Setting the Stage** (5-10 min): Read Prime Directive aloud, review previous actions (celebrate completions, decide on incompletes)

**Gathering Data** (15-20 min): Silent writing (5 min) → Share round-robin (10-15 min) → Cluster similar items

**Generating Insights** (15-20 min): Dot voting for focus (5 min) → Discuss top items with 5 Whys (10-15 min)

**Deciding Actions** (10-15 min): Brainstorm solutions (5 min) → Vote and prioritize (5-10 min) → Make SMART, get owner commitment

**Closing** (5 min): Confirm actions, appreciate contributions, retro the retro

---

## Common Patterns by Team Type

**Software Engineering Team**:
- **Frequency**: Every 2-week sprint
- **Format**: Start/Stop/Continue
- **Common themes**: Code quality, technical debt, deployment process, pairing/collaboration
- **Action examples**: Adopt linter rule, schedule refactoring day, improve CI/CD pipeline

**Product Team**:
- **Frequency**: After each release or monthly
- **Format**: 4Ls or Sailboat
- **Common themes**: User feedback, roadmap clarity, stakeholder communication, scope creep
- **Action examples**: User interview cadence, stakeholder update format, prioritization framework

**Marketing/Growth Team**:
- **Frequency**: Weekly or bi-weekly
- **Format**: Wins/Blockers/Priorities (custom)
- **Common themes**: Campaign performance, cross-functional dependencies, experiment velocity
- **Action examples**: A/B test process, creative review workflow, metrics dashboard

**Leadership/Executive Team**:
- **Frequency**: Quarterly
- **Format**: Timeline + 4Ls
- **Common themes**: Strategic alignment, resource allocation, organizational health, market changes
- **Action examples**: OKR calibration, communication forums, talent strategy

---

## Quality Checklist

### Before the Retro
- [ ] Scheduled with sufficient notice (≥3 days)
- [ ] Participants know format and expectations
- [ ] Previous action items reviewed
- [ ] Metrics/data gathered if relevant

### During the Retro
- [ ] Prime Directive stated upfront
- [ ] All voices heard (facilitation balanced participation)
- [ ] Time-boxed (started and ended on schedule)
- [ ] Discussion stayed blameless and constructive
- [ ] Actions are SMART (specific, measurable, assigned, realistic, time-bound)
- [ ] 1-3 actions maximum (not overwhelming)

### After the Retro
- [ ] Actions documented and shared with team
- [ ] Owners confirmed and committed
- [ ] Follow-up scheduled (date in calendar)
- [ ] Next retro scheduled
- [ ] Completion tracked (>80% target before next retro)
