# Email Templates

This resource provides templates and examples for scientific email communication.

---

## Subject Lines

### Formula Patterns

| Type | Formula | Example |
|------|---------|---------|
| Meeting | "Meeting request: [Topic/Project]" | "Meeting request: RNA-seq collaboration" |
| Question | "Question about [Specific topic]" | "Question about your ChIP-seq protocol" |
| Follow-up | "Follow-up: [Original topic]" | "Follow-up: Manuscript draft" |
| Submission | "Submission: [Title]" | "Submission: Novel inhibitors of kinase X" |
| Introduction | "Introduction: [Your name] - [Context]" | "Introduction: Jane Smith - Stanford postdoc" |
| Update | "[Project]: [Status/Update type]" | "Collaboration project: Preliminary results" |
| Request | "Request: [What you need]" | "Request: Letter of recommendation" |
| Urgent | "[URGENT] [Topic] - [Deadline]" | "[URGENT] Grant submission - Nov 15 deadline" |

### Good vs. Bad Subject Lines

| Bad | Good | Why |
|-----|------|-----|
| "Quick question" | "Question about Figure 3 data analysis" | Specific, searchable |
| "Hi" | "Meeting request: Collaboration discussion" | Informative |
| "Important" | "[ACTION NEEDED] Review draft by Friday" | Clear action, deadline |
| "Following up" | "Follow-up: Reagent sharing request" | Context preserved |
| "Paper" | "Submission: Novel CRISPR method - Nature Methods" | Complete information |

---

## Openings

### Context-Setting Openers

**First contact (you don't know them):**
```
I am [Name], a [position] at [Institution] working on [research area].
I am reaching out because [specific reason - their work, mutual contact, etc.].
```

**Follow-up (they should remember you):**
```
I hope this finds you well. I wanted to follow up on [previous topic/meeting].
```

**Known contact (warm relationship):**
```
I hope you're well. I'm writing about [topic].
```

**Response to their email:**
```
Thank you for your email regarding [topic]. [Direct response to their point]
```

**Submission/formal:**
```
Please find attached [document] for your consideration.
```

### Avoid These Openers

- ❌ "I hope this email finds you well" (to strangers - feels formulaic)
- ❌ "Sorry to bother you, but..." (undermines your message)
- ❌ "I know you're busy, but..." (everyone is busy)
- ❌ No context at all (assumes they remember you)

---

## Closings

### Sign-offs by Formality

**Formal (editors, unknown senior faculty):**
- "Sincerely,"
- "Respectfully,"
- "Best regards,"

**Professional (colleagues, known contacts):**
- "Best regards,"
- "Best,"
- "Kind regards,"

**Warm (close colleagues, collaborators):**
- "Best,"
- "Thanks,"
- "Cheers,"

**After a request:**
- "Thank you for your consideration,"
- "Thank you in advance for your help,"
- "I appreciate your time,"

### Closing Patterns

**Standard close:**
```
Thank you for your time. Please let me know if you have any questions.

Best regards,
[Name]
```

**After making a request:**
```
Thank you for considering this request. I'm happy to provide any additional
information needed.

Best,
[Name]
```

**After providing information:**
```
I hope this is helpful. Please don't hesitate to reach out if you need
anything further.

Best,
[Name]
```

**Suggesting next steps:**
```
Would you be available for a brief call next week to discuss further?
I'm flexible on timing.

Thanks,
[Name]
```

---

## Response to Reviewers Template

### Header

```markdown
Response to Reviewers

Manuscript ID: [ID]
Manuscript Title: [Title]
Authors: [Author list]

Dear Dr. [Editor],

Thank you for the opportunity to revise our manuscript. We appreciate the
constructive feedback from the reviewers and have carefully addressed each
comment. Below, we provide detailed point-by-point responses.

**Formatting guide:**
- Reviewer comments are in **bold italic**
- Our responses are in plain text
- New or modified text in the manuscript is indicated in [brackets]
- Page and line numbers refer to the revised manuscript

---
```

### Response Format

```markdown
## REVIEWER 1

***Major Comments***

***1. [Quote the reviewer's comment exactly or paraphrase accurately]***

Thank you for raising this important point. [Your response addressing the
concern]. We have [specific action taken].

**Changes made:** [Describe changes with page/line numbers]
- Page X, lines Y-Z: "[Quote new text]"
- New Figure X has been added showing [description]

---

***2. [Next comment]***

We appreciate this suggestion. [Response]

**Changes made:** [Description]

---

***Minor Comments***

***1. [Minor comment]***

Done. [Brief response if needed]

**Changes made:** Page X, line Y.

---

## REVIEWER 2

[Same format]

---

## Summary of Changes

- Added new analysis addressing Reviewer 1, Comment 3
- Revised Discussion section to address Reviewer 2's concerns about interpretation
- Corrected typographical errors noted by both reviewers
- Updated Figure 2 for clarity

We hope these revisions address the reviewers' concerns. We thank them again
for their thoughtful feedback, which has substantially improved the manuscript.

Sincerely,
[Corresponding Author]
```

### Response Language

**Agreeing and making changes:**
- "We agree and have revised accordingly."
- "Thank you for this excellent suggestion. We have..."
- "This point is well-taken. We have clarified by..."

**Respectfully disagreeing:**
- "We appreciate this perspective. However, we respectfully maintain our interpretation because..."
- "While we understand this concern, our data support [X] for the following reasons..."
- "We have added clarification to address this point, while maintaining our original conclusion because..."

**Explaining without changing:**
- "We understand this concern. However, we believe the current presentation is appropriate because..."
- "We appreciate this suggestion but respectfully decline to make this change because..."
- "We have added clarification to the text rather than removing this section because..."

---

## Cold Email Template

### For Potential Collaborator

```markdown
Subject: Collaboration opportunity: [Specific topic]

Dear Dr. [Name],

I am [Your name], a [position] at [Institution] working on [your research focus].
I recently read your paper on [specific paper] and was impressed by [specific aspect].

I am reaching out because I think there may be an opportunity for collaboration.
My lab has developed [your capability/resource], which could complement your work
on [their work]. Specifically, I'm wondering if you might be interested in [concrete
proposal].

Would you be open to a brief call to discuss whether this makes sense? I'm happy
to share more details about our work and hear about your current directions.

Thank you for considering this. I look forward to potentially connecting.

Best regards,
[Your name]
[Your position]
[Your institution]
[Your email]
```

### For Informational Interview

```markdown
Subject: Request for advice: [Specific topic]

Dear Dr. [Name],

I am [Your name], a [position] at [Institution]. I am writing to ask if you might
have 20-30 minutes to share your perspective on [specific topic].

[Brief context: why you're asking, what you're trying to learn]

I've [done your homework: read their papers, looked at their trajectory, etc.],
and I particularly appreciated [specific thing]. Your experience with [specific
aspect] would be especially valuable for [your situation].

I would be grateful for any time you could spare. I'm flexible on timing and
happy to arrange whatever is most convenient for you.

Thank you for considering this request.

Best regards,
[Your name]
```
