# Methodology

This resource supports the Scientific Manuscript Review skill with detailed review methods.

---

## Core Message Extraction

### Why This Matters

Every manuscript should have ONE central message readers remember. Without identifying this, editing becomes unfocused and the manuscript lacks coherence.

### What to Do

**Ask the author (or yourself):**
- "If readers remember only one thing, what should it be?"
- "What is the single most important finding?"
- "How would you summarize this in one tweet?"

**Format the core message:**
```
[Subject/System] + [Key finding/contribution] + [Significance/Implication]
```

**Example:**
"This study shows that CRISPR-Cas9 editing of gene X restores protein function in patient cells, suggesting a potential therapeutic strategy for disease Y."

**Use the core message to:**
- Evaluate if Introduction builds to it
- Check if Results support it
- Verify Discussion interprets around it
- Ensure Abstract leads with it

---

## Structural Assessment

### Why This Matters

Structure determines reader comprehension. Poor organization loses readers even when science is excellent.

### What to Do

**Map the existing structure:**
1. List all section headings
2. Summarize each section in one sentence
3. Draw dependency arrows (what relies on what)
4. Identify logical gaps

**Evaluate against standard patterns:**

**Research Article (IMRaD):**
```
Introduction: Why this problem matters, what's the gap, what's our hypothesis
Methods: How we did it (reproducible detail)
Results: What we found (data + interpretation)
Discussion: What it means in context
```

**Review Article:**
```
Introduction: Scope and importance of topic
Body sections: Organized by theme/chronology/controversy
Synthesis: What we know, don't know, future directions
```

**Check for:**
- [ ] Each section has a clear purpose
- [ ] Sections appear in logical order
- [ ] Transitions between sections are clear
- [ ] No major gaps in logic
- [ ] No redundancy between sections

---

## Discussion Structure

### Why This Matters

The Discussion is where meaning is made. Poor discussions either repeat results or overclaim.

### What to Do

**Standard Discussion Flow:**

**Paragraph 1: Main Finding**
- Restate central finding (not verbatim from Results)
- State whether hypothesis was supported/refuted
- Brief statement of significance

**Paragraph 2-3: Interpretation**
- What does this finding mean mechanistically?
- How does it advance understanding?
- What new questions does it raise?

**Paragraph 4: Literature Context**
- How does this compare to prior work?
- Agreements and disagreements
- Why might disagreements exist?

**Paragraph 5: Limitations**
- What are the caveats?
- What can't we conclude from this data?
- What would strengthen the conclusions?

**Paragraph 6: Future Directions**
- What experiments come next?
- What questions remain?
- Broader implications

**Red flags to fix:**
- Discussion that just repeats Results → Add interpretation
- No limitations section → Add honest assessment
- Unmarked speculation → Add "we speculate that..." or "one possibility is..."
- No connection to literature → Add comparison paragraphs

---

## Language Guidelines

### Why This Matters

Scientific writing has conventions. Violating them signals inexperience; following them aids clarity.

### What to Do

**Voice Selection:**

| Situation | Recommended | Example |
|-----------|-------------|---------|
| Methods (routine steps) | Passive | "Cells were incubated..." |
| Results (your contribution) | Active | "We found that..." |
| Discussion (interpretation) | Active | "Our data suggest..." |
| Describing others' work | Active | "Smith et al. showed..." |

**Hedging Calibration:**

| Evidence Strength | Hedge Level | Words |
|-------------------|-------------|-------|
| Strong direct evidence | Minimal | demonstrates, shows, establishes |
| Good indirect evidence | Moderate | suggests, indicates, supports |
| Limited evidence | Significant | may, might, could |
| Speculation | High | conceivably, potentially, one possibility |

**Quantification Standards:**
- ❌ "Expression increased" → ✅ "Expression increased 3.2-fold (p<0.01)"
- ❌ "Several patients improved" → ✅ "7 of 12 patients (58%) improved"
- ❌ "The difference was significant" → ✅ "The difference was significant (p=0.003, n=24)"

**Terminology Rules:**
1. Define abbreviations on first use
2. Use the same term consistently (pick one: "patients" OR "subjects")
3. Use field-standard terms (don't invent new jargon)
4. Spell out numbers under 10 in text, use numerals for measurements
