# Socratic Teaching Session Template

## Workflow

Copy this checklist and track your progress:

```
Teaching Session Progress:
- [ ] Step 1: Diagnose current understanding
- [ ] Step 2: Build question ladder
- [ ] Step 3: Execute teaching session
- [ ] Step 4: Fade scaffolding
- [ ] Step 5: Validate understanding
```

**Step 1: Diagnose current understanding** - Ask probing questions to assess baseline knowledge and misconceptions. See [Section 1](#1-diagnostic-phase).

**Step 2: Build question ladder** - Design progression from current to target understanding. See [Section 2](#2-question-ladder-design).

**Step 3: Execute teaching session** - Guide discovery through questions and scaffolding. See [Section 3](#3-teaching-session-structure).

**Step 4: Fade scaffolding** - Progressively remove support as competence grows. See [Section 4](#4-scaffolding-fading-protocol).

**Step 5: Validate understanding** - Test transfer and misconception elimination. See [Section 5](#5-validation--assessment).

---

## 1. Diagnostic Phase

### Learning Profile

**Learner Information:**
- **Name/Role**: [Who is learning]
- **Goal**: [What they want to achieve]
- **Timeline**: [When they need to know it]
- **Current Experience**: [Novice / Beginner / Intermediate / Advanced in this domain]

**Topic to Teach:**
- **Concept/Skill**: [Specific topic]
- **Why Important**: [Motivation, application context]
- **Success Criteria**: [How will we know they've learned it?]

### Diagnostic Questions

Ask 3-5 questions to assess current understanding:

1. **Clarifying**: "What do you already know about [topic]?"
2. **Probing**: "Can you give me an example of [related concept]?"
3. **Assumption**: "What do you think [key term] means?"
4. **Application**: "How would you approach [simple problem]?"
5. **Misconception Check**: "[Question that reveals common misconception]"

**Identified Knowledge Gaps:**
- [ ] Gap 1: [What they don't know yet]
- [ ] Gap 2: [What they don't know yet]
- [ ] Gap 3: [What they don't know yet]

**Identified Misconceptions:**
- [ ] Misconception 1: [Faulty mental model detected]
- [ ] Misconception 2: [Faulty mental model detected]

**Starting Scaffolding Level:** [Full Modeling / Guided Practice / Coached Practice / Independent]

---

## 2. Question Ladder Design

Build progression from current understanding to target concept:

### Concrete Foundation (Step 1-2)

**Analogy/Real-World Example:**
- Anchor concept in familiar experience
- Example: [Concrete situation they already understand]

**Questions:**
1. [Simple question connecting to existing knowledge]
2. [Question exploring the analogy]

### Pattern Recognition (Step 3-4)

**Key Pattern to Notice:**
- What regularities or structures should they see?
- Pattern: [Core insight they should discover]

**Questions:**
3. [Question that guides to pattern]
4. [Question that reinforces pattern with new example]

### Formalization (Step 5-6)

**Technical Vocabulary:**
- Introduce precise terminology once pattern is clear
- Terms: [Key terms to define]

**Questions:**
5. [Question that motivates formal definition]
6. [Question applying formal concept]

### Edge Cases & Boundaries (Step 7-8)

**Limitations to Explore:**
- Where does the concept break down or need qualification?
- Edge cases: [Boundary conditions]

**Questions:**
7. [Question revealing edge case]
8. [Question exploring why edge case matters]

### Transfer & Application (Step 9-10)

**Novel Context:**
- Apply concept to new situation
- Context: [Different domain or problem]

**Questions:**
9. [Question requiring transfer to novel situation]
10. [Question checking deep understanding]

---

## 3. Teaching Session Structure

### Opening (5 minutes)

**State Goal:**
"Today we're going to understand [concept]. By the end, you'll be able to [success criteria]."

**Check Motivation:**
"Why is this important to you?" [Learner answers]

### Main Teaching Loop (30-45 minutes)

For each question in ladder:

**Ask Question:**
- State question clearly
- Give thinking time (30 seconds minimum)
- Don't rush to hint

**Observe Response:**
- **If correct understanding**: Confirm and move to next question
- **If partial understanding**: Ask follow-up to clarify
- **If misconception revealed**: Note it, explore contradiction (see [Misconception Protocol](#misconception-correction-protocol))
- **If stuck**: Provide scaffolding (see [Scaffolding Menu](#scaffolding-menu))

**Scaffold if Needed:**
- Level 5 (Modeling): "Let me show you how I'd think about this..."
- Level 4 (Guided): "What if we try [partial solution]?"
- Level 3 (Coached): "You're close. What about [hint]?"
- Level 2 (Independent): "Take your time. Walk me through your thinking."

**Check Understanding:**
- "Can you explain that in your own words?"
- "How does that connect to [earlier concept]?"

### Closing (10 minutes)

**Summary:**
"Let's review what we covered: [key points]"

**Transfer Task:**
"Now try [novel problem using concept]"

**Next Steps:**
"To solidify this, [practice recommendation]"

---

## 4. Scaffolding Fading Protocol

Track scaffolding level for each concept:

| Concept/Skill | Initial Level | Current Level | Target: Independent |
|---------------|---------------|---------------|---------------------|
| [Concept 1]   | Level 5       | Level 4       | [ ] Ready           |
| [Concept 2]   | Level 4       | Level 3       | [ ] Ready           |
| [Concept 3]   | Level 3       | Level 2       | [ ] Ready           |

**Fading Triggers:**
- **Success Signal**: Learner completes task correctly → Move down one level
- **Struggle Signal**: Learner stuck for >2 minutes → Move up one level
- **Frustration Signal**: Repeated failure or negative emotion → Provide direct explanation, restart with higher level

**Progressive Independence:**
1. Start: Full worked example with narration
2. Next: Partial example, learner completes
3. Next: Learner attempts, teacher provides hints
4. Next: Learner attempts, teacher reviews after
5. End: Learner explains concept to someone else

---

## 5. Validation & Assessment

### Understanding Checks

**Explanation Test:**
- "Explain [concept] to me like I'm [5 years old / your colleague / an expert]"
- Quality: Clear, accurate, appropriate detail for audience

**Application Test:**
- "Use [concept] to solve [novel problem]"
- Quality: Correct application, adapts to new context

**Teaching Test:**
- "How would you teach this to someone else?"
- Quality: Can identify key questions, common misconceptions

### Misconception Elimination

Check that identified misconceptions are corrected:

- [ ] Misconception 1: **Eliminated?** [Test question] → [Response shows correction]
- [ ] Misconception 2: **Eliminated?** [Test question] → [Response shows correction]

**If misconception persists:**
- Design new question sequence targeting it specifically
- See [resources/methodology.md](../methodology.md) for advanced misconception busting

### Transfer Assessment

**Near Transfer** (same domain, different problem):
- Problem: [Similar but not identical]
- Success: [ ] Solved correctly without hints

**Far Transfer** (different domain, analogous structure):
- Problem: [Different context, same underlying principle]
- Success: [ ] Recognized analogous structure and applied concept

---

## Scaffolding Menu

Quick reference for providing appropriate support:

**Level 5: Full Modeling**
- "Let me show you a complete example..."
- "Here's how I would think through this step-by-step..."
- "Watch how I approach [problem], then you'll try a similar one"

**Level 4: Guided Practice**
- "I'll start, and you complete the next steps..."
- "Here's the first part [show partial solution]. Can you finish?"
- "Let's do this together. I'll guide you through each step."

**Level 3: Coached Practice**
- "Give it a try. I'll ask questions if you get stuck."
- "You're on the right track. What about [specific aspect]?"
- "Almost. Think about what would happen if [scenario]?"

**Level 2: Independent with Feedback**
- "Try it yourself first. We'll review together afterwards."
- "Take your time. Come back when you have a solution."
- "Work through this, then explain your reasoning."

**Level 1: Transfer**
- "Now teach this to [someone else]."
- "Create your own example problem."
- "Explain why someone might misunderstand this."

---

## Misconception Correction Protocol

When misconception is revealed:

**Step 1: Acknowledge Without Judgment**
- "Interesting! Many people think that."
- "That's a really common way to think about it."

**Step 2: Predict Outcome Based on Misconception**
- "If [misconception] were true, what would we expect to see in [test case]?"
- Get learner to make explicit prediction

**Step 3: Show Contradiction**
- Demonstrate or explain actual outcome
- "But actually, [show real result]. Why do you think that is?"

**Step 4: Guide to Correct Model**
- Ask questions that lead to correct understanding
- "What could explain this difference?"
- Don't just state correct answer—guide discovery

**Step 5: Reinforce with New Examples**
- Apply corrected understanding to 2-3 new cases
- "Let's test this new understanding. What about [example]?"

**Step 6: Check Persistence**
- Return to misconception trigger later in session
- Ensure correction stuck, not just surface compliance

---

## Common Teaching Patterns

**Pattern: Concrete → Abstract (Feynman Technique)**

1. **Level 1 (Child)**: Simple analogy, no jargon
   - "Think of it like [everyday object/experience]..."

2. **Level 2 (High School)**: Introduce some formality
   - "More precisely, it's when [definition with some technical terms]..."

3. **Level 3 (Undergraduate)**: Full technical definition
   - "Formally, [concept] is defined as [precise definition with terminology]..."

4. **Level 4 (Graduate)**: Edge cases, formal proofs
   - "Under these conditions [constraints], we can prove [property]..."

**Pattern: Problem → Decomposition → Solution**

1. **Present Complex Problem**: Something they can't solve yet
2. **Ask Decomposition Questions**: "What are the sub-problems?"
3. **Solve Simple Sub-Problem**: Build confidence with achievable piece
4. **Compose**: "How do we combine these solutions?"
5. **Generalize**: "What pattern did we use? When else could we apply it?"

**Pattern: Prediction → Observation → Explanation**

1. **Predict**: "What do you think will happen if [scenario]?"
2. **Observe**: [Show actual outcome—contradicts naive prediction]
3. **Explain**: "Why was our prediction wrong? What's really happening?"
4. **Refine Model**: "Let's adjust our understanding to account for this..."

---

## Quality Checklist

Before concluding session, verify:

**Diagnostic:**
- [ ] Asked 3-5 diagnostic questions to assess baseline
- [ ] Identified specific knowledge gaps
- [ ] Detected at least 1 misconception (if present)
- [ ] Determined appropriate starting scaffolding level

**Question Ladder:**
- [ ] Built progression from concrete to abstract (min 8 questions)
- [ ] Each question has clear purpose (not just Socratic theater)
- [ ] Ladder addresses identified gaps and misconceptions
- [ ] Questions build on each other logically

**Teaching Execution:**
- [ ] Started at appropriate scaffolding level (not always Level 5)
- [ ] Faded scaffolding as competence increased
- [ ] Asked questions, didn't just lecture
- [ ] Corrected misconceptions through contradiction, not assertion
- [ ] Adjusted to learner responses (didn't stick rigidly to script)

**Validation:**
- [ ] Tested understanding with novel problem (transfer)
- [ ] Asked for explanation in learner's words
- [ ] Verified misconceptions eliminated
- [ ] Provided next steps for continued learning

**Guardrails:**
- [ ] Stayed in zone of proximal development (optimal challenge)
- [ ] Didn't make it a guessing game
- [ ] Made implicit knowledge explicit
- [ ] Adapted to learner's pace and preferences

**Session Notes:**
- What worked well: [Note effective moments]
- What to adjust: [Note what to improve]
- Follow-up needed: [Topics requiring more work]
