# Strategy & Competitive Analysis Template

## Workflow

Copy this checklist and track your progress:

```
Strategy Template Progress:
- [ ] Step 1: Define strategic question and context
- [ ] Step 2: Conduct competitive analysis
- [ ] Step 3: Apply Good Strategy kernel
- [ ] Step 4: Create action plan
- [ ] Step 5: Validate with quality checklist
```

**Step 1: Define question** - Clarify strategic question, business context, constraints. See [Section 1](#1-strategic-question--context).

**Step 2: Competitive analysis** - Profile competitors, apply Porter's 5 Forces if relevant. See [Section 2](#2-competitive-analysis).

**Step 3: Good Strategy kernel** - Diagnosis, Guiding Policy, Coherent Actions. See [Section 3](#3-strategy-formulation-good-strategy-kernel).

**Step 4: Action plan** - Initiatives, owners, timelines, metrics. See [Section 4](#4-action-plan).

**Step 5: Validate** - Quality checklist before finalizing. See [Quality Checklist](#quality-checklist).

---

## 1. Strategic Question & Context

### Strategic Question

**What strategic decision or question are we addressing?**

[Clear, specific question. Examples: "Should we enter the enterprise market?", "How should we respond to Competitor X's new product?", "What's our 2024 strategy?", "Should we build or buy analytics capabilities?"]

### Business Context

**Company/Product:**
- **Name**: [Your company/product]
- **Industry**: [Industry sector]
- **Stage**: [Startup/Growth/Mature]
- **Current position**: [Market position, revenue range, customer base]

**Strategic Context:**
- **Goal**: [What are we trying to achieve? Growth, profitability, market leadership, survival?]
- **Timeline**: [When does decision need to be made? Implementation timeline?]
- **Constraints**: [Budget, resources, capabilities, regulatory, competitive]
- **Stakeholders**: [Who cares about this decision? CEO, board, investors, customers?]

---

## 2. Competitive Analysis

### Competitive Landscape Overview

**Market Definition:**
- **Market size**: [TAM/SAM/SOM or addressable market estimate]
- **Growth rate**: [Market growth %, trends]
- **Maturity**: [Emerging, Growth, Mature, Declining]
- **Concentration**: [Fragmented or consolidated? Top 3 players' market share?]

### Porter's 5 Forces Analysis

*Use if assessing industry attractiveness or market entry decision. Skip for pure competitive response.*

| Force | Assessment (High/Medium/Low) | Evidence | Strategic Implication |
|-------|------------------------------|----------|----------------------|
| **Competitive Rivalry** | [H/M/L] | [# competitors, growth rate, differentiation, switching costs] | [What this means for profitability] |
| **Threat of New Entrants** | [H/M/L] | [Barriers: capital, brand, tech, regulation, network effects] | [How easy for new players to enter] |
| **Threat of Substitutes** | [H/M/L] | [Alternative solutions, price-performance, switching costs] | [Risk of being replaced by different approach] |
| **Buyer Power** | [H/M/L] | [Buyer concentration, price sensitivity, switching costs] | [Can customers squeeze margins?] |
| **Supplier Power** | [H/M/L] | [Supplier concentration, uniqueness, switching costs] | [Can suppliers squeeze margins?] |

**Overall Industry Attractiveness**: [High/Medium/Low profit potential]

**Key Dynamics**: [2-3 sentences summarizing competitive forces and implications]

### Competitor Profiling

*Profile 3-5 key competitors (direct + most threatening indirect/potential).*

**Competitor 1: [Name]**

| Dimension | Assessment | Notes |
|-----------|------------|-------|
| **Product/Features** | [Brief description] | [Key capabilities, gaps vs us] |
| **Pricing** | [Price points, model] | [Premium/Parity/Discount vs us] |
| **Target Customers** | [Segments] | [Who they serve, overlap with our targets] |
| **Positioning** | [How they position] | [Messaging, brand promise] |
| **Strengths** | [Top 2-3 strengths] | [What they do well] |
| **Weaknesses** | [Top 2-3 weaknesses] | [Vulnerabilities, gaps] |
| **Strategy Inference** | [Their likely strategy] | [Where they're headed, recent moves] |
| **Threat Level** | [High/Medium/Low] | [How much of a threat to us] |

**Competitor 2: [Name]**
[Same structure as Competitor 1]

**Competitor 3: [Name]**
[Same structure as Competitor 1]

**Additional competitors to monitor**: [List with 1-sentence descriptions]

### Competitive Positioning Map

*Create 2x2 map to visualize competitive positioning.*

**Axes:**
- X-axis: [Dimension 1 - e.g., Price: Low → High]
- Y-axis: [Dimension 2 - e.g., Features: Simple → Comprehensive]

**Positioning:**
- **Us**: [Where we sit on map]
- **Competitor 1**: [Position]
- **Competitor 2**: [Position]
- **Competitor 3**: [Position]

**Insight**: [Where is there white space? Where is it crowded? Where should we position?]

### Competitive Advantages (Moats)

**Our current moats:**
- [ ] Network effects: [Yes/No - Description if yes]
- [ ] Switching costs: [Yes/No - Description if yes]
- [ ] Brand: [Yes/No - Description if yes]
- [ ] Cost advantages: [Yes/No - Description if yes]
- [ ] Regulatory/IP: [Yes/No - Description if yes]

**Competitor moats to be aware of**: [Which competitors have what moats]

**Moat to build**: [What sustainable advantage should our strategy create?]

---

## 3. Strategy Formulation (Good Strategy Kernel)

### Diagnosis: What's the Challenge?

**Core challenge we face** (1-3 sentences):

[Describe the fundamental problem or opportunity. Be specific. Not "we need to grow" but "customer acquisition cost has doubled while LTV stayed flat, making current channels unprofitable." Not "market is competitive" but "we're squeezed between low-cost offshore competitors and full-service premium players, lacking differentiation."]

**Supporting analysis:**

| Finding | Evidence | Implication |
|---------|----------|-------------|
| [Key finding 1] | [Data/research supporting this] | [What this means] |
| [Key finding 2] | [Data/research supporting this] | [What this means] |
| [Key finding 3] | [Data/research supporting this] | [What this means] |

**Root cause** (if applicable):

[What's the underlying cause of this challenge? Avoid symptoms. Example: Not "low sales" (symptom) but "product-market fit in wrong segment, high churn" (root cause)]

### Guiding Policy: Overall Approach

**Guiding policy** (1-2 sentences):

[High-level approach to address the diagnosis. Should be directional, not specific actions. Examples: "Vertical specialization in healthcare to create defensible differentiation", "Product-led growth to reduce CAC and improve unit economics", "Platform play to leverage network effects", "Operational excellence to compete on cost"]

**Strategic choice rationale:**

**Why this approach?**
- [Reason 1: Directly addresses diagnosis]
- [Reason 2: Plays to our strengths]
- [Reason 3: Exploits competitor weaknesses or market gaps]

**Why not alternatives?**
- Alternative 1: [Approach we're NOT taking] - Rejected because: [Reason]
- Alternative 2: [Approach we're NOT taking] - Rejected because: [Reason]

**How this creates competitive advantage:**

[Explain why this approach is defensible. Why can't competitors easily copy? What moat does it build?]

### Coherent Actions: Coordinated Steps

**Action 1: [Specific action]**
- **Description**: [What exactly are we doing]
- **How it supports guiding policy**: [Connection to overall approach]
- **How it reinforces other actions**: [Synergies with Actions 2-5]
- **Owner**: [Who is responsible]
- **Timeline**: [When, milestones]
- **Resources required**: [Budget, headcount, tools]

**Action 2: [Specific action]**
- [Same structure as Action 1]

**Action 3: [Specific action]**
- [Same structure as Action 1]

**Action 4: [Specific action]** (if applicable)
- [Same structure as Action 1]

**Action 5: [Specific action]** (if applicable)
- [Same structure as Action 1]

**Coherence check:**
- [ ] All actions support guiding policy
- [ ] Actions reinforce each other (not independent initiatives)
- [ ] No contradictions (e.g., pursuing both cost leadership AND premium positioning)
- [ ] Actions are specific and concrete (not "improve product" but "build HIPAA compliance module")

---

## 4. Action Plan

### Strategic Initiatives

| Initiative | Owner | Timeline | Success Metrics | Resources | Dependencies |
|------------|-------|----------|-----------------|-----------|--------------|
| [Initiative 1 from Actions] | [Name/Team] | [Q1 2024 or specific dates] | [KPI: target value] | [Budget, FTE] | [What must happen first] |
| [Initiative 2] | [Name/Team] | [Timeline] | [Metrics] | [Resources] | [Dependencies] |
| [Initiative 3] | [Name/Team] | [Timeline] | [Metrics] | [Resources] | [Dependencies] |
| [Initiative 4] | [Name/Team] | [Timeline] | [Metrics] | [Resources] | [Dependencies] |
| [Initiative 5] | [Name/Team] | [Timeline] | [Metrics] | [Resources] | [Dependencies] |

### Success Metrics & Targets

**North Star Metric**: [Primary metric indicating strategy is working]
- **Baseline**: [Current value]
- **Target**: [Goal value]
- **Timeline**: [By when]

**Supporting Metrics:**

| Metric | Baseline | 6-Month Target | 12-Month Target | Why This Matters |
|--------|----------|----------------|-----------------|------------------|
| [Metric 1] | [Current] | [Target] | [Target] | [Connection to strategy] |
| [Metric 2] | [Current] | [Target] | [Target] | [Connection to strategy] |
| [Metric 3] | [Current] | [Target] | [Target] | [Connection to strategy] |

### Assumptions & Risks

**Critical Assumptions:**
1. [Assumption 1 - e.g., "Market will grow 20% annually"] - **Validation plan**: [How we'll test this]
2. [Assumption 2] - **Validation plan**: [How we'll test this]
3. [Assumption 3] - **Validation plan**: [How we'll test this]

**Key Risks:**

| Risk | Likelihood (H/M/L) | Impact (H/M/L) | Mitigation | Owner |
|------|-------------------|----------------|------------|-------|
| [Risk 1 - e.g., "Competitor X launches similar feature"] | [H/M/L] | [H/M/L] | [How we prepare/respond] | [Name] |
| [Risk 2] | [H/M/L] | [H/M/L] | [Mitigation] | [Name] |
| [Risk 3] | [H/M/L] | [H/M/L] | [Mitigation] | [Name] |

**Competitive Response Scenarios:**

**If competitors do X**: [Our response plan]

**If market shifts Y**: [Our pivot/adaptation plan]

### Decision Points & Review Cadence

**Go/No-Go Decision Points:**
- [Milestone 1]: [Date] - **Criteria**: [What must be true to continue]
- [Milestone 2]: [Date] - **Criteria**: [What must be true to continue]

**Review Cadence:**
- **Weekly**: [Who meets, what's reviewed - execution progress]
- **Monthly**: [Who meets, what's reviewed - metrics, blockers]
- **Quarterly**: [Who meets, what's reviewed - strategy validation, course correction]

---

## Quality Checklist

Before finalizing, verify:

**Diagnosis:**
- [ ] Diagnosis is specific (not vague like "need to grow")
- [ ] Grounded in evidence (data, customer feedback, competitive analysis)
- [ ] Identifies root challenge (not symptoms)
- [ ] Clear why this is the critical challenge to address

**Guiding Policy:**
- [ ] Directly addresses the diagnosis (not unrelated)
- [ ] High-level approach (not list of actions)
- [ ] Explains how it solves the diagnosed problem
- [ ] Explains why this approach vs alternatives
- [ ] Describes competitive advantage created

**Coherent Actions:**
- [ ] 3-5 specific actions (not vague or generic)
- [ ] All actions support guiding policy
- [ ] Actions reinforce each other (coherent, not scattered)
- [ ] No contradictions between actions
- [ ] Each action has owner, timeline, resources

**Competitive Analysis:**
- [ ] Key competitors identified and profiled
- [ ] Strengths/weaknesses analyzed per competitor
- [ ] Positioning map or competitive landscape clear
- [ ] Competitive moats identified (ours and theirs)
- [ ] Porter's 5 Forces completed (if relevant to question)

**Action Plan:**
- [ ] Initiatives have clear owners and timelines
- [ ] Success metrics defined (baseline + targets)
- [ ] Assumptions stated explicitly
- [ ] Risks identified with mitigations
- [ ] Review cadence and decision points set

**Overall Quality:**
- [ ] Strategy is defensible against competition
- [ ] Evidence-based (not aspirational or wishful thinking)
- [ ] Realistic given constraints (resources, capabilities, time)
- [ ] Internally consistent (no contradictions)
- [ ] Stakeholders will understand and align

**Minimum Standard**: All checklist items should be checkable before delivering strategy document.
