---
name: strategy-and-competitive-analysis
description: Use when developing business strategy (market entry, product launch, geographic expansion, M&A, turnaround), conducting competitive analysis (profiling competitors, assessing competitive threats, Porter's 5 Forces, identifying differentiation), applying strategic frameworks (Good Strategy kernel with diagnosis/guiding policy/coherent actions, SWOT, Blue Ocean Strategy, Playing to Win where-to-play/how-to-win, Value Chain Analysis, BCG Matrix), making strategic decisions under constraints (build vs buy, pricing strategy, market positioning, business model choices), planning strategic initiatives (annual planning, OKRs, roadmaps), evaluating competitive positioning (moats, sustainable advantages, differentiation vs cost leadership), or when user mentions "strategy", "competitive analysis", "Porter's 5 Forces", "SWOT", "market positioning", "strategic planning", "competitive landscape", or "strategic frameworks".
---
# Strategy & Competitive Analysis

## Table of Contents
- [Purpose](#purpose)
- [When to Use](#when-to-use)
- [What Is It](#what-is-it)
- [Workflow](#workflow)
- [Strategic Frameworks Overview](#strategic-frameworks-overview)
- [Competitive Analysis Overview](#competitive-analysis-overview)
- [Common Patterns](#common-patterns)
- [Guardrails](#guardrails)
- [Quick Reference](#quick-reference)

## Purpose

Develop robust strategies grounded in rigorous competitive and market analysis, using proven frameworks to diagnose challenges, formulate guiding policies, and specify coherent actions.

## When to Use

**Business Strategy Development:**
- Market entry strategy (new product, geography, segment)
- Strategic planning (annual plans, 3-year vision, OKRs)
- Strategic decisions (build vs buy, pricing, positioning, business model)
- Growth strategy (organic, M&A, partnerships, platform)

**Competitive Analysis:**
- Competitor profiling (features, pricing, positioning, strengths/weaknesses)
- Threat assessment (new entrants, substitutes, competitive moves)
- Differentiation opportunities (market gaps, uncontested space)
- Industry structure analysis (5 Forces, consolidation, barriers to entry)

**Strategic Frameworks:**
- Need structured approach to complex strategic questions
- Multiple stakeholders requiring alignment on strategy rationale
- High-stakes decisions requiring rigorous analysis
- Teaching/communicating strategy to teams

## What Is It

Strategy & Competitive Analysis applies proven frameworks to make better strategic decisions:

**Good Strategy Kernel** (Rumelt): Diagnosis (what's the challenge) → Guiding Policy (overall approach) → Coherent Actions (specific coordinated steps).

**Competitive Analysis**: Porter's 5 Forces (rivalry, new entrants, substitutes, buyer power, supplier power), competitor profiling (SWOT per competitor), positioning maps, moat assessment.

**Example**: SaaS startup entering crowded market → **Diagnosis**: commoditized features, price competition, high CAC. **Guiding Policy**: vertical specialization (healthcare) + product-led growth. **Coherent Actions**: build HIPAA compliance, create compliance templates, offer free tier, invest in SEO for "healthcare SaaS".

## Workflow

Copy this checklist and track your progress:

```
Strategy & Competitive Analysis Progress:
- [ ] Step 1: Frame strategic question and gather context
- [ ] Step 2: Choose framework(s) based on question type
- [ ] Step 3: Conduct analysis using chosen framework(s)
- [ ] Step 4: Synthesize insights and formulate strategy
- [ ] Step 5: Validate and create action plan
```

**Step 1: Frame strategic question**

Clarify the strategic question, business context (industry, stage, constraints), competitive landscape, and success criteria. See [Common Patterns](#common-patterns) for typical question types.

**Step 2: Choose framework(s)**

For industry/competitive structure → Use Porter's 5 Forces. For positioning → Use Blue Ocean Strategy Canvas or Value Chain Analysis. For overall strategy → Use Good Strategy kernel. For multiple options → Use SWOT per option. See [Strategic Frameworks Overview](#strategic-frameworks-overview) and [resources/methodology.md](resources/methodology.md) for framework selection guidance.

**Step 3: Conduct analysis**

For straightforward competitive analysis → Use [resources/template.md](resources/template.md). For complex multi-framework strategy → Study [resources/methodology.md](resources/methodology.md) for integrated approach. Gather data (competitor research, market analysis, customer insights), apply framework systematically, document findings with evidence.

**Step 4: Synthesize insights**

Apply Good Strategy kernel: **Diagnosis** (core challenge from analysis), **Guiding Policy** (overall approach to address challenge), **Coherent Actions** (3-5 specific coordinated steps). Ensure coherence (actions reinforce each other, support guiding policy, address diagnosis).

**Step 5: Validate and create action plan**

Self-assess using [resources/evaluators/rubric_strategy_and_competitive_analysis.json](resources/evaluators/rubric_strategy_and_competitive_analysis.json). Check: diagnosis grounded in evidence, guiding policy addresses root challenge, actions coherent and specific, competitive positioning clear, assumptions explicit, risks identified. Create `strategy-and-competitive-analysis.md` with strategy summary, supporting analysis, action plan with owners/timelines.

## Strategic Frameworks Overview

| Framework | Use When | Key Output |
|-----------|----------|------------|
| **Good Strategy Kernel** | Overall strategy formulation | Diagnosis + Guiding Policy + Coherent Actions |
| **Porter's 5 Forces** | Assess industry attractiveness, competitive intensity | Industry structure analysis, profit potential |
| **SWOT Analysis** | Evaluate internal/external factors, compare options | Strengths, Weaknesses, Opportunities, Threats |
| **Blue Ocean Strategy** | Find uncontested market space, redefine competition | Strategy canvas, value innovation |
| **Playing to Win** | Define strategic choices explicitly | Where to play (markets/segments), How to win (advantage) |
| **Value Chain Analysis** | Identify cost advantages, differentiation opportunities | Value activities, cost drivers, linkages |
| **BCG Matrix** | Manage product portfolio | Stars, Cash Cows, Dogs, Question Marks |
| **Competitive Profiling** | Understand specific competitors deeply | Competitor SWOT, positioning, strategy inference |

**Framework Selection:**
- **Single product launch** → Blue Ocean Strategy Canvas + Competitive Profiling
- **Market entry decision** → Porter's 5 Forces + Playing to Win
- **Annual strategic planning** → Good Strategy Kernel + SWOT
- **Turnaround/crisis** → Good Strategy Kernel (diagnosis critical)
- **Portfolio management** → BCG Matrix + Resource allocation

See [resources/methodology.md](resources/methodology.md) for detailed framework application guidance.

## Competitive Analysis Overview

**Competitor Profiling:**
- **Identify competitors**: Direct (same solution), Indirect (different solution, same job), Potential (adjacent markets, new entrants)
- **Profile each**: Product/features, Pricing, Target customers, Positioning/messaging, Strengths/weaknesses, Strategy inference, Financial health, Recent moves
- **Analyze**: SWOT per competitor, Competitive positioning map (2x2: price vs features, etc.), Share of wallet, Win/loss patterns

**Porter's 5 Forces:**
1. **Competitive Rivalry**: Number of competitors, market growth rate, differentiation, switching costs, exit barriers
2. **Threat of New Entrants**: Barriers to entry (capital, technology, brand, regulation, network effects)
3. **Threat of Substitutes**: Alternative solutions, price-performance trade-offs, switching costs
4. **Bargaining Power of Buyers**: Concentration, price sensitivity, switching costs, backward integration threat
5. **Bargaining Power of Suppliers**: Concentration, uniqueness, switching costs, forward integration threat

**Output**: Industry attractiveness (high/medium/low profit potential), key competitive dynamics, strategic implications.

**Competitive Moats** (sustainable advantages):
- **Network effects**: Value increases with more users (platforms, marketplaces)
- **Switching costs**: High cost to change providers (data lock-in, integration, learning curve)
- **Brand**: Strong brand recognition and loyalty
- **Cost advantages**: Scale economies, proprietary technology, favorable access to resources
- **Regulatory**: Licenses, patents, compliance barriers

## Common Patterns

**Pattern 1: Market Entry Strategy**
- Diagnosis: Assess market using Porter's 5 Forces + competitive profiling
- Guiding Policy: Choose positioning (Blue Ocean or competitive response)
- Coherent Actions: Go-to-market, product roadmap, pricing, partnerships

**Pattern 2: Competitive Response**
- Diagnosis: Analyze competitor threat (new entrant, feature launch, price cut)
- Guiding Policy: Defend, ignore, or leapfrog
- Coherent Actions: Feature parity, differentiation doubling-down, or new positioning

**Pattern 3: Strategic Planning (Annual)**
- Diagnosis: Current state SWOT + market trends + competitive landscape
- Guiding Policy: Focus areas (3-5 strategic themes) for next year
- Coherent Actions: OKRs, initiatives, resource allocation

**Pattern 4: Differentiation Strategy**
- Diagnosis: Competitive positioning map + customer needs analysis
- Guiding Policy: Differentiation axis (vertical, feature set, experience, business model)
- Coherent Actions: Product roadmap, marketing messaging, pricing structure

## Guardrails

**Evidence-Based:**
- Ground diagnosis in data (market research, customer interviews, competitor analysis)
- State assumptions explicitly (market size, growth rate, competitive response)
- Distinguish facts from hypotheses
- Cite sources for key claims

**Coherence:**
- Actions must reinforce each other (not independent initiatives)
- Actions must support guiding policy
- Guiding policy must address diagnosis (not aspirational goals)
- Strategy must be internally consistent (no contradictions)

**Realism:**
- Acknowledge constraints (resources, capabilities, time, competition)
- Identify risks and mitigation plans
- Avoid wishful thinking ("if we just execute perfectly...")
- Test strategy against competitive response scenarios

**Specificity:**
- Diagnosis: specific challenge (not "we need to grow" but "customer acquisition cost exceeds LTV in current market")
- Guiding Policy: clear approach (not "be customer-focused" but "vertical specialization in healthcare")
- Coherent Actions: concrete steps with owners and timelines (not "improve product" but "build HIPAA compliance by Q2, led by Security Team")

**Differentiation:**
- Strategy must be defensible against competition
- Identify sustainable competitive advantages (moats)
- Avoid "best practices" that competitors can easily copy
- Explain why this strategy is hard for competitors to replicate

## Quick Reference

**Inputs Required:**
- Strategic question or decision to make
- Business context (industry, stage, goals, constraints)
- Competitive landscape (who are competitors, market dynamics)
- Available resources and capabilities

**Frameworks to Use:**
- Industry analysis → Porter's 5 Forces
- Overall strategy → Good Strategy Kernel
- Positioning → Blue Ocean Strategy Canvas, Value Chain Analysis
- Portfolio → BCG Matrix
- Competitor analysis → SWOT, Competitive Profiling

**Outputs Produced:**
- `strategy-and-competitive-analysis.md` with:
  - Strategic question and context
  - Analysis (frameworks applied, findings, evidence)
  - Strategy summary (diagnosis, guiding policy, coherent actions)
  - Competitive positioning
  - Action plan (initiatives, owners, timelines, success metrics)
  - Assumptions, risks, mitigations

**Resources:**
- Quick competitive analysis → [resources/template.md](resources/template.md)
- Complex multi-framework strategy → [resources/methodology.md](resources/methodology.md)
- Quality validation → [resources/evaluators/rubric_strategy_and_competitive_analysis.json](resources/evaluators/rubric_strategy_and_competitive_analysis.json)

**Minimum Quality Standard:**
- Diagnosis grounded in evidence (not assumptions)
- Guiding policy addresses root challenge (not symptoms)
- Coherent actions specific and mutually reinforcing
- Competitive analysis rigorous (Porter's 5 Forces or equivalent)
- Assumptions explicit, risks identified with mitigations
- Average rubric score ≥ 3.5/5 before delivering
