# Advanced Strategy & Competitive Analysis Methodology

## Workflow

```
Advanced Strategy Methodology Progress:
- [ ] Step 1: Deep diagnosis using multiple frameworks
- [ ] Step 2: Competitive intelligence and scenario planning
- [ ] Step 3: Integrated strategy synthesis
- [ ] Step 4: Stress-test strategy against scenarios
- [ ] Step 5: Implementation planning with adaptive triggers
```

**Step 1**: Deep diagnosis - Combine Porter's 5 Forces, Value Chain, SWOT. See [1. Good Strategy Kernel](#1-good-strategy-kernel-deep-dive).

**Step 2**: Competitive intelligence - Gather data, infer strategies, scenarios. See [6. Competitive Intelligence](#6-competitive-intelligence-gathering).

**Step 3**: Strategy synthesis - Apply Good Strategy kernel with options analysis. See [1. Good Strategy Kernel](#1-good-strategy-kernel-deep-dive).

**Step 4**: Stress-test - Scenarios, competitive response, fragile assumptions. See [7. Strategic Scenarios](#7-strategic-scenario-planning).

**Step 5**: Adaptive planning - Triggers, decision points, pivot criteria. See [7. Strategic Scenarios](#7-strategic-scenario-planning).

---

## 1. Good Strategy Kernel Deep Dive

### Diagnosis: Identifying Critical Challenge

**Common mistakes:**
- Too vague ("need to grow", "market is competitive")
- Symptom not cause ("low sales" vs "wrong target segment")
- Multiple unrelated issues (laundry list, not THE challenge)
- Aspirational goal as diagnosis ("want to be market leader")

**Crafting strong diagnosis:**

1. **Gather multi-source evidence**: Customer data (churn, NPS, win/loss), market data (growth, TAM, trends), competitive data (pricing, features, share), financials (CAC/LTV, margins), internal (capabilities, constraints)

2. **Find root cause (5 Whys)**:
   - "Revenue growth slowing" → "Customer acquisition slowing" → "CAC doubled" → "Paid channels saturated, organic declining" → "No differentiation, price competition, high churn"
   - **Root cause**: Lack of differentiation in commoditized market → poor unit economics

3. **Validate with stakeholders**: Sales, product, finance must agree on core challenge

4. **Test specificity**: Can you explain in 2-3 sentences? Specific enough to rule out certain approaches? Identifies leverage point?

**Good examples:**
- "CAC ($500) exceeds LTV ($300) in SMB segment due to 60% annual churn, making growth unprofitable"
- "Squeezed between low-cost offshore competitors ($10/unit) and premium players ($100/unit), our mid-market positioning ($50/unit) lacks differentiation"

### Guiding Policy: Strategic Approach

**Strong guiding policy characteristics:**
- Directional not prescriptive (approach, not detailed actions)
- Addresses diagnosis directly
- Creates advantage (moat or leverage)
- Rules things out (says what we WON'T do)

| Diagnosis | Guiding Policy | Why This Works |
|-----------|---------------|----------------|
| CAC > LTV in SMB, high churn | Vertical specialization (healthcare) + product-led growth | Higher LTV in healthcare, compliance creates switching costs; PLG reduces CAC |
| Squeezed between low-cost and premium | Blue Ocean: compete on speed/convenience not price/features | New dimension competitors haven't optimized |
| Weak network effects, multi-tenanting | Platform strategy: integrate with others, become "hub" | Can't beat multi-tenanting, embrace and add value |

**Testing guiding policy:**
- **Specificity**: Does it rule out certain actions?
- **Leverage**: Exploits capability, market gap, or competitor weakness?
- **Coherence**: Can you imagine 3-5 mutually reinforcing actions?
- **Defensibility**: Why can't competitors easily copy?

### Coherent Actions: Mutually Reinforcing Steps

**Coherence = actions support guiding policy + reinforce each other + no contradictions**

**Example: "Vertical specialization in healthcare"**
- Build HIPAA compliance (supports verticalization)
- Create healthcare templates/workflows (supports specialization)
- Hire healthcare domain experts (supports credibility)
- Target healthcare conferences (supports go-to-market)
- Partner with healthcare ecosystem (reinforces positioning)
- **Result**: All five together create "healthcare specialist" positioning (more than sum)

**Common failures:**
- **Laundry list**: 10 unrelated initiatives, no synergies
- **Contradictions**: Cost-cutting + premium feature investment
- **Vague**: "Improve customer experience" (not specific)
- **Orphaned**: Actions don't support guiding policy

---

## 2. Porter's 5 Forces Advanced Application

### When to Use

**Best for**: Industry attractiveness, profit potential, market entry/exit decisions
**Not for**: Operational decisions, short-term competitive moves, internal strategy

### Each Force Deep Dive

| Force | High = Bad (Low Profit) | Low = Good (High Profit) | Strategic Response if High |
|-------|------------------------|-------------------------|---------------------------|
| **Competitive Rivalry** | Many competitors, slow growth, low differentiation, high fixed costs | Few competitors, fast growth, high differentiation | Differentiate or achieve cost leadership |
| **New Entrants** | Low barriers (easy to enter) | High barriers (capital, scale, brand, regulation, network effects) | Build moats (switching costs, network effects) |
| **Substitutes** | Strong alternatives, low switching cost | Weak alternatives, high switching cost | Innovate faster, bundle, lock-in |
| **Buyer Power** | Few large customers, low switching cost, price sensitive | Many small customers, high switching cost | Increase switching costs, differentiate |
| **Supplier Power** | Few suppliers, unique inputs, high switching cost | Many suppliers, commodity inputs | Vertical integration, alternative suppliers |

### Scoring Industry Attractiveness

| Force | High/Med/Low | Weight | Score (1-5, 5=attractive) | Weighted |
|-------|-------------|--------|--------------------------|----------|
| Rivalry | [Assessment] | 30% | [1-5] | [X] |
| Entry Barriers | [Assessment] | 20% | [1-5] | [X] |
| Substitutes | [Assessment] | 15% | [1-5] | [X] |
| Buyer Power | [Assessment] | 20% | [1-5] | [X] |
| Supplier Power | [Assessment] | 15% | [1-5] | [X] |
| **Total** | | 100% | | [Avg] |

**Interpretation**: 4-5 = Highly attractive | 3-4 = Moderately attractive | 2-3 = Challenging | 1-2 = Unattractive

---

## 3. Blue Ocean Strategy

**Core idea**: Create uncontested market space (blue ocean) vs compete in existing market (red ocean).

### Strategy Canvas

**X-axis**: Factors industry competes on (price, features, service, speed, convenience)
**Y-axis**: Level of offering (low to high)

**Example: Cirque du Soleil**
- **Eliminated**: Star performers, animal shows, multiple arenas
- **Reduced**: Ticket price (somewhat higher but not luxury theater prices)
- **Raised**: Artistic theme, refined environment
- **Created**: Multiple productions, theatrical themes

**Result**: Circus + theater + artistic performance = new market (adults paying premium, not families with kids)

### Four Actions Framework

1. **Eliminate**: Factors industry takes for granted to remove?
2. **Reduce**: Factors to reduce below industry standard?
3. **Raise**: Factors to raise above industry standard?
4. **Create**: Factors to create that industry never offered?

**Application steps:**
- Map current competitive factors
- Identify industry assumptions
- Look across substitutes and buyer groups
- Apply Four Actions
- Test new value curve (differentiated? Lower costs? Higher value?)

---

## 4. Playing to Win Framework

**Two core choices:**

### 1. Where to Play

**Dimensions**: Geography, product category, customer segment, channel, vertical, value chain stage

**Choosing:**
- Start narrow (beachhead), expand later
- Choose markets where you can win (have or can build advantage)
- Explicit about where NOT to play

**Example: Stripe (early)**
- **Where to Play**: Online developers building internet businesses
- **Where NOT**: Offline merchants, enterprises, legacy systems

### 2. How to Win

**Porter's Generic Strategies:**

| Strategy | How | Risk | Examples |
|----------|-----|------|----------|
| **Cost Leadership** | Scale economies, process efficiency, automation | Price wars, inflexible, quality suffers | Walmart, Southwest, Amazon |
| **Differentiation** | Innovation, brand, service, features, design | Competitors copy, insufficient premium | Apple, Tesla, Airbnb |
| **Focus** (niche) | Cost or differentiation in narrow segment | Niche too small, competitors enter | Ferrari (differentiation focus) |

**Key**: Pick ONE strategy (avoid "stuck in the middle"), ensure capabilities support choice, build reinforcing moat.

---

## 5. Value Chain Analysis

**Purpose**: Identify where you create value, where to build cost or differentiation advantage.

**Primary Activities**: Inbound logistics → Operations → Outbound logistics → Marketing/Sales → Service
**Support Activities**: Procurement, Technology, HR, Infrastructure

### Using for Strategy

**Cost Advantage**:
- Identify high-cost activities → automate, outsource, eliminate, redesign
- Find economies of scale opportunities
- Example: Dell (direct-to-consumer eliminated distributor margins, built-to-order reduced inventory)

**Differentiation**:
- Identify activities most valued by customers → invest, enhance
- Find unique activities competitors can't copy
- Example: Apple (design + operations + marketing + ecosystem = integrated experience)

| Activity | Current Cost | % Total | Differentiation Impact | Opportunity |
|----------|--------------|---------|----------------------|-------------|
| Inbound | $X | Y% | Low | Automate to reduce 30% |
| Operations | $X | Y% | High | Invest in quality |
| Marketing | $X | Y% | High | Invest, creates brand |

---

## 6. Competitive Intelligence Gathering

### Data Sources

**Public**: Company websites (job listings signal priorities), social media, SEC filings, press releases, analyst reports (Gartner, Forrester), review sites (G2, Capterra), news

**Primary**: Customer interviews (why chose us/them?), win/loss analysis, mystery shopping (try competitor products), trade shows

**Inferring strategy**:
- **Hiring patterns**: Data scientist hiring → investing in AI/ML
- **Acquisitions**: Adjacent space → likely expanding there
- **Pricing changes**: Raised → profitability or upmarket; lowered → land grab or cost pressure
- **Feature releases**: Consistent theme → strategic direction
- **Partnerships**: Signal target customers or integrations

### Competitor SWOT Template

**Competitor**: [Name]
- **Strengths**: What they're good at, where they win, source of advantage
- **Weaknesses**: Vulnerabilities, customer complaints, product gaps
- **Opportunities** (for them): Market trends favoring them, untapped segments
- **Threats** (to them): Regulatory, technology, competitive threats
- **Likely Strategy** (inference): Where they're headed based on above

---

## 7. Strategic Scenario Planning

### When to Use

**Best for**: High uncertainty (multiple plausible futures), long time horizons (3-5+ years), high stakes (major investments)

### Building Scenarios

1. **Identify critical uncertainties** (high impact + high uncertainty)
   - Example: "Will regulation favor our model?" (High impact, uncertain)
   - Not: "Will sun rise?" (Certain) or "Office supplies +2%?" (Low impact)

2. **Select 2 most critical** → 2x2 matrix = 4 scenarios

**Example: SaaS deciding enterprise vs SMB**
- **Uncertainty 1**: Economy (Recession vs Boom)
- **Uncertainty 2**: Regulation (Strict vs Light)

**Scenarios:**
- **Recession + Strict**: Enterprises consolidate, need compliance → Enterprise compliance features
- **Recession + Light**: Price-sensitive buyers → SMB, low-cost model
- **Boom + Strict**: Enterprises invest in compliance → Both segments viable
- **Boom + Light**: High growth, less constraints → Land grab, rapid expansion

3. **Develop strategy per scenario** + **Identify common actions** (robust across scenarios)

4. **Set trigger points**: "If X happens → Scenario A more likely → Adjust strategy"

### Stress-Testing Strategy

**Questions:**
- What if core assumption is wrong? (Market grows slower, competitor responds differently)
- What if competitors do X? (Price war, feature parity, acquire key partner)
- What if key resource unavailable? (Talent shortage, supplier issue, platform dependency)
- What breaks this strategy?

**Fragility test**: Identify assumptions strategy depends on → Rate likelihood each is wrong → If wrong, can strategy adapt or collapse?
- **Fragile**: Depends on many assumptions being right
- **Robust**: Works across multiple scenarios

---

## 8. Common Strategic Pitfalls

| Pitfall | Mistake | Fix |
|---------|---------|-----|
| **Goals = Strategy** | "Grow 50% annually, become market leader" | Apply Good Strategy kernel (diagnosis/policy/actions) |
| **Fluff** | "Be customer-centric, innovative, data-driven" | Be specific, different from competitors |
| **Laundry List** | "Improve product, hire sales, better marketing..." | Ensure coherence under guiding policy |
| **Ignoring Constraints** | "Cost leadership AND premium differentiation" | Choose one, acknowledge trade-offs |
| **Imitating** | "Amazon did X, so we should too" | Understand WHY, adapt to your context |
| **Consensus Mush** | "Combine everyone's ideas" | Clear decision-maker, seek input not consensus |
| **Analysis Paralysis** | "Need more data" | Decide with available data, state assumptions, adapt |
| **Planning ≠ Strategy** | "Launch Product A in Q1, hire 10 in Q2" | Strategy = WHY (given challenges), plan = WHEN |
| **Ignoring Competitive Response** | Assume competitors do nothing | Game out responses, ensure robustness |
| **Best Practices = Strategy** | "Implement Agile, A/B testing" | Best practices = table stakes, not advantage |

**Key Takeaway**: Good strategy = diagnosis (challenge) + guiding policy (approach) + coherent actions (coordinated steps). Specific, evidence-based, makes choices, addresses competitive realities.
