# Synthesis & Analogy Template

## Workflow

Copy this checklist and track your progress:

```
Synthesis & Analogy Template Progress:
- [ ] Step 1: Define goal and scope
- [ ] Step 2: Gather and organize sources/domains
- [ ] Step 3: Apply synthesis or analogy techniques
- [ ] Step 4: Extract insights and test validity
- [ ] Step 5: Document findings and validate quality
```

**Step 1**: Define goal - synthesis question or analogy purpose. See [Section 1](#1-goal--scope).

**Step 2**: Gather sources/domains - list all sources (synthesis) or identify source/target domains (analogy). See [Section 2A](#2a-synthesis-sources) or [Section 2B](#2b-analogy-domains).

**Step 3**: Apply techniques - thematic synthesis, conflict resolution (synthesis) or structural mapping (analogy). See [Section 3A](#3a-synthesis-application) or [Section 3B](#3b-analogy-application).

**Step 4**: Extract insights - patterns, themes, transferred knowledge. See [Section 4](#4-insights--findings).

**Step 5**: Validate quality - use quality checklist before finalizing. See [Quality Checklist](#quality-checklist).

---

## 1. Goal & Scope

**Choose One** (or combine):
- [ ] **Synthesis**: Combining multiple sources into unified understanding
- [ ] **Analogy**: Transferring knowledge between domains or explaining via familiar concepts
- [ ] **Both**: Synthesize then use analogy to explain

**Goal Statement:**

[What question are you answering? What problem are you solving? What are you trying to understand or explain?]

**Success Criteria:**

What does good output look like?
- [ ] [Criterion 1 - e.g., "Identifies 3-5 major themes across all sources"]
- [ ] [Criterion 2 - e.g., "Resolves apparent conflicts between sources"]
- [ ] [Criterion 3 - e.g., "Generates actionable insights not present in individual sources"]

---

## 2A. Synthesis: Sources

*Skip this section if doing analogy only.*

### Source Inventory

List all sources to synthesize:

| Source # | Type | Title/Description | Key Claims | Date | Quality |
|----------|------|-------------------|------------|------|---------|
| 1 | [Research paper / Interview / Survey / Data / Report] | [Title or description] | [Main points] | [When] | [High/Med/Low] |
| 2 | [Type] | [Title] | [Points] | [When] | [Quality] |
| 3 | [Type] | [Title] | [Points] | [When] | [Quality] |
| 4 | [Type] | [Title] | [Points] | [When] | [Quality] |
| 5 | [Type] | [Title] | [Points] | [When] | [Quality] |

**Total sources**: [Count]

**Source quality notes**: [Any concerns about reliability, bias, or relevance of sources?]

---

## 2B. Analogy: Domains

*Skip this section if doing synthesis only.*

### Source Domain (Familiar)

**Domain**: [What domain are we drawing from? Must be familiar to audience.]

**Why this domain?** [Why is this a good source for analogy? What makes it familiar and well-understood?]

**Key entities in source domain:**
- Entity 1: [Name and description]
- Entity 2: [Name and description]
- Entity 3: [Name and description]

**Key relationships in source domain:**
- Relationship 1: [How entities relate - e.g., "Entity 1 → Entity 2 (causes, contains, transforms)"]
- Relationship 2: [Relationship description]
- Relationship 3: [Relationship description]

### Target Domain (Unfamiliar or Complex)

**Domain**: [What are we trying to explain or solve?]

**Why needs explanation/transfer?** [What's complex or unfamiliar about this domain?]

**Key entities in target domain:**
- Entity A: [Name and description]
- Entity B: [Name and description]
- Entity C: [Name and description]

**Key relationships in target domain:**
- Relationship A: [How entities relate]
- Relationship B: [Relationship description]
- Relationship C: [Relationship description]

---

## 3A. Synthesis: Application

*Use if synthesizing multiple sources.*

### Thematic Analysis

**Theme 1: [Theme Name]**
- **Description**: [What is this theme about?]
- **Frequency**: [X/Y sources mention this]
- **Supporting sources**: [List source #s]
- **Key evidence**:
  - Source [#]: "[Quote or key point]"
  - Source [#]: "[Quote or key point]"
  - Source [#]: "[Quote or key point]"
- **Importance**: [Why does this matter? What's the implication?]

**Theme 2: [Theme Name]**
[Same structure as Theme 1]

**Theme 3: [Theme Name]**
[Same structure as Theme 1]

**Theme 4: [Theme Name]** (if applicable)
[Same structure as Theme 1]

**Theme 5: [Theme Name]** (if applicable)
[Same structure as Theme 1]

### Agreements Across Sources

**What do most/all sources agree on?**

| Agreement | Sources Supporting | Evidence |
|-----------|-------------------|----------|
| [Point of agreement] | [Source #s] | [Brief supporting quotes/data] |
| [Point of agreement] | [Source #s] | [Evidence] |
| [Point of agreement] | [Source #s] | [Evidence] |

### Conflicts & Resolution

**Conflict 1:**
- **Source(s) A claim**: [What do some sources say?] (Sources: [#s])
- **Source(s) B claim**: [What do other sources say?] (Sources: [#s])
- **Nature of conflict**: [Genuine disagreement or scope/context difference?]
- **Resolution**: [How can we reconcile? Meta-framework? Scope distinction? Temporal? State uncertainty?]

**Conflict 2:**
[Same structure as Conflict 1]

**Conflict 3:**
[Same structure as Conflict 1]

### Patterns & Meta-Insights

**Pattern 1:**
- **Pattern**: [What repeats across multiple sources in different guises?]
- **Evidence**: [Where do we see this? Source #s and examples]
- **Meta-insight**: [What does this pattern tell us? What's the underlying principle?]

**Pattern 2:**
[Same structure as Pattern 1]

**Gaps & Uncertainties:**

What's not covered or unclear?
- Gap 1: [What's missing from all sources?]
- Gap 2: [What remains uncertain despite synthesis?]
- Gap 3: [What contradictions remain unresolved?]

---

## 3B. Analogy: Application

*Use if creating or testing analogy.*

### Structural Mapping Table

| Source Domain (Familiar) | → | Target Domain (Unfamiliar) | Validity |
|--------------------------|---|----------------------------|----------|
| **Entity Mapping** | | | |
| [Source entity 1] | ↔ | [Target entity A] | [Does this map hold? Y/N, why?] |
| [Source entity 2] | ↔ | [Target entity B] | [Validity] |
| [Source entity 3] | ↔ | [Target entity C] | [Validity] |
| **Relationship Mapping** | | | |
| [Source relationship: X→Y] | ↔ | [Target relationship: A→B] | [Do similar causal/structural relations exist?] |
| [Source relationship] | ↔ | [Target relationship] | [Validity] |
| [Source relationship] | ↔ | [Target relationship] | [Validity] |

### Deep vs Surface Analysis

**Deep (Structural) Similarities:**
- [What structural/relational similarities exist? These make the analogy powerful.]
- [Example: "Both have feedback loops", "Both involve hub-spoke topology", "Both use hierarchical organization"]

**Surface (Superficial) Similarities:**
- [What surface-level similarities exist but don't help understanding?]
- [Example: "Both are round", "Both involve numbers" - note these are weak and should not drive analogy]

**Assessment**: [Is this analogy primarily deep (good) or surface (weak)?]

### Transfer of Insights

**What transfers from source to target?**

1. **Insight/Solution 1**: [What knowledge from source domain applies to target?]
   - Source: [How it works in source domain]
   - Target: [How it could work in target domain]
   - Evidence it transfers: [Why does this mapping work?]

2. **Insight/Solution 2**:
   [Same structure as Insight 1]

3. **Insight/Solution 3**:
   [Same structure as Insight 1]

### Limitations & Where Analogy Breaks Down

**Critical**: Always acknowledge where analogy stops working.

**Limitation 1**:
- **What doesn't transfer**: [Aspect of source domain that doesn't map to target]
- **Why it breaks**: [Explanation]
- **Implication**: [What this means for using the analogy]

**Limitation 2**:
[Same structure as Limitation 1]

**Limitation 3**:
[Same structure as Limitation 1]

**Bottom line**: [This analogy is useful for understanding [X, Y, Z] but should not be pushed to explain [A, B, C].]

---

## 4. Insights & Findings

### Synthesized Summary

**Main findings** (3-5 bullet points):
- [Finding 1 from synthesis/analogy work]
- [Finding 2]
- [Finding 3]
- [Finding 4]
- [Finding 5]

**New insights not present in individual sources:**

[What have we learned from combining sources or mapping analogies that wasn't obvious from any single source? This is the value-add of synthesis/analogy work.]

### Supporting Evidence

**Claim 1**: [Major claim or insight]
- **Evidence**: [Which sources support this? Specific quotes or data points]
- **Strength**: [How strong is the evidence? High/Medium/Low]

**Claim 2**: [Major claim or insight]
[Same structure as Claim 1]

**Claim 3**: [Major claim or insight]
[Same structure as Claim 1]

### Actionable Implications

**What should we do based on these insights?**

1. **Action 1**: [Specific action]
   - **Rationale**: [Why this action follows from synthesis/analogy]
   - **Priority**: [High/Medium/Low]
   - **Owner**: [Who should do this]

2. **Action 2**:
   [Same structure as Action 1]

3. **Action 3**:
   [Same structure as Action 1]

### Confidence & Uncertainties

**High confidence in:**
- [What are we very sure about based on synthesis/analogy?]

**Medium confidence in:**
- [What seems likely but has some uncertainty?]

**Low confidence / Open questions:**
- [What remains uncertain or needs further investigation?]

---

## Quality Checklist

Before finalizing, verify:

**For Synthesis:**
- [ ] All relevant sources included in inventory (no cherry-picking)
- [ ] Thematic analysis identifies 3-5 major themes with supporting evidence
- [ ] Agreements across sources documented (what's consensus?)
- [ ] Conflicts explicitly addressed and resolved (or stated as uncertain)
- [ ] Patterns identified beyond what individual sources state (value-add)
- [ ] Evidence cited for major claims (source #s, quotes, data)
- [ ] Gaps and uncertainties acknowledged (what's missing or unclear?)
- [ ] New insights generated (synthesis adds value, not just summarizes)
- [ ] Facts distinguished from interpretations (clear what's data vs analysis)

**For Analogy:**
- [ ] Source domain appropriate (familiar to audience, well-understood)
- [ ] Target domain clear (what we're explaining or transferring to)
- [ ] Structural mapping table complete (entities and relationships mapped)
- [ ] Deep (structural) similarities identified (not just surface features)
- [ ] Mapping validity tested (do relationships actually transfer?)
- [ ] Insights/solutions transfer clearly explained (what moves from source to target)
- [ ] Limitations explicitly stated (where analogy breaks down)
- [ ] Analogy doesn't overextend (knows when to stop)
- [ ] Helps understanding (audience will grasp target domain better)
- [ ] Not used as proof (analogies illustrate, don't prove)

**Both:**
- [ ] Goal from Step 1 achieved (answered question or solved problem)
- [ ] Success criteria from Step 1 met (check against your own criteria)
- [ ] Evidence-based (grounded in sources/domains, not speculation)
- [ ] Actionable implications provided (so what? what should we do?)
- [ ] Appropriate level of confidence stated (not overconfident or too hedged)
- [ ] Readable and clear (audience will understand)
- [ ] No contradictions (internally consistent)

**Minimum Standard**: All applicable checklist items should be checkable. Average rubric score ≥ 3.5/5.
