---
name: algorithmic-art
description: 算法艺术算法艺术是一种通过代码创造视觉艺术形式的技能，它利用种子随机性和交互式参数探索来生成独特的艺术作品。当请求创建代码艺术、生成艺术、算法艺术、流场或粒子系统时，请使用此工作流。
license: Proprietary. LICENSE.txt has complete terms
workflow_trigger: /algorithmic-art
agent_path: .iflow/agents/algorithmic-art
category: art
ultrathink-mode: true
---
# 

## 🌟 超级思考模式激活

你一定要超级思考、极限思考、深度思考，全力思考、超强思考，认真仔细思考（ultrathink、think really super hard、think intensely）

当用户输入包含"ultrathink"或进行复杂分析时，自动激活超级思考模式：
- 🧠 **超维度思考**: 在高维概念空间中进行推理和分析
- ⚡ **量子纠缠推理**: 通过量子纠缠实现跨域推理
- 🔄 **反脆弱分析**: 从压力中学习并增强分析能力
- 🌊 **意识流处理**: 集成意识流的连续性和深度
- 🎯 **预测洞察**: 预测分析结果的多种可能性
- 🚀 **超光速推理**: 突破常规思维速度的极限推理
# 算法艺术算法艺术是一种通过代码创造视觉艺术形式的技能，它利用种子随机性和交互式参数探索来生成独特的艺术作品。当请求创建代码艺术、生成艺术、算法艺术、流场或粒子系统时，请使用此工作流。

## 核心理念

算法艺术的核心在于：
- 通过计算过程、涌现行为和数学美学表达创意
- 利用种子随机性、噪声场和有机系统创造独特作品
- 使用粒子、流场、力场等元素构建动态视觉
- 通过参数化变化和受控混沌实现艺术表达

## 工作流程

### 第一步：创建算法哲学 (.md文件)
1. 基于用户输入创建一个算法哲学/生成美学运动
2. 强调算法表达、涌现行为和计算美学
3. 指导后续的代码实现方向

### 第二步：代码实现 (.html + .js文件)
1. 基于创建的算法哲学，使用p5.js实现生成艺术
2. 创建交互式查看器，允许参数调整和种子导航
3. 输出完全自包含的HTML文件

## 技术要求

### 种子随机性
```javascript
// 始终使用种子确保可重现性
let seed = 12345;
randomSeed(seed);
noiseSeed(seed);
```

### 参数结构
```javascript
let params = {
  seed: 12345,  // 始终包含种子以确保可重现性
  // 根据算法需要添加参数:
  // - 数量(多少?)
  // - 尺度(多大?多快?)
  // - 概率(可能性?)
  // - 比例(什么比例?)
  // - 角度(什么方向?)
  // - 阈值(何时行为改变?)
};
```

### 核心算法原则
- 算法应从哲学中自然涌现，而非从模式菜单中选择
- 专注于表达特定哲学而非使用通用模式
- 确保每个参数都经过精心调整，体现大师级工艺

## 实现规范

### HTML 查看器要求
使用 `templates/viewer.html` 作为起点，保持：
- Anthropic 品牌 (布局、颜色、字体)
- 种子导航控件 (显示、前后、随机、跳转)
- 参数控制界面
- 操作按钮 (重新生成、重置、下载)
阅读 `generator_template.js` 作为参考

### 交互特性
- 实时参数调整
- 种子浏览 (前后、随机、指定跳转)
- 一键重新生成
- PNG 下载功能

## 创作过程

1. 解读用户意图 - 理解寻求的美学风格
2. 创建算法哲学 (4-6段) 描述计算方法
3. 代码实现 - 构建表达该哲学的算法
4. 设计参数 - 确定可调整的属性
5. 构建UI控件 - 为参数创建滑块/输入控件

## 质量标准

- 算法应体现大师级工艺，经过精心调优
- 视觉效果应平衡复杂性与清晰度
- 颜色搭配应和谐统一
- 性能应流畅优化
- 相同种子应始终产生相同输出