---
name: design-audit
description: Use when reviewing frontend design quality without a reference. Identifies UX issues, accessibility problems, and visual inconsistencies with actionable fix suggestions.
---

# Design Audit

## Overview

Quickly identify design issues and provide actionable suggestions for improvement without needing a reference design.

**Core principle:** Good design follows patterns. Deviations from patterns are often bugs.

## When to Use

Use this skill when:
- Reviewing UI during development
- Quick sanity check before PR
- User asks "what's wrong with this design?"
- Accessibility review needed
- User wants "quick feedback on the UI"
- Polishing before demo/launch

## Required Inputs

1. **Screenshot or URL** of the frontend to audit
2. **Context** (optional) - Target audience, brand guidelines, purpose

**Announce:** "I'll perform a quick design audit using design-audit skill."

## Audit Process

### Phase 1: First Impression (2 seconds)

Capture gut reaction:
- What draws attention first?
- Does hierarchy feel clear?
- Any elements feel "off"?
- Professional or amateur feel?

### Phase 2: Systematic Scan

Check each category in order:

#### 1. Visual Hierarchy
- [ ] Clear primary action/CTA
- [ ] Heading levels make sense
- [ ] Important info is prominent
- [ ] Secondary items subdued

#### 2. Spacing & Alignment
- [ ] Consistent margins/padding
- [ ] Grid alignment
- [ ] Breathing room between elements
- [ ] No orphaned elements

#### 3. Typography
- [ ] Max 2-3 font families
- [ ] Readable font sizes (min 14px body)
- [ ] Sufficient line-height (1.4-1.6)
- [ ] Proper font weights

#### 4. Color & Contrast
- [ ] WCAG AA contrast (4.5:1 text, 3:1 UI)
- [ ] Consistent color palette
- [ ] Meaningful color usage
- [ ] Not relying on color alone

#### 5. Components
- [ ] Buttons look clickable
- [ ] Interactive states clear
- [ ] Forms properly labeled
- [ ] Icons sized consistently

#### 6. Accessibility
- [ ] Focus indicators visible
- [ ] Touch targets 44px+
- [ ] Alt text would make sense
- [ ] Keyboard navigation logical

#### 7. Polish
- [ ] No pixelated images
- [ ] Consistent border radius
- [ ] Shadows consistent
- [ ] No alignment jitter

### Phase 3: Generate Audit Report

**Output format:**

```markdown
## Quick Design Audit

### Overall Score: [X/10]
Brief 1-line summary

### Critical Issues (Fix Now)
1. **[Issue]** - [Location]
   - Problem: [Description]
   - Fix: [Specific actionable suggestion]
   - Impact: [Why this matters]

### High Priority Issues (Should Fix)
1. **[Issue]** - [Location]
   - Problem: [Description]
   - Fix: [Specific actionable suggestion]

### Medium Priority Issues (Consider Fixing)
1. **[Issue]** - [Location]
   - Problem: [Description]
   - Fix: [Specific actionable suggestion]

### Low Priority Polish (Nice to Have)
1. **[Issue]** - [Location]
   - Suggestion: [Improvement idea]

### What's Working Well
- [Positive observation]
- [Another strength]
```

## Issue Priority Matrix

| Impact \ Effort | Low Effort | High Effort |
|-----------------|------------|-------------|
| **High Impact** | Fix Now | Plan Soon |
| **Low Impact** | Quick Win | Backlog |

## Common Issues & Fixes

### Spacing Issues
```css
/* Problem: Inconsistent spacing */
/* Fix: Use spacing scale */
--space-1: 4px;
--space-2: 8px;
--space-3: 16px;
--space-4: 24px;
--space-5: 32px;
```

### Typography Issues
```css
/* Problem: Poor readability */
/* Fix: */
body {
  font-size: 16px;      /* Not 14px */
  line-height: 1.5;     /* Not 1.2 */
  max-width: 65ch;      /* Limit line length */
}
```

### Color Contrast
```css
/* Problem: Low contrast */
/* Fix: Use contrast checker, aim for 4.5:1+ */
/* Bad: #888 on #fff (3.5:1) */
/* Good: #666 on #fff (5.7:1) */
```

### Button States
```css
/* Problem: No hover/focus states */
/* Fix: */
button:hover { background: var(--primary-dark); }
button:focus { outline: 2px solid var(--focus-ring); }
button:active { transform: scale(0.98); }
```

## Severity Definitions

| Severity | Criteria | Examples |
|----------|----------|----------|
| **Critical** | Blocks usage or accessibility | No focus states, contrast < 3:1, touch targets < 30px |
| **High** | Impacts usability significantly | Unclear CTA, confusing hierarchy, inconsistent patterns |
| **Medium** | Noticeable but functional | Minor spacing issues, suboptimal typography |
| **Low** | Polish items | Pixel alignment, shadow refinement |

## Output Actions

After audit, offer:
1. **Generate CSS fixes** - Code snippets to fix issues
2. **Create ticket list** - Formatted for issue tracker
3. **Deep dive area** - Detailed analysis of specific section
4. **Full report** - Use `design-report` for comprehensive analysis

## Red Flags

Stop and clarify if:
- Image is blurry or low resolution
- Cannot determine intended audience
- Multiple distinct UI patterns present
- Unclear what constitutes "done"

## Integration

**Related skills:**
- `design-compare` - When you have a reference design
- `design-report` - For deep expert analysis
