# Apple Design Principles Reference

## Human Interface Guidelines Core Principles

### Aesthetic Integrity
Design appearance reflects function. A productivity app uses subtle, unobtrusive graphics. An immersive game uses rich visuals.

**Evaluate:**
- Does visual treatment match purpose?
- Is decoration functional or arbitrary?
- Does aesthetic support or distract from content?

### Consistency
Use familiar standards: system-provided interface elements, well-known icons, standard text styles, uniform terminology.

**Evaluate:**
- Do similar components behave similarly?
- Are patterns learnable and predictable?
- Does it follow platform conventions?

### Direct Manipulation
Manipulate onscreen content directly. Rotation gestures rotate content. Manipulation increases engagement and understanding.

**Evaluate:**
- Can users interact directly with content?
- Do gestures feel natural?
- Is there clear cause-and-effect?

### Feedback
Every action needs acknowledgment. Built-in apps provide perceptible feedback. Interactive elements highlight briefly when tapped.

**Evaluate:**
- Do all interactions have visible response?
- Is system state always clear?
- Are loading states informative?

### Metaphors
Virtual objects and actions are metaphors for familiar experiences. Moving layered views exposes content beneath.

**Evaluate:**
- Are metaphors intuitive?
- Do they translate across cultures?
- Are abstractions necessary?

### User Control
People—not apps—initiate and control actions. Keep interactive elements familiar and predictable. Confirm destructive actions. Make it easy to cancel operations.

**Evaluate:**
- Can users always undo?
- Are destructive actions confirmed?
- Do people feel in control?

## Typography Excellence

### Apple's Type Philosophy
- SF Pro for interfaces
- New York for reading
- Type is 90% of design
- White space is not empty space

### Typography Scoring Rubric

| Score | Criteria |
|-------|----------|
| 10 | Perfect type hierarchy, optimal readability, delightful details |
| 8-9 | Strong hierarchy, good readability, professional |
| 6-7 | Adequate hierarchy, readable, some inconsistencies |
| 4-5 | Weak hierarchy, readability issues, many inconsistencies |
| 1-3 | No clear hierarchy, poor readability, amateur |

## Color Philosophy

### Apple's Approach
- Color has purpose
- System colors adapt to context
- High contrast modes are first-class
- Vibrancy creates depth

### Color Evaluation Criteria

**Semantic Usage:**
- Red = destructive
- Green = positive
- Blue = interactive
- Gray = secondary

**Contrast Requirements:**
- Text: 4.5:1 minimum, 7:1 ideal
- Large text: 3:1 minimum
- UI components: 3:1 minimum

## Spacing System

### Apple's 8-Point Grid
Everything aligns to 8px grid:
- 4px for small adjustments
- 8px base unit
- 16px comfortable spacing
- 24px generous spacing
- 32px+ section separation

### Evaluation Criteria
- Consistent spacing scale?
- Adequate breathing room?
- Grouped elements clearly related?
- Isolated elements clearly separate?

## Animation Principles

### Apple Motion Philosophy
- Animation communicates
- Physics feel real
- Timing creates personality
- Transitions orient users

### Animation Scoring

| Aspect | Excellent | Poor |
|--------|-----------|------|
| Timing | Natural easing, ~300ms | Linear, jarring, too fast/slow |
| Purpose | Communicates change | Decorative only |
| Continuity | Elements relate spatially | Disconnected |
| Performance | 60fps smooth | Janky, dropped frames |

## Iconography

### Apple's Icon Standards
- Optically weighted (not mathematically)
- Consistent stroke weight
- Clear at small sizes
- Meaningful, not decorative

### Icon Evaluation
- [ ] Consistent style across set
- [ ] Recognizable at 16px
- [ ] Appropriate visual weight
- [ ] Aligned to pixel grid

## What Would Jony Ive Notice?

1. **Honesty** - Materials and behaviors are authentic
2. **Simplicity** - Nothing unnecessary
3. **Craft** - Details reveal care
4. **Timelessness** - Won't look dated in 5 years
5. **Inevitability** - Feels like the only solution
6. **Restraint** - Says no to 1000 things
