---
name: job-apply
description: Analyze job roles for fit, draft application question responses, find hiring managers, and create follow-up emails for RYLLC job applications. Focuses on climate tech IC product/SRE roles.
---

# Job Apply Skill

**Purpose:** Streamline job application process by analyzing role fit, drafting responses to application questions, identifying hiring managers, and creating follow-up outreach emails.

## Core Workflow

1. **Fetch and analyze job posting** (via WebFetch/WebSearch)
2. **Assess role fit** against candidate profile
3. **Draft cover letter** tailored to the role
4. **Draft responses** to application questions
5. **Find hiring manager** via LinkedIn/web search
6. **Generate follow-up email** using job posting outreach template
7. **Create Gmail draft** with labels: `Craft` and `RYLLC`

## Candidate Profile

### Background
- **6 years as CTO and co-founder of Gremlin** (chaos engineering pioneer)
- **Head of Engineering at QuitCarbon** (climate tech)
- **Technical expertise:** Distributed systems, reliability/resilience, scaling infrastructure, technical debt resolution
- **Product sense:** Strong product intuition, enjoys building products
- **Barbell CTO:** Deep technical work (architecture, code reviews, system design) + high-level strategy (roadmap, team structure, hiring)

### Role Preferences (Priority Order)
1. **Staff/Principal Product Engineering (IC)** - Full-stack or backend product work at climate tech companies (FIRST CHOICE)
2. **Staff/Principal SRE** - Reliability work (bread and butter, but not primary preference)
3. **Fractional CTO / Staff Augmentation** - Consulting work (feels like management, less desirable than IC)

### Key Fit Indicators

**Strong Fit:**
- Climate tech or sustainability mission
- Staff+ IC engineering role (product or SRE)
- Distributed systems, infrastructure scaling, reliability challenges
- Technical leadership without direct management
- Remote flexibility
- Startup/scale-up stage (growth challenges)

**Medium Fit:**
- Adjacent to climate (energy, manufacturing efficiency, supply chain optimization)
- Senior engineer role with clear path to Staff+
- Hybrid remote (some travel acceptable)
- Some technical leadership responsibilities

**Weak Fit:**
- Non-climate tech mission
- Heavy management responsibilities
- Early stage startup (pre-product-market fit)
- Full on-site requirement
- Junior/mid-level scope

## Role Fit Assessment

Evaluate each role on these dimensions:

### Mission Alignment (0-10)
- Direct climate impact: 10
- Energy/sustainability adjacent: 7-8
- Efficiency/optimization with indirect climate benefit: 5-6
- No climate connection: 0-3

### Technical Fit (0-10)
- Distributed systems/infrastructure/reliability: 9-10
- Backend product engineering: 8-9
- Full-stack product engineering: 7-8
- Frontend-heavy: 4-5
- Non-technical: 0-2

### Role Level (0-10)
- Staff+ IC: 10
- Senior with leadership: 7-8
- Senior IC only: 5-6
- Mid-level: 0-3

### Work Style (0-10)
- Fully remote: 10
- Hybrid (1-2 days/week): 7-8
- Hybrid (3+ days/week): 4-5
- Full on-site: 0-2

### Overall Fit Calculation
- **Strong fit:** Average score ≥ 8.0
- **Medium fit:** Average score 6.0-7.9
- **Weak fit:** Average score < 6.0

## Application Question Response Guidelines

Common questions and approach:

### "Why do you want to work here?"
**Structure:**
1. **Mission resonance** (1-2 sentences) - Connect personal values to company mission
2. **Technical excitement** (1-2 sentences) - Specific interest in their technical challenges
3. **Experience alignment** (1-2 sentences) - How your background uniquely positions you to contribute

**Tone:** Genuine, specific, technical. Avoid generic statements.

**Example for climate tech:**
> "I'm deeply committed to working on climate solutions, and [Company]'s approach to [specific problem] resonates with me. At QuitCarbon, I saw firsthand how technical execution can accelerate decarbonization. I'm particularly excited about [specific technical challenge from job posting] because at Gremlin, we wrestled with similar distributed systems challenges around [relevant experience]. I believe my experience scaling [relevant system] could help [Company] achieve [specific goal from their mission]."

### "Tell us about an achievement you are proud of"
**Structure:**
1. **Context** (1 sentence) - What was the situation/challenge?
2. **Action** (2-3 sentences) - What did you do? Focus on technical approach and leadership
3. **Impact** (1-2 sentences) - What was the result? Technical and business impact

**Tone:** Concrete, technical, impact-focused. No bragging about metrics unless specifically asked.

**Example:**
> "At Gremlin, we faced a critical challenge: how do you quantify the value of failures that didn't happen? I led the architecture of our reliability scoring system, designing a distributed event processing pipeline that correlated chaos experiments with production incidents. This required building consensus across engineering and product on what 'resilience' meant quantitatively. The system became core to our product value proposition and enabled customers to demonstrate ROI to their executives. I'm proud of both the technical architecture and the cross-functional collaboration required to ship it."

### "What are your salary expectations?"
**Approach:**
- For IC roles: Research market rate for Staff+ in that geo/industry
- Climate tech typically pays 10-20% below big tech
- Be flexible but know your floor
- Standard range: $180K-$220K base for Staff Engineer at climate tech companies

**Example response:**
> "I'm targeting $[X]-$[Y] base salary, which I believe aligns with market rates for Staff+ engineers in climate tech. I'm flexible on the exact number depending on equity, benefits, and the overall compensation package. Most important to me is working on meaningful climate solutions with a strong technical team."

### Other common questions
- **"What are you looking for in your next role?"** - IC technical work, climate mission, distributed systems challenges, remote flexibility
- **"Describe a technical challenge you solved"** - Use Gremlin or QuitCarbon examples, focus on distributed systems/reliability/scaling
- **"How do you approach technical leadership?"** - Barbell approach: deep technical work + strategic direction, not middle management

## Cover Letter Guidelines

**Purpose:** Every job application should include a tailored cover letter that demonstrates genuine interest and technical fit.

**Length:** 250-350 words (3-4 paragraphs)

**Tone:** Professional but conversational, specific to the role and company, shows research and genuine interest

### Structure

**Paragraph 1: Opening and Mission Alignment (2-3 sentences)**
- Express enthusiasm for the specific role and company
- Connect to their mission or technical challenge
- Show you understand what they do

**Paragraph 2: Technical Fit and Relevant Experience (3-4 sentences)**
- Highlight most relevant experience from Gremlin/QuitCarbon
- Connect your expertise to their specific technical needs from job posting
- Demonstrate understanding of their technical challenges
- Use concrete examples without bragging about metrics

**Paragraph 3: Why This Role/Why Now (2-3 sentences)**
- Explain what you're looking for in your next role
- Connect it to what makes this opportunity unique
- Show alignment between your goals and their needs

**Paragraph 4: Closing (1-2 sentences)**
- Express eagerness to discuss further
- Thank them for consideration
- Keep it warm and professional

### Example Template

```
I'm writing to express my strong interest in the [Job Title] position at [Company]. [Specific aspect of their mission/technology] resonates deeply with my commitment to [relevant value/goal], and I'm excited about the opportunity to contribute to [specific company goal or technical challenge].

I spent six years as CTO and co-founder of Gremlin, where I [relevant technical achievement tied to their needs]. Before that, I [relevant prior experience]. At QuitCarbon, I served as Head of Engineering and saw firsthand how [relevant insight about climate tech/their domain]. I'm particularly drawn to [specific technical challenge from posting] because [connection to your experience], and I believe my background in [relevant expertise] would enable me to [specific contribution to their goals].

I'm looking for Staff+ IC engineering work where I can focus on deep technical challenges in [relevant domain] while contributing to climate solutions. [Company's] approach to [specific aspect of their work] represents exactly the kind of meaningful technical problem I want to spend my time on. The opportunity to [specific aspect from job posting] while [another specific aspect] aligns perfectly with how I work best.

I'd welcome the opportunity to discuss how my experience in [relevant areas] could help [Company] [specific goal]. Thank you for considering my application.

Best regards,
Matthew Fornaciari
```

### Key Principles

- **Be specific:** Reference actual details from the job posting and company
- **Show research:** Demonstrate you understand their product, mission, and technical challenges
- **Connect dots:** Explicitly link your experience to their needs
- **No generic statements:** Every sentence should be unique to this company/role
- **Technical credibility:** Show you understand their stack and challenges
- **Mission alignment:** Especially important for climate tech roles
- **No bragging:** Focus on experience and fit, not metrics or accomplishments

### What to Avoid

- Generic opening: "I am writing to apply for..."
- Listing resume bullet points
- Mentioning multiple companies or roles in comparison
- Overly formal language or business jargon
- Metrics bragging ($10M ARR, 100+ customers, etc.)
- Spelling the company name wrong
- Forgetting to customize template placeholders

## Finding Hiring Managers

### Search Strategy

**Priority 1: LinkedIn Search**
```
[Company Name] (Director of Engineering OR VP Engineering OR Head of Engineering OR CTO OR Engineering Manager)
```

Filter by:
- Current company match
- Engineering/Product department
- Seniority level

**Priority 2: Job Posting Analysis**
- Look for "Reports to:" section
- Check posting author/recruiter connections
- Search company engineering blog for author names

**Priority 3: Company Website/About Page**
- Look for engineering leadership team
- Check "Team" or "About" pages
- LinkedIn cross-reference

**Priority 4: GitHub/Technical Community**
- Search company GitHub org for active contributors
- Look for engineering managers in commit history
- Cross-reference with LinkedIn

### Sizing Guidelines

**Startup (< 50 people):**
- Likely: CTO or co-founder
- Sometimes: Head of Engineering

**Scale-up (50-200 people):**
- Likely: VP Engineering or Head of Engineering
- Sometimes: Director of Engineering (if specific team)

**Growth Stage (200-500 people):**
- Likely: Director of Engineering
- Sometimes: VP Engineering (if senior role)

**Large Company (500+ people):**
- Likely: Director or Senior Engineering Manager
- Sometimes: VP (if very senior role)

## Follow-Up Email Generation

Use template: `/Users/forni/Craft/vocation/templates/07-job-posting-cold-outreach.md`

### Key Elements
1. **Subject line:** Title Case, reference role
2. **Reference job posting** with hyperlink to posting
3. **Forward request** to right person (polite)
4. **Brief credentials** showing technical fit (1-2 sentences)
5. **Specific interest** in their tech/mission (1-2 sentences)
6. **Fractional alternative pitch** - "rather than (or alongside) a full-time hire"
7. **Low-pressure close** with scheduling link
8. **Word count:** ~150-170 words

### Template Structure
```
Subject: [Role Title] at [Company]

Hi [First Name],

[Opening: Found posting + forward request]

[Brief credentials: Gremlin CTO + relevant experience]

[Specific interest: What excites you about their tech/mission]

[Fractional pitch: Position as alternative or complement]

[Close: Scheduling link]

Matthew Fornaciari
```

## Gmail Integration

After generating email:

1. **Create draft** using `draft_email` tool
2. **Apply labels:** `Craft` and `RYLLC`
3. **Verify:**
   - Subject line in Title Case
   - Scheduling link: https://app.reclaim.ai/m/forni/chat
   - Signature: Matthew Fornaciari
   - No sentence fragments
   - ~150-170 word count

## Process Checklist

When skill is invoked with job posting URL:

- [ ] Fetch job posting details (title, description, requirements, application questions)
- [ ] Assess role fit (mission, technical, level, work style)
- [ ] If weak fit: Report assessment and recommend not applying
- [ ] If medium/strong fit: Continue with application support
- [ ] Draft cover letter tailored to the role
- [ ] Draft responses to all application questions found
- [ ] Search for hiring manager (LinkedIn → job posting → website → GitHub)
- [ ] Generate follow-up email using template 07
- [ ] Create Gmail draft with `Craft` and `RYLLC` labels
- [ ] Report summary: fit assessment, cover letter, application responses, hiring manager found, email drafted

## Output Format

```
# Job Application Analysis: [Company] - [Role]

## Fit Assessment
- **Mission Alignment:** [score]/10 - [brief explanation]
- **Technical Fit:** [score]/10 - [brief explanation]
- **Role Level:** [score]/10 - [brief explanation]
- **Work Style:** [score]/10 - [brief explanation]
- **Overall:** [average score]/10 - [Strong/Medium/Weak Fit]

**Recommendation:** [Apply / Reconsider / Skip]

---

## Cover Letter

[Full cover letter text, 250-350 words]

---

## Application Question Responses

### [Question 1]
[Response]

### [Question 2]
[Response]

[etc.]

---

## Hiring Manager Research

**Identified:** [Name], [Title]
**LinkedIn:** [URL if found]
**Email:** [If found, otherwise "Not found - will send to general hiring contact"]

---

## Follow-Up Email

**Status:** [Draft created in Gmail / Ready to send]
**Labels:** Craft, RYLLC
**Subject:** [Subject line]

[Email preview]

---

## Next Steps

1. [Copy cover letter to job application]
2. [Copy application question responses to job portal]
3. [Review and send Gmail draft to hiring manager]
4. [Track in vocation repo: companies/[company-name].md]
```

## Resources

**Email template:**
- `/Users/forni/Craft/vocation/templates/07-job-posting-cold-outreach.md`

**Project guidelines:**
- `/Users/forni/Craft/vocation/CLAUDE.md`

**Contact tracking:**
- `/Users/forni/Craft/vocation/network/contacts.md`

**Company profiles:**
- `/Users/forni/Craft/vocation/companies/`
