# GTM-XXX: [Product/Feature Name] Go-to-Market Strategy

**ID**: GTM-XXX
**Product/Feature**: [Name - e.g., Dark Mode, Email Verification, Premium Tier]
**Launch Type**: [New Product | New Feature | Feature Enhancement | Pricing Change | Relaunch]
**Target Audience**: [Primary persona - e.g., PER-101, PER-102]
**Owner**: [Product Marketing, Product Manager, or GTM Lead]
**Created**: YYYY-MM-DD
**Launch Date**: YYYY-MM-DD (Target)
**Status**: [Planning | Ready | Launched | Post-Launch]

---

## Executive Summary

**What We're Launching**:
[1-2 sentence description of product/feature]

**Why Now**:
[Business context, market opportunity, customer demand]

**Expected Outcome**:
[Primary success metric - e.g., 1000 signups in first month, 20% feature adoption, $50k MRR]

**Investment Required**:
[Time, budget, resources - e.g., 2 weeks dev, $5k ad spend, 1 designer]

---

## Strategic Context

### Product Type
**Classification**: [From BR-XXX - Clone | Unbundle | Undercut | Slice | Wrapper | Innovation]

**Implication for GTM**:
- **Clone**: Fast launch, price-competitive messaging, land grab
- **Unbundle**: Niche focus, targeted ads, demonstrate focus advantage
- **Undercut**: Price leadership, cost comparison, volume play
- **Slice**: Wedge entry, specific use case, expand later
- **Wrapper**: Integration benefits, ecosystem play, partner channels
- **Innovation**: Educate market, thought leadership, patience required

---

### Competitive Positioning
**From**: [CFD-XXX - Competitive analysis entries]

**Primary Competitors**:
1. [Competitor A]: [Their strength, our advantage]
2. [Competitor B]: [Their strength, our advantage]

**Our Differentiation**:
[What makes us different - features, price, experience, focus]

**Target Switching Users**:
- **From**: [Which competitor's users are we targeting?]
- **Why They'll Switch**: [Specific pain point we solve that competitor doesn't]

---

### Success Metrics
**From**: [KPI-XXX - Launch metrics entries]

**Primary KPI**: [e.g., 1000 new signups]
**Secondary KPIs**:
- [e.g., 30% activation rate (users who complete onboarding)]
- [e.g., $10k MRR in first 30 days]
- [e.g., 40% feature adoption among existing users]

**Early Indicators** (Week 1):
- [e.g., 50 signups/day]
- [e.g., 20% email open rate]
- [e.g., 10% landing page conversion]

**Lagging Indicators** (Month 1-3):
- [e.g., 60% retention after 30 days]
- [e.g., 5% conversion to paid]

---

## Messaging Framework

### Value Proposition
**From**: [CFD-XXX - Value hypothesis entries from v0.1]

**Problem Statement**:
[The pain point - specific, concrete, relatable]
[Example: "Managing projects across multiple tools creates chaos and lost information."]

**Our Solution**:
[How we solve it - simple, clear, benefit-focused]
[Example: "One place for all your project work, so nothing falls through the cracks."]

**Differentiation**:
[Why us vs alternatives - unique advantage, proof point]
[Example: "Unlike generic tools, built specifically for design teams with built-in asset management."]

---

### Message Hierarchy

**Primary Message** (Headline):
[One sentence, benefit-focused, memorable]
[Example: "Project management designed for design teams"]

**Supporting Messages** (3-5 bullets):
1. [Feature → Benefit - e.g., "Built-in asset library → No more lost files"]
2. [Feature → Benefit - e.g., "Design-specific workflows → No complex setup"]
3. [Feature → Benefit - e.g., "Integrates with Figma → Work where you already are"]

**Proof Points**:
- [Social proof - e.g., "Used by 500+ design teams"]
- [Metric - e.g., "Teams ship 30% faster"]
- [Customer quote - e.g., "'Finally, a tool that gets how we work' - Design Lead at Acme"]

---

### Messaging by Audience

**For [PER-101: Primary Persona]**:
- **Hook**: [What resonates - e.g., "Tired of juggling 5 tools?"]
- **Benefit**: [Core value - e.g., "Simplify your workflow"]
- **Call to Action**: [What to do - e.g., "Try free for 14 days"]

**For [PER-102: Secondary Persona]** (if applicable):
- **Hook**: [Different pain point for this persona]
- **Benefit**: [Core value for this persona]
- **Call to Action**: [What to do]

---

## Launch Strategy

### Launch Type
**Selected Strategy**: [Beta | Soft Launch | Phased Rollout | Big Bang | Stealth | Relaunch]

**Rationale**:
[Why this strategy? - based on risk, audience size, complexity]

**Timeline**:
- **T-4 weeks**: [Preparation activities]
- **T-2 weeks**: [Content creation, beta testing]
- **T-1 week**: [Final prep, stakeholder communication]
- **Launch Day**: [Go live activities]
- **T+1 week**: [Monitoring, early optimization]
- **T+1 month**: [Review, iterate]

---

### Rollout Plan

**Phase 1** (Days 1-7):
- **Audience**: [Who - e.g., Existing users, Email list, Beta users]
- **Channels**: [Where - e.g., In-app announcement, Email]
- **Goal**: [What - e.g., 100 early adopters, feedback collection]

**Phase 2** (Days 8-21):
- **Audience**: [Expanded - e.g., Paid ads, Product Hunt]
- **Channels**: [Where]
- **Goal**: [What - e.g., 500 signups, public visibility]

**Phase 3** (Days 22-30):
- **Audience**: [Full market - e.g., PR push, partnerships]
- **Channels**: [Where]
- **Goal**: [What - e.g., 1000 signups, market presence]

---

## Channel Strategy

### Selected Channels
**From**: [Channel selection criteria based on persona, budget, product type]

**Primary Channels** (High Investment):
1. **[Channel 1 - e.g., Email Marketing]**
   - **Audience**: Existing email list (5,000 subscribers)
   - **Tactic**: 3-email sequence (announcement, feature highlight, last chance)
   - **Expected Result**: 25% open rate, 5% click-through, 50 signups
   - **Budget**: $0 (owned channel)

2. **[Channel 2 - e.g., Product Hunt]**
   - **Audience**: Early adopter community
   - **Tactic**: Coordinated launch day, prep supporters, respond to comments
   - **Expected Result**: Top 5 product of day, 200 signups
   - **Budget**: $0 (time investment)

**Secondary Channels** (Low Investment):
3. **[Channel 3 - e.g., Twitter/X]**
   - **Audience**: Design community
   - **Tactic**: Launch thread, founder story, visual demos
   - **Expected Result**: 500 impressions, 50 clicks, 10 signups
   - **Budget**: $0 (organic)

4. **[Channel 4 - e.g., LinkedIn Ads]**
   - **Audience**: Design managers (job title targeting)
   - **Tactic**: Sponsored content, case study ad
   - **Expected Result**: 10,000 impressions, 100 clicks, 5 signups
   - **Budget**: $500 (test budget)

**Channels NOT Using** (and Why):
- [Channel - e.g., TV Ads]: Too expensive, not targeted enough
- [Channel - e.g., Cold calling]: Not product-led, doesn't match buying behavior

---

### Channel-Specific Tactics

**[Channel 1: Email Marketing]**:

**Email 1: Announcement** (Launch Day):
- **Subject**: [e.g., "Introducing Dark Mode (you asked, we built it)"]
- **Body**: Problem → Solution → Screenshots → CTA ("Enable now")
- **CTA**: In-app link to enable feature

**Email 2: Feature Highlight** (Day 3):
- **Subject**: [e.g., "3 ways Dark Mode boosts your productivity"]
- **Body**: Benefit-focused bullets, customer quotes
- **CTA**: Tutorial video link

**Email 3: Engagement** (Day 7):
- **Subject**: [e.g., "Haven't tried Dark Mode yet?"]
- **Body**: Social proof (X% of users enabled), FOMO
- **CTA**: One-click enable

---

**[Channel 2: Product Hunt]**:

**Pre-Launch** (Week Before):
- Recruit 20 supporters (team, customers, friends)
- Prepare assets (tagline, screenshots, demo video)
- Schedule launch for Tuesday-Thursday (best days)

**Launch Day**:
- Go live at 12:01 AM PT (full day visibility)
- Founder posts launch comment (personal story, why we built this)
- Team upvotes and comments
- Respond to EVERY comment within 1 hour

**Post-Launch** (Day After):
- Thank supporters
- Share results on social media
- Add "Featured on Product Hunt" badge to site

---

## Content & Assets

### Required Assets

**Launch Assets** (Must Have):
- [x] Landing page: [URL - e.g., yourproduct.com/dark-mode]
- [x] Product screenshots: [5+ high-quality images]
- [x] Demo video: [60-90 second overview]
- [x] Launch blog post: [Founder perspective, why we built this]
- [x] Social media graphics: [3-5 variations for different platforms]

**Supporting Assets** (Should Have):
- [ ] Customer testimonials: [3-5 quotes with photos]
- [ ] Case study: [One detailed customer story]
- [ ] FAQ page: [Common questions answered]
- [ ] Comparison page: [Us vs Competitor A, B]

**Nice to Have**:
- [ ] Launch video: [Founder announcement, team behind-the-scenes]
- [ ] Press kit: [For journalists - screenshots, fact sheet, quotes]
- [ ] Partner co-marketing: [If launching with integration partner]

---

### Content Calendar

**T-2 Weeks**:
- [ ] Teaser post on social media ("Something new is coming...")
- [ ] Email to VIP users (early access offer)

**T-1 Week**:
- [ ] Blog post: "Behind the scenes" (building the feature)
- [ ] Social media: Sneak peek screenshot

**Launch Day**:
- [ ] Launch blog post published
- [ ] Email to full list
- [ ] Social media: Announcement thread
- [ ] Product Hunt: Go live
- [ ] In-app: Announcement banner
- [ ] Support: FAQ updated

**T+1 Day**:
- [ ] Social media: User reactions, early wins
- [ ] Support: Monitor for issues

**T+1 Week**:
- [ ] Blog post: "First 1000 users" (metrics, learnings)
- [ ] Email: Highlight popular use cases

**T+1 Month**:
- [ ] Case study published
- [ ] Post-mortem: What worked, what didn't

---

## Internal Coordination

### Team Responsibilities

**Product Marketing**:
- [ ] Messaging framework
- [ ] Landing page copy
- [ ] Launch blog post
- [ ] Email campaign

**Product Management**:
- [ ] In-app announcement
- [ ] User onboarding flow
- [ ] Metrics tracking
- [ ] Feature flag management

**Engineering**:
- [ ] Feature complete and tested
- [ ] Feature flag implemented
- [ ] Monitoring dashboards
- [ ] Rollback plan ready

**Design**:
- [ ] Landing page design
- [ ] Social media graphics
- [ ] Demo video
- [ ] In-app announcement design

**Customer Success / Support**:
- [ ] FAQ documentation
- [ ] Support team training
- [ ] Canned responses prepared
- [ ] Escalation plan

**Sales** (if applicable):
- [ ] Sales enablement deck
- [ ] Pricing / packaging clarity
- [ ] Demo script

---

### Communication Plan

**Internal Kickoff** (T-2 Weeks):
- [ ] All-hands announcement: "We're launching X on Y date"
- [ ] Slack channel: #launch-gtm-xxx
- [ ] Weekly sync: GTM status, blockers

**Launch Day**:
- [ ] #general: "We're live!" with link
- [ ] All team members share on personal social media
- [ ] Real-time monitoring in #launch-gtm-xxx

**Post-Launch**:
- [ ] Daily metrics update (first week)
- [ ] Weekly retrospective (first month)
- [ ] Post-mortem presentation (after 1 month)

---

## Risk Mitigation

### Launch Risks

**Risk 1: Low Adoption**
- **Probability**: Medium
- **Impact**: High (business case fails)
- **Mitigation**: Pre-launch validation (beta users, surveys), clear value prop, easy onboarding
- **Contingency**: Iterate messaging, extend promotion period, offer incentive

**Risk 2: Technical Issues**
- **Probability**: Medium
- **Impact**: High (reputation damage)
- **Mitigation**: Phased rollout (10% → 50% → 100%), monitoring, rollback plan
- **Contingency**: Rollback immediately, communicate transparently, offer apology/credit

**Risk 3: Competitive Response**
- **Probability**: Low (for small features), High (for major product launches)
- **Impact**: Medium (they copy us)
- **Mitigation**: Move fast, build moat (quality, brand, network effects), keep iterating
- **Contingency**: Emphasize our unique advantages, customer service, ecosystem

**Risk 4: Negative Customer Reaction**
- **Probability**: Low
- **Impact**: Medium (churn, bad reviews)
- **Mitigation**: Beta testing with representative users, clear communication, optional features
- **Contingency**: Address feedback publicly, iterate quickly, grandfather old plans if needed

---

## Budget

**Total Budget**: $[Amount]

**Breakdown**:
- **Paid Ads**: $[Amount - e.g., $2,000 for LinkedIn + Google]
- **Content Creation**: $[Amount - e.g., $500 for demo video]
- **Tools**: $[Amount - e.g., $100 for email tool overage]
- **Partnerships/Sponsorships**: $[Amount - e.g., $1,000 for newsletter sponsorship]
- **Contingency**: $[Amount - e.g., $400 buffer]

**ROI Calculation**:
- **Investment**: $3,000
- **Expected New Customers**: 100
- **LTV per Customer**: $500
- **Expected Revenue**: $50,000
- **ROI**: 16.7x (= $50k / $3k)

---

## Success Criteria

### Launch Declared Successful If:
- [x] [Primary KPI met - e.g., 1000 signups in first 30 days]
- [x] [Secondary KPI met - e.g., 30% activation rate]
- [x] [Quality threshold - e.g., NPS > 40]

### Launch Declared Needs Iteration If:
- [ ] [Primary KPI below threshold - e.g., < 500 signups]
- [ ] [High drop-off - e.g., < 10% activation]
- [ ] [Negative feedback - e.g., NPS < 0]

### Pivot Triggers:
- **No demand signal** (< 100 signups despite full promotion)
- **Wrong audience** (signups but low engagement)
- **Wrong channel** (high cost per acquisition, unsustainable)

---

## Post-Launch Plan

### Week 1:
- [ ] Daily metrics review
- [ ] Rapid iteration on messaging (if needed)
- [ ] Respond to all user feedback

### Week 2-4:
- [ ] Optimize top-of-funnel (landing page, ads)
- [ ] Optimize onboarding (reduce drop-off)
- [ ] Collect testimonials from happy users

### Month 2-3:
- [ ] Case studies from early adopters
- [ ] Expand to additional channels
- [ ] Iterate product based on feedback

### Post-Mortem (After 1 Month):
- [ ] Review all KPIs vs targets
- [ ] Document what worked
- [ ] Document what didn't
- [ ] Share learnings with team
- [ ] Plan next launch improvements

---

## Linked IDs

**Personas**:
- [PER-XXX]: [Primary persona targeted]
- [PER-YYY]: [Secondary persona]

**Competitive Analysis**:
- [CFD-XXX]: [Competitor landscape]
- [CFD-YYY]: [Market positioning]

**Features**:
- [FEA-XXX]: [Features being launched]

**User Journeys**:
- [UJ-XXX]: [User journey enabled by this launch]

**Metrics**:
- [KPI-XXX]: [Launch metrics]

**Business Rules**:
- [BR-XXX]: [Pricing model, product type, moat]

---

## Version History

| Version | Date | Change | Updated By |
|---------|------|--------|------------|
| 1.0 | YYYY-MM-DD | Initial GTM plan | [Name] |
| | | | |

---

## Notes

[Any additional context, assumptions, dependencies, or open questions]

---

*Template: Use this to create GTM-XXX entries in SoT or separate GTM strategy documents.*
