# Messaging Frameworks

**Purpose**: Templates and patterns for crafting product messaging that resonates with target audiences and drives conversion.

---

## Core Messaging Formula

```
[Target Audience] who [Pain Point] can now [Outcome] with [Product/Feature] unlike [Alternative] because [Unique Advantage].
```

**Example**:
"Design teams who struggle with project chaos across multiple tools can now ship faster with DesignHub, unlike generic project managers, because it's purpose-built for design workflows with integrated asset management."

---

## Framework 1: Problem-Solution-Proof (PSP)

**Structure**:
1. **Problem**: What pain does customer feel? (Specific, relatable)
2. **Solution**: How do we solve it? (Simple, clear benefit)
3. **Proof**: Why should they believe us? (Social proof, metrics, demo)

---

### Example: Superhuman (Email Client)

**Problem**:
"Email is slow. The average professional spends 3 hours/day in email, yet still ends the day with a full inbox."

**Solution**:
"Superhuman is the fastest email experience ever made. Get through your inbox twice as fast with keyboard shortcuts, instant search, and AI triage."

**Proof**:
"Used by executives at Uber, Facebook, and Dropbox. Customers save 4+ hours per week."

---

### Good Pattern: Specific Pain

**Good**:
"Designers waste 2 hours/day searching for files across Dropbox, Figma, and Slack."

**Bad**:
"Managing design files is hard."

**Why Good Wins**: Specific = relatable. Quantified = credible.

---

### Good Pattern: Outcome-Focused Solution

**Good**:
"Find any design file in < 5 seconds with unified search across all your tools."

**Bad**:
"We have a search feature."

**Why Good Wins**: Benefit (speed, outcome) > Feature (search).

---

### Good Pattern: Credible Proof

**Good**:
- "500+ design teams, including Airbnb and Stripe"
- "Designers ship 30% faster (measured across 200 teams)"
- "4.8/5 stars from 1,200 reviews"

**Bad**:
- "Many teams use us"
- "You'll love it"
- "Award-winning design" (whose award?)

**Why Good Wins**: Specific > Vague. Quantified > Subjective.

---

## Framework 2: Before-After-Bridge (BAB)

**Structure**:
1. **Before**: What's the current frustrating state?
2. **After**: What's the desired state?
3. **Bridge**: How does our product get you there?

---

### Example: Notion (Productivity)

**Before**:
"Your team's knowledge is scattered. Meeting notes in Docs, tasks in Asana, wikis in Confluence, files in Drive. Finding anything takes forever."

**After**:
"Imagine one workspace where everything lives. Notes, tasks, wikis, databases—all connected and searchable in seconds."

**Bridge**:
"Notion gives you that workspace. Customize it to your team's workflow, integrate your tools, and finally have one source of truth."

---

### Good Pattern: Paint the "After" Vividly

**Good**:
"Ship features in days, not weeks. Your team moves fast, stakeholders stay informed, and nothing falls through the cracks."

**Bad**:
"Project management will be better."

**Why Good Wins**: Concrete, tangible outcome vs abstract promise.

---

## Framework 3: Features-Advantages-Benefits (FAB)

**Structure**:
- **Feature**: What it is (technical capability)
- **Advantage**: How it's different (vs alternatives)
- **Benefit**: Why it matters (user outcome)

---

### Example: Figma

**Feature**:
"Multiplayer editing—multiple designers can edit the same file simultaneously."

**Advantage**:
"Unlike Sketch or Adobe XD, which require file passing or cloud syncing, Figma works like Google Docs."

**Benefit**:
"Your team ships faster because no one is blocked waiting for files or merging changes."

---

### Conversion Hierarchy

Most messaging fails because it stops at **Features**. Always climb to **Benefits**.

```
Feature → "What it is" → Weak (they don't care WHAT)
Advantage → "How it's different" → Medium (they might care HOW)
Benefit → "Why it matters to YOU" → Strong (they ALWAYS care WHY)
```

**Example Progression**:

**Feature** (Weak):
"Dark mode available"

**Advantage** (Medium):
"Unlike competitors, our dark mode adapts to ambient light automatically"

**Benefit** (Strong):
"Reduce eye strain during late-night work sessions—your eyes will thank you"

---

## Framework 4: 5-Point Value Proposition

**Structure**:
1. **Headline**: One sentence, benefit-focused
2. **Subheadline**: Elaborate on headline, who it's for
3. **3 Key Benefits**: Bullets, each benefit = outcome
4. **Visual**: Screenshot, demo, or illustration
5. **Call to Action**: What to do next

---

### Example: Stripe

**Headline**:
"Payments infrastructure for the internet"

**Subheadline**:
"Millions of companies of all sizes use Stripe to accept payments and manage their businesses online."

**3 Key Benefits**:
- Start fast: Integrate payments in minutes with our APIs
- Scale globally: Accept 135+ currencies, built for international growth
- Prevent fraud: Machine learning blocks fraud while approving more good transactions

**Visual**: Code snippet + dashboard screenshot

**CTA**: "Start now →" (clear action)

---

### Good Pattern: Headline Tests

**Test 1: Clarity Over Cleverness**

**Good**: "Project management for design teams"
**Bad**: "Where design comes alive" (what does that mean?)

**Test 2: Benefit Over Feature**

**Good**: "Ship faster with AI-powered code reviews"
**Bad**: "AI-powered code reviews" (so what?)

**Test 3: Audience-Specific**

**Good**: "Accounting software for freelancers"
**Bad**: "Accounting software" (for who?)

---

## Framework 5: AIDA (Attention-Interest-Desire-Action)

**Structure**:
1. **Attention**: Hook (bold claim, question, statistic)
2. **Interest**: Elaborate (why this matters)
3. **Desire**: Proof (make them want it)
4. **Action**: CTA (what to do)

---

### Example: Landing Page Flow

**Attention** (Hero):
"Email doesn't have to be a full-time job."

**Interest** (Subhero):
"The average professional spends 3 hours/day in email. Superhuman gets you to inbox zero in under 30 minutes."

**Desire** (Body):
- Keyboard shortcuts → 2x faster than mouse
- Instant search → Find any email in < 1 second
- AI triage → Focus on what matters
- [Customer testimonials]: "I save 4 hours/week with Superhuman" —CEO, Uber

**Action** (CTA):
"Get Superhuman → [Book Demo]"

---

## Messaging by Persona

### B2B vs B2C Messaging

| Dimension | B2B | B2C |
|-----------|-----|-----|
| **Focus** | ROI, efficiency, risk reduction | Emotion, aspiration, instant gratification |
| **Proof** | Case studies, metrics, logos | Reviews, social proof, influencers |
| **Tone** | Professional, credible, thorough | Conversational, fun, aspirational |
| **CTA** | "Book demo", "Talk to sales", "Free trial" | "Start free", "Buy now", "Join 10k users" |

---

### Example: Same Product, Different Personas

**Product**: Time-tracking software

**For Freelancer (B2C)**:
- **Headline**: "Get paid for every minute you work"
- **Benefit**: "Never underbill again—track time automatically and invoice clients instantly"
- **Proof**: "Freelancers bill 18% more on average"
- **CTA**: "Start free trial"

**For Agency Owner (B2B)**:
- **Headline**: "See exactly where your team's time goes"
- **Benefit**: "Increase billable utilization from 60% to 80% with automatic time tracking and project insights"
- **Proof**: "Agencies increase revenue 25% in first year"
- **CTA**: "Book a demo"

---

## Messaging for Product Types

### Clone (Fast Follow)

**Positioning**: "Better X for Y audience"

**Example**: "Linear is Jira for fast-moving teams"

**Messaging Focus**:
- Acknowledge incumbent ("Love Jira but...")
- Emphasize speed/simplicity
- Show migration path

**Good Example (Linear)**:
"Built for high-performance teams. Unlike Jira, Linear is fast, opinionated, and delightful to use."

---

### Unbundle (Niche Focus)

**Positioning**: "We do ONE thing better than anyone"

**Example**: "Calendly is scheduling, nothing else"

**Messaging Focus**:
- Reject complexity
- Emphasize focus
- Show depth over breadth

**Good Example (Calendly)**:
"Calendly takes the work out of scheduling. Unlike calendar apps that do everything poorly, Calendly does scheduling perfectly."

---

### Undercut (Price Leader)

**Positioning**: "Same features, better price"

**Example**: "Intercom, but affordable"

**Messaging Focus**:
- Lead with price
- Show feature parity
- Emphasize value

**Good Example (Customer.io)**:
"All the features of Intercom at 1/3 the price. No compromises, no contracts."

---

### Slice (Wedge Entry)

**Positioning**: "For [specific use case/industry]"

**Example**: "GitHub for data science" (DVC)

**Messaging Focus**:
- Hyper-specific pain
- Industry jargon (show you understand them)
- Verticalized features

**Good Example (Retool)**:
"Build internal tools 10x faster. Stop wrestling with React to build admin panels. Drag, drop, ship."

---

### Wrapper (Integration Play)

**Positioning**: "Connects X + Y + Z"

**Example**: "Zapier connects 3,000 apps"

**Messaging Focus**:
- Ecosystem breadth
- No-code/ease
- Time savings

**Good Example (Zapier)**:
"Connect your apps and automate workflows. No code required."

---

### Innovation (New Category)

**Positioning**: "The future of [category]"

**Example**: "Notion is the future of productivity"

**Messaging Focus**:
- Educate market (new concept)
- Show "before" as broken
- Use analogies ("Google Docs for X")

**Good Example (Figma, early days)**:
"Design tools are stuck in the desktop era. Figma brings design to the browser—real-time, collaborative, and fast."

---

## Messaging Testing Framework

### Headline A/B Test Template

Test variants across:
1. **Clarity vs Emotion**
   - A: "Project management for design teams" (clear)
   - B: "Where great design teams thrive" (emotional)

2. **Benefit vs Feature**
   - A: "Ship projects 2x faster" (benefit)
   - B: "Built-in asset management and workflows" (feature)

3. **Audience-Specific vs General**
   - A: "For design teams at startups" (specific)
   - B: "For modern teams" (general)

---

### Metrics to Track

**Top of Funnel**:
- **Click-Through Rate**: Does headline get clicks? (Good: >2%)
- **Bounce Rate**: Do visitors leave immediately? (Good: <50%)
- **Time on Page**: Do they read? (Good: >30 seconds)

**Middle of Funnel**:
- **CTA Click Rate**: Do they want to try? (Good: >10%)
- **Signup Rate**: Do they sign up? (Good: >20% of CTA clicks)

**Bottom of Funnel**:
- **Activation**: Do they complete onboarding? (Good: >40%)
- **Retention**: Do they come back? (Good: >50% Week 2)

---

## Common Messaging Mistakes

### Mistake 1: Feature Dump

**Bad**:
"We have 50 features: dark mode, real-time sync, version history, comments, @mentions, integrations, API, webhooks, SSO, SAML..."

**Fix**:
Lead with 3 benefits, features as proof points.

**Good**:
"Ship faster (real-time collaboration), stay organized (version history and search), work your way (100+ integrations)."

---

### Mistake 2: Jargon Without Translation

**Bad**:
"Leverage our AI-powered, cloud-native, microservices architecture to optimize your tech stack."

**Fix**:
Translate to business outcome.

**Good**:
"Our system scales automatically so your app stays fast even during traffic spikes."

---

### Mistake 3: "We" Language

**Bad**:
"We are the leading provider of innovative solutions..."

**Fix**:
"You" language, customer-focused.

**Good**:
"You get the fastest email experience ever made..."

---

### Mistake 4: No Differentiation

**Bad**:
"Easy to use, powerful, and secure" (everyone claims this)

**Fix**:
Specific, defensible claim.

**Good**:
"The only design tool that works in the browser with real-time multiplayer editing."

---

### Mistake 5: Burying the Benefit

**Bad** (Hidden benefit):
"Our patented algorithm uses machine learning to analyze millions of data points and optimize..." (so what?)

**Fix** (Lead with benefit):
"Block 98% of fraud while approving 5% more good transactions." (...using our ML algorithm)

---

## Messaging Checklist

Before launching, test your messaging:

- [ ] **Clarity Test**: Can a 12-year-old understand what you do?
- [ ] **Benefit Test**: Does every feature mention translate to user outcome?
- [ ] **Proof Test**: Do you back up claims with numbers, testimonials, or demos?
- [ ] **Differentiation Test**: Could a competitor say the same thing?
- [ ] **Audience Test**: Is it clear WHO this is for?
- [ ] **Urgency Test**: Is there a reason to act now (not later)?
- [ ] **CTA Test**: Is it crystal clear what action to take?

---

*Reference: Use these frameworks when crafting GTM messaging in `prd-v09-gtm-strategy` skill.*
