# Launch Validation Criteria

**Purpose**: Decision framework for determining if a launch succeeded, needs iteration, or should be killed.

---

## Go/No-Go Framework

### Green Light (Success - Scale It)

**Quantitative**:
- ✅ Primary KPI met or exceeded
- ✅ D30 retention > 30% (SaaS) or > 40% (Consumer)
- ✅ NPS > 40
- ✅ Organic growth (k > 0.5 or 20%+ from referrals)
- ✅ Cohorts stable or improving

**Qualitative**:
- ✅ Users saying "I love this"
- ✅ Unsolicited testimonials
- ✅ Feature requests (want more)
- ✅ Hard to keep up with demand

**Action**: Scale marketing, invest in product, hire team

---

### Yellow Light (Needs Work - Iterate)

**Quantitative**:
- ⚠️ Primary KPI at 50-90% of target
- ⚠️ D30 retention 20-30%
- ⚠️ NPS 20-40
- ⚠️ Some organic growth (k = 0.2-0.5)
- ⚠️ Cohorts declining but not terrible

**Qualitative**:
- ⚠️ Users saying "It's okay"
- ⚠️ Feedback is constructive, not enthusiastic
- ⚠️ Small group loves it, most indifferent
- ⚠️ Can keep up with demand easily

**Action**: Iterate messaging, improve onboarding, extend timeline, user research

---

### Red Light (Failure - Pivot or Kill)

**Quantitative**:
- ❌ Primary KPI < 50% of target
- ❌ D30 retention < 20%
- ❌ NPS < 20
- ❌ No organic growth (k < 0.2)
- ❌ Cohorts degrading rapidly

**Qualitative**:
- ❌ Users saying "This isn't for me"
- ❌ Complaints or indifference
- ❌ No one would care if product disappeared
- ❌ Crickets (no demand)

**Action**: Kill feature, pivot to different problem, or completely redesign

---

## Validation Checklist (30 Days Post-Launch)

### Acquisition Validation

- [ ] **Signups met target** (or within 20%)
- [ ] **Signups growing** week-over-week (not declining)
- [ ] **Attribution clear** (know which channels work)
- [ ] **CAC sustainable** (< 1/3 of LTV)

**Pass**: 3+ of 4 criteria met
**Fail**: < 2 criteria met

---

### Activation Validation

- [ ] **Activation rate > 40%**
- [ ] **Time to value < target** (see product type benchmarks)
- [ ] **Onboarding completion > 60%**
- [ ] **Aha moment reached** (users "get it")

**Pass**: 3+ of 4 criteria met
**Fail**: < 2 criteria met

---

### Retention Validation

- [ ] **D7 retention > 40%**
- [ ] **D30 retention > 30%** (or > 40% for consumer)
- [ ] **Retention curve flattening** (not heading to zero)
- [ ] **Cohorts stable** (not degrading week-over-week)

**Pass**: 3+ of 4 criteria met
**Fail**: < 2 criteria met

---

### Revenue Validation (If Applicable)

- [ ] **Free → Paid conversion > 2%** (freemium) or > 10% (trial)
- [ ] **MRR growing** week-over-week
- [ ] **ARPU meeting expectations**
- [ ] **At least 10 paying customers** (proof of willingness to pay)

**Pass**: 3+ of 4 criteria met
**Fail**: < 2 criteria met

---

### Qualitative Validation

- [ ] **NPS > 40**
- [ ] **10+ unsolicited positive testimonials**
- [ ] **Users sharing organically** (social media, word-of-mouth)
- [ ] **Would users be "very disappointed" if product went away?** (PMF question)

**Pass**: 3+ of 4 criteria met
**Fail**: < 2 criteria met

---

## Overall Launch Grade

**A (Exceptional)**:
- All 5 categories PASS
- Primary KPI exceeded by 20%+
- Action: Scale aggressively

**B (Success)**:
- 4 of 5 categories PASS
- Primary KPI met
- Action: Scale with confidence

**C (Needs Work)**:
- 3 of 5 categories PASS
- Primary KPI at 70-90% of target
- Action: Iterate for 30 more days, then re-evaluate

**D (Struggling)**:
- 2 of 5 categories PASS
- Primary KPI at 50-70% of target
- Action: Major iteration or pivot

**F (Failure)**:
- 0-1 categories PASS
- Primary KPI < 50% of target
- Action: Kill or complete redesign

---

## Pivot Triggers

### When to Pivot (Not Kill)

**Trigger 1: Wrong Audience**
- **Signal**: Low signups BUT high engagement from small segment
- **Example**: Built for agencies, but freelancers love it
- **Action**: Reposition for freelancers, relaunch

**Trigger 2: Wrong Messaging**
- **Signal**: High signups, terrible activation
- **Example**: Messaging attracted wrong users (not target persona)
- **Action**: Rewrite messaging, target different segment

**Trigger 3: Wrong Pricing**
- **Signal**: High usage, no one paying
- **Example**: Priced too high, or value prop unclear
- **Action**: Test new pricing model (lower tier, usage-based, etc.)

**Trigger 4: Wrong Channel**
- **Signal**: High CAC, low conversion
- **Example**: Advertising on LinkedIn but audience is on Reddit
- **Action**: Kill paid ads, test organic channels

---

### When to Kill (Not Pivot)

**Trigger 1: No Demand**
- **Signal**: Low signups despite full promotional push
- **Example**: Promoted to email list, Product Hunt, ads → crickets
- **Action**: Kill feature, wrong problem to solve

**Trigger 2: No Retention**
- **Signal**: Users try once, never return
- **Example**: D7 retention < 20%, heading to zero
- **Action**: Kill feature, no "aha moment"

**Trigger 3: Better Alternatives**
- **Signal**: Users switch to competitors immediately
- **Example**: Launched project tool, users prefer Asana
- **Action**: Kill feature, can't compete

**Trigger 4: Opportunity Cost**
- **Signal**: This feature distracting from core product
- **Example**: Side feature getting lukewarm reception, core product suffering
- **Action**: Kill feature, refocus on core

---

## Early Indicator Thresholds (Week 1)

**Purpose**: Don't wait 30 days to know you're failing

### Week 1 Validation

**Acquisition**:
- **Target**: 10% of Month 1 goal
- **Example**: Month 1 goal = 1,000 signups → Week 1 should have 100
- **Red Flag**: < 50 signups

**Activation**:
- **Target**: > 40% activation rate
- **Red Flag**: < 30% activation

**Retention**:
- **Target**: D1 retention > 50%
- **Red Flag**: D1 retention < 40%

**NPS**:
- **Target**: NPS > 30 (early feedback)
- **Red Flag**: NPS < 20

**If 2+ Red Flags in Week 1**: Don't wait for Month 1, iterate NOW

---

## Case Study Decision Matrix

### Example 1: Dark Mode Feature Launch

**Month 1 Results**:
- Signups: 1,000 (target: 1,000) ✅
- Activation: 25% (target: 30%) ⚠️
- D30 Retention: 35% (target: 30%) ✅
- NPS: 45 ✅

**Categories**:
- Acquisition: PASS ✅
- Activation: FAIL (25% < 40%) ❌
- Retention: PASS ✅
- Qualitative: PASS ✅

**Grade**: B (3 of 4 PASS)

**Decision**: SUCCESS - Scale, but improve onboarding to boost activation

**Action**: A/B test in-app prompts, improve tutorial

---

### Example 2: Premium Tier Launch

**Month 1 Results**:
- Signups: 200 (target: 500) ❌
- Activation: 60% (target: 40%) ✅
- D30 Retention: 50% ✅
- Revenue: 5 paid (target: 20) ❌
- NPS: 50 ✅

**Categories**:
- Acquisition: FAIL (200 < 500) ❌
- Activation: PASS ✅
- Retention: PASS ✅
- Revenue: FAIL (5 < 10) ❌
- Qualitative: PASS ✅

**Grade**: C (3 of 5 PASS)

**Decision**: ITERATE - Users love it (high NPS, retention), but not enough aware

**Action**: Increase promotion, improve messaging, extend timeline 30 days

---

### Example 3: Social Feature Launch

**Month 1 Results**:
- Signups: 2,000 (target: 1,000) ✅
- Activation: 15% (target: 40%) ❌
- D7 Retention: 10% ❌
- D30 Retention: 5% ❌
- NPS: 15 ❌

**Categories**:
- Acquisition: PASS ✅
- Activation: FAIL ❌
- Retention: FAIL ❌
- Qualitative: FAIL ❌

**Grade**: F (1 of 4 PASS)

**Decision**: KILL - Signups high but no one using it (wrong feature)

**Action**: Remove feature, learn from feedback, build different feature

---

## Red Flag Patterns

### Pattern 1: High Signups, No Usage

**Symptoms**: 1,000 signups, 10% activation

**Diagnosis**: Messaging attracted wrong people OR onboarding broken

**Test**: Interview non-activated users
- Wrong problem? → Kill feature
- Onboarding broken? → Fix and relaunch

---

### Pattern 2: High Usage, No Growth

**Symptoms**: 100 users, 90% retention, but no new signups

**Diagnosis**: Niche product OR poor marketing

**Test**: Ask users to refer friends
- They won't refer? → Product too niche, cap growth expectations
- They refer but friends don't sign up? → Messaging problem

---

### Pattern 3: High Churn, Good NPS

**Symptoms**: NPS 50, but D30 retention 10%

**Diagnosis**: Users LOVE it... briefly (novelty wears off)

**Test**: Cohort analysis
- All cohorts churn? → Novelty product, not habit-forming
- Early cohorts retained? → New users wrong fit

---

### Pattern 4: Good Metrics, No Revenue

**Symptoms**: 40% retention, NPS 50, but 0% paid conversion

**Diagnosis**: Free tier too generous OR pricing mismatch

**Test**: Survey users "Would you pay $X?"
- "No" → Wrong pricing OR wrong monetization model
- "Yes" → Increase friction on free tier

---

## 90-Day Review Framework

**Month 1**: Launch validation (pass/fail on primary KPI)

**Month 2**: Iteration validation (did changes improve metrics?)

**Month 3**: Scale decision (invest or maintain?)

**Questions to Answer**:
1. Did we hit Month 1 primary KPI? (Go/No-Go)
2. Are cohorts improving Month 1 → Month 2? (Iteration working?)
3. Is organic growth starting? (Ready to scale?)
4. Is CAC sustainable? (Unit economics work?)
5. Are users happy? (NPS > 40, testimonials?)

**Outcome Matrix**:
- **5 Yes**: Scale aggressively
- **4 Yes**: Scale cautiously
- **3 Yes**: Maintain, keep iterating
- **2 Yes**: Pivot or significantly change
- **0-1 Yes**: Kill

---

*Reference: Use these criteria to determine launch success in `prd-v09-launch-metrics` skill.*
