# Static Pages

## Contents

- [Overview](#overview)
- [FAQ Page](#faq-page)
- [About Page](#about-page)
- [Contact Page](#contact-page)
- [Shipping and Returns](#shipping-and-returns)
- [Privacy Policy and Terms](#privacy-policy-and-terms)
- [Size Guide](#size-guide)
- [Mobile and SEO](#mobile-and-seo)
- [Checklist](#checklist)

## Overview

Static pages provide essential information about the store, policies, and customer support. Purpose: Build trust, reduce support inquiries, meet legal requirements, improve SEO.

### Essential Static Pages

**Required:**
- Privacy Policy (legally required in most regions)
- Terms and Conditions
- Shipping and Returns
- Contact

**Strongly recommended:**
- FAQ (Frequently Asked Questions)
- About Us

**Optional:**
- Size Guide (for apparel stores)
- Store Locator (if physical stores)

## FAQ Page

### Purpose and Structure

**Purpose**: Answer common customer questions, reduce support inquiries, improve purchase confidence.

**Common FAQ categories:**
- Ordering and Payment
- Shipping and Delivery
- Returns and Exchanges
- Product Information
- Account Management

### Layout Pattern: Accordion (Recommended)

Question as clickable header, answer hidden by default, click to expand. Compact, scannable format.

**Example:**
```
Frequently Asked Questions

Ordering and Payment

▸ How do I place an order?
▸ What payment methods do you accept?
▸ Is it safe to use my credit card?

Shipping and Delivery

▸ How long does shipping take?
▸ Do you ship internationally?
```

**Alternative: All Expanded**
All questions and answers visible. Better for few questions (<10), good for SEO (all content visible), easy to Ctrl+F search.

### Search Functionality

**FAQ search** (for extensive FAQs):
Search box at top, real-time filtering as user types, highlights matching questions, "No results" state with contact link.

### Content Guidelines

**Question format:**
Clear, concise, use customer language, start with question words (How, What, When).

**Answer format:**
Direct answer first sentence, additional details if needed, bullet points for lists, link to related pages, 2-4 sentences ideal.

## About Page

### Purpose and Content

**Purpose**: Tell brand story, build trust and connection, showcase values and mission, differentiate from competitors.

**Key sections:**
- Brand story/history (how the company started)
- Mission and values (3-5 core values)
- Why choose us (what makes you different)
- Sustainability/social responsibility (if applicable)

### Layout Structure

**Hero section:**
Large image (team, products, brand imagery), headline (brand tagline or mission), brief intro paragraph (2-3 sentences).

**Story section:**
3-5 paragraphs, conversational tone, focus on customer benefits.

**Values section:**
3-5 core values with icon or image for each, brief description (1-2 sentences).

**Call-to-action:**
Shop products, join newsletter, follow on social media.

## Contact Page

### Contact Methods

**Essential:**
- Contact form (primary)
- Email address
- Phone number (optional)
- Business hours
- Response time expectation ("We respond within 24 hours")

**Optional:**
- Live chat button
- FAQ link ("Find answers faster")
- Social media links
- Physical address (if applicable)

### Contact Form

**Form fields:**
- Name (required)
- Email (required)
- Subject or Topic (dropdown, optional)
- Message (textarea, required)
- Order number (optional, for order inquiries)
- Submit button

**Form features:**
Clear field labels, placeholder examples, required field indicators, email validation, success confirmation.

## Shipping and Returns

### Shipping Information

**Key sections:**
- Shipping methods and costs (table format)
- Delivery timeframes
- International shipping (if applicable)
- Order processing time ("Orders placed by 2pm EST ship same day")
- Tracking information
- Shipping restrictions

**Shipping Methods Table Format:**
```
Method          | Cost      | Delivery Time
──────────────────────────────────────────
Standard        | $5.99     | 5-7 business days
Express         | $12.99    | 2-3 business days
Overnight       | $24.99    | Next business day
Free Shipping   | Free      | Orders over $50
```

### Returns and Exchanges

**Key information:**
- Return window (e.g., 30 days)
- Return conditions (unused, tags attached, etc.)
- Refund method (original payment, store credit)
- Return shipping cost
- Exchange process
- Non-returnable items

**Return process steps:**
```
How to Return an Item

1. Initiate Return
   Log into your account and select the order

2. Print Return Label
   We'll email you a prepaid shipping label

3. Pack and Ship
   Include all original packaging and tags

4. Receive Refund
   Refunds processed within 5-7 business days
```

## Privacy Policy and Terms

### Privacy Policy

**Purpose**: Legal requirement in most regions (GDPR, CCPA compliance), explain data collection and use, build customer trust.

**Key sections:**
- Information collected
- How information is used
- Data sharing and disclosure
- Cookies and tracking
- User rights (access, deletion, etc.)
- Data security measures
- Contact for privacy inquiries
- Last updated date

**Layout:**
Table of contents (for long policies), clear section headings, numbered or bulleted lists, plain language, last updated date at top.

**Important**: Consult legal counsel for content, include required disclosures, update regularly.

### Terms and Conditions

**Purpose**: Legal agreement between store and customer, define rules and limitations, protect business legally.

**Key sections:**
- Acceptance of terms
- Product descriptions and pricing
- Order acceptance and cancellation
- Payment and billing
- Shipping and delivery
- Returns and refunds
- Intellectual property
- Limitation of liability
- Dispute resolution
- Changes to terms

**Layout:**
Numbered sections (1, 1.1, 1.2), table of contents for long documents, clear section titles, anchor links to sections.

## Size Guide

**Purpose (for apparel/footwear stores)**:
Help customers choose correct size, reduce returns due to sizing issues, increase purchase confidence.

**Content:**
- Size charts (numeric measurements) - use proper table markup
- How to measure instructions with illustrations
- Fit descriptions (slim fit, relaxed, etc.)
- Model measurements (for reference)
- Size conversion chart (US, EU, UK)

**Size Chart Format:**
```
Women's Tops Size Guide

Size  | Bust      | Waist     | Hips
─────────────────────────────────────
XS    | 32-33"    | 24-25"    | 35-36"
S     | 34-35"    | 26-27"    | 37-38"
M     | 36-37"    | 28-29"    | 39-40"
L     | 38-40"    | 30-32"    | 41-43"
XL    | 41-43"    | 33-35"    | 44-46"
```

**Accessibility:**
Use proper table markup (not images), clear column headers, screen reader friendly, mobile-responsive tables.

## Mobile and SEO

### Mobile Optimizations

**Layout:**
Single column, full-width content, larger touch targets for accordions, generous padding (16-20px).

**Typography:**
16px minimum body text, 24-32px headings, line height 1.5-1.6, short paragraphs (3-4 sentences max).

**Tables:**
Horizontal scroll for wide tables or card layout (stacked rows), responsive design.

**Forms:**
Full-width inputs, 44-48px height, large submit buttons, appropriate keyboard types.

**Quick actions:**
- Tap-to-call: Phone numbers as clickable links (`tel:`)
- Tap-to-email: Email addresses as clickable links (`mailto:`)
- Map integration: "Get Directions" links to native map app

### SEO for Static Pages

**On-Page SEO:**
- Unique title per page (50-60 characters max, format: "Page Title | Store Name")
- Meta descriptions (150-160 characters, include call-to-action)
- Proper heading hierarchy (one H1 per page, H2 for sections, H3 for subsections)
- Original, unique content
- Internal links to products/categories
- Regular updates (especially FAQ)

**Schema Markup:**
- FAQ schema for FAQ pages (rich snippets)
- Organization schema for About page
- LocalBusiness schema for Store Locator
- ContactPoint schema for Contact page

**Benefits:**
Rich snippets in search results, improved visibility, better click-through rates.

## Checklist

**Essential pages:**

- [ ] FAQ page with accordion layout
- [ ] FAQ search functionality (for extensive FAQs)
- [ ] FAQ categories organized logically
- [ ] Contact page with form
- [ ] Contact form validation
- [ ] Email address and business hours visible
- [ ] Shipping and Returns page
- [ ] Shipping methods and costs table
- [ ] Delivery timeframes clear
- [ ] Return policy with conditions
- [ ] Return process step-by-step
- [ ] Privacy Policy page
- [ ] Last updated date on Privacy Policy
- [ ] Privacy policy in plain language
- [ ] Terms and Conditions page
- [ ] Last updated date on Terms

**Optional but valuable:**

- [ ] About Us page with brand story
- [ ] Mission and values section
- [ ] Size Guide (if apparel)
- [ ] Size charts with measurements
- [ ] How to measure instructions
- [ ] Store Locator (if physical stores)

**SEO and technical:**

- [ ] Unique title tags per page
- [ ] Meta descriptions per page
- [ ] Proper heading hierarchy (H1, H2, H3)
- [ ] Internal links to products/categories
- [ ] Schema markup (FAQ, Organization, etc.)
- [ ] Mobile-responsive layout
- [ ] Fast loading times

**Accessibility:**

- [ ] Semantic HTML (main, article, section)
- [ ] ARIA labels on accordions
- [ ] Keyboard navigation supported
- [ ] Focus indicators visible
- [ ] High contrast text (4.5:1)
- [ ] Forms properly labeled
- [ ] Tables with proper headers
- [ ] Alt text on images

**Content quality:**

- [ ] Clear, concise writing
- [ ] Short paragraphs (3-4 sentences)
- [ ] Bullet points for lists
- [ ] Regular content updates
- [ ] No outdated information
- [ ] Contact info current
- [ ] Policies reflect current practices
