# RFC {{RFC_NUMBER}}: {{RFC_TITLE}}

| Field | Value |
|-------|-------|
| **Author(s)** | {{AUTHOR}} |
| **Status** | {{STATUS}} |
| **Date** | {{DATE}} |
| **Version** | {{VERSION}} |
| **Reviewers** | {{REVIEWERS}} |
| **Implementation Due** | {{DUE_DATE}} |

## Abstract

{{ABSTRACT}}

## Motivation

### Problem Statement

{{PROBLEM_STATEMENT}}

### Goals

{{GOALS}}

### Non-Goals

{{NON_GOALS}}

### Success Criteria

{{SUCCESS_CRITERIA}}

## Background

### Current State

{{CURRENT_STATE}}

### Historical Context

{{HISTORICAL_CONTEXT}}

### Related Work

{{RELATED_WORK}}

## Detailed Design

### Overview

{{DESIGN_OVERVIEW}}

### System Architecture

{{SYSTEM_ARCHITECTURE}}

### API Design

{{API_DESIGN}}

### Data Model

{{DATA_MODEL}}

### Security Considerations

{{SECURITY_CONSIDERATIONS}}

### Performance Implications

{{PERFORMANCE_IMPLICATIONS}}

### Compatibility

{{COMPATIBILITY}}

## Implementation Plan

### Phase 1: {{PHASE_1}}

{{PHASE_1_DETAILS}}

**Timeline:** {{PHASE_1_TIMELINE}}
**Deliverables:** {{PHASE_1_DELIVERABLES}}

### Phase 2: {{PHASE_2}}

{{PHASE_2_DETAILS}}

**Timeline:** {{PHASE_2_TIMELINE}}
**Deliverables:** {{PHASE_2_DELIVERABLES}}

### Phase 3: {{PHASE_3}}

{{PHASE_3_DETAILS}}

**Timeline:** {{PHASE_3_TIMELINE}}
**Deliverables:** {{PHASE_3_DELIVERABLES}}

## Alternatives Considered

### Alternative 1: {{ALT_1_NAME}}

{{ALT_1_DESCRIPTION}}

**Advantages:**

- {{ALT_1_ADVANTAGE_1}}
- {{ALT_1_ADVANTAGE_2}}

**Disadvantages:**

- {{ALT_1_DISADVANTAGE_1}}
- {{ALT_1_DISADVANTAGE_2}}

**Decision:** {{ALT_1_DECISION}}

### Alternative 2: {{ALT_2_NAME}}

{{ALT_2_DESCRIPTION}}

**Advantages:**

- {{ALT_2_ADVANTAGE_1}}
- {{ALT_2_ADVANTAGE_2}}

**Disadvantages:**

- {{ALT_2_DISADVANTAGE_1}}
- {{ALT_2_DISADVANTAGE_2}}

**Decision:** {{ALT_2_DECISION}}

### Alternative 3: {{ALT_3_NAME}}

{{ALT_3_DESCRIPTION}}

**Advantages:**

- {{ALT_3_ADVANTAGE_1}}
- {{ALT_3_ADVANTAGE_2}}

**Disadvantages:**

- {{ALT_3_DISADVANTAGE_1}}
- {{ALT_3_DISADVANTAGE_2}}

**Decision:** {{ALT_3_DECISION}}

## Risk Assessment

| Risk | Probability | Impact | Mitigation Strategy |
|------|-------------|--------|-------------------|
| {{RISK_1}} | {{PROB_1}} | {{IMPACT_1}} | {{MITIGATION_1}} |
| {{RISK_2}} | {{PROB_2}} | {{IMPACT_2}} | {{MITIGATION_2}} |
| {{RISK_3}} | {{PROB_3}} | {{IMPACT_3}} | {{MITIGATION_3}} |
| {{RISK_4}} | {{PROB_4}} | {{IMPACT_4}} | {{MITIGATION_4}} |

## Resource Requirements

### Team Requirements

{{TEAM_REQUIREMENTS}}

### Infrastructure Requirements

{{INFRASTRUCTURE_REQUIREMENTS}}

### Budget Considerations

{{BUDGET_CONSIDERATIONS}}

### Timeline

{{PROJECT_TIMELINE}}

## Measurement and Evaluation

### Key Performance Indicators

{{KPIS}}

### Monitoring Strategy

{{MONITORING_STRATEGY}}

### Success Metrics

{{SUCCESS_METRICS}}

### Failure Criteria

{{FAILURE_CRITERIA}}

## Dependencies

### Internal Dependencies

{{INTERNAL_DEPENDENCIES}}

### External Dependencies

{{EXTERNAL_DEPENDENCIES}}

### Blocking Issues

{{BLOCKING_ISSUES}}

## Testing Strategy

### Unit Testing

{{UNIT_TESTING}}

### Integration Testing

{{INTEGRATION_TESTING}}

### Performance Testing

{{PERFORMANCE_TESTING}}

### Security Testing

{{SECURITY_TESTING}}

## Rollout Plan

### Deployment Strategy

{{DEPLOYMENT_STRATEGY}}

### Rollback Plan

{{ROLLBACK_PLAN}}

### Communication Plan

{{COMMUNICATION_PLAN}}

### Training Requirements

{{TRAINING_REQUIREMENTS}}

## Future Considerations

### Scalability

{{SCALABILITY_CONSIDERATIONS}}

### Evolution Path

{{EVOLUTION_PATH}}

### Deprecation Strategy

{{DEPRECATION_STRATEGY}}

## Open Questions

{{OPEN_QUESTIONS}}

## References

{{REFERENCES}}

## Appendices

### Appendix A: {{APPENDIX_A_TITLE}}

{{APPENDIX_A_CONTENT}}

### Appendix B: {{APPENDIX_B_TITLE}}

{{APPENDIX_B_CONTENT}}

---

## Review History

| Version | Date | Author | Changes |
|---------|------|--------|---------|
| {{VERSION_1}} | {{DATE_1}} | {{AUTHOR_1}} | {{CHANGES_1}} |
| {{VERSION_2}} | {{DATE_2}} | {{AUTHOR_2}} | {{CHANGES_2}} |

## Approval

| Role | Name | Date | Signature |
|------|------|------|-----------|
| **Technical Lead** | {{TECH_LEAD}} | {{TECH_LEAD_DATE}} | {{TECH_LEAD_SIG}} |
| **Product Owner** | {{PRODUCT_OWNER}} | {{PO_DATE}} | {{PO_SIG}} |
| **Architecture Review** | {{ARCH_REVIEWER}} | {{ARCH_DATE}} | {{ARCH_SIG}} |
