### {{PROJECT_NAME}} Architecture

**Last Updated:** {{DATE}}
**Version:** {{VERSION}}
**Authors:** {{AUTHORS}}

## Overview

{{ARCHITECTURE_OVERVIEW}}

[Provide a high-level summary of the system architecture in 2-3 sentences. What does this system do and what are its key characteristics?]

## System Context

{{SYSTEM_CONTEXT}}

[Describe how this system fits into the larger ecosystem. What external systems does it interact with?]

## Goals and Non-Goals

### Goals

{{ARCHITECTURE_GOALS}}

- [Primary objective 1]
- [Primary objective 2]
- [Primary objective 3]

### Non-Goals

{{ARCHITECTURE_NON_GOALS}}

- [What this system explicitly does NOT do]
- [Scope limitations]
- [Future considerations that are out of scope]

## High-Level Design

{{HIGH_LEVEL_DESIGN}}

[Describe the overall system design, major components, and their relationships]

## Detailed Design

### Core Components

#### {{COMPONENT_1_NAME}}

{{COMPONENT_1_DESCRIPTION}}

**Responsibilities:**

- [Primary responsibility 1]
- [Primary responsibility 2]

**Interfaces:**

- [Input interfaces]
- [Output interfaces]

**Dependencies:**

- [External dependencies]
- [Internal dependencies]

#### {{COMPONENT_2_NAME}}

{{COMPONENT_2_DESCRIPTION}}

**Responsibilities:**

- [Primary responsibility 1]
- [Primary responsibility 2]

**Interfaces:**

- [Input interfaces]
- [Output interfaces]

**Dependencies:**

- [External dependencies]
- [Internal dependencies]

#### {{COMPONENT_3_NAME}}

{{COMPONENT_3_DESCRIPTION}}

**Responsibilities:**

- [Primary responsibility 1]
- [Primary responsibility 2]

**Interfaces:**

- [Input interfaces]
- [Output interfaces]

**Dependencies:**

- [External dependencies]
- [Internal dependencies]

### Data Flow

{{DATA_FLOW}}

[Describe how data flows through the system, including typical request/response patterns]

1. [Step 1 of typical flow]
2. [Step 2 of typical flow]
3. [Step 3 of typical flow]

### APIs and Interfaces

{{APIS_AND_INTERFACES}}

[Document key APIs, protocols, and interface contracts]

#### Internal APIs

- **{{API_1_NAME}}**: {{API_1_DESCRIPTION}}
- **{{API_2_NAME}}**: {{API_2_DESCRIPTION}}

#### External Integrations

- **{{EXTERNAL_1_NAME}}**: {{EXTERNAL_1_DESCRIPTION}}
- **{{EXTERNAL_2_NAME}}**: {{EXTERNAL_2_DESCRIPTION}}

## Technology Stack

{{TECHNOLOGY_STACK}}

### Backend

- **Language:** {{BACKEND_LANGUAGE}}
- **Framework:** {{BACKEND_FRAMEWORK}}
- **Database:** {{DATABASE_TECHNOLOGY}}
- **Caching:** {{CACHING_TECHNOLOGY}}

### Frontend

- **Language:** {{FRONTEND_LANGUAGE}}
- **Framework:** {{FRONTEND_FRAMEWORK}}
- **Build Tool:** {{BUILD_TOOL}}

### Infrastructure

- **Cloud Provider:** {{CLOUD_PROVIDER}}
- **Container Runtime:** {{CONTAINER_RUNTIME}}
- **Orchestration:** {{ORCHESTRATION_PLATFORM}}
- **Monitoring:** {{MONITORING_TOOLS}}

## Security Considerations

{{SECURITY_CONSIDERATIONS}}

[Address key security aspects of the architecture]

### Authentication & Authorization

{{AUTH_APPROACH}}

[Describe how authentication and authorization are handled]

### Data Protection

{{DATA_PROTECTION}}

[Describe how sensitive data is protected in transit and at rest]

### Network Security

{{NETWORK_SECURITY}}

[Describe network-level security measures]

## Performance and Scalability

{{PERFORMANCE_SCALABILITY}}

### Performance Requirements

- **Throughput:** {{THROUGHPUT_REQUIREMENTS}}
- **Latency:** {{LATENCY_REQUIREMENTS}}
- **Availability:** {{AVAILABILITY_REQUIREMENTS}}

### Scaling Strategy

{{SCALING_STRATEGY}}

[Describe how the system scales horizontally and vertically]

### Bottlenecks and Limitations

{{BOTTLENECKS}}

[Identify known performance bottlenecks and system limitations]

## Reliability and Monitoring

{{RELIABILITY_MONITORING}}

### Error Handling

{{ERROR_HANDLING}}

[Describe error handling patterns and recovery mechanisms]

### Monitoring and Observability

{{MONITORING_OBSERVABILITY}}

- **Metrics:** {{METRICS_APPROACH}}
- **Logging:** {{LOGGING_APPROACH}}
- **Tracing:** {{TRACING_APPROACH}}
- **Alerting:** {{ALERTING_APPROACH}}

### Disaster Recovery

{{DISASTER_RECOVERY}}

[Describe backup, recovery, and business continuity plans]

## Deployment and Operations

{{DEPLOYMENT_OPERATIONS}}

### Deployment Strategy

{{DEPLOYMENT_STRATEGY}}

[Describe how the system is deployed and updated]

### Configuration Management

{{CONFIGURATION_MANAGEMENT}}

[Describe how configuration is managed across environments]

### Development Workflow

{{DEVELOPMENT_WORKFLOW}}

[Describe the development, testing, and release process]

## Alternative Designs Considered

{{ALTERNATIVE_DESIGNS}}

[Document major design alternatives that were considered and why they were not chosen]

### Alternative 1: {{ALTERNATIVE_1_NAME}}

{{ALTERNATIVE_1_DESCRIPTION}}

**Pros:**

- [Advantage 1]
- [Advantage 2]

**Cons:**

- [Disadvantage 1]
- [Disadvantage 2]

**Decision:** [Why this was not chosen]

## Future Considerations

{{FUTURE_CONSIDERATIONS}}

[Discuss planned improvements, technical debt, and long-term vision]

### Planned Improvements

- [Improvement 1]
- [Improvement 2]
- [Improvement 3]

### Technical Debt

- [Technical debt item 1]
- [Technical debt item 2]

### Long-term Vision

{{LONG_TERM_VISION}}

[Describe the 6-12 month vision for the architecture]

## References and Resources

{{REFERENCES}}

- [Link to design documents]
- [Link to API documentation]
- [Link to runbooks]
- [Link to related ADRs]

## Glossary

{{GLOSSARY}}

- **{{TERM_1}}**: {{TERM_1_DEFINITION}}
- **{{TERM_2}}**: {{TERM_2_DEFINITION}}
- **{{TERM_3}}**: {{TERM_3_DEFINITION}}

---

*This document follows Google's documentation standards for architecture documentation.*
